/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RedisModelCacheLog {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel");
    private static final String REDISMODELCACHE_ENABLELUA = "redismodelcache.enablelua";
    private static final Log log = LogFactory.getLog(RedisModelCacheLog.class);
    private boolean enableLog = false;
    private final Set<String> logentryKey = new HashSet<String>();
    private StackTraceElement[] lastStackTrace;
    protected static Method evalMethod;

    public RedisModelCacheLog(String entityName, String pageId) {
        String logEntry;
        String logDT = System.getProperty("redismodelcache.logdt");
        if (logDT != null && logDT.contains(entityName)) {
            this.enableLog = true;
        }
        if ((logEntry = System.getProperty("redismodelcache.logdtentry")) != null) {
            String[] split = logEntry.split(",");
            this.logentryKey.addAll(Arrays.asList(split));
        }
    }

    private void logInfo(String key, Supplier<String> supplier) {
        String entryName;
        if (this.enableLog && ((entryName = this.getEntryName(key)).equals("") || this.logentryKey.isEmpty() || this.logentryKey.contains(entryName))) {
            String s;
            try {
                s = supplier.get();
            }
            catch (Exception ex) {
                s = "key " + key;
                log.error((Throwable)ex);
            }
            if (!s.equals("")) {
                this.doLogInfo("{} \r\n{}", s, this.getStackTrace());
            }
        }
    }

    protected void doLogInfo(String msg, Object ... params) {
        log.info(msg, params);
    }

    private String getEntryName(String key) {
        String[] split = key.split("\\.");
        if (split.length == 5) {
            return split[3];
        }
        return "";
    }

    private String normalKey(String key) {
        return key.replace(CacheKeyUtil.getAcctId() + ".", "");
    }

    private String getStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int max = stackTrace.length - 1;
        int startTrace = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (stackTrace[i].getClassName().equals(RedisModelCacheLog.class.getName())) continue;
            if (startTrace == 0) {
                startTrace = i;
            }
            if (stackTrace[i].getClassName().contains("kd.bos.mservice.form.FormServiceImpl")) {
                max = i;
                break;
            }
            if (i <= 30) continue;
            max = 30;
            break;
        }
        int len = max - startTrace + 1;
        StackTraceElement[] stackTraceNew = new StackTraceElement[len];
        System.arraycopy(stackTrace, startTrace, stackTraceNew, 0, len);
        stackTrace = stackTraceNew;
        if (this.lastStackTrace != null) {
            int k = this.lastStackTrace.length - 1;
            boolean changed = false;
            for (int i = stackTrace.length - 1; i >= 0 && k >= 0; --i, --k) {
                if (this.lastStackTrace[k].getClassName().equals(stackTrace[i].getClassName()) && this.lastStackTrace[k].getMethodName().equals(stackTrace[i].getMethodName()) && this.lastStackTrace[k].getLineNumber() == stackTrace[i].getLineNumber()) continue;
                stackTraceNew = new StackTraceElement[i == stackTrace.length - 1 ? i + 1 : i + 2];
                System.arraycopy(stackTrace, 0, stackTraceNew, 0, stackTraceNew.length);
                this.lastStackTrace = stackTrace;
                stackTrace = stackTraceNew;
                changed = true;
                break;
            }
            if (!changed) {
                stackTrace = new StackTraceElement[]{};
            }
        } else {
            this.lastStackTrace = stackTrace;
        }
        StringBuilder s = new StringBuilder();
        for (StackTraceElement e : stackTrace) {
            s.append(e).append("\r\n");
        }
        return s.toString();
    }

    public int addList(String key, String[] values) {
        this.logInfo(key, () -> "addList key:" + this.normalKey(key) + " values size:" + values.length);
        return cache.addList(key, values);
    }

    public int addList(String key, String[] values, int timeOut) {
        this.logInfo(key, () -> "addList key:" + this.normalKey(key) + " values size" + values.length);
        return cache.addList(key, values, timeOut);
    }

    public int insertList(String key, int index, String[] values) {
        this.logInfo(key, () -> "insertList key:" + this.normalKey(key) + " index:" + index + " values size:" + values.length);
        return cache.insertList(key, index, values);
    }

    public void setListObject(String key, int index, String value) {
        this.logInfo(key, () -> "setListObject key:" + this.normalKey(key) + " index:" + index + " value len:" + value.length());
        cache.setListObject(key, index, value);
    }

    public String[] getList(String key) {
        String[] result = cache.getList(key);
        this.logInfo(key, () -> "getList key:" + this.normalKey(key) + " result list size:" + result.length);
        return result;
    }

    public String[] getList(String key, int index, int length) {
        String[] result = cache.getList(key, index, length);
        this.logInfo(key, () -> "getList key:" + this.normalKey(key) + " index:" + index + " length:" + length + " result list size:" + result.length);
        return result;
    }

    public String getListObject(String key, int index) {
        String result = cache.getListObject(key, index);
        this.logInfo(key, () -> "getListObject key:" + this.normalKey(key) + " index:" + index + " result length:" + (result == null ? " null " : "" + result.length()));
        return result;
    }

    public void removeListObject(String key, int index) {
        this.logInfo(key, () -> {
            String result = cache.getListObject(key, index);
            return "removeListObject key:" + this.normalKey(key) + " before result length:" + (result == null ? " null " : "" + result.length()) + " index: " + index;
        });
        cache.removeListObject(key, index);
    }

    public void removeListObjects(String key, int index, int length) {
        this.logInfo(key, () -> {
            String[] result = cache.getList(key, index, length);
            return "removeListObjects key:" + this.normalKey(key) + " before result list size:" + result.length + " remove index: " + index + " length:" + length;
        });
        cache.removeListObjects(key, index, length);
    }

    public String get(String key) {
        String res = (String)cache.get(key);
        this.logInfo(key, () -> "get key:" + this.normalKey(key) + " result length:" + res.length());
        return res;
    }

    public void put(String key, String value, int timeout) {
        this.logInfo(key, () -> "put key:" + this.normalKey(key) + " value length:" + value.length());
        cache.put(key, (Object)value, timeout);
    }

    public void remove(String key) {
        this.logInfo(key, () -> {
            try {
                String res = (String)cache.get(key);
                return "remove key:" + this.normalKey(key) + " value length:" + res.length();
            }
            catch (Exception ex) {
                String[] list = cache.getList(key);
                return "remove key:" + this.normalKey(key) + " value size:" + list.length;
            }
        });
        cache.remove(key);
    }

    public void remove(String[] keys) {
        this.logInfo(keys[0], () -> {
            StringBuilder s = new StringBuilder();
            try {
                String value = (String)cache.get(keys[0]);
                s.append("key:").append(this.normalKey(keys[0])).append(" value size:").append(value.length()).append("\t");
            }
            catch (Exception ex) {
                String[] value = cache.getList(keys[0]);
                s.append("key:").append(this.normalKey(keys[0])).append(" value list size:").append(value.length).append("\t");
            }
            for (int i = 1; i < keys.length; ++i) {
                String[] list = cache.getList(keys[i]);
                s.append("key:").append(this.normalKey(keys[i])).append(" value list size:").append(list.length).append("\t");
            }
            return "remove " + s;
        });
        cache.remove(keys);
    }

    public void expireAfter(String keyOrType, int second) {
        cache.expireAfter(keyOrType, second);
    }

    public Integer getListLength(String key) {
        return cache.getListLength(key);
    }

    private boolean isEqualLen(String[] arr1, String[] arr2) {
        int len1 = arr1 == null ? 0 : arr1.length;
        int len2 = arr2 == null ? 0 : arr2.length;
        return len1 == len2;
    }

    public void storeEntryByLua(Map<String, String[]> entryMap) {
        if (this.enableLua()) {
            for (Map.Entry<String, String[]> keyValue : entryMap.entrySet()) {
                this.logIfNotEquals(keyValue);
                String key = keyValue.getKey();
                String[] strRows = keyValue.getValue();
                StringBuilder lua = new StringBuilder("redis.call('del', KEYS[1])\n");
                if (strRows.length > 0) {
                    for (int i = 1; i <= strRows.length; ++i) {
                        lua.append("redis.call('rpush', KEYS[1], ARGV[").append(i).append("])");
                    }
                }
                this.innerEval(lua.toString(), key, Arrays.asList(strRows));
                cache.expireAfter(key, CacheKeyUtil.getPageCacheKeyTimeout());
            }
        } else {
            cache.remove(entryMap.keySet().toArray(new String[0]));
            for (Map.Entry<String, String[]> keyValue : entryMap.entrySet()) {
                this.logIfNotEquals(keyValue);
                String[] strRows = keyValue.getValue();
                if (strRows.length <= 0) continue;
                cache.addList(keyValue.getKey(), strRows);
            }
        }
    }

    private void logIfNotEquals(Map.Entry<String, String[]> keyValue) {
        this.logInfo(keyValue.getKey(), () -> {
            StringBuilder s = new StringBuilder();
            String[] list = cache.getList((String)keyValue.getKey());
            if (!this.isEqualLen(list, (String[])keyValue.getValue())) {
                s.append(" key:").append(this.normalKey((String)keyValue.getKey())).append(" redis size: ").append(list == null ? 0 : list.length).append(" local size:").append(((String[])keyValue.getValue()).length).append("\t");
            }
            return s.length() == 0 ? "" : "storeEntryByLua" + s;
        });
    }

    public void storeEntryByLua(String key, String[] strRows) {
        HashMap<String, String[]> entryMap = new HashMap<String, String[]>();
        entryMap.put(key, strRows);
        this.storeEntryByLua(entryMap);
    }

    protected boolean enableLua() {
        String lightWeight = System.getProperty("lightweightdeploy");
        if (StringUtils.isNotBlank((CharSequence)lightWeight) && Boolean.parseBoolean(lightWeight)) {
            return false;
        }
        String enableLua = System.getProperty(REDISMODELCACHE_ENABLELUA);
        if (StringUtils.isBlank((CharSequence)enableLua)) {
            String code = RequestContext.get().getTenantCode();
            enableLua = System.getProperty(code + "_" + REDISMODELCACHE_ENABLELUA);
        }
        return StringUtils.isBlank((CharSequence)enableLua) || Boolean.parseBoolean(enableLua);
    }

    private void innerEval(String lua, String key, List<String> params) {
        if (evalMethod != null) {
            try {
                evalMethod.invoke((Object)cache, lua, key, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getRedisUrl(String region) {
        String redisUrl = null;
        String configKeyStr = this.getSessionlessConfigKey(region);
        redisUrl = System.getProperty(configKeyStr);
        if (redisUrl == null && region != null) {
            configKeyStr = this.getSessionlessConfigKey(null);
            redisUrl = System.getProperty(configKeyStr);
        }
        return redisUrl;
    }

    private String getSessionlessConfigKey(String region) {
        String redischey = "redis.serversForCache";
        if (region != null) {
            redischey = redischey + "." + region;
        }
        return redischey;
    }

    static {
        try {
            evalMethod = DistributeSessionlessCache.class.getMethod("eval", String.class, String.class, List.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            log.info("no eval interface");
        }
    }
}

