/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.TCacheSortDate;
import kd.bos.entity.cache.TCacheSortDecimal;
import kd.bos.entity.cache.TCacheSortString;
import kd.bos.entity.formula.MemberVarParser;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;

interface TCacheSortField {
    public String getFieldKey();

    public String getFullFieldKey();

    public void setSeq(int var1);

    public int getSeq();

    public void setOrder(String var1);

    public String getOrder();

    public String getAlias();

    public String getFieldName();

    public int getDBType();

    public Object formatValue(Row var1);

    public Object formatValue(DynamicObject var1);

    public static TCacheSortField create(MainEntityType mainEntityType, String sortFieldKey) {
        List list = MemberVarParser.findPropertys((MainEntityType)mainEntityType, (String)sortFieldKey, (boolean)true);
        ArrayList<String> fullKeys = new ArrayList<String>(list.size());
        for (DynamicProperty property : list) {
            IDataEntityType pt = property.getParent();
            if (pt instanceof SubEntryType) {
                fullKeys.add(pt.getParent().getName() + "." + pt.getName() + "." + property.getName());
                continue;
            }
            if (pt instanceof EntryType) {
                fullKeys.add(pt.getName() + "." + property.getName());
                continue;
            }
            fullKeys.add(property.getName());
        }
        String fullPropName = StringUtils.join((Object[])fullKeys.toArray(new String[0]), (String)".");
        IDataEntityProperty prop = (IDataEntityProperty)list.get(list.size() - 1);
        if (prop instanceof DecimalProp) {
            return new TCacheSortDecimal(sortFieldKey, fullPropName);
        }
        if (prop instanceof DateTimeProp) {
            return new TCacheSortDate(sortFieldKey, fullPropName);
        }
        return new TCacheSortString(sortFieldKey, fullPropName);
    }
}

