/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IModelCache;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.cache.TableModelCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.EntryFilterHandler;
import kd.bos.entity.datamodel.IDataModelRepository;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

class DataModelCacheRepository
implements IDataModelRepository {
    private IModelCache cache;
    private AbstractFormDataModel model;
    private EntryFilterHandler entryFilterHandler;
    private Boolean tableCache = null;

    public DataModelCacheRepository(AbstractFormDataModel model) {
        this.model = model;
        this.entryFilterHandler = new EntryFilterHandler(this.model);
    }

    protected AbstractFormDataModel getModel() {
        return this.model;
    }

    protected IModelCache getCache() {
        if (this.cache == null) {
            this.cache = !this.isTableCache() ? new RedisModelCache(this.model, this.model.getDataEntityType(), this.model.getPageId()) : new TableModelCache(this.model, this.model.getDataEntityType(), this.model.getPageId());
        }
        return this.cache;
    }

    public void updateCache(String pageId) {
        if (this.cache != null && this.getCache().isChanged() && this.model.getDataEntityType().getProperties().size() > 0) {
            this.getCache().storeChanged();
        }
    }

    public void addNewRows(String entryKey, DynamicObject[] entryRows) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection cols = this.getEntry(entryKey);
            if (cols != null) {
                for (DynamicObject entryRow : entryRows) {
                    cols.add((Object)entryRow);
                    this.entryFilterHandler.appendRK(entryKey, entryRow.getInt("seq") - 1);
                }
            }
        } else {
            this.getCache().appendEntryRows(entryKey, entryRows);
        }
    }

    public void insertEntryRow(String entryKey, int row, DynamicObject[] entryRows) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            this.insertSubEntryRowsCacheHandle((EntryProp)((SubEntryProp)prop), row, entryRows);
            if (entryRows.length > 0) {
                this.entryFilterHandler.insertRkBefore(prop.getName(), entryRows[entryRows.length - 1].getInt("seq") - 1);
            }
        } else {
            this.getCache().insertEntryRows(prop.getName(), row, entryRows);
        }
    }

    public void insertEntryRow(EntryProp prop, int row, DynamicObject entryRow) {
        if (prop instanceof SubEntryProp) {
            this.insertSubEntryRowsCacheHandle(prop, row, new DynamicObject[]{entryRow});
            this.entryFilterHandler.insertRkBefore(prop.getName(), entryRow.getInt("seq") - 1);
        } else {
            this.getCache().insertEntryRows(prop.getName(), row, new DynamicObject[]{entryRow});
        }
    }

    public void appendEntryRows(EntryProp prop, int row, DynamicObject[] entryRows) {
        if (prop instanceof SubEntryProp) {
            this.insertSubEntryRowsCacheHandle(prop, row, entryRows);
            int[] rows = new int[entryRows.length];
            for (int i = 0; i < entryRows.length; ++i) {
                rows[i] = entryRows[i].getInt("seq") - 1;
            }
            this.entryFilterHandler.insertRkAfter(prop.getName(), rows);
        } else {
            this.getCache().appendEntryRows(prop.getName(), row, entryRows);
        }
    }

    private void insertSubEntryRowsCacheHandle(EntryProp prop, int row, DynamicObject[] entryRows) {
        DynamicObjectCollection cols = this.getEntry(prop.getName());
        int start = cols.getStartRowIndex();
        for (int i = 0; i < entryRows.length; ++i) {
            cols.add(i + row - start, entryRows[i]);
        }
        ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
        this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
    }

    public DynamicObject getDataEntityByField(IDataEntityProperty prop, int rowIndex, int parentRowIndex) {
        IDataEntityType parent4;
        DynamicObject dyn = null;
        IDataEntityType parent1 = prop.getParent();
        IDataEntityType parent2 = parent1 != null ? parent1.getParent() : null;
        IDataEntityType parent3 = parent2 != null ? parent2.getParent() : null;
        IDataEntityType iDataEntityType = parent4 = parent3 != null ? parent3.getParent() : null;
        if (parent1 instanceof MainEntityType) {
            dyn = this.getCache().getRootDataEntity();
        } else if (parent2 instanceof MainEntityType) {
            String entryName = prop.getParent().getName();
            dyn = this.getCache().getEntryRowDataEntity(entryName, rowIndex);
        } else if (parent3 instanceof MainEntityType) {
            DynamicObjectCollection cols = this.getSubEntryEntities(prop.getParent(), parentRowIndex);
            if (cols != null && (cols.size() != 0 || rowIndex != 0)) {
                dyn = (DynamicObject)cols.get(rowIndex);
            }
        } else if (parent4 instanceof MainEntityType) {
            int subEntryRowIndex;
            IDataEntityType entryType = parent3;
            IDataEntityType subEntryType = parent2;
            IDataEntityType linkEntryType = parent1;
            String entryTypeName = null;
            String subEntryTypeName = null;
            if (entryType != null) {
                entryTypeName = entryType.getName();
            }
            if (subEntryType != null) {
                subEntryTypeName = subEntryType.getName();
            }
            int entryRowIndex = this.model.getEntryCurrentRowIndex(entryTypeName);
            DynamicObject entryRow = this.getCache().getEntryRowDataEntity(entryTypeName, entryRowIndex);
            if (entryRow == null) {
                return null;
            }
            DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection(subEntryTypeName);
            int n = subEntryRowIndex = parentRowIndex >= 0 ? parentRowIndex : this.model.getEntryCurrentRowIndex(subEntryTypeName);
            if (subEntryRows.size() <= subEntryRowIndex || subEntryRowIndex < 0) {
                return null;
            }
            DynamicObject subEntryRow = (DynamicObject)subEntryRows.get(subEntryRowIndex);
            DynamicObjectCollection linkEntryRows = subEntryRow.getDynamicObjectCollection(linkEntryType.getName());
            int linkEntryRowIndex = rowIndex;
            if (linkEntryRows.size() <= linkEntryRowIndex || linkEntryRowIndex < 0) {
                return null;
            }
            return (DynamicObject)linkEntryRows.get(linkEntryRowIndex);
        }
        return dyn;
    }

    private DynamicObjectCollection getSubEntryEntities(IDataEntityType sub_entry_prop, int parentRowIndex) {
        DynamicObject entryRow;
        String entryName = sub_entry_prop.getParent().getName();
        if (parentRowIndex < 0) {
            parentRowIndex = this.model.getEntryCurrentRowIndex(entryName);
        }
        if ((entryRow = this.getCache().getEntryRowDataEntity(entryName, parentRowIndex)) == null) {
            return null;
        }
        IDataEntityProperty subEntryProp = this.model.getProperty(sub_entry_prop.getName());
        return (DynamicObjectCollection)subEntryProp.getValueFast((Object)entryRow);
    }

    public int getEntryRowCount(String entryKey) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection col = this.getEntry(entryKey);
            if (col == null) {
                return 0;
            }
            return col.getRowCount();
        }
        return this.getCache().getEntryRowCount(entryKey);
    }

    public DynamicObject getAll() {
        if (this.model.getDataEntityType().getProperties().isEmpty()) {
            return (DynamicObject)this.model.getDataEntityType().createInstance();
        }
        DynamicObject dyn = this.getCache().getAll();
        return dyn;
    }

    public void moveEntryBlockRows(EntryProp prop, int startIndex, int len, int toIndex) {
        if (prop instanceof SubEntryProp) {
            int i;
            DynamicObjectCollection cols = this.getEntry(prop.getName());
            int start = cols.getStartRowIndex();
            ArrayList<Object> rows = new ArrayList<Object>(len);
            for (i = 0; i < len; ++i) {
                rows.add(cols.get(startIndex + i));
            }
            for (i = startIndex; i < startIndex + len; ++i) {
                cols.remove(i);
                cols.add(toIndex, (DynamicObject)rows.get(i - startIndex));
            }
            ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
            this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
        } else {
            this.getCache().moveEntryBlockRows(prop.getName(), startIndex, len, toIndex);
        }
    }

    public void moveEntryBlockRows(EntryProp prop, int[] formIndexs, int toIndex) {
        if (prop instanceof SubEntryProp) {
            int i;
            DynamicObjectCollection cols = this.getEntry(prop.getName());
            int start = cols.getStartRowIndex();
            ArrayList<Object> rows = new ArrayList<Object>(formIndexs.length);
            for (i = 0; i < formIndexs.length; ++i) {
                rows.add(cols.get(formIndexs[i]));
            }
            for (i = formIndexs.length - 1; i >= 0; --i) {
                cols.remove(formIndexs[i]);
                if (formIndexs[i] > toIndex) continue;
                --toIndex;
            }
            for (i = formIndexs.length - 1; i >= 0; --i) {
                cols.add(toIndex + 1, (DynamicObject)rows.get(i));
            }
            ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
            this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
        } else {
            this.getCache().moveEntryBlockRows(prop.getName(), formIndexs, toIndex);
        }
    }

    public void swapEntryRow(String entryName, int rowIndex1, int rowIndex2) {
        IDataEntityProperty prop = this.model.getProperty(entryName);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection cols = this.getEntry(entryName);
            int start = cols.getStartRowIndex();
            DynamicObject row1 = (DynamicObject)cols.get(rowIndex1 - start);
            DynamicObject row2 = (DynamicObject)cols.get(rowIndex2 - start);
            cols.set(rowIndex1 - start, (Object)row2);
            cols.set(rowIndex2 - start, (Object)row1);
            row1.set("seq", (Object)(rowIndex2 + 1));
            row2.set("seq", (Object)(rowIndex1 + 1));
            ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
        } else {
            this.getCache().swapEntryRow(entryName, rowIndex1, rowIndex2);
        }
    }

    public void deleteEntryRows(String entryKey, int[] rows) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection cols = this.getSubEntryEntities(((SubEntryProp)prop).getItemType(), -1);
            if (cols != null) {
                int start = cols.getStartRowIndex();
                Arrays.sort(rows);
                for (int i = rows.length - 1; i >= 0; --i) {
                    cols.remove(rows[i] - start);
                }
                ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
                this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
                this.getCache().setRemovedItemFlag(Boolean.valueOf(true));
                this.entryFilterHandler.removeRK(entryKey, rows);
            }
        } else if (prop instanceof EntryProp) {
            this.getCache().delEntryRows(entryKey, rows);
        } else {
            throw new KDException(new ErrorCode("###", "not support entrytype %s"), new Object[]{prop.getClass().getName()});
        }
    }

    private List<DynamicObject> reSetSubEntrySeqAfterDelete(int start, DynamicObjectCollection cols, IDataEntityType itemType) {
        IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast(cols.get(i), (Object)(start + i + 1));
            }
        }
        return cols;
    }

    public void deleteEntryRow(String entryName, int rowIndex) {
        this.deleteEntryRows(entryName, new int[]{rowIndex});
    }

    public void deleteEntryData(String entryName) {
        IDataEntityProperty prop = this.model.getProperty(entryName);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection cols = this.getSubEntryEntities(((SubEntryProp)prop).getItemType(), -1);
            if (cols != null) {
                cols.clear();
                ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
                this.entryFilterHandler.clearFilterRKList(entryName);
                this.getCache().setRemovedItemFlag(Boolean.valueOf(true));
            }
        } else if (prop instanceof EntryProp) {
            this.getCache().deleteEntryData(entryName);
        } else {
            throw new KDException(new ErrorCode("###", "not support entrytype %s"), new Object[]{prop.getClass().getName()});
        }
    }

    public DynamicObject getEntryRow(String entryKey, int rowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            String parentName = prop.getParent().getName();
            int parentIndex = this.model.getEntryCurrentRowIndex(parentName);
            DynamicObject parentRow = this.getEntryRow(parentName, parentIndex);
            return (DynamicObject)((DynamicObjectCollection)prop.getValueFast((Object)parentRow)).get(rowIndex);
        }
        if (prop instanceof EntryProp) {
            return this.getCache().getEntryRowDataEntity(prop.getName(), rowIndex);
        }
        return null;
    }

    public DynamicObject getEntryRow(String entryKey, int rowIndex, int parentRowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            String parentName = prop.getParent().getName();
            if (parentRowIndex == -1) {
                parentRowIndex = this.model.getEntryCurrentRowIndex(parentName);
            }
            DynamicObject parentRow = this.getEntryRow(parentName, parentRowIndex);
            return (DynamicObject)((DynamicObjectCollection)prop.getValueFast((Object)parentRow)).get(rowIndex);
        }
        if (prop instanceof EntryProp) {
            return this.getCache().getEntryRowDataEntity(prop.getName(), rowIndex);
        }
        return null;
    }

    public DynamicObjectCollection getEntry(String entryKey) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            DynamicObject parentRow;
            String parentName = prop.getParent().getName();
            int parentIndex = this.model.getEntryCurrentRowIndex(parentName);
            if (parentIndex >= 0 && (parentRow = this.getEntryRow(parentName, parentIndex)) != null) {
                return (DynamicObjectCollection)prop.getValueFast((Object)parentRow);
            }
        } else if (prop instanceof EntryProp) {
            return this.getCache().getEntryRowDataEntities((EntryProp)prop);
        }
        return null;
    }

    public DynamicObject getRootEntity() {
        if (this.model.getDataEntityType().getProperties().isEmpty()) {
            return (DynamicObject)this.model.getDataEntityType().createInstance();
        }
        return this.getCache().getRootDataEntity();
    }

    public DynamicObject[] getEntry(String entryName, int startRowIndex, int endRowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryName);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection cols = this.getEntry(entryName);
            if (cols != null) {
                Object ret;
                if (startRowIndex == 0 && endRowIndex == cols.size() - 1) {
                    ret = cols;
                } else {
                    int startRow = startRowIndex - cols.getStartRowIndex();
                    int endRow = endRowIndex - cols.getStartRowIndex();
                    ret = cols.subList(startRow, endRow);
                }
                return ret.toArray(new DynamicObject[ret.size()]);
            }
        } else if (prop instanceof EntryProp) {
            List ret = this.getCache().getEntryRowDataEntities(entryName, startRowIndex, endRowIndex);
            return ret.toArray(new DynamicObject[ret.size()]);
        }
        return new DynamicObject[0];
    }

    public void setRemovedItemFlag(Boolean b) {
        this.getCache().setRemovedItemFlag(b);
    }

    public void release() {
        if (this.model.getDataEntityType().getProperties().size() > 0) {
            this.getCache().release();
        }
    }

    public void cacheExpireAfter(int timeout) {
        this.getCache().expireAfter(timeout);
    }

    public void updateEntryCache(String pageId, DynamicObjectCollection colls) {
        this.getCache().storeEntry(colls);
    }

    public boolean isExistDataEntity() {
        return this.getCache().isExistDataEntity();
    }

    public void filterEntry(String entryKey, EntryQueryParam queryParam) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            DynamicObjectCollection subEntryRows = this.getEntry(entryKey);
            EntryFilterHandler entryFilterHandler = new EntryFilterHandler(this.model);
            entryFilterHandler.filterEntry(entryKey, queryParam, subEntryRows);
        } else if (prop instanceof EntryProp) {
            this.getCache().filterEntry(entryKey, queryParam);
        }
    }

    public int getFilterEntryRowCount(String entryKey) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
            DynamicObjectCollection entryDataEntities = this.getEntry(entryKey);
            if (isFilterAndSortModel) {
                return this.entryFilterHandler.getFilterEntryRowCount(entryKey, entryDataEntities);
            }
            if (entryDataEntities == null) {
                return 0;
            }
            return entryDataEntities.getRowCount();
        }
        return this.getCache().getFilterEntryRowCount(entryKey);
    }

    public DynamicObject[] getFilterEntryRows(String entryKey, int startRowIndex, int endRowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
            DynamicObjectCollection entryDataEntities = this.getEntry(entryKey);
            if (isFilterAndSortModel) {
                return this.entryFilterHandler.getFilterEntryRows(entryKey, startRowIndex, endRowIndex, entryDataEntities);
            }
            if (entryDataEntities == null) {
                return new DynamicObject[0];
            }
            List dynamicObjects = entryDataEntities.subList(startRowIndex, endRowIndex);
            return dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
        }
        return this.getCache().getFilterEntryRows(entryKey, startRowIndex, endRowIndex);
    }

    public List<Integer> getFilterEntryRowKeys(String entryKey, int startRowIndex, int endRowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            return this.entryFilterHandler.getFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
        }
        return this.getCache().getFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
    }

    public List<Integer> getFilterIndexByRowKeys(String entryKey, List<Integer> rowkeyList) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
            if (isFilterAndSortModel) {
                return this.entryFilterHandler.getFilterIndexByRowKeys(entryKey, rowkeyList);
            }
            return rowkeyList;
        }
        return this.getCache().getFilterIndexByRowKeys(entryKey, rowkeyList);
    }

    public List<Integer> filterSortByRowKeys(String entryKey, List<Integer> rowkeyList) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop instanceof SubEntryProp) {
            boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
            if (isFilterAndSortModel) {
                return this.entryFilterHandler.filterSortByRowKeys(entryKey, rowkeyList);
            }
            return rowkeyList;
        }
        return this.getCache().filterSortByRowKeys(entryKey, rowkeyList);
    }

    public boolean isFilterAndSortModel(String entryKey) {
        return this.getCache().isFilterAndSortModel(entryKey);
    }

    public EntryQueryParam getEntryQueryParam(String entryKey) {
        return this.getCache().getEntryQueryParam(entryKey);
    }

    protected boolean isTableCacheAndSpiltPage(String entryKey) {
        return this.isTableCache() && this.isSplitPage(entryKey);
    }

    protected boolean isTableCache() {
        if (this.tableCache == null) {
            this.tableCache = this.model.useTableCache();
        }
        return this.tableCache;
    }

    protected boolean isSplitPage(String entryKey) {
        DynamicObject root = this.getCache().getRootDataEntity();
        if (root.getDataEntityState().getEntryInfos() == null) {
            return false;
        }
        EntryInfo entryInfo = (EntryInfo)root.getDataEntityState().getEntryInfos().get(entryKey);
        if (entryInfo == null || entryInfo.getRowCount() == null) {
            return false;
        }
        return entryInfo.getRowCount() > entryInfo.getPageSize();
    }

    protected int getMaxSeqInBatch1(String entryKey) {
        if (this.isTableCache() && this.isSplitPage(entryKey)) {
            return ((TableModelCache)this.getCache()).getMaxSeqInBatch1(entryKey);
        }
        return this.getCache().getEntryRowCount(entryKey);
    }

    protected boolean isInBatch1(String entryKey, int rowIndex) {
        int seq = rowIndex + 1;
        int maxSeq = this.getMaxSeqInBatch1(entryKey);
        return seq <= maxSeq;
    }
}

