/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel.events;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropChangedTask;

class PropChangedTaskCollection {
    private long _maxTaskCount = 100000L;
    private List<PropChangedTask> _tasks;
    private int _head;

    PropChangedTaskCollection() {
    }

    public void clear() {
        if (this._tasks != null) {
            this._tasks.clear();
        }
    }

    public void add(PropChangedTask newTask) {
        ArrayList<PropChangedTask> newTasks = new ArrayList<PropChangedTask>();
        newTasks.add(newTask);
        this.addAll(newTasks);
    }

    public void addAll(List<PropChangedTask> newTasks) {
        if (newTasks == null) {
            return;
        }
        if (this._tasks != null && (long)this._tasks.size() > this._maxTaskCount) {
            StringBuilder sb = new StringBuilder();
            String errMessage = ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5b57\u6bb5\u503c\u6539\u53d8\u4e8b\u4ef6\u8c03\u7528\u53ef\u80fd\u8fdb\u5165\u4e86\u6b7b\u5faa\u73af\uff01", (String)"PropChangedTaskCollection_0", (String)"bos-entity-core", (Object[])new Object[0]);
            sb.append(errMessage);
            sb.append(ResManager.loadKDString((String)"\u53ef\u7591\u5b57\u6bb5\uff1a", (String)"PropChangedTaskCollection_1", (String)"bos-entity-core", (Object[])new Object[0]));
            int seq = 1;
            for (PropChangedTask task : newTasks) {
                if (seq > 5) break;
                sb.append(seq).append(". ").append(task.getProperty().getName());
                ++seq;
            }
            throw new RuntimeException(sb.toString());
        }
        RefObject item = new RefObject(null);
        for (PropChangedTask task : newTasks) {
            if (this.tryGetTask(task.getProperty(), (RefObject<PropChangedTask>)item)) {
                if (ObjectUtils.nullSafeEquals(task.getChangeSet(), ((PropChangedTask)item.argvalue).getChangeSet())) continue;
                ((PropChangedTask)item.argvalue).getChangeSet().addAll(task.getChangeSet());
                continue;
            }
            if (this._tasks == null) {
                this._tasks = new ArrayList<PropChangedTask>(4);
            }
            this._tasks.add(task);
        }
    }

    private boolean tryGetTask(IDataEntityProperty prop, RefObject<PropChangedTask> item) {
        if (this._tasks != null) {
            for (int i = this._head; i < this._tasks.size(); ++i) {
                item.argvalue = this._tasks.get(i);
                if (!StringUtils.equals((CharSequence)((PropChangedTask)item.argvalue).getProperty().getName(), (CharSequence)prop.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean dequeue(RefObject<PropChangedTask> result) {
        if (this._tasks != null && this._head < this._tasks.size()) {
            result.argvalue = this._tasks.get(this._head);
            this._tasks.set(this._head, null);
            ++this._head;
            return true;
        }
        return false;
    }

    public int size() {
        if (this._tasks != null) {
            return Math.max(0, this._tasks.size() - this._head);
        }
        return 0;
    }
}

