/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.dynplugin.EntityDynamicPluginCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.form.plugin.annotations.OperatePluginMethod;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.util.CollectionUtils;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public class OperationDynamicProxyPlugin
extends AbstractOperationServicePlugIn {
    private Map<String, IOperationServicePlugIn> opPluginMap = new HashMap<String, IOperationServicePlugIn>(10);

    @OperatePluginMethod
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String eventmethod = "afterExecuteOperationTransaction";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.afterExecuteOperationTransaction(e);
            }
        }
    }

    @OperatePluginMethod
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String eventmethod = "beforeExecuteOperationTransaction";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.beforeExecuteOperationTransaction(e);
            }
        }
    }

    @OperatePluginMethod
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String eventmethod = "beginOperationTransaction";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.beginOperationTransaction(e);
            }
        }
    }

    @OperatePluginMethod
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String eventmethod = "endOperationTransaction";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.endOperationTransaction(e);
            }
        }
    }

    @OperatePluginMethod
    public void onAddValidators(AddValidatorsEventArgs e) {
        String eventmethod = "onAddValidators";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.onAddValidators(e);
            }
        }
    }

    @OperatePluginMethod
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String eventmethod = "onPreparePropertys";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.onPreparePropertys(e);
            }
        }
    }

    @OperatePluginMethod
    public void rollbackOperation(RollbackOperationArgs e) {
        String eventmethod = "rollbackOperation";
        List<IOperationServicePlugIn> plugins = this.getPlugins(eventmethod);
        if (CollectionUtils.isNotEmpty(plugins)) {
            for (IOperationServicePlugIn plugin : plugins) {
                plugin.rollbackOperation(e);
            }
        }
    }

    private List<IOperationServicePlugIn> getPlugins(String eventmethod) {
        String formId = this.billEntityType.getName();
        if (this.operateMeta == null) {
            return null;
        }
        String operationKey = this.operateMeta.get("type") == null ? "" : (String)this.operateMeta.get("type");
        List dynamicPlugins = EntityDynamicPluginCache.getDynamicPlugins((String)formId, (String)eventmethod, (String)operationKey);
        if (CollectionUtils.isNotEmpty((Collection)dynamicPlugins)) {
            ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>(dynamicPlugins.size());
            for (int i = 0; i < dynamicPlugins.size(); ++i) {
                LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>(6);
                plugin.put("className", ((DynPlugin)dynamicPlugins.get(i)).getClassName());
                plugin.put("rowKey", 0);
                plugin.put("enabled", true);
                plugin.put("type", Integer.valueOf(((DynPlugin)dynamicPlugins.get(i)).getCodeType()));
                plugin.put("events", new ArrayList(0));
                plugin.put("dynamicPlugin", false);
                plugins.add(plugin);
            }
            List<IOperationServicePlugIn> instancePlugins = this.createPlugin(plugins);
            if (CollectionUtils.isNotEmpty(instancePlugins)) {
                for (IOperationServicePlugIn plugin : instancePlugins) {
                    plugin.setContext(this.billEntityType, this.operateMeta, this.operateOption);
                    plugin.setOperateProgress(this.operateProgress);
                    plugin.initializeOperationResult(this.getOperationResult());
                }
            }
            return instancePlugins;
        }
        return null;
    }

    private List<IOperationServicePlugIn> createPlugin(List<Map<String, Object>> plugins) {
        ArrayList<IOperationServicePlugIn> opPlugIns = new ArrayList<IOperationServicePlugIn>(plugins.size());
        if (plugins == null) {
            return opPlugIns;
        }
        for (Map<String, Object> ins : plugins) {
            int type = (Integer)ins.get("type");
            String className = (String)ins.get("className");
            IOperationServicePlugIn instance = this.opPluginMap.get(className);
            if (instance != null) {
                opPlugIns.add(instance);
                continue;
            }
            if (0 == type) {
                IOperationServicePlugIn javaInstance = (IOperationServicePlugIn)TypesContainer.createInstance((String)className);
                opPlugIns.add(javaInstance);
                this.opPluginMap.put(className, javaInstance);
                continue;
            }
            if (4 != type || !Plugin.enableRunKingScript()) continue;
            try {
                IOperationServicePlugIn splugin = (IOperationServicePlugIn)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(className, scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)));
                if (splugin == null) continue;
                opPlugIns.add(splugin);
                this.opPluginMap.put(className, splugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return opPlugIns;
    }
}

