/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.query;

import java.sql.SQLException;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GetMetaDataEntityOnly2Shard {
    private static final Log log = LogFactory.getLog(GetMetaDataEntityOnly2Shard.class);

    public static MainEntityType getDataEntityType(String entityNumber) {
        log.info("GetMetaDataEntityOnly2Shard,getDataEntityType: " + entityNumber);
        String str = GetMetaDataEntityOnly2Shard.getEntityMeta(entityNumber);
        try {
            return (MainEntityType)EntityItemTypes.fromJsonString((String)str);
        }
        catch (Exception e) {
            log.error("GetMetaDataEntityOnly2ShardError,getDataEntityType : " + entityNumber, (Object)e.getMessage());
            throw e;
        }
    }

    private static String getEntityMeta(String entityNumber) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
        String str = (String)cache.get(GetMetaDataEntityOnly2Shard.getCacheType(entityNumber), GetMetaDataEntityOnly2Shard.getCacheKey(entityNumber, 11));
        if (StringUtils.isBlank((CharSequence)str)) {
            str = GetMetaDataEntityOnly2Shard.doQueryMetaData(entityNumber, entityNumber, 11, GetMetaDataEntityOnly2Shard.getGrayTableName(entityNumber, "T_META_ENTITY"));
            if (StringUtils.isBlank((CharSequence)str) && GetMetaDataEntityOnly2Shard.isGrayGroup()) {
                str = GetMetaDataEntityOnly2Shard.doQueryMetaData(entityNumber, entityNumber, 11, "T_META_ENTITY");
            }
            if (StringUtils.isNotBlank((CharSequence)str)) {
                cache.put(GetMetaDataEntityOnly2Shard.getCacheType(entityNumber), GetMetaDataEntityOnly2Shard.getCacheKey(entityNumber, 11), (Object)str);
            }
        }
        if (str == null || str.length() == 0) {
            throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{entityNumber});
        }
        return str;
    }

    private static String doQueryMetaData(String number, String ctlKey, int type, String table) {
        String sql = String.format("select FDATA from %s where FNUMBER = ? and FKEY = ? and FTYPE = ?", table);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)ctlKey), new SqlParameter("FTYPE", 5, (Object)((short)type))};
        String sRet = GetMetaDataEntityOnly2Shard.queryDB(sql, params);
        if (StringUtils.isBlank((CharSequence)sRet)) {
            sRet = "";
        }
        return sRet;
    }

    private static String queryDB(String sql, SqlParameter[] params) {
        ResultSetHandler callBackHanlder = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return sFdata;
        };
        String sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        return sRet;
    }

    private static String getCacheType(String number) {
        String appGroup = AppGroup.getMetaLookupAppGroup();
        String accountId = GetMetaDataEntityOnly2Shard.getAcctId();
        return String.format("%s_meta_%s_%s", accountId, appGroup, number);
    }

    private static String getCacheKey(String key, int metaType) {
        return String.format("_%s_%s", metaType, key);
    }

    private static String getAcctId() {
        return new StringBuilder(64).append(Instance.getClusterName()).append('.').append(RequestContext.get().getAccountId()).toString();
    }

    private static String getGrayTableName(String formId, String tabName) {
        String appGroup = AppGroup.getMetaLookupAppGroup();
        if (GetMetaDataEntityOnly2Shard.isGrayGroup()) {
            return String.format("%s_%s", tabName, appGroup);
        }
        return tabName;
    }

    private static boolean isGrayGroup() {
        String appGroup = AppGroup.getMetaLookupAppGroup();
        return StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup);
    }
}

