/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.query;

import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.orm.impl.ORMEntityInvoker;

public class ORMEntityInvokerImpl
implements ORMEntityInvoker {
    public static final String audit_orm_get_meta = "orm_get_meta";
    public static final String audit_orm_clone_meta = "orm_clone_meta";

    public DynamicObjectType getDataEntityType(String entityName) {
        try (Auditable audit = Audit.audit((String)audit_orm_get_meta, (Object[])new Object[0]);){
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            return mainEntityType;
        }
    }

    public String getBaseDataEntityName(IComplexProperty baseDataProp) {
        String name = null;
        if (baseDataProp instanceof BasedataProp) {
            name = ((BasedataProp)baseDataProp).getBaseEntityId();
        } else if (baseDataProp instanceof RefBillProp) {
            name = ((RefBillProp)baseDataProp).getBillEntityId();
        }
        if (name == null) {
            name = baseDataProp.getComplexType().getName();
        }
        return name;
    }

    public IDataEntityType getMulBasedataPropDataEntityType(IDataEntityProperty dp) {
        if (dp instanceof MulBasedataProp) {
            MulBasedataProp mp = (MulBasedataProp)dp;
            return mp.getDynamicCollectionItemPropertyType();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataEntityType cloneDataEntityType(IDataEntityType dt) {
        try (Auditable audit = Audit.audit((String)audit_orm_clone_meta, (Object[])new Object[0]);){
            IDataEntityType iDataEntityType = (IDataEntityType)dt.clone();
            return iDataEntityType;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

