/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportBatchLoadInfo
implements Serializable {
    private int batchCount = 1;
    private ConcurrentSkipListMap<Integer, String> batchIndex2CachedDataSetIds = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<Integer, Integer> batchIndex2RowCounts = new ConcurrentSkipListMap();
    private ArrayList<Integer> noDataBatchIndexs = new ArrayList();

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setBatchCount(int batchCount) {
        this.batchCount = batchCount;
    }

    public ArrayList<Integer> getNoDataBatchIndexs() {
        return this.noDataBatchIndexs;
    }

    public ConcurrentSkipListMap<Integer, Integer> getBatchIndex2RowCounts() {
        return this.batchIndex2RowCounts;
    }

    public ConcurrentSkipListMap<Integer, String> getBatchIndex2CachedDataSetIds() {
        return this.batchIndex2CachedDataSetIds;
    }

    public boolean isAllBatchLoaded() {
        return this.getBatchIndex2RowCounts().size() + this.getNoDataBatchIndexs().size() >= this.getBatchCount();
    }

    public int getLoadedRowCount() {
        int rowCountCached = 0;
        for (Integer value : this.getBatchIndex2RowCounts().values()) {
            rowCountCached += value.intValue();
        }
        return rowCountCached;
    }

    public int getEstimateTotalRowCount() {
        if (this.isAllBatchLoaded()) {
            return this.getLoadedRowCount();
        }
        int loadedRowCount = this.getLoadedRowCount();
        int loadedBatchCount = this.getBatchIndex2RowCounts().size();
        if (loadedBatchCount == 0) {
            loadedBatchCount = 1;
        }
        return this.getBatchCount() / loadedBatchCount * loadedRowCount;
    }
}

