/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ds.AbstractDataSource;
import kd.bos.entity.report.ds.DSHelper;
import kd.bos.entity.report.ds.EntityDS;
import kd.bos.entity.report.ds.JoinDS;
import kd.bos.entity.report.ds.SortDS;
import kd.bos.entity.report.ds.UnionDS;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.formula.FormulaEngine;
import kd.bos.util.StringUtils;

public class DataSourceFactory {
    private static Map<String, Class<?>> dsMap = new HashMap();

    public static AbstractDataSource createDataSource(String reportName, ReportQueryParam queryParam, Object selectedObj, String dataSource) {
        List<AbstractDataSource> dsList = DataSourceFactory.getDataSourceList(dataSource, queryParam, selectedObj, reportName);
        for (AbstractDataSource ds : dsList) {
            Object val = DataSourceFactory.getFormulaValue(ds.getConition(), queryParam.getFilter());
            if (!ds.isEnable() || val != null && !Boolean.parseBoolean(val.toString())) continue;
            return ds;
        }
        return null;
    }

    private static Object getFormulaValue(String formula, FilterInfo filter) {
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        Object[] vars = FormulaEngine.extractVariables((String)formula);
        Arrays.sort(vars);
        HashMap<Object, Object> formulaCtx = new HashMap<Object, Object>(32);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            Object val = filter.getValue((String)var);
            if (val instanceof ILocaleString) {
                val = ((ILocaleString)val).getLocaleValue();
            }
            formulaCtx.put(var, val);
        }
        return FormulaEngine.execExcelFormula((String)formula, formulaCtx);
    }

    private static List<AbstractDataSource> getDataSourceList(String dataSource, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ide_dsedit");
        DynamicObject obj = DSHelper.toDynamicObject(dataSource, type);
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("dsentry");
        ArrayList<AbstractDataSource> dsList = new ArrayList<AbstractDataSource>(20);
        for (int i = 0; i < dsColl.size(); ++i) {
            DynamicObject dsObj = (DynamicObject)dsColl.get(i);
            AbstractDataSource ds = DataSourceFactory.getDataSource(dsObj, dsList, queryParam, selectedObj, reportName);
            dsList.add(ds);
        }
        return dsList;
    }

    private static AbstractDataSource getDataSource(DynamicObject dsObj, List<AbstractDataSource> dsList, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        String dsType = dsObj.getString("dstype");
        Class<?> typeClass = dsMap.get(dsType);
        if (typeClass != null) {
            try {
                AbstractDataSource ds = (AbstractDataSource)typeClass.newInstance();
                ds.init(dsObj, dsList, queryParam, selectedObj, reportName);
                return ds;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e});
            }
        }
        return null;
    }

    static {
        dsMap.put("1", EntityDS.class);
        dsMap.put("2", JoinDS.class);
        dsMap.put("3", UnionDS.class);
        dsMap.put("4", SortDS.class);
    }
}

