/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ds.AbstractDataSource;
import kd.bos.entity.report.ds.DSHelper;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fs.util.StringUtils;
import kd.bos.util.JSONUtils;

public class UnionDS
extends AbstractDataSource {
    private Map<String, List<String>> dsFields = new HashMap<String, List<String>>();

    @Override
    protected void init(DynamicObject dsObj, List<AbstractDataSource> dsList, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        super.init(dsObj, dsList, queryParam, selectedObj, reportName);
        String data = dsObj.getString("data");
        if (!StringUtils.isEmpty((String)data)) {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"ide_unionds");
            DynamicObject obj = DSHelper.toDynamicObject(data, entity);
            DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("dsentry");
            DynamicObjectCollection selectFields = obj.getDynamicObjectCollection("selectentry");
            for (DynamicObject ds : dsColl) {
                Map<String, String> fieldMap = this.getFieldMap(ds);
                String dsNumer = ds.getString("ds");
                String condtion = ds.getString("condition");
                if (!DSHelper.pass(queryParam, condtion)) continue;
                ArrayList<String> selector = new ArrayList<String>();
                for (DynamicObject field : selectFields) {
                    String fieldname = field.getString("fieldname");
                    String queryField = fieldMap.get(fieldname);
                    if (!StringUtils.isEmpty((String)queryField)) {
                        queryField = DSHelper.calQueryField(queryParam, queryField);
                    }
                    String dataType = DSHelper.getDataTypeMap(field.getString("datatype"));
                    if (StringUtils.isEmpty((String)queryField)) {
                        queryField = "null";
                    }
                    selector.add("cast(" + queryField + " as " + dataType + ") as " + field.getString("fieldname"));
                }
                this.dsFields.put(dsNumer, selector);
            }
        }
    }

    private Map<String, String> getFieldMap(DynamicObject ds) {
        String dsData = ds.getString("dsdata");
        Map<String, String> fieldMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)dsData)) {
            try {
                fieldMap = (Map)JSONUtils.cast((String)dsData, HashMap.class);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return fieldMap;
    }

    @Override
    public DataSet createDataSet() {
        DataSet dataSet = null;
        for (Map.Entry<String, List<String>> entry : this.dsFields.entrySet()) {
            String dsNumber = entry.getKey();
            AbstractDataSource ds = this.getDS(dsNumber);
            if (ds == null) continue;
            DataSet set = ds.getDataSet();
            List<String> selector = this.dsFields.get(dsNumber);
            set = set.select(selector.toArray(new String[0]));
            if (dataSet == null) {
                dataSet = set;
                continue;
            }
            dataSet = dataSet.union(set);
        }
        return dataSet;
    }

    private AbstractDataSource getDS(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        for (AbstractDataSource ds : this.getDSList()) {
            if (!ds.getNumber().equals(number)) continue;
            return ds;
        }
        return null;
    }
}

