/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.web.DispatchServiceHelper;

public class DeployAction {
    private static final Log logger = LogFactory.getLog(DeployAction.class);
    private static final String METADATA_SERVICE = "MetadataService";
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String SUCCESS_INFO = "successInfo";
    private static final String ERROR_INFO = "errorInfo";
    private static final String COUNT = "count";
    private static final String DEPLOY_SERVICE = "DeployService";
    private static final String REBUILD_ALL = "rebuildAll";
    private static final String PERMISSION_SERVICE = "PermissionService";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws IOException {
        String resString;
        HttpServletResponse res;
        block58: {
            OperationContext oc;
            ApiRequestContext ctx = ApiRequestContext.get();
            HttpServletRequest request = ctx.getRequest();
            res = ctx.getResponse();
            if (this.accessCheck()) {
                ActionUtil.writeResponseJson((ServletResponse)res, (CharSequence)"Method forbidden access.(kd.upgrade.signverify.enable=true).");
                return;
            }
            if (!this.isVirtualUser() && !this.isAdminUser()) {
                ActionUtil.writeResponseJson((ServletResponse)res, (CharSequence)this.getUnauthorizedMsg());
                return;
            }
            resString = "";
            String type = request.getParameter("type");
            String fileName = request.getParameter("filename");
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
                    type = "app";
                } else if (fileName.endsWith(".sch")) {
                    type = "sch";
                } else if (fileName.endsWith(".cld") || fileName.endsWith(".cldx")) {
                    type = "cld";
                } else if (fileName.endsWith(".schdata") || fileName.endsWith(".schdatax")) {
                    type = "schdata";
                }
            }
            if ((oc = OperationContext.get()) == null) {
                oc = new OperationContext();
            }
            oc.setAppId("bos");
            oc.setFormId("deploy");
            oc.setFormName(fileName);
            try (InputStream ins = null;){
                List<String> sqlList;
                if (REBUILD_ALL.equals(type)) {
                    Map result;
                    String diffVerStr = request.getParameter("onlydiff");
                    if (Boolean.parseBoolean(diffVerStr)) {
                        oc.setOpMethod("rebuildAllDiffVer");
                        result = (Map)DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, "rebuildAllDiffVer", Boolean.TRUE, Boolean.TRUE);
                    } else {
                        oc.setOpMethod(REBUILD_ALL);
                        result = (Map)DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, REBUILD_ALL, Boolean.TRUE);
                    }
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    if (result.get(FAILED) != null && ((List)result.get(FAILED)).size() > 0) {
                        map.put(SUCCESS, Boolean.FALSE);
                        map.put(SUCCESS_INFO, (Boolean)result.get(SUCCESS));
                        map.put(ERROR_INFO, (Boolean)result.get(FAILED));
                    } else {
                        map.put(SUCCESS, Boolean.TRUE);
                        map.put(SUCCESS_INFO, (Boolean)result.get(SUCCESS));
                    }
                    map.put(COUNT, (Boolean)result.get(COUNT));
                    logger.debug("rebuild all map:" + map);
                    resString = JSON.toJSONString(map, (boolean)true);
                    logger.debug("rebuild all resString:" + resString);
                    break block58;
                }
                if ("rebuildApp".equals(type)) {
                    oc.setOpMethod("rebuildByApps");
                    String appParamsStr = request.getParameter("appParamsStr");
                    List<String> rebuidAppParams = Arrays.asList(appParamsStr.split("-"));
                    Map resultApps = (Map)DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, "rebuildByApps", Boolean.TRUE, rebuidAppParams);
                    ArrayList appInfoList = new ArrayList(4);
                    HashMap<String, Serializable> appsMap = new HashMap<String, Serializable>();
                    boolean success = true;
                    for (Map.Entry entry : resultApps.entrySet()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Map appResult = (Map)entry.getValue();
                        if (appResult.get(FAILED) != null && ((List)appResult.get(FAILED)).size() > 0) {
                            success = false;
                            map.put(SUCCESS, Boolean.FALSE);
                            map.put(SUCCESS_INFO, appResult.get(SUCCESS));
                            map.put(ERROR_INFO, appResult.get(FAILED));
                        } else {
                            map.put(SUCCESS, Boolean.TRUE);
                            map.put(SUCCESS_INFO, appResult.get(SUCCESS));
                        }
                        map.put("appNumber", "");
                        map.put("appId", entry.getKey());
                        map.put(COUNT, appResult.get(COUNT));
                        appInfoList.add(map);
                    }
                    if (resultApps.isEmpty()) {
                        success = false;
                    }
                    appsMap.put(SUCCESS, Boolean.valueOf(success));
                    appsMap.put("rebuildInfo", appInfoList);
                    resString = JSON.toJSONString(appsMap, (boolean)true);
                    break block58;
                }
                if ("rebuild".equals(type)) {
                    String formId = request.getParameter("formId");
                    oc.setOpMethod("rebuildFormRuntimeMeta");
                    oc.setFormId(formId);
                    DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, "rebuildFormRuntimeMeta", formId);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    map.put(SUCCESS, Boolean.TRUE);
                    resString = JSON.toJSONString(map, (boolean)true);
                    break block58;
                }
                if ("dym".equals(type) || "app".equals(type) || "js".equals(type) || "card".equals(type) || "sch".equals(type) || "cld".equals(type) || "schdata".equals(type)) {
                    oc.setOpMethod("deployDym");
                    ins = request.getInputStream();
                    String content = this.readerDym(ins);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("type", type);
                    DispatchServiceHelper.invokeBOSService(DEPLOY_SERVICE, "deployDym", params, content);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    map.put(SUCCESS, Boolean.TRUE);
                    resString = JSON.toJSONString(map, (boolean)true);
                    break block58;
                }
                if ("xml".equals(type)) {
                    oc.setOpMethod("deployXML");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("type", type);
                    ins = request.getInputStream();
                    String content = this.readerDym(ins);
                    Map map = (Map)DispatchServiceHelper.invokeBOSService(DEPLOY_SERVICE, "deployXML", params, content);
                    resString = JSON.toJSONString((Object)map, (boolean)true);
                    break block58;
                }
                ins = request.getInputStream();
                String separator = request.getParameter("separator");
                if (separator == null) {
                    separator = ";";
                }
                String dbkey = request.getParameter("dbkey");
                String ksqlName = request.getParameter("ksqlname");
                String version = request.getParameter("version");
                String appName = request.getParameter("appname");
                String pkname = request.getParameter("pkname");
                String plugin = request.getParameter("plugin");
                try (InputStreamReader inputStreamReader = new InputStreamReader(ins, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(inputStreamReader);){
                    sqlList = this.readerSql(type, br, separator);
                }
                ins.close();
                String el = request.getParameter("el");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", type);
                params.put("dbkey", dbkey);
                params.put("el", el);
                params.put("ksqlname", ksqlName);
                params.put("version", version);
                params.put("appname", appName);
                params.put("pkname", pkname);
                params.put("plugin", plugin);
                oc.setOpMethod("deploySql");
                Map map = (Map)DispatchServiceHelper.invokeBOSService(DEPLOY_SERVICE, "deploySql", params, sqlList);
                if (!((Boolean)map.get(SUCCESS)).booleanValue()) {
                    resString = JSON.toJSONString((Object)map);
                } else {
                    String checkinfo = (String)map.get("checkinfo");
                    map.put(SUCCESS, Boolean.TRUE);
                    map.put("checkinfo", checkinfo);
                    resString = JSON.toJSONString((Object)map, (boolean)true);
                }
            }
        }
        if (resString != null) {
            res.getOutputStream().write(resString.getBytes(StandardCharsets.UTF_8));
        }
    }

    private String getNormalError() {
        RequestContext requestContext = RequestContext.get();
        String msg = "";
        if (requestContext != null) {
            msg = " TraceId:" + requestContext.getTraceId() + "\r\n";
        }
        msg = msg + " deploy : error ";
        return msg;
    }

    private static boolean isShowStackTrace() {
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if ("true".equals(showStackTrace)) {
            return true;
        }
        try {
            Object isShowStackTrace;
            Map cache = ParameterReader.loadPublicParameterFromCache();
            if (cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
                return (Boolean)isShowStackTrace;
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u516c\u5171\u53c2\u6570\u5931\u8d25.", (Throwable)ex);
            return false;
        }
        return false;
    }

    private List<String> readerSql(String type, BufferedReader br, String separator) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String line = null;
        boolean isFirstLine = true;
        StringBuilder sb = new StringBuilder();
        boolean commentLine = false;
        int i = 0;
        while ((line = br.readLine()) != null) {
            ++i;
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String temp = line.trim();
            if (commentLine) {
                if (!temp.endsWith("*/")) continue;
                commentLine = false;
                continue;
            }
            if (temp.startsWith("/*")) {
                if (temp.endsWith("*/")) continue;
                commentLine = true;
                continue;
            }
            if (temp.startsWith("--")) continue;
            if (!(temp.endsWith(separator) && separator.equals("GO") || StringUtils.isBlank((CharSequence)temp))) {
                sb.append(' ').append(line).append(' ');
            }
            if (!temp.endsWith(separator)) continue;
            String sql = sb.toString().trim();
            if ("oracle".equalsIgnoreCase(type) && sql.endsWith(";") && separator.equals(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            if (StringUtils.isBlank((CharSequence)sql)) {
                throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"sql\u4e3a\u7a7a\uff1a%1$s ---- temp:%2$s ---- \u884c\uff1a%3$s\uff0c\u5206\u9694\u7b26\uff1a%4$s\u3002", (String)"DeployAction_0", (String)"bos-webactions", (Object[])new Object[0]), line, temp, i, separator)});
            }
            sqlList.add(sql);
            sb = new StringBuilder();
        }
        return sqlList;
    }

    private String readerDym(InputStream in) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        int count = -1;
        while ((count = in.read(data, 0, 4096)) != -1) {
            outStream.write(data, 0, count);
        }
        data = null;
        String content = new String(outStream.toByteArray(), StandardCharsets.UTF_8);
        outStream.close();
        in.close();
        return content;
    }

    public void deployJar(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.accessCheck()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Method forbidden access.(kd.upgrade.signverify.enable=true).");
            return;
        }
        if (!this.isVirtualUser() && !this.isAdminUser()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)this.getUnauthorizedMsg());
            return;
        }
        ServletInputStream ins = request.getInputStream();
        String body = this.readerDym((InputStream)ins);
        String result = (String)DispatchServiceHelper.invokeBOSService("JarDeployService", "deployJar", body);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private boolean accessCheck() {
        return Boolean.parseBoolean(System.getProperty("kd.upgrade.signverify.enable"));
    }

    private String getUnauthorizedMsg() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error:", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"DeployAction_1", (String)"bos-webactions", (Object[])new Object[0]));
        return SerializationUtils.toJsonString(map);
    }

    private boolean isAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        return (Boolean)DispatchServiceHelper.invokeBOSService(PERMISSION_SERVICE, "isAdminUser", userId);
    }

    private boolean isVirtualUser() {
        return RequestContext.get().getCurrUserId() == 0L;
    }
}

