/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.instance.AppGroup;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.list.CtsyListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ctsy.CtsyApiDispatchServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.web.DispatchServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;

public class FormAction {
    private static final String PAGE_ID = "pageId";
    private static final String FORM_SERVICE = "FormService";
    private static final String FORM_ID = "formId";
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String PARAMS = "params";
    private static final String UTF_8 = "UTF-8";
    private static final String QUERY_SERVICE = "QueryService";
    private static final String RELEASE_EXPORT_DATA = "releaseExportData";
    private static final String HAS_NEXT_PAGE = "hasNextPage";
    private static final String APP_ID = "appId";
    private static final String BR_STR = "<br><br>";
    private static final String LOCK_SPLIT_CHAR = "/";
    private static Log log = LogFactory.getLog(FormAction.class);
    private static final String KD_CSRF_TOKEN = "kd-csrf-token";
    private static final String IS_NEED_CHECK_CSRF = "is_need_check_csrf";
    private static final String TYPE_NAME = "FormAction";

    public void getConfigByPageId(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getConfigByPageId");){
            String pageId = request.getParameter(PAGE_ID);
            String ctsynonce = request.getParameter("ctsynonce");
            if (span.isRealtime()) {
                span.addTag("ctsynonce", ctsynonce);
                span.addTag(PAGE_ID, pageId);
            }
            String config = "";
            config = StringUtils.isNotEmpty((CharSequence)ctsynonce) ? this.getCtsyConfigByPageId(request, span) : (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getConfigByPageId", pageId);
            FormAction.putConfigCSRFToken(response);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)config);
        }
    }

    public void getConfigByParameter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cacheId = request.getParameter("parameter");
        String config = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getConfigByParameter", cacheId);
        if (StringUtils.isBlank((CharSequence)config)) {
            HashMap<String, String> items = new HashMap<String, String>();
            String client = RequestContext.get().getClient();
            if ("mobile".equals(client)) {
                items.put(FORM_ID, "error_404_mob");
                items.put("caption", ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9875\u9762", (String)"FormAction_7", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            } else {
                items.put(FORM_ID, "error_404");
            }
            config = (String)DispatchServiceHelper.invokeBOSServiceByAppId("bos", FORM_SERVICE, "getConfig", items);
        }
        FormAction.putConfigCSRFToken(response);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)config);
    }

    public void getConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String params = request.getParameter(PARAMS);
        Map items = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
        String formId = (String)items.get(FORM_ID);
        String type = (String)items.get("type");
        if ("list".equals(type)) {
            formId = (String)items.get("billFormId");
        }
        String appId = "bos";
        try {
            appId = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getAppId", formId);
        }
        catch (KDException e) {
            String client = RequestContext.get().getClient();
            if ("mobile".equals(client)) {
                items.put(FORM_ID, "error_404_mob");
                items.put("caption", ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9875\u9762", (String)"FormAction_7", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            }
            items.put(FORM_ID, "error_404");
        }
        FormAction.putConfigCSRFToken(response);
        String config = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "getConfig", items);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)config);
    }

    private static void putConfigCSRFToken(HttpServletResponse response) {
        String kdCsrfToken = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        if (kd.bos.util.StringUtils.isNotEmpty((String)kdCsrfToken)) {
            response.addHeader(KD_CSRF_TOKEN, kdCsrfToken);
        }
    }

    public void releaseRootPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rootPageId = request.getParameter("rootpage");
        String byPage = request.getParameter("bypageid");
        boolean bbypage = false;
        if ("true".equalsIgnoreCase(byPage)) {
            bbypage = true;
        }
        DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "releaseRootPage", rootPageId, bbypage);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"sucess");
    }

    public void getMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId;
        String id;
        block2: {
            id = request.getParameter("fid");
            appId = "bos";
            try {
                appId = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getAppId", id);
            }
            catch (KDException e) {
                log.error(String.format("formId:%s,getMetadataError:%s", id, e.getMessage()), (Throwable)e);
                if (!AppGroup.isGrayUpgrade()) break block2;
                throw e;
            }
        }
        String metadata = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "MetadataService", "loadClientFormMeta", id);
        FormAction.putConfigCSRFToken(response);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)metadata);
    }

    public void getCtsyMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getCtsyMetadata");){
            String metadata = "";
            String ctsynonce = request.getParameter("ctsynonce");
            span.addTag("ctsynonce", ctsynonce);
            if (StringUtils.isBlank((CharSequence)ctsynonce)) {
                metadata = ResManager.loadKDString((String)"ctsynonce\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"FormAction_12", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
            } else {
                String ctsynonceVal = CtsyListShowParameter.getCtsynonceVal((String)ctsynonce);
                span.addTag("ctsynonceVal", ctsynonceVal);
                if (StringUtils.isBlank((CharSequence)ctsynonceVal) || ctsynonceVal.indexOf(",") == -1) {
                    metadata = ResManager.loadKDString((String)"ctsynonce\u53c2\u6570\u6709\u8bef\u3002", (String)"FormAction_13", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                } else {
                    String id = request.getParameter("fid");
                    String[] tenantArray = ctsynonceVal.split(",");
                    HashMap<String, String> params = new HashMap<String, String>(5);
                    params.put("method", "getCtsyMetadata");
                    params.put(FORM_ID, id);
                    HashMap<String, HashMap<String, String>> paramsTemp = new HashMap<String, HashMap<String, String>>(1);
                    paramsTemp.put(PARAMS, params);
                    if (Boolean.parseBoolean(tenantArray[2])) {
                        Object resultMap = CtsyApiDispatchServiceHelper.invokeWebApi((String)tenantArray[0], (String)tenantArray[1], (String)"/v2/ctsy/ctform/handle", paramsTemp);
                        metadata = resultMap instanceof Map && ((Map)resultMap).get("data") instanceof String ? (String)((Map)resultMap).get("data") : ResManager.loadKDString((String)"\u83b7\u53d6\u8fdc\u7aef\u79df\u6237\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"FormAction_14", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                    } else {
                        String result = CtsyApiDispatchServiceHelper.post((String)tenantArray[0], (String)tenantArray[1], (String)"v2/ctsy/ctform/handle", (String)SerializationUtils.toJsonString(paramsTemp));
                        span.addTag("result", result);
                        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                        metadata = openApiResult.get("data") instanceof String ? (String)openApiResult.get("data") : ResManager.loadKDString((String)"\u83b7\u53d6\u8fdc\u7aef\u79df\u6237\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"FormAction_14", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                    }
                }
            }
            FormAction.putConfigCSRFToken(response);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)metadata);
        }
    }

    public void pushAICommand(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String command = request.getParameter("command");
        String userId = request.getParameter("userId");
        String aitoken = request.getParameter("aitoken");
        if (StringUtils.isNotBlank((CharSequence)command)) {
            DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "pushAICommand", aitoken, userId, command);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"sucess");
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"command=null");
        }
    }

    public void export(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        exportService.doExportAction(request, response);
    }

    public void timerElapsed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding(UTF_8);
        String appId = request.getParameter(APP_ID);
        appId = appId == null ? "" : appId;
        String pageId = request.getParameter(PAGE_ID);
        String params = request.getParameter(PARAMS);
        String result = "[]";
        try {
            result = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "batchInvokeAction", pageId, params);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void batchInvokeAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String result;
        block8: {
            request.setCharacterEncoding(UTF_8);
            String originUrl = request.getHeader("Origin");
            String refererUrl = request.getHeader("Referer");
            if (StringUtils.isNotBlank((CharSequence)refererUrl) && StringUtils.isNotBlank((CharSequence)originUrl) && !refererUrl.startsWith(originUrl)) {
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)String.format("Resources not found. Origin:%s, Referer:%s", originUrl, refererUrl));
                return;
            }
            String appId = request.getParameter(APP_ID);
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = "bos";
            }
            String pageId = request.getParameter(PAGE_ID);
            String dataParams = request.getParameter(PARAMS);
            boolean isNeedCheckCsrf = false;
            String token = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
            if (FormAction.isNeedCheckCSRF()) {
                isNeedCheckCsrf = true;
                if (StringUtils.isBlank((CharSequence)token)) {
                    isNeedCheckCsrf = false;
                }
            }
            if (isNeedCheckCsrf && !this.checkCsrf(request)) {
                String errorMessage = ResManager.loadKDString((String)"\u65e0\u6548\u8bf7\u6c42", (String)"FormAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)this.wrapToJson(errorMessage));
                return;
            }
            if (this.checkDuplicateAttack(request)) {
                String errorMessage = ResManager.loadKDString((String)"\u65e0\u6548\u8bf7\u6c42", (String)"FormAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)this.wrapToJson(errorMessage));
                return;
            }
            HashMap<String, Object> actionParams = new HashMap<String, Object>();
            actionParams.put("web", Boolean.TRUE);
            String pageToken = request.getHeader("pagesign");
            actionParams.put("pagesign", pageToken);
            actionParams.put("parallel", request.getParameter("parallel"));
            result = "[]";
            try {
                String duplicateCheck = System.getProperty("request.duplicate.check", "false");
                result = "true".equals(duplicateCheck) ? this.preventDuplicateLockRequest(pageId, appId, dataParams, actionParams) : (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "batchInvokeAction", pageId, dataParams, actionParams);
            }
            catch (Exception e) {
                if (dataParams != null && dataParams.startsWith("[{\"key\":\"\",\"methodName\":\"timerElapsed\"")) break block8;
                throw e;
            }
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private boolean checkCsrf(HttpServletRequest request) {
        boolean isValidRequest = true;
        String clientStartTime = request.getHeader("client-start-time");
        if (StringUtils.isEmpty((CharSequence)clientStartTime)) {
            log.info("csrf check error. clientStartTime is null");
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)clientStartTime)) {
            log.info("csrf check error. clientStartTime is invalid");
            return false;
        }
        String kdCsrfToken = request.getHeader(KD_CSRF_TOKEN);
        if (StringUtils.isBlank((CharSequence)kdCsrfToken)) {
            log.info("csrf check error. kd-csrf-token is null. ");
            return false;
        }
        String signature = request.getHeader("signature");
        int signatureSplitLength = 64;
        if (StringUtils.isEmpty((CharSequence)signature)) {
            log.info("csrf check error. signature is null. ");
            return false;
        }
        if (signature.length() < signatureSplitLength) {
            log.info(String.format("csrf check error. signature length exceed %d.", signatureSplitLength));
            return false;
        }
        String dataParams = request.getParameter(PARAMS);
        if (dataParams == null) {
            dataParams = "";
            log.info("csrf check . dataParams is null.");
        }
        String lengthPrefix = "__length__";
        int lengthIndex = signature.indexOf(lengthPrefix);
        int maxlength = 300;
        if (lengthIndex > 0) {
            maxlength = Integer.parseInt(signature.substring(lengthIndex + lengthPrefix.length()));
            signature = signature.substring(0, lengthIndex);
        }
        int length = dataParams.length() > maxlength ? maxlength : dataParams.length();
        String clientServerDiffTime = signature.substring(signatureSplitLength);
        StringBuffer bf = new StringBuffer(clientStartTime).append(kdCsrfToken).append(clientServerDiffTime).append(dataParams, 0, length);
        String str = DigestUtils.sha256Hex((String)bf.toString());
        if (!signature.equals(str + clientServerDiffTime)) {
            log.info("csrf check error. signature notMatch");
            if (log.isDebugEnabled()) {
                log.debug("csrf check error. bf : " + bf + " signature : " + signature + " request.getHeader(signature) : " + request.getHeader("signature"));
            }
            isValidRequest = false;
        }
        return isValidRequest;
    }

    private boolean checkDuplicateAttack(HttpServletRequest request) {
        String accountId;
        String cacheKey;
        String duplicateAttackCheck = System.getProperty("request.duplicate.attackcheck", "false");
        if (!"true".equals(duplicateAttackCheck)) {
            return false;
        }
        String clientStartTime = request.getHeader("client-start-time");
        if (StringUtils.isEmpty((CharSequence)clientStartTime)) {
            log.info("request duplicate submit check error. clientStartTime is null");
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)clientStartTime)) {
            log.info("request duplicate submit check error. clientStartTime is invalid");
            return false;
        }
        String pageId = request.getParameter(PAGE_ID);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        String cacheClientStartTime = (String)redisCache.get(cacheKey = String.format("%s.%s.%s", accountId = CacheKeyUtil.getAcctId(), pageId, "clientstarttime"));
        if (cacheClientStartTime != null && cacheClientStartTime.equals(clientStartTime)) {
            log.info("request duplicate submit. pageId={}", (Object)pageId);
            return true;
        }
        int page_timeout = 60000;
        redisCache.put(cacheKey, (Object)clientStartTime, page_timeout, TimeUnit.MILLISECONDS);
        return false;
    }

    private String preventDuplicateLockRequest(String pageId, String appId, String dataParams, Map<String, Object> actionParams) {
        String result;
        StringBuilder paramString = new StringBuilder();
        paramString.append("kd_DuplReqLock").append(LOCK_SPLIT_CHAR).append(pageId);
        try (DLock lock = DLock.create((String)paramString.toString());){
            if (lock.tryLock(180000L)) {
                result = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "batchInvokeAction", pageId, dataParams, actionParams);
            } else {
                log.info("request duplicate submit. pageId={}", (Object)pageId);
                result = ResManager.loadKDString((String)"\u65e0\u6548\u8bf7\u6c42", (String)"FormAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
            }
        }
        return result;
    }

    private String wrapToJson(String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", content);
        return SerializationUtils.toJsonString(map);
    }

    public void getQingColumns(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pageId = request.getParameter(PAGE_ID);
        String key = request.getParameter("key");
        String appId = request.getParameter(APP_ID);
        appId = appId == null ? "bos" : appId;
        String result = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "getQingColumns", pageId, key);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getQingData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pageId = request.getParameter(PAGE_ID);
        String key = request.getParameter("key");
        String appId = request.getParameter(APP_ID);
        appId = appId == null ? "bos" : appId;
        Integer startRowIndex = Integer.parseInt(request.getParameter("startRow"));
        Integer limit = Integer.parseInt(request.getParameter("limit"));
        String result = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "getQingData", pageId, key, startRowIndex, limit);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void hello(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formId = request.getParameter(FORM_ID);
        String data = request.getParameter("data");
    }

    public void ksqlTranslate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), "utf-8");){
            response.setContentType("text/json;charset=utf-8");
            String ksql = request.getParameter("ksql");
            int orc = Integer.parseInt(request.getParameter("orc"));
            int pos = Integer.parseInt(request.getParameter("pos"));
            int mys = Integer.parseInt(request.getParameter("mys"));
            if (orc != -1) {
                String korc = TransUtil.translate((String)ksql, (int)orc);
                writer.write("To Oracle:<br>&nbsp&nbsp" + korc + BR_STR);
            }
            if (pos != -1) {
                String kpos = TransUtil.translate((String)ksql, (int)pos);
                writer.write("To PostgresSQL:<br>&nbsp&nbsp" + kpos + BR_STR);
            }
            if (mys != -1) {
                String kmys = TransUtil.translate((String)ksql, (int)orc);
                writer.write("To MySQL:<br>&nbsp&nbsp" + kmys + BR_STR);
            }
            writer.flush();
        }
        catch (SqlTranslateException e) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Sorry,Translate Error!");
        }
    }

    public void getThemeCSS(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String themeNum = null;
        String css = null;
        try {
            themeNum = request.getParameter("themeNum");
            if (StringUtils.isEmpty((CharSequence)themeNum)) {
                String errorCode = "";
                String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a \u4e0d\u5b58\u5728\u53c2\u6570 themeNum", (String)"FormAction_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)errorMessage);
                return;
            }
            css = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getThemeCSS", themeNum);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)css);
        }
        catch (Exception e) {
            String errorCode = "";
            String errorMessage = ResManager.loadKDString((String)"\u83b7\u53d6\u754c\u9762\u4e3b\u9898\u6837\u5f0f\u5185\u5bb9\u5f02\u5e38\u3002", (String)"FormAction_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)errorMessage);
        }
    }

    public void getCustomCtlVersion(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String schemaId = request.getParameter("schemaId");
        if (StringUtils.isNotBlank((CharSequence)schemaId)) {
            String version = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getCustomCtlVersion", schemaId);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)version);
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"schemaId: \u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a.", (String)"FormAction_6", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private static boolean isNeedCheckCSRF() {
        String tenantId = RequestContext.get().getTenantId();
        String isNeedCheckCSRF = System.getProperty(tenantId + "_" + IS_NEED_CHECK_CSRF);
        if (StringUtils.isBlank((CharSequence)isNeedCheckCSRF)) {
            isNeedCheckCSRF = System.getProperty(IS_NEED_CHECK_CSRF);
        }
        return isNeedCheckCSRF == null || !"false".equalsIgnoreCase(isNeedCheckCSRF.trim());
    }

    private String getCtsyConfigByPageId(HttpServletRequest request, EntityTraceSpan span) {
        String config = "";
        String ctsynonce = request.getParameter("ctsynonce");
        String pageId = request.getParameter(PAGE_ID);
        String ctsynonceVal = CtsyListShowParameter.getCtsynonceVal((String)ctsynonce);
        span.addTag("ctsynonceVal", ctsynonceVal);
        if (StringUtils.isEmpty((CharSequence)ctsynonceVal) || ctsynonceVal.indexOf(",") == -1) {
            config = ResManager.loadKDString((String)"ctsynonce\u53c2\u6570\u6709\u8bef\u3002", (String)"FormAction_13", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
        } else {
            String remotePageId = CtsyListShowParameter.getCtsyRemotePageId((String)pageId);
            if (StringUtils.isNotEmpty((CharSequence)remotePageId)) {
                String[] tenantArray = ctsynonceVal.split(",");
                HashMap<String, String> params = new HashMap<String, String>(5);
                params.put("method", "getConfigByPageId");
                params.put(PAGE_ID, remotePageId);
                HashMap<String, HashMap<String, String>> paramsTemp = new HashMap<String, HashMap<String, String>>(1);
                paramsTemp.put(PARAMS, params);
                if (Boolean.parseBoolean(tenantArray[2])) {
                    Object resultMap = CtsyApiDispatchServiceHelper.invokeWebApi((String)tenantArray[0], (String)tenantArray[1], (String)"/v2/ctsy/ctform/handle", paramsTemp);
                    config = resultMap instanceof Map && ((Map)resultMap).get("data") instanceof String ? (String)((Map)resultMap).get("data") : ResManager.loadKDString((String)"\u6839\u636e\u9875\u9762id\u83b7\u53d6\u8fdc\u7aef\u7684\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"FormAction_15", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                } else {
                    String result = CtsyApiDispatchServiceHelper.post((String)tenantArray[0], (String)tenantArray[1], (String)"v2/ctsy/ctform/handle", (String)SerializationUtils.toJsonString(paramsTemp));
                    span.addTag("result", result);
                    Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                    if (openApiResult.get("data") instanceof String) {
                        config = (String)openApiResult.get("data");
                        config = config.replaceAll(remotePageId, pageId);
                    } else {
                        config = ResManager.loadKDString((String)"\u6839\u636e\u9875\u9762id\u83b7\u53d6\u8fdc\u7aef\u7684\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"FormAction_15", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                    }
                }
            } else {
                config = ResManager.loadKDString((String)"\u6839\u636e\u9875\u9762id\u672a\u83b7\u53d6\u5230\u8fdc\u7aef\u7684\u9875\u9762id\u3002", (String)"FormAction_16", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
            }
        }
        return config;
    }
}

