/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.web.DispatchServiceHelper;

public class MetaTemplateAction {
    private static final String METADATA_SERVICE = "MetadataService";

    public void getTemplates(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String templateType = request.getParameter("templateType");
        String result = (String)DispatchServiceHelper.invokeBOSService("MetaTemplateService", "getTemplates", templateType);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getFragmentTemplates(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String result = (String)DispatchServiceHelper.invokeBOSService("MetaTemplateService", "getFragmentTemplates", new Object[0]);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getDesignerFragmentMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String fragmentId = request.getParameter("fragmentId");
        String result = (String)DispatchServiceHelper.invokeBOSService("MetaTemplateService", "getDesignerFragmentMetadata", fragmentId);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getTemplateScheme(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String controlType = request.getParameter("controlType");
        String result = (String)DispatchServiceHelper.invokeBOSService("MetaTemplateService", "getTemplateScheme", controlType);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        return (Boolean)DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, "checkPermission", userId, 0L, null, "pc_devportal_main", "47150e89000000ac");
    }

    private String getUnauthorizedMsg() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error:", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"MetaTemplateAction_0", (String)"bos-webactions", (Object[])new Object[0]));
        return SerializationUtils.toJsonString(map);
    }
}

