/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.action.AllowGuest;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.web.DispatchServiceHelper;

public class MetadataAction {
    private static final String FORM_ID = "formId";
    private static final String FORM_ID_1 = "formid";
    private static final String METADATA_SERVICE = "MetadataService";
    private static final String ENTITY_ID = "entityId";
    private static final String CACHE = "cache";
    private static final String DEBUG_METADATA_SERVICE = "DebugMetadataService";
    private static final String PERMISSION_SERVICE = "PermissionService";
    private static final String MESSAGE = "formId is null";
    private static final String FORBIDDEN_STR = "access is not allowed.";
    private static final Log logger = LogFactory.getLog(MetadataAction.class);

    private static String getContent(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        in.close();
        return sb.toString();
    }

    public void getDomainModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean bizext;
            String modelType = request.getParameter("modelType");
            boolean isOnlyEntity = Boolean.parseBoolean(request.getParameter("onlyEntity"));
            boolean isExt = Boolean.parseBoolean(request.getParameter("ext"));
            String appId = this.getAppId(request);
            String formModel = "";
            formModel = isOnlyEntity ? (isExt ? (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getDomainModelOnlyEntityExt", modelType) : (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getDomainModelOnlyEntity", modelType)) : ((bizext = Boolean.parseBoolean(request.getParameter("bizext"))) ? (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getDomainModelBizExt", modelType) : (isExt ? (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getDomainModelExt", modelType) : (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getDomainModel", modelType)));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)formModel);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            String error = MetadataAction.isShowStackTrace() ? ex.getMessage() : this.getNormalError();
            throw new IOException(error);
        }
    }

    private String getNormalError() {
        RequestContext requestContext = RequestContext.get();
        String msg = "";
        if (requestContext != null) {
            msg = " TraceId:" + requestContext.getTraceId() + "\r\n";
        }
        msg = msg + " getDomainModel : error ";
        return msg;
    }

    private static boolean isShowStackTrace() {
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if ("true".equals(showStackTrace)) {
            return true;
        }
        try {
            Object isShowStackTrace;
            Map cache = ParameterReader.loadPublicParameterFromCache();
            if (cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
                return (Boolean)isShowStackTrace;
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u516c\u5171\u53c2\u6570\u5931\u8d25.", (Throwable)ex);
            return false;
        }
        return false;
    }

    public void help(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!MetadataAction.canAccessMetaDataHelp()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)FORBIDDEN_STR);
            return;
        }
        try (InputStream in = MetadataAction.class.getResourceAsStream("/metadataapihelp.html");){
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MetadataAction.getContent(in));
        }
    }

    public void rebuild(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!MetadataAction.canAccessMetaDataHelp()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)FORBIDDEN_STR);
            return;
        }
        if (!this.isAdminUser()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"formId is null,rebuild faile.");
            return;
        }
        String appId = this.getAppId(request);
        DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "rebuildFormRuntimeMeta", formId);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"sucess!");
    }

    public void rebuildAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!MetadataAction.canAccessMetaDataHelp()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)FORBIDDEN_STR);
            return;
        }
        if (!this.isAdminUser()) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        Boolean force = Boolean.valueOf(request.getParameter("force"));
        String appId = this.getAppId(request);
        String diffVerStr = request.getParameter("diffVer");
        if (StringUtils.isNotBlank((CharSequence)diffVerStr)) {
            Boolean diffVer = Boolean.valueOf(diffVerStr);
            Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "rebuildAllDiffVer", force, diffVer);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)result));
        } else {
            Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "rebuildAll", force);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)result));
        }
    }

    public void rebuildAllApp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!MetadataAction.canAccessMetaDataHelp()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)FORBIDDEN_STR);
            return;
        }
        String appId = this.getAppId(request);
        String appParamsStr = request.getParameter("appParamsStr");
        List<Object> rebuidAppParams = new ArrayList(1);
        if (StringUtils.isNotBlank((CharSequence)appParamsStr)) {
            rebuidAppParams = Arrays.asList(appParamsStr.split("-"));
        }
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "rebuildAllApp", rebuidAppParams);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)result));
    }

    public void getEntityType(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String entityId = request.getParameter(ENTITY_ID);
        String cache = request.getParameter(CACHE);
        String appId = this.getAppId(request);
        if (StringUtils.isNotEmpty((CharSequence)cache) && cache.equalsIgnoreCase("true")) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadEntityMetaFromCache", entityId)));
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadEntityMeta", entityId)));
        }
    }

    public void getEntityOperate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String entityId = request.getParameter(ENTITY_ID);
        String operKey = request.getParameter("operKey");
        String cache = request.getParameter(CACHE);
        String appId = this.getAppId(request);
        if (StringUtils.isNotEmpty((CharSequence)cache) && cache.equalsIgnoreCase("true")) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getEntityOperateFromCache", entityId, operKey)));
        } else if (StringUtils.isNotBlank((CharSequence)operKey)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadEntityOperationMeta", entityId, operKey)));
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadEntityAllOperationMeta", entityId)));
        }
    }

    public void getFormConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadFormConfig", formId)));
    }

    public void getControl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "getControls", formId)));
    }

    public void getFormDeployFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String appId = this.getAppId(request);
        String lang = request.getParameter("lang");
        String file = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "DesignMetadataService", "getFormDeployFile", formId, lang == null ? "" : lang);
        response.setContentType("application/xml");
        ActionUtil.writeResponseXml((ServletResponse)response, (CharSequence)file);
    }

    public void getDesignerMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        String designerMetaType = request.getParameter("designerMetaType");
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String srcFormId = request.getParameter("srcFormId");
        if (srcFormId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"srcFormId is null");
            return;
        }
        String srcScriptId = request.getParameter("srcScriptId");
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "getDesignerMetadata2", formId, designerMetaType, "", srcFormId, srcScriptId)));
    }

    @AllowGuest
    public void getFormMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getFormMetadata", formId)));
    }

    @AllowGuest
    public void getEntityMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String entityId = request.getParameter(ENTITY_ID);
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getEntityMetadata", entityId)));
    }

    @AllowGuest
    public void getJarInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String jarname = request.getParameter("jarname");
        String appId = this.getAppId(request);
        String jarInfo = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getJarInfo", jarname);
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)jarInfo);
    }

    @AllowGuest
    public void getClassUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String className = request.getParameter("className");
        String appId = this.getAppId(request);
        String jarInfo = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getClassUrl", className);
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)jarInfo);
    }

    private String getAppId(HttpServletRequest request) {
        String appId = request.getParameter("appId");
        appId = appId == null ? "bos" : appId;
        return appId;
    }

    public void getBizAppInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String bizAppId = request.getParameter("bizappid");
        String bizAppInfo = (String)DispatchServiceHelper.invokeBOSService(DEBUG_METADATA_SERVICE, "getAppMetadataByID", bizAppId);
        String result = SerializationUtils.toJsonString((Object)bizAppInfo);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    @AllowGuest
    public void getFormAndEntityMetadataDiff(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String day;
        String type;
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String number = request.getParameter("number");
        if (number == null) {
            number = request.getParameter("number");
        }
        if ((type = request.getParameter("type")) == null) {
            type = request.getParameter("type");
        }
        if ((day = request.getParameter("day")) == null) {
            day = request.getParameter("day");
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getFormAndEntityMetadataDiff", number, type, day)));
    }

    @AllowGuest
    public void getBotpRule(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ruleId = request.getParameter("ruleid");
        if (ruleId == null) {
            ruleId = request.getParameter("ruleId");
        }
        if (ruleId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"ruleid is null");
            return;
        }
        String type = request.getParameter("type");
        if (type == null) {
            type = "cr";
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"cr") && !StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"wr")) {
            type = "cr";
        }
        String cache = request.getParameter(CACHE);
        if (cache == null) {
            cache = "local";
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getBotpRule", ruleId, type, cache)));
    }

    public void getCheckFormInfoList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!(this.isDebug() || this.isAdminUser() || this.isHasRight())) {
            String notifyMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)notifyMsg);
            return;
        }
        String appnumbers = request.getParameter("appnumbers");
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, DEBUG_METADATA_SERVICE, "getCheckFormInfoList", appnumbers)));
    }

    public void savePageJsScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String unauthorizedMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)unauthorizedMsg);
            return;
        }
        String appId = this.getAppId(request);
        String scriptId = request.getParameter("scriptId");
        String bizAppId = request.getParameter("bizAppId");
        String formId = request.getParameter(FORM_ID);
        String formType = request.getParameter("formType");
        if (scriptId == null || bizAppId == null || formId == null || formType == null) {
            logger.info("scriptId={},bizAppId={},formId={},formType={}", new Object[]{scriptId, bizAppId, formId, formType});
            String errorMsg = "params is illegal";
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)errorMsg);
            return;
        }
        String scriptContent = request.getParameter("scriptContent");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("scriptId", scriptId);
        params.put("bizAppId", bizAppId);
        params.put(FORM_ID, formId);
        params.put("formType", formType);
        params.put("scriptContent", scriptContent);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "savePageJsScript", params)));
    }

    public void loadPageJsScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isHasRight()) {
            String unauthorizedMsg = this.getUnauthorizedMsg();
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)unauthorizedMsg);
            return;
        }
        String appId = this.getAppId(request);
        String scriptId = request.getParameter("scriptId");
        if (scriptId == null) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"scriptId is null");
            return;
        }
        List scriptIds = (List)SerializationUtils.fromJsonString((String)scriptId, List.class);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadPageJsScript", scriptIds)));
    }

    private static boolean canAccessMetaDataHelp() {
        String value = System.getProperty("allowupdatemetadata", "true");
        return "true".equals(value);
    }

    private String getUnauthorizedMsg() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error:", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"MetadataAction_0", (String)"bos-webactions", (Object[])new Object[0]));
        return SerializationUtils.toJsonString(map);
    }

    private boolean isDebug() {
        return Boolean.parseBoolean(System.getProperty("metadata.debug", "false"));
    }

    private boolean isAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        return (Boolean)DispatchServiceHelper.invokeBOSService(PERMISSION_SERVICE, "isAdminUser", userId);
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        return (Boolean)DispatchServiceHelper.invokeBOSService(METADATA_SERVICE, "checkPermission", userId, 0L, null, "pc_devportal_main", "47150e89000000ac");
    }
}

