/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.audit.exception.report.AuditReports;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.rule.BRErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;
import kd.bos.form.MessageTypes;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logging.logback.report.ReportObject;
import kd.bos.param.ParameterReader;

public class ExceptionHandler {
    private static final Log log = LogFactory.getLog(ExceptionHandler.class);
    private static ThreadLocal<String> formName = new ThreadLocal();

    public static Map<String, Object> HandlerErr(Throwable ex, String key) {
        return ExceptionHandler.loadData(ex, key);
    }

    public static void setFormName(String name) {
        formName.set(name);
    }

    public static void LoggerErr(RuntimeException Ex) {
    }

    private static Map<String, Object> loadData(Throwable Ex, String key) {
        ArrayList<HashMap<String, Object>> paras;
        KDException KDEx;
        HashMap<String, Object> ClientPageAction = null;
        HashMap<String, Object> ClientActionParas = null;
        while (Ex instanceof InvocationTargetException) {
            Ex = ((InvocationTargetException)Ex).getTargetException();
        }
        while (Ex.getCause() != null) {
            String msg = Ex.getMessage();
            if (msg == null) {
                Ex = Ex.getCause();
                continue;
            }
            String superMsg = Ex.getCause().getMessage();
            if (!msg.equals(superMsg)) break;
            Ex = Ex.getCause();
        }
        if (Ex instanceof KDBizException) {
            KDEx = (KDException)Ex;
            ClientPageAction = new HashMap<String, Object>();
            paras = new ArrayList<HashMap<String, Object>>();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap<String, Object>();
            ClientPageAction.put("a", "ShowNotificationMsg");
            ClientActionParas.put("type", 1);
            ClientActionParas.put("content", KDEx.getMessage());
            paras.add(ClientActionParas);
            if (BRErrorCode.isBRErrorCode((ErrorCode)((KDBizException)Ex).getErrorCode())) {
                ClientPageAction.put("a", "showMessage");
                ClientActionParas.put("msg", ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u51fa\u9519", (String)"ExceptionHandler_04", (String)"bos-mservice-form", (Object[])new Object[0]));
                ClientActionParas.put("detail", KDEx.getMessage());
                ClientActionParas.put("messageType", MessageTypes.Business);
            }
        } else if (Ex instanceof KDException) {
            KDEx = (KDException)Ex;
            ClientPageAction = new HashMap();
            paras = new ArrayList();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap();
            ExceptionHandler.setErrorShowNotiMsgOrErrMes(KDEx, ClientPageAction, ClientActionParas, log);
            ExceptionHandler.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras.add(ClientActionParas);
        } else if ((Ex instanceof RuntimeException || Ex instanceof SQLException) && Ex.getCause() instanceof KDException) {
            KDEx = (KDException)Ex.getCause();
            ClientPageAction = new HashMap();
            paras = new ArrayList();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap();
            ExceptionHandler.setErrorShowNotiMsgOrErrMes(KDEx, ClientPageAction, ClientActionParas, log);
            ExceptionHandler.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras.add(ClientActionParas);
        } else if (Ex instanceof SQLException && Ex.getCause() instanceof SQLException && Ex.getCause().getCause() instanceof KDException) {
            KDEx = (KDException)Ex.getCause().getCause();
            ClientPageAction = new HashMap();
            paras = new ArrayList();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap();
            ExceptionHandler.setErrorShowNotiMsgOrErrMes(KDEx, ClientPageAction, ClientActionParas, log);
            ExceptionHandler.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras.add(ClientActionParas);
        } else {
            ClientPageAction = new HashMap();
            ArrayList<HashMap<String, Object>> paras2 = new ArrayList<HashMap<String, Object>>();
            ClientPageAction.put("p", paras2);
            ClientActionParas = new HashMap();
            ClientPageAction.put("a", "showErrMsg");
            ExceptionHandler.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras2.add(ClientActionParas);
        }
        ExceptionHandler.reportException(ClientActionParas);
        return ClientPageAction;
    }

    private static void setErrorShowNotiMsgOrErrMes(KDException kdEx, Map<String, Object> clientPageAction, Map<String, Object> clientActionParas, Log log) {
        ErrorCode errorCode = kdEx.getErrorCode();
        if (errorCode != null) {
            String message = errorCode.getMessage();
            if (errorCode.equals((Object)XDBErrorCode.xdbSqlRWTimeOut)) {
                clientPageAction.put("a", "ShowNotificationMsg");
                clientActionParas.put("type", 1);
                clientActionParas.put("content", ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6c34\u5e73\u5206\u8868\u64cd\u4f5c\uff0c\u8868\u5355\u8bfb\u5199\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f85\u6c34\u5e73\u5206\u8868\u5b8c\u6210\u3002", (String)"ExceptionHandler_3", (String)"bos-mservice-form", (Object[])new Object[0]));
                log.error(message, (Throwable)kdEx);
            } else if (XDBErrorCode.xdbMultiDBWrited.equals((Object)errorCode)) {
                clientPageAction.put("a", "ShowNotificationMsg");
                clientActionParas.put("type", 1);
                clientActionParas.put("content", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u64cd\u4f5c\u5728\u4e8b\u52a1\u4e2d\u8de8\u5e93\u5199\u5165\u6570\u636e\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ExceptionHandler_4", (String)"bos-mservice-form", (Object[])new Object[0]));
                log.error(message, (Throwable)kdEx);
            } else if (errorCode.equals((Object)XDBErrorCode.xdbDeleteShardingColumn) || errorCode.equals((Object)XDBErrorCode.xdbUpdateShardingColumn) || errorCode.equals((Object)XDBErrorCode.xdbRenameTable) || errorCode.equals((Object)XDBErrorCode.xdbDeleteShardingTable) || "bos.orm.read.dataNotExist".equals(errorCode.getCode())) {
                clientPageAction.put("a", "ShowNotificationMsg");
                clientActionParas.put("type", 1);
                clientActionParas.put("content", message);
                log.error(message, (Throwable)kdEx);
            } else if (PrivacyDataConstant.WARNCODE.equals((Object)errorCode)) {
                clientPageAction.put("a", "ShowNotificationMsg");
                clientActionParas.put("type", 1);
                clientActionParas.put("content", kdEx.getMessage());
                log.error(message, (Throwable)kdEx);
            } else {
                clientPageAction.put("a", "showErrMsg");
            }
        } else {
            clientPageAction.put("a", "showErrMsg");
        }
    }

    private static String getAccountName() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (account != null) {
            return account.getAccountName();
        }
        return "";
    }

    private static void reportException(Map<String, Object> ClientActionParas) {
        ReportObject a = new ReportObject();
        a.tag("acctname", ExceptionHandler.getAccountName());
        a.tag("errormsg", (String)ClientActionParas.get("errorTitle"));
        a.tag("stack", (String)ClientActionParas.get("errorInfo"));
        a.tag("ver", BOSRuntime.getVersion());
        OperationContext oc = OperationContext.get();
        if (oc != null) {
            a.tag("appid", oc.getAppId());
            a.tag("formid", oc.getFormId());
            a.tag("formname", oc.getFormName());
            a.tag("opkey", oc.getOpKey());
            a.tag("methodname", oc.getOpMethod());
        }
        AuditReports.report((boolean)false, (ReportObject[])new ReportObject[]{a});
    }

    private static void SetExceptionErrorInfo(Throwable Ex, String key, Map<String, Object> ClientActionParas) {
        StringBuilder oSB = new StringBuilder();
        oSB.append("\r\nKey: ").append(key).append("\r\n");
        RequestContext ctx = RequestContext.get();
        oSB.append("TraceId\uff1a").append(ctx != null ? ctx.getTraceId() : null).append("\r\n");
        oSB.append("Instance\uff1a").append(Instance.getInstanceId()).append("\r\n");
        oSB.append(ResManager.loadKDString((String)"\u53d1\u751f\u65f6\u95f4\uff1a", (String)"ExceptionHandler_0", (String)"bos-mservice-form", (Object[])new Object[0])).append(new Date().toString()).append("\r\n");
        if (ExceptionHandler.isShowStackTrace()) {
            oSB.append("===================================================\r\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Ex.printStackTrace(pw);
            oSB.append(ResManager.loadKDString((String)"\u8c03\u7528\u5806\u6808\uff1a", (String)"ExceptionHandler_1", (String)"bos-mservice-form", (Object[])new Object[0])).append("\r\n");
            oSB.append(sw.getBuffer().toString()).append("\r\n");
        }
        ClientActionParas.put("errorTitle", Instance.getAppName() + ":" + Ex.getMessage());
        ClientActionParas.put("errorInfo", oSB.toString());
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = ParameterReader.loadPublicParameterFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

