/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ForbiddenRunMCInfo;
import kd.bos.orm.util.CollectionUtils;

class ForbiddenRunService {
    private static Log log = LogFactory.getLog(ForbiddenRunService.class);
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String KEY_FORBIDDENPROP = ".forbiddenprop";
    private static final String MCDEMOTE_FORBIDDENRUN = "mcdemote_forbiddenrun";
    private static final String TYPE_NAME = "ForbiddenRunService";
    private IFormView formView;
    private FormShowParameter showParameter;
    private List<Map<String, Object>> params;

    public ForbiddenRunService(IFormView formView, List<Map<String, Object>> params) {
        this.formView = formView;
        this.params = params;
        this.showParameter = formView.getFormShowParameter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isForbiddenRun() {
        Throwable throwable = null;
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"isForbiddenRun");){
            List forbiddenRunInfoList;
            String formId;
            boolean isForbiddenRun;
            block30: {
                boolean bl;
                block31: {
                    String forbiddenRunMCInfoStr;
                    block28: {
                        boolean bl2;
                        block29: {
                            block26: {
                                boolean bl3;
                                block27: {
                                    isForbiddenRun = false;
                                    if (this.showParameter.getCustomParam(MCDEMOTE_FORBIDDENRUN) == null || !((Boolean)this.showParameter.getCustomParam(MCDEMOTE_FORBIDDENRUN)).booleanValue()) break block26;
                                    bl3 = true;
                                    if (span == null) return bl3;
                                    if (throwable == null) break block27;
                                    try {
                                        span.close();
                                        return bl3;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                        return bl3;
                                    }
                                }
                                span.close();
                                return bl3;
                            }
                            formId = this.getFormId();
                            forbiddenRunMCInfoStr = System.getProperty(RequestContext.get().getTenantId() + RequestContext.get().getAccountId() + KEY_FORBIDDENPROP, "");
                            if (!StringUtils.isBlank((CharSequence)forbiddenRunMCInfoStr)) break block28;
                            bl2 = false;
                            if (span == null) return bl2;
                            if (throwable == null) break block29;
                            try {
                                span.close();
                                return bl2;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                return bl2;
                            }
                        }
                        span.close();
                        return bl2;
                    }
                    span.addTag("forbiddenRunMCInfo", forbiddenRunMCInfoStr);
                    forbiddenRunInfoList = SerializationUtils.fromJsonStringToList((String)forbiddenRunMCInfoStr, ForbiddenRunMCInfo.class);
                    if (!CollectionUtils.isEmpty((Collection)forbiddenRunInfoList)) break block30;
                    bl = false;
                    if (span == null) return bl;
                    if (throwable == null) break block31;
                    try {
                        span.close();
                        return bl;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        return bl;
                    }
                }
                span.close();
                return bl;
            }
            try {
                for (Map<String, Object> param : this.params) {
                    ForbiddenRunMCInfo forbiddenRunParam = new ForbiddenRunMCInfo();
                    forbiddenRunParam.setKey((String)param.get("key"));
                    forbiddenRunParam.setMethodName((String)param.get("methodName"));
                    forbiddenRunParam.setArgs((List)param.get("args"));
                    forbiddenRunParam.setFormId(formId);
                    if (!this.isForbiddenRunByParam(forbiddenRunInfoList, forbiddenRunParam)) continue;
                    isForbiddenRun = true;
                    if (!"treeMenuClick".equalsIgnoreCase(forbiddenRunParam.getMethodName().trim()) || !"navigationbar".equalsIgnoreCase(forbiddenRunParam.getKey().trim())) {
                        this.showParameter.getCustomParams().put(MCDEMOTE_FORBIDDENRUN, true);
                    }
                    this.formView.cacheFormShowParameter();
                    break;
                }
            }
            catch (Exception e) {
                log.error("Degraded forbidden request function is abnormal, please check the MC parameter configuration.", (Throwable)e);
            }
            boolean bl = isForbiddenRun;
            return bl;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
    }

    private boolean isForbiddenRunByParam(List<ForbiddenRunMCInfo> forbiddenRunInfoList, ForbiddenRunMCInfo param) {
        for (ForbiddenRunMCInfo forbiddenRunMcInfo : forbiddenRunInfoList) {
            if (!forbiddenRunMcInfo.isEquals(param)) continue;
            return true;
        }
        return false;
    }

    public String showForbiddenRunMessage() {
        ArrayList<Map<String, Object>> acts = new ArrayList<Map<String, Object>>();
        HashMap<String, String> jo = new HashMap<String, String>();
        jo.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u5df2\u88ab\u7981\u7528\uff0c\u5177\u4f53\u6062\u590d\u65f6\u95f4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\u5982\u9700\u4f7f\u7528\u975e\u7981\u7528\u529f\u80fd\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00\u3002", (String)"ForbiddenRunService_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        jo.put("messageType", (String)MessageTypes.Default);
        acts.add(this.createAction("showMessage", jo));
        return SerializationUtils.toJsonString(acts);
    }

    private Map<String, Object> createAction(String actionName, Object arg) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>(1);
        paras.add(arg);
        action.put("p", paras);
        return action;
    }

    public String getFormId() {
        String formId = this.showParameter.getFormId();
        if (this.showParameter instanceof ListShowParameter) {
            formId = ((ListShowParameter)this.showParameter).getBillFormId();
        }
        return formId;
    }

    public void writeLog(String pageId, Map<String, Object> param) {
        try {
            String paramKey = (String)param.get("key");
            String methodName = (String)param.get("methodName");
            log.info("batchInvokeAction request parameters\uff0cpageId\uff1a'{}'\uff0ctenantId\uff1a'{}'\uff0centityId\uff1a'{}'\uff0cformId\uff1a'{}'\uff0ckey\uff1a'{}'\uff0cmethodName\uff1a'{}'", new Object[]{pageId, RequestContext.get().getTenantId(), this.formView.getEntityId(), this.getFormId(), paramKey, methodName});
        }
        catch (Exception e) {
            log.error("batchInvokeAction Request parameter parsing exception", (Throwable)e);
        }
    }
}

