/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.healthvalidate;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.health.validate.HealthMetaDataExcutor;
import kd.bos.health.validate.HealthMetaDataResult;
import kd.bos.health.validate.HealthResult;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.mservice.healthvalidate.HealthValidateService;

public class HealthValidateServiceImpl
implements HealthValidateService {
    public String validate(String apps) {
        HealthMetaDataExcutor excutor = new HealthMetaDataExcutor();
        String[] app = apps.split(",");
        List<String> numberList = this.getFormNumbersByAppNumber(app);
        excutor.setNumbers(numberList);
        List resultList = excutor.execute();
        ArrayList<String> returnInfo = new ArrayList<String>();
        for (HealthResult healthResult : resultList) {
            if (!(healthResult instanceof HealthMetaDataResult)) continue;
            HealthMetaDataResult result = (HealthMetaDataResult)healthResult;
            returnInfo.add(result.getNumber() + ":" + result.getName() + " Warning: " + result.getReturnText() + " ErrorField: " + result.getMetadataField());
        }
        return SerializationUtils.toJsonString(returnInfo);
    }

    private List<String> getFormNumbersByAppNumber(String[] app) {
        final ArrayList<String> numbers = new ArrayList<String>();
        String sql = "select fnumber from t_meta_formdesign where fbizappid=?";
        for (String appNumber : app) {
            String appId = AppReader.getAppIdByNumber((String)appNumber);
            Object[] queryParams = new Object[]{new SqlParameter("fbizappid", 12, (Object)appId)};
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<Object>(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        String number = resultSet.getString(1);
                        numbers.add(number);
                    }
                    return null;
                }
            });
        }
        return numbers;
    }
}

