/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.list;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mservice.list.ListQueryParameter;
import kd.bos.mservice.list.ListService;
import kd.bos.mservice.list.ListServiceResult;
import kd.bos.mservice.list.ListServiceResultBuilder;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.ListController;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ResultCodeEnum;

public class ListServiceImpl
implements ListService {
    private static final Log log = LogFactory.getLog(ListServiceImpl.class);
    private static final String SPAN_TYPE_NAME = "list";
    private static final String FUNCTION_AUDIT_NAME = "function";
    private static final String SERVICE_AUDIT_PREFIX_NAME = "function_";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";

    public ListServiceResult getListRealCount(ListQueryParameter listQueryParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"listService.realCount");){
            ListServiceResult checkResult;
            if (span.isRealtime()) {
                span.addLocaleTag("queryParameter", (Object)SerializationUtils.toJsonString((Object)listQueryParameter));
            }
            if ((checkResult = this.checkListQueryParameter(listQueryParameter)) != null) {
                if (span.isRealtime()) {
                    span.addLocaleTag("realCountResult", (Object)SerializationUtils.toJsonString((Object)checkResult));
                }
                ListServiceResult listServiceResult = checkResult;
                return listServiceResult;
            }
            ListShowParameter listShowParameter = this.createListShowParameter(listQueryParameter);
            ListServiceResult listServiceResult = this.createContextAndInvokeMethod(listShowParameter, "queryListRealCount", new Object[0]);
            if (span.isRealtime()) {
                span.addLocaleTag("realCountResult", (Object)SerializationUtils.toJsonString((Object)listServiceResult));
            }
            ListServiceResult listServiceResult2 = listServiceResult;
            return listServiceResult2;
        }
    }

    public ListServiceResult getBillDataCount(ListQueryParameter listQueryParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"listService.billDataCount");){
            ListServiceResult checkResult;
            if (span.isRealtime()) {
                span.addLocaleTag("queryParameter", (Object)SerializationUtils.toJsonString((Object)listQueryParameter));
            }
            if ((checkResult = this.checkListQueryParameter(listQueryParameter)) != null) {
                if (span.isRealtime()) {
                    span.addLocaleTag("billDataCountResult", (Object)SerializationUtils.toJsonString((Object)checkResult));
                }
                ListServiceResult listServiceResult = checkResult;
                return listServiceResult;
            }
            ListShowParameter listShowParameter = this.createListShowParameter(listQueryParameter);
            ListServiceResult listServiceResult = this.createContextAndInvokeMethod(listShowParameter, "queryBillDataCount", new Object[0]);
            if (span.isRealtime()) {
                span.addLocaleTag("billDataCountResult", (Object)SerializationUtils.toJsonString((Object)listServiceResult));
            }
            ListServiceResult listServiceResult2 = listServiceResult;
            return listServiceResult2;
        }
    }

    public ListServiceResult getListSummaryResult(ListQueryParameter listQueryParameter, String ... sumFields) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"listService.summaryResult");){
            Object dataObj;
            ListServiceResult checkResult;
            if (span.isRealtime()) {
                span.addLocaleTag("queryParameter", (Object)SerializationUtils.toJsonString((Object)listQueryParameter));
                span.addLocaleTag("sumFields", (Object)sumFields);
            }
            if ((checkResult = this.checkListQueryParameter(listQueryParameter)) != null) {
                if (span.isRealtime()) {
                    span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString((Object)checkResult));
                }
                ListServiceResult listServiceResult = checkResult;
                return listServiceResult;
            }
            if (sumFields == null || sumFields.length == 0) {
                ListServiceResult sumFieldsCheckResult = ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_SUMFIELDSERROR);
                if (span.isRealtime()) {
                    span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString(sumFieldsCheckResult));
                }
                ListServiceResult listServiceResult = sumFieldsCheckResult;
                return listServiceResult;
            }
            String billFormId = listQueryParameter.getBillFormId();
            String entityId = FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId();
            if (StringUtils.isBlank((CharSequence)entityId)) {
                ListServiceResult entityIdCheckResult = ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_ENTITYID_NULL);
                if (span.isRealtime()) {
                    span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString(entityIdCheckResult));
                }
                ListServiceResult listServiceResult = entityIdCheckResult;
                return listServiceResult;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            ArrayList<String> rightSumFields = new ArrayList<String>(sumFields.length);
            for (String sumField : sumFields) {
                if (!StringUtils.isNotBlank((CharSequence)sumField)) continue;
                String[] splitField = sumField.split("\\.");
                String fieldName = splitField[splitField.length - 1];
                rightSumFields.add(fieldName);
                IDataEntityProperty property = mainEntityType.findProperty(fieldName);
                if (property == null) {
                    String message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6807\u8bc6\u5b57\u6bb5\u5728\u5b9e\u4f53\u4e2d\u4e0d\u5b58\u5728", (String)"ListServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sumField);
                    ListServiceResult sumFieldsCheckResult = ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_SUMFIELDNOTEXIST, message);
                    if (span.isRealtime()) {
                        span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString(sumFieldsCheckResult));
                    }
                    ListServiceResult listServiceResult = sumFieldsCheckResult;
                    return listServiceResult;
                }
                if (property instanceof DecimalProp) continue;
                String message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6807\u8bc6\u5b57\u6bb5\u4e0d\u652f\u6301\u5408\u8ba1", (String)"ListServiceImpl_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sumField);
                ListServiceResult sumFieldsCheckResult = ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_NOTALLOWEDSUMMARY, message);
                if (span.isRealtime()) {
                    span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString(sumFieldsCheckResult));
                }
                ListServiceResult listServiceResult = sumFieldsCheckResult;
                return listServiceResult;
            }
            ListShowParameter listShowParameter = this.createListShowParameter(listQueryParameter);
            ListServiceResult listServiceResult = this.createContextAndInvokeMethod(listShowParameter, "querySummaryResults", new Object[]{rightSumFields.toArray(new String[0])});
            if (listServiceResult.getSuccess().booleanValue() && (dataObj = listServiceResult.getData()) instanceof List) {
                List datas = (List)dataObj;
                ArrayList<SummaryResult> returnValue = new ArrayList<SummaryResult>(sumFields.length);
                for (SummaryResult data : datas) {
                    if (!rightSumFields.contains(data.getFieldName())) continue;
                    returnValue.add(data);
                }
                listServiceResult = ListServiceResultBuilder.success(returnValue);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("summaryResult", (Object)SerializationUtils.toJsonString((Object)listServiceResult));
            }
            ListServiceResult listServiceResult2 = listServiceResult;
            return listServiceResult2;
        }
    }

    private ListServiceResult checkListQueryParameter(ListQueryParameter listQueryParameter) {
        if (listQueryParameter == null) {
            return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_LISTQUERYPARAMETER_NULL);
        }
        if (StringUtils.isBlank((CharSequence)listQueryParameter.getBillFormId())) {
            return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_BILLFORMID_NULL);
        }
        if (StringUtils.isBlank((CharSequence)listQueryParameter.getFormId())) {
            return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_FORMID_NULL);
        }
        if (StringUtils.isBlank((CharSequence)listQueryParameter.getAppId())) {
            return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_APPID_NULL);
        }
        return null;
    }

    private ListShowParameter createListShowParameter(ListQueryParameter listQueryParameter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId(listQueryParameter.getFormId());
        listShowParameter.setBillFormId(listQueryParameter.getBillFormId());
        if (StringUtils.isNotBlank((CharSequence)listQueryParameter.getParentFormId())) {
            listShowParameter.setParentFormId(listQueryParameter.getParentFormId());
        }
        listShowParameter.setAppId(listQueryParameter.getAppId());
        if (StringUtils.isNotBlank((CharSequence)listQueryParameter.getFilterSchemeId())) {
            listShowParameter.setFilterSchemeId(listQueryParameter.getFilterSchemeId());
        }
        listShowParameter.setHasRight(listQueryParameter.isHasRight());
        listShowParameter.setIsolationOrg(listQueryParameter.isIsolationOrg());
        if (!CollectionUtils.isEmpty((Map)listQueryParameter.getCustomParams())) {
            listShowParameter.setCustomParams(listQueryParameter.getCustomParams());
        }
        listShowParameter.setCustomParam("appid", (Object)listQueryParameter.getAppId());
        listShowParameter.setLoadData(false);
        return listShowParameter;
    }

    private FormServiceImpl getFormService() {
        return new FormServiceImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ListServiceResult createContextAndInvokeMethod(ListShowParameter listShowParameter, String methodName, Object[] args) {
        try {
            String pageId = null;
            Map<String, Object> lspMaps = this.getFormService().createConfig((FormShowParameter)listShowParameter);
            pageId = (String)lspMaps.get("pageId");
            if (StringUtils.isBlank((CharSequence)pageId)) {
                return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_PAGEID_NULL);
            }
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            if (!(formView instanceof IListView)) return ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_NOT_LISTVIEW);
            IListView listView = (IListView)formView;
            ListController listController = (ListController)listView.getService(IFormController.class);
            listController.loadData();
            try {
                Object returnValue = this.invokeMethod((IFormView)listView, listController, methodName, args);
                if (returnValue != null) {
                    ListServiceResult<Object> listServiceResult = ListServiceResultBuilder.success(returnValue);
                    return listServiceResult;
                }
                ListServiceResult listServiceResult = ListServiceResultBuilder.errorOf(ResultCodeEnum.LIST_FAILED_RETURNVALUE_NULL);
                return listServiceResult;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e});
            }
            finally {
                listController.release(null);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e});
        }
    }

    private Object invokeMethod(IFormView formView, Object object, String methodName, Object[] args) throws Exception {
        String serviceName = object.getClass().getName() + "." + methodName + '@' + formView.getFormShowParameter().getFormId();
        try (Auditable audit = Audit.audit((String)("function,function_" + serviceName), (Object[])new Object[]{serviceName, args});){
            Class<?> objClass = object.getClass();
            Method method = null;
            if (args == null || args.length == 0) {
                method = objClass.getDeclaredMethod(methodName, new Class[0]);
            } else {
                Class[] paramTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    paramTypes[i] = args[i].getClass();
                }
                method = objClass.getDeclaredMethod(methodName, paramTypes);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object object2 = method.invoke(object, args);
            return object2;
        }
    }
}

