/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.metatemplate.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.metatemplate.scheme.MetaSchemeTemplate;
import kd.bos.mservice.metatemplate.scheme.MetaSchemeTemplateChildren;
import kd.bos.mservice.metatemplate.scheme.MetaSchemeTemplateParent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetaSchemeTemplateServiceImpl {
    private static final String ENABLE = "enable";
    private static final String TEMPLATEITEMS = "number,name,enable,group.number,json_tag,title,mulcolums,smallimg,image,order,value,hoverimg";
    private static final Log LOGGER = LogFactory.getLog(MetaSchemeTemplateServiceImpl.class);

    public String getTemplateScheme(String controlType) {
        DynamicObjectCollection schemeTemplate = QueryServiceHelper.query((String)"bos_schemetemplate", (String)TEMPLATEITEMS, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)controlType), new QFilter(ENABLE, "=", (Object)"1")});
        List<DynamicObject> sortSchemeTemplate = this.sortOrder(schemeTemplate);
        Map dynamicObjectGroupMap = sortSchemeTemplate.stream().collect(Collectors.groupingBy(x -> x.getString("title"), LinkedHashMap::new, Collectors.toList()));
        ArrayList<MetaSchemeTemplateChildren> childList = new ArrayList<MetaSchemeTemplateChildren>(10);
        for (Map.Entry entrySet : dynamicObjectGroupMap.entrySet()) {
            String title = (String)entrySet.getKey();
            List dynamicObjectList = (List)entrySet.getValue();
            ArrayList<MetaSchemeTemplate> items = new ArrayList<MetaSchemeTemplate>(10);
            for (DynamicObject dynamicObject : dynamicObjectList) {
                MetaSchemeTemplate item = new MetaSchemeTemplate();
                String number = dynamicObject.getString("number");
                item.setKey(number);
                item.setName(dynamicObject.getString("name"));
                item.setSmallImg(dynamicObject.getBoolean("smallImg"));
                item.setImage(dynamicObject.getString("image"));
                item.setValue(dynamicObject.getInt("value"));
                item.setHoverimg(dynamicObject.getString("hoverimg"));
                String string = dynamicObject.getString("json_tag");
                if (StringUtils.isNotEmpty((CharSequence)string)) {
                    try {
                        item.setJson((JSONObject)JSON.parse((String)string));
                    }
                    catch (Exception e) {
                        LOGGER.error(number + "\uff1a" + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684Json\u5b57\u7b26\u4e32\u6570\u636e\u6709\u8bef\u3002", (String)"MetaSchemeTemplateServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]));
                    }
                }
                items.add(item);
            }
            MetaSchemeTemplateChildren child = new MetaSchemeTemplateChildren();
            child.setTitle(title);
            child.setMulColums((Boolean)((DynamicObject)dynamicObjectList.get(0)).get("mulColums"));
            child.setItems(items);
            childList.add(child);
        }
        MetaSchemeTemplateParent parent = new MetaSchemeTemplateParent();
        parent.setControlName(controlType);
        parent.setChildren(childList);
        return SerializationUtils.toJsonString(Collections.singletonList(parent));
    }

    private List<DynamicObject> sortOrder(DynamicObjectCollection dynamicObjects) {
        List<DynamicObject> list = dynamicObjects.stream().sorted((a, b) -> {
            Integer orderA = (Integer)a.get("order");
            Integer orderB = (Integer)b.get("order");
            if (orderA == null || orderA.equals(0)) {
                return 1;
            }
            if (orderB == null || orderB.equals(0)) {
                return -1;
            }
            return orderA - orderB;
        }).collect(Collectors.toList());
        return list;
    }
}

