/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.mservice.task.SchTaskFormService;
import kd.bos.mvc.SessionManager;
import kd.bos.response.ResponseHeader;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingTask;
import kd.bos.schedule.api.StopTask;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskType;
import kd.bos.schedule.form.JobFormDao;
import kd.bos.schedule.form.TaskClickProxy;
import kd.bos.util.StringUtils;

public class SchTaskFormServiceImpl
implements SchTaskFormService {
    private static Log log = LogFactory.getLog(SchTaskFormServiceImpl.class);

    public String taskClick(String rootPageId, String taskId, String itemKey, String params) {
        try {
            IFormView mainView = SessionManager.getCurrent().getView(rootPageId);
            if (mainView != null) {
                TaskClickProxy taskClickProxy = new TaskClickProxy(mainView, taskId);
                taskClickProxy.click(itemKey);
                List results = mainView == null ? new ArrayList() : mainView.getActionResult();
                String str_result = SerializationUtils.toJsonString(results);
                return str_result;
            }
            return this.handleTimeout(rootPageId, params);
        }
        catch (Exception ex) {
            List<Object> results = this.createJSONObjectException("", ex);
            String jsonString = SerializationUtils.toJsonString(results);
            log.error(jsonString);
            return jsonString;
        }
    }

    public String clearTasks(String rootPageId, List<String> taskIds) {
        try {
            IFormView mainView = SessionManager.getCurrent().getView(rootPageId);
            if (StringUtils.isEmpty((String)rootPageId) || mainView != null) {
                for (String taskId : taskIds) {
                    TaskClickProxy taskClickProxy = new TaskClickProxy(mainView, taskId);
                    taskClickProxy.release();
                }
                List results = mainView == null ? new ArrayList() : mainView.getActionResult();
                String str_result = SerializationUtils.toJsonString(results);
                return str_result;
            }
            return this.handleTimeout(rootPageId, "clearTasks");
        }
        catch (Exception ex) {
            List<Object> results = this.createJSONObjectException("", ex);
            String jsonString = SerializationUtils.toJsonString(results);
            log.error(jsonString);
            return jsonString;
        }
    }

    public TaskType getTaskType(String className) {
        TaskType taskType = new TaskType();
        try {
            Class<?> aClass = Class.forName(className);
            Object instance = aClass.newInstance();
            if (!(instance instanceof Task)) {
                taskType.setErrorMsg("NOTASK");
                return taskType;
            }
            taskType.getRouteModes().add(RouteMode.RAMDOM);
            if (instance instanceof ShardingTask) {
                taskType.getRouteModes().add(RouteMode.SHARDINGTASK);
            }
            if (instance instanceof BroadcastTask) {
                taskType.getRouteModes().add(RouteMode.SHARDINGBROADCAST);
            }
            if (instance instanceof StopTask) {
                taskType.setCanStop(true);
            }
            Task taskInstance = (Task)instance;
            taskType.setSupportReschedule(taskInstance.isSupportReSchedule());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25:" + e.getMessage());
            taskType.setErrorMsg("CLASSNOTFOUND");
        }
        return taskType;
    }

    public List<Map<String, Object>> getUnConfirmTasks() {
        return JobFormDao.getUnConfirmTasks();
    }

    private List<Object> createJSONObjectException(String method, Throwable ex) {
        TX.setResponseException((Throwable)ex);
        ArrayList<Object> acts = new ArrayList<Object>();
        Map<String, Object> action = ExceptionHandler.HandlerErr(ex, "");
        acts.add(action);
        ResponseHeader.get().error(new ErrorCode("TaskServiceInvoke/" + method, ex.getMessage()));
        return acts;
    }

    private String handleTimeout(String rootPageId, String params) {
        ResponseHeader.get().error(new ErrorCode("FormServiceImpl.handleTimeout", "login is timeout."));
        log.warn("handleTimeOut, userId: {}, pageId: {}, params: {}", new Object[]{RequestContext.get().getCurrUserId(), rootPageId, params});
        log.warn(String.format("\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5237\u65b0:pageId=%s,accountId=%s", rootPageId, CacheKeyUtil.getAcctId()));
        return SerializationUtils.toJsonString(this.showTimeOutMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5237\u65b0\u3002", (String)"SchTaskFormServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]), "refleshrootpage"));
    }

    private List<Object> showTimeOutMessage(String msg, String timeoutType) {
        ArrayList<Object> acts = new ArrayList<Object>();
        HashMap<String, Object> jo = new HashMap<String, Object>();
        jo.put("msg", msg);
        jo.put("detail", "");
        jo.put("id", timeoutType);
        jo.put("messageType", MessageTypes.Default);
        jo.put("confirmType", ConfirmTypes.Default.getValue());
        jo.put("button_type", MessageBoxOptions.None.getValue());
        acts.add(this.createAction("showConfirm", jo));
        return acts;
    }

    private Map<String, Object> createAction(String actionName, Object arg) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>(1);
        paras.add(arg);
        action.put("p", paras);
        return action;
    }
}

