/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.card;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mvc.card.CardView;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.url.UrlService;

public class CardServiceImpl {
    public String getCardInfo(String cardId, String formId, String params) {
        try (EntityTraceSpan span = EntityTracer.create((String)"CardService", (String)"getCardInfo");){
            Map mapparam = params == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            String string = SerializationUtils.toJsonString(this.loadCardInfo(cardId, formId, mapparam));
            return string;
        }
    }

    private Map<String, Object> loadCardInfo(String cardId, String formId, Map<String, Object> param) {
        CardView cardView = new CardView(formId, cardId, param);
        MetadataService MetadataServiceImpl2 = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = MetadataServiceImpl2.loadClientFormMeta(formId);
        Map formMetaMap = (Map)SerializationUtils.fromJsonString((String)metadata, Map.class);
        HashMap<String, Object> cardInfo = new HashMap<String, Object>();
        cardView.loadData();
        cardInfo.put("metadata", formMetaMap);
        cardInfo.put("actions", cardView.getActionResult());
        cardInfo.put("systemConfig", this.getSystemConfig());
        Integer intervalItem = cardView.getIntervalTime();
        if (intervalItem != null) {
            cardInfo.put("itime", intervalItem);
        }
        return cardInfo;
    }

    private Map<String, Object> getSystemConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>(16);
        String mobDomainUrl = UrlService.getMobileDomainContextUrl();
        config.put("ajaxUrl", mobDomainUrl);
        String fileServerUrl = UrlService.getImageFullUrl((String)"");
        config.put("fileserver", fileServerUrl);
        String imageVersion = System.getProperty("imageserver.imageversion");
        if (StringUtils.isEmpty((CharSequence)imageVersion)) {
            config.put("imgversion", "0.5");
        } else {
            config.put("imgversion", imageVersion);
        }
        return config;
    }

    public String batchInvokeAction(String cardId, String formId, String params) {
        try (EntityTraceSpan span = EntityTracer.create((String)"CardService", (String)"batchInvokeAction");){
            span.addTag("cardId", cardId);
            span.addTag("formId", formId);
            span.addTag("params", params);
            List parameters = (List)SerializationUtils.fromJsonString((String)params, List.class);
            CardView cardView = new CardView(formId, cardId, null);
            String paramKey = "";
            String methodName = null;
            HashMap<String, List> resultInfo = new HashMap<String, List>();
            for (Map param : parameters) {
                List r;
                paramKey = (String)param.get("key");
                methodName = (String)param.get("methodName");
                cardView.setParameter(param);
                if ("click".equalsIgnoreCase(methodName)) {
                    cardView.click(paramKey);
                } else if ("timerElapsed".equalsIgnoreCase(methodName)) {
                    cardView.timerElapsed();
                }
                if ((r = cardView.getActionResult()) == null) continue;
                resultInfo.put("actions", r);
            }
            String string = SerializationUtils.toJsonString(resultInfo);
            return string;
        }
    }
}

