/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.dynplugin;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.form.dynplugin.FormDynamicProxyPluginFactory;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta;
import kd.bos.mservice.result.ApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.service.dynplugin.DynPluginBind;
import kd.bos.service.dynplugin.DynamicPluginService;
import kd.bos.util.CollectionUtils;

public class DynamicPluginServiceImpl
implements DynamicPluginService {
    private static final Log log = LogFactory.getLog(DynamicPluginServiceImpl.class);
    private static final String TYPE_NAME = "DynamicPluginServiceImpl";
    private static final String SPAN_TYPE_READER = "datareader";
    private static final String PARAM_FILTERS = "filters";
    public static final String FORMID_DYNPLUGIN = "bos_dynplugin";
    public static final String FORMID_DYNPLUGINBIND = "bos_dynpluginbind";
    public static final String KEY_INTERFACETYPE = "dynplugin.interfacetype";
    public static final String KEY_EVENTMETHOD = "dynplugin.eventmethod";
    public static final String KEY_CLIENT = "dynplugin.client";
    public static final String KEY_NUMBER = "dynplugin.number";
    public static final String KEY_ENABLE = "enable";
    public static final String MODELTYPE = "modeltype";
    public static final String KEY_TEXT = "text";
    public static final String KEY_ID = "id";
    private static final String NUMBER = "number";
    public static final String KEY_DYNPLUGIN_ROLE = "role";
    public static final String KEY_DYNPLUGIN_INTERFACETYPE = "interfacetype";
    public static final String KEY_DYNPLUGIN_EVENTMETHOD = "eventmethod";
    public static final String KEY_DYNPLUGIN_CLASSNAME = "classname";
    public static final String KEY_DYNPLUGIN_NUMBER = "number";
    public static final String KEY_DYNPLUGIN_NUMBERPK = "number_pk";
    public static final String KEY_DYNPLUGIN_NAME = "name";
    public static final String KEY_DYNPLUGIN_CODETYPE = "codeType";
    public static final String KEY_DYNPLUGIN_BIZAPP = "bizapp";
    public static final String KEY_DYNPLUGIN_PLUGINDESC = "plugindesc_tag";
    public static final String KEY_DYNPLUGIN_ISV = "isv";
    public static final String KEY_DYNPLUGIN_ENABLE = "enable";
    public static final String KEY_DYNPLUGINBIND_DYNPLUGIN = "dynplugin";
    public static final String KEY_DYNPLUGINBIND_OBJECTTYPE = "objecttype";
    public static final String KEY_DYNPLUGINBIND_OPERATIONKEY = "operationkey";
    public static final String KEY_DYNPLUGINBIND_RUNCONDITION = "runcondition";
    public static final String KEY_DYNPLUGINBIND_CLIENT = "client";
    public static final String KEY_DYNPLUGINBIND_APPLYSUBPAGE = "applysubpage";
    private static final List<String> UNSUPPORTED_FORMIDS = Arrays.asList("bos_dynplugin", "bos_dynpluginbind");
    private static final List<String> MODELTYPE_LISTS = Arrays.asList("DynamicFormModel", "MobileFormModel", "BillFormModel", "MobileBillFormModel", "BaseFormModel", "MobileListModel");
    public static final String OPERATE_PLUGIN = "4";
    private static final String T_META_FORM = "T_META_FORM";
    private static final String T_META_ENTITY = "T_META_ENTITY";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    public static final String LAYOUT_ROLE = "1";
    public static final String ENTITY_ROLE = "2";
    public static final String CODETYPE_JAVA = "0";
    public static final String CODETYPE_KINGSCRIPT = "4";
    public static final String ERRORCODE = "4";
    private static final String REGION = "meta";

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REGION, new DistributeCacheHAPolicy());
    }

    private static String getCacheType(String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return DynamicPluginServiceImpl.getCacheType(appGroup, number);
    }

    private static String getCacheType(String appGroup, String number) {
        String accountId = CacheKeyUtil.getAcctId();
        if ("defaultGroup".equals(appGroup)) {
            return String.format("%s_meta_%s", accountId, number);
        }
        return String.format("%s_meta_%s_%s", accountId, appGroup, number);
    }

    private static String getCacheKey(String key, int metaType) {
        return String.format("%s_%s", metaType, key);
    }

    public List<DynPlugin> getDynamicPluginsForOp(String formNumber, String eventmethod, String operationkey) {
        return this.getDynamicPluginsByNumber(formNumber, "4", eventmethod, operationkey, "");
    }

    public List<DynPlugin> getDynamicPluginsForForm(String formNumber, String interfacetype, String eventmethod, String client) {
        return this.getDynamicPluginsByNumber(formNumber, interfacetype, eventmethod, "", client);
    }

    public boolean writeFormRuntimeMeta(String formId, String key, String data) {
        return this.writeRuntimeMeta(formId, key, data, false);
    }

    public boolean writeEntityRuntimeMeta(String entityNumber, String key, String data) {
        return this.writeRuntimeMeta(entityNumber, key, data, true);
    }

    public boolean clearFormRuntimeMetaCache(String formId, String key) {
        boolean b = this.deleteRuntimeMeta(formId, key, false);
        DynamicPluginServiceImpl.getCache().remove(DynamicPluginServiceImpl.getCacheType(formId), DynamicPluginServiceImpl.getCacheKey(key, RuntimeMetaType.DynPlugin.getValue()));
        return b;
    }

    public boolean clearEntityRuntimeMetaCache(String entityNumber, String key) {
        boolean b = this.deleteRuntimeMeta(entityNumber, key, true);
        DynamicPluginServiceImpl.getCache().remove(DynamicPluginServiceImpl.getCacheType(entityNumber), DynamicPluginServiceImpl.getCacheKey(key, RuntimeMetaType.DynPlugin.getValue()));
        return b;
    }

    /*
     * Exception decompiling
     */
    private boolean writeRuntimeMeta(String entityNumber, String key, String data, boolean isEntity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean deleteRuntimeMeta(String entityNumber, String key, boolean isEntity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SqlParameter[] getInsertRuntimeMetaParams(String formId, Object fid, String key, String data) {
        SqlParameter[] params = StringUtils.isNotEmpty((CharSequence)key) ? new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formId), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 5, (Object)RuntimeMetaType.DynPlugin.getValue()), new SqlParameter("FID", 12, fid), new SqlParameter("FTIMESTAMP", -5, (Object)System.currentTimeMillis()), new SqlParameter("FDATA", 2011, (Object)data)} : new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formId), new SqlParameter("FTYPE", 5, (Object)RuntimeMetaType.DynPlugin.getValue()), new SqlParameter("FID", 12, fid), new SqlParameter("FTIMESTAMP", -5, (Object)System.currentTimeMillis()), new SqlParameter("FDATA", 2011, (Object)data)};
        return params;
    }

    private SqlParameter[] getDeleteRuntimeMetaParams(String formId, String key) {
        SqlParameter[] params = StringUtils.isNotEmpty((CharSequence)key) ? new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formId), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 5, (Object)RuntimeMetaType.DynPlugin.getValue())} : new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formId), new SqlParameter("FTYPE", 5, (Object)RuntimeMetaType.DynPlugin.getValue())};
        return params;
    }

    private List<DynPlugin> getDynamicPluginsByNumber(String formNumber, String interfacetype, String eventmethod, String operationkey, String client) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteRuntimeMeta");){
            if (span.isRealtime()) {
                span.addTag("formNumber", formNumber);
                span.addTag(KEY_DYNPLUGIN_INTERFACETYPE, interfacetype);
                span.addTag(KEY_DYNPLUGIN_EVENTMETHOD, eventmethod);
                span.addTag(KEY_DYNPLUGINBIND_OPERATIONKEY, operationkey);
                span.addTag(KEY_DYNPLUGINBIND_CLIENT, client);
            }
            if (UNSUPPORTED_FORMIDS.contains(formNumber)) {
                ArrayList<DynPlugin> arrayList = new ArrayList<DynPlugin>(0);
                return arrayList;
            }
            ArrayList<String> allFormIds = new ArrayList<String>(10);
            List<String> topFormIds = this.getTopPageInfo(formNumber);
            if (topFormIds != null && !topFormIds.isEmpty()) {
                allFormIds.addAll(topFormIds);
                for (String formId : topFormIds) {
                    List<String> allChildrenFormIds = this.getAllChildrenPages(formId);
                    if (!CollectionUtils.isNotEmpty(allChildrenFormIds)) continue;
                    allFormIds.addAll(allChildrenFormIds);
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("allFormIds", allFormIds);
                }
                ArrayList<DynPlugin> plugins = new ArrayList<DynPlugin>(10);
                for (String tempFormId : allFormIds) {
                    List<DynPlugin> dynamicPlugins = this.getDynamicPluginsByFormId(tempFormId, interfacetype, eventmethod, operationkey, client);
                    if (!CollectionUtils.isNotEmpty(dynamicPlugins)) continue;
                    plugins.addAll(dynamicPlugins);
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("plugins", plugins);
                }
                ArrayList<DynPlugin> arrayList = plugins;
                return arrayList;
            }
            ArrayList<DynPlugin> arrayList = new ArrayList<DynPlugin>(0);
            return arrayList;
        }
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginIds(List<Object> dynPluginIds) {
        return this.getClearCacheFormNumbers(dynPluginIds, null);
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginBindIds(List<Object> dynPluginBindIds) {
        return this.getClearCacheFormNumbers(null, dynPluginBindIds);
    }

    private List<Map<String, String>> getClearCacheFormNumbers(List<Object> dynPluginIds, List<Object> dynPluginBindIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"getDynamicPluginsByFormId");){
            List<Object> listIds;
            if (span.isRealtime()) {
                span.addLocaleTag("dynPluginIds", dynPluginIds);
                span.addLocaleTag("dynPluginBindIds", dynPluginBindIds);
            }
            if ((listIds = this.loadDynPluginBindIDs(dynPluginIds, dynPluginBindIds)) == null || listIds.isEmpty()) {
                ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(0);
                return arrayList;
            }
            span.addLocaleTag("listIds", listIds);
            List<DynamicObject> dynamicObjects = this.loadDynamicObject(FORMID_DYNPLUGINBIND, listIds);
            if (dynamicObjects == null || dynamicObjects.isEmpty()) {
                ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(0);
                return arrayList;
            }
            ArrayList allObjs = new ArrayList(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject dynplugin;
                String formId = dynamicObject.getString("objecttype_id");
                ArrayList<Object> allFormIds = new ArrayList<Object>(10);
                ArrayList<Object> formIds = new ArrayList<Object>(1);
                formIds.add(formId);
                List<DynamicObject> formmetas = this.loadDynamicObject("bos_formmeta", formIds);
                if (formmetas != null && formmetas.size() > 0) {
                    for (DynamicObject formNumber : formmetas) {
                        String masterid = formNumber.getString("masterid");
                        String type = formNumber.getString("type");
                        String tempFormId = "";
                        tempFormId = StringUtils.isNotEmpty((CharSequence)type) && ENTITY_ROLE.equals(type) && StringUtils.isNotEmpty((CharSequence)masterid) ? masterid : formNumber.getString(KEY_ID);
                        allFormIds.add(tempFormId);
                        List<Object> subPageInfo = this.getSubPageInfo(tempFormId);
                        if (!CollectionUtils.isNotEmpty(subPageInfo)) continue;
                        allFormIds.addAll(subPageInfo);
                    }
                }
                span.addLocaleTag("allFormIds" + formId, allFormIds);
                List<DynamicObject> allFormNumbers = this.loadDynamicObject("bos_formmeta", allFormIds);
                if (allFormNumbers == null || allFormNumbers.size() <= 0 || (dynplugin = dynamicObject.getDynamicObject(KEY_DYNPLUGINBIND_DYNPLUGIN)) == null) continue;
                for (DynamicObject formNumber : allFormNumbers) {
                    HashMap<String, String> obj = new HashMap<String, String>(10);
                    obj.put("formNumber", formNumber.getString("number"));
                    obj.put(KEY_DYNPLUGIN_INTERFACETYPE, dynplugin.getString(KEY_DYNPLUGIN_INTERFACETYPE));
                    obj.put(KEY_DYNPLUGINBIND_CLIENT, dynplugin.getString(KEY_DYNPLUGINBIND_CLIENT));
                    obj.put(KEY_DYNPLUGINBIND_OPERATIONKEY, dynamicObject.getString(KEY_DYNPLUGINBIND_OPERATIONKEY));
                    allObjs.add(obj);
                }
            }
            span.addLocaleTag("allObjs", allObjs);
            ArrayList arrayList = allObjs;
            return arrayList;
        }
    }

    private List<DynPlugin> getDynamicPluginsByFormId(String formId, String interfacetype, String eventmethod, String operationkey, String client) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"getDynamicPluginsByFormId");){
            ArrayList<DynPlugin> list;
            List<DynamicObject> objs;
            if (span.isRealtime()) {
                span.addTag("formId", formId);
                span.addTag(KEY_DYNPLUGIN_INTERFACETYPE, interfacetype);
                span.addTag(KEY_DYNPLUGIN_EVENTMETHOD, eventmethod);
                span.addTag(KEY_DYNPLUGINBIND_OPERATIONKEY, operationkey);
                span.addTag(KEY_DYNPLUGINBIND_CLIENT, client);
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            if (!StringUtils.isNotBlank((CharSequence)formId)) {
                ArrayList<DynPlugin> arrayList = new ArrayList<DynPlugin>(0);
                return arrayList;
            }
            filters.add(new QFilter(KEY_DYNPLUGINBIND_OBJECTTYPE, "=", (Object)formId));
            filters.add(new QFilter(KEY_DYNPLUGINBIND_APPLYSUBPAGE, "=", (Object)LAYOUT_ROLE));
            filters.add(new QFilter("enable", "=", (Object)LAYOUT_ROLE));
            if (StringUtils.isNotBlank((CharSequence)interfacetype)) {
                filters.add(new QFilter(KEY_INTERFACETYPE, "=", (Object)interfacetype));
            }
            if (StringUtils.isNotBlank((CharSequence)eventmethod)) {
                filters.add(new QFilter(KEY_EVENTMETHOD, "=", (Object)eventmethod));
            }
            if (StringUtils.isNotBlank((CharSequence)operationkey)) {
                filters.add(new QFilter(KEY_DYNPLUGINBIND_OPERATIONKEY, "=", (Object)operationkey));
            }
            if (StringUtils.isNotBlank((CharSequence)client)) {
                filters.add(new QFilter(KEY_CLIENT, "=", (Object)client));
            }
            try {
                if (span.isRealtime()) {
                    span.addLocaleTag(PARAM_FILTERS, filters);
                }
                if (CollectionUtils.isEmpty(objs = this.loadFromCache(FORMID_DYNPLUGINBIND, "dynplugin,runcondition_tag", filters.toArray(new QFilter[filters.size()])))) {
                    ArrayList<DynPlugin> arrayList = new ArrayList<DynPlugin>(0);
                    return arrayList;
                }
                list = new ArrayList<DynPlugin>(objs.size());
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u52a8\u6001\u63d2\u4ef6\u5217\u8868\u5f02\u5e38:", (Throwable)e);
                ArrayList<DynPlugin> arrayList = new ArrayList<DynPlugin>(0);
                return arrayList;
            }
            for (DynamicObject obj : objs) {
                DynamicObject dynpluginObject;
                String classname;
                if (!(obj.get(KEY_DYNPLUGINBIND_DYNPLUGIN) instanceof DynamicObject) || !StringUtils.isNotBlank((CharSequence)(classname = (dynpluginObject = (DynamicObject)obj.get(KEY_DYNPLUGINBIND_DYNPLUGIN)).getString("number")))) continue;
                DynPlugin dynPlugin = new DynPlugin();
                dynPlugin.setFid(dynpluginObject.getLong(KEY_ID));
                dynPlugin.setClassName(classname);
                dynPlugin.setInterfacetype(dynpluginObject.getString(KEY_DYNPLUGIN_INTERFACETYPE));
                dynPlugin.setEventmethod(dynpluginObject.getString(KEY_DYNPLUGIN_NAME));
                String codetype = dynpluginObject.getString(KEY_DYNPLUGIN_CODETYPE);
                dynPlugin.setCodeType(codetype);
                String conditionJson = obj.getString("runcondition_tag");
                if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
                    dynPlugin.setRuncondition(conditionJson);
                }
                list.add(dynPlugin);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("list", list);
            }
            ArrayList<DynPlugin> arrayList = list;
            return arrayList;
        }
    }

    private List<DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"loadFromCache");){
            if (span.isRealtime()) {
                span.addTag("entityName", entityName);
                span.addTag("selectProperties", selectProperties);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            DynamicObjectType type = this.getSubEntityType(entityName, selectProperties);
            List<DynamicObject> list = this.loadFromCache(type, filters);
            return list;
        }
    }

    private DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    private List<DynamicObject> loadFromCache(DynamicObjectType type, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"loadFromCache");){
            Serializable serializable;
            DataEntityCacheManager cacheManager;
            boolean filtersNotNull;
            if (span.isRealtime()) {
                span.addTag("entityName", type.getName());
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            ArrayList idList = new ArrayList();
            Object[] pks = null;
            boolean bl = filtersNotNull = filters != null && filters.length == 1 && filters[0] != null && filters[0].getProperty().equals(KEY_ID) && filters[0].getNests(false).isEmpty();
            if (filtersNotNull) {
                if ("in".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = QFilterUtil.getWithoutDuplicateInValues((Object)filters[0].getValue());
                } else if ("=".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = new Object[]{filters[0].getValue()};
                }
            }
            if (pks == null && (pks = (cacheManager = new DataEntityCacheManager((IDataEntityType)type)).getCachePks(filters)) == null) {
                DataSet ds = ORM.create().queryDataSet("BusinessDataReader.LoadFromCache", type.getName(), KEY_ID, filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());
                serializable = null;
                try {
                    ds.forEach(row -> idList.add(row.get(0)));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (serializable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                pks = idList.toArray();
                cacheManager.putCachePks(filters, pks);
            }
            Map objs = BusinessDataReader.loadFromCache(pks, (DynamicObjectType)type);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(objs.size());
            if (objs != null && !objs.isEmpty()) {
                list.addAll(objs.values());
            }
            serializable = list;
            return serializable;
        }
    }

    public List<DynamicObject> loadDynPlugin(DynPlugin dynPlugin) {
        List<Object> listIds = this.loadDynPluginID(dynPlugin);
        return this.loadDynamicObject(FORMID_DYNPLUGIN, listIds);
    }

    public List<DynamicObject> loadDynPluginBind(DynPluginBind dynPluginBind) {
        return this.loadDynPluginBind(null, dynPluginBind);
    }

    public List<DynamicObject> loadDynPluginBind(DynPlugin dynPlugin, DynPluginBind dynPluginBind) {
        List<Object> listIds = this.loadDynPluginBindID(dynPlugin, dynPluginBind);
        return this.loadDynamicObject(FORMID_DYNPLUGINBIND, listIds);
    }

    public List<Object> loadDynPluginID(DynPlugin dynPlugin) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (dynPlugin.getFid() != 0L) {
            qFilters.add(new QFilter(KEY_ID, "=", (Object)dynPlugin.getFid()));
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getClassName())) {
            qFilters.add(new QFilter("number", "=", (Object)dynPlugin.getClassName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getEventmethod())) {
            qFilters.add(new QFilter(KEY_DYNPLUGIN_EVENTMETHOD, "=", (Object)dynPlugin.getEventmethod()));
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getClient())) {
            qFilters.add(new QFilter(KEY_DYNPLUGINBIND_CLIENT, "=", (Object)dynPlugin.getClient()));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return new ArrayList<Object>(0);
        }
        String currentIsv = ISVService.getISVInfo().getId();
        qFilters.add(new QFilter(KEY_DYNPLUGIN_ISV, "=", (Object)currentIsv));
        return this.loadIDByQFilter(FORMID_DYNPLUGIN, qFilters.toArray(new QFilter[qFilters.size()]));
    }

    public List<Object> loadDynPluginIDByPkId(long pkId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter(KEY_ID, "=", (Object)pkId));
        String currentIsv = ISVService.getISVInfo().getId();
        qFilters.add(new QFilter(KEY_DYNPLUGIN_ISV, "=", (Object)currentIsv));
        return this.loadIDByQFilter(FORMID_DYNPLUGIN, qFilters.toArray(new QFilter[qFilters.size()]));
    }

    public List<Object> loadDynPluginBindID(DynPluginBind dynPluginbind) {
        return this.loadDynPluginBindID(null, dynPluginbind);
    }

    public List<Object> loadDynPluginBindID(DynPlugin dynPlugin, DynPluginBind dynPluginbind) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (dynPlugin != null) {
            if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getClassName())) {
                qFilters.add(new QFilter(KEY_NUMBER, "=", (Object)dynPlugin.getClassName()));
            }
            if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getInterfacetype())) {
                qFilters.add(new QFilter(KEY_INTERFACETYPE, "=", (Object)dynPlugin.getInterfacetype()));
            }
            if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getEventmethod())) {
                qFilters.add(new QFilter(KEY_EVENTMETHOD, "=", (Object)dynPlugin.getEventmethod()));
            }
            if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getClient())) {
                qFilters.add(new QFilter(KEY_CLIENT, "=", (Object)dynPlugin.getClient()));
            }
        }
        if (dynPluginbind != null) {
            if (dynPluginbind.getFid() != 0L) {
                qFilters.add(new QFilter(KEY_ID, "=", (Object)dynPluginbind.getFid()));
            }
            if (dynPluginbind.getDynpluginId() != 0L) {
                qFilters.add(new QFilter(KEY_DYNPLUGINBIND_DYNPLUGIN, "=", (Object)dynPluginbind.getDynpluginId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)dynPluginbind.getObjecttype())) {
                qFilters.add(new QFilter(KEY_DYNPLUGINBIND_OBJECTTYPE, "=", (Object)dynPluginbind.getObjecttype()));
            }
            if (StringUtils.isNotEmpty((CharSequence)dynPluginbind.getOperationkey())) {
                qFilters.add(new QFilter(KEY_DYNPLUGINBIND_OPERATIONKEY, "=", (Object)dynPluginbind.getOperationkey()));
            }
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return new ArrayList<Object>(0);
        }
        String currentIsv = ISVService.getISVInfo().getId();
        qFilters.add(new QFilter(KEY_DYNPLUGIN_ISV, "=", (Object)currentIsv));
        return this.loadIDByQFilter(FORMID_DYNPLUGINBIND, qFilters.toArray(new QFilter[qFilters.size()]));
    }

    private List<Object> loadDynPluginBindIDs(List<Object> dynPluginIds, List<Object> dynPluginbindIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (dynPluginIds != null && !dynPluginIds.isEmpty()) {
            qFilters.add(new QFilter(KEY_DYNPLUGINBIND_DYNPLUGIN, "in", dynPluginIds));
        }
        if (dynPluginbindIds != null && !dynPluginbindIds.isEmpty()) {
            qFilters.add(new QFilter(KEY_ID, "in", dynPluginbindIds));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return new ArrayList<Object>(0);
        }
        String currentIsv = ISVService.getISVInfo().getId();
        qFilters.add(new QFilter(KEY_DYNPLUGIN_ISV, "=", (Object)currentIsv));
        return this.loadIDByQFilter(FORMID_DYNPLUGINBIND, qFilters.toArray(new QFilter[qFilters.size()]));
    }

    private List<Object> loadIDByQFilter(String formId, QFilter[] qFilters) {
        ArrayList<Object> listIds = new ArrayList<Object>();
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataReader.loadIDByQFilter", formId, KEY_ID, qFilters);){
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        return listIds;
    }

    private List<DynamicObject> loadDynamicObject(String formId, List<Object> listIds) {
        if (listIds.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        Object[] pks = listIds.toArray(new Object[listIds.size()]);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObject[] objs = BusinessDataReader.load((Object[])pks, (DynamicObjectType)mainType, (Boolean)Boolean.TRUE);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(listIds.size());
        if (objs != null && objs.length > 0) {
            list.addAll(Arrays.asList(objs));
        }
        return list;
    }

    private List<String> getTopPageInfo(String formNumber) {
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return null;
        }
        QFilter q = new QFilter("number", "=", (Object)formNumber);
        QFilter[] filters = new QFilter[]{q};
        List<DynamicObject> dynamicObjects = this.loadFromCache("bos_formmeta", "modeltype,inheritpath", filters);
        if (dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = dynamicObjects.get(0);
            String modeltype = dynamicObject.getString(MODELTYPE);
            if (StringUtils.isBlank((CharSequence)modeltype) || !MODELTYPE_LISTS.contains(modeltype)) {
                return null;
            }
            ArrayList<String> formIds = new ArrayList<String>(10);
            String id = dynamicObject.getString(KEY_ID);
            String inheritpath = dynamicObject.getString("inheritpath");
            formIds.add(id);
            if (StringUtils.isNotBlank((CharSequence)inheritpath)) {
                String[] inheritpathArray;
                for (String topformId : inheritpathArray = inheritpath.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)topformId) || !StringUtils.isNotBlank((CharSequence)topformId.trim())) continue;
                    formIds.add(topformId);
                }
            }
            return formIds;
        }
        return null;
    }

    private List<Object> getSubPageInfo(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return new ArrayList<Object>(10);
        }
        String text = String.format("%s%s%s", "%", formId, "%");
        QFilter q = new QFilter("inheritpath", "like", (Object)text);
        QFilter[] filters = new QFilter[]{q};
        List<DynamicObject> dynamicObjects = this.loadFromCache("bos_formmeta", "modeltype,inheritpath", filters);
        if (dynamicObjects.size() > 0) {
            ArrayList<Object> formIds = new ArrayList<Object>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                String modeltype = dynamicObject.getString(MODELTYPE);
                if (StringUtils.isEmpty((CharSequence)modeltype) || !MODELTYPE_LISTS.contains(modeltype)) continue;
                String id = dynamicObject.getString(KEY_ID);
                formIds.add(id);
            }
            return formIds;
        }
        return new ArrayList<Object>(10);
    }

    private List<String> getAllChildrenPages(String formId) {
        ArrayList<String> formIds = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("parentid", "=", (Object)formId), new QFilter("enabled", "=", (Object)LAYOUT_ROLE), new QFilter("type", "=", (Object)ENTITY_ROLE)};
            List<DynamicObject> dynamicObjects = this.loadFromCache("bos_formmeta", "id,name,number,modeltype", qFilters);
            if (CollectionUtils.isNotEmpty(dynamicObjects)) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String selectFormId = dynamicObject.getString(KEY_ID);
                    formIds.add(selectFormId);
                    formIds.addAll(this.getAllChildrenPages(selectFormId));
                }
            }
        }
        return formIds;
    }

    public ApiResult saveDynPlugin(DynPlugin dynPlugin) {
        ApiResult apiResult;
        boolean isSave = true;
        Tuple validator = dynPlugin.validator(isSave);
        ApiResult apiResult2 = apiResult = (Boolean)validator.item1 != false ? ApiResult.success(null) : ApiResult.error((String)"4", (String)((String)validator.item2), null);
        if (!apiResult.isStatus()) {
            return apiResult;
        }
        Method method = FormDynamicProxyPluginFactory.getEventmethod((String)dynPlugin.getInterfacetype(), (String)dynPlugin.getClient(), (String)dynPlugin.getEventmethod());
        if (!dynPlugin.getEventmethod().equals("ALL") && method == null) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"DynamicPluginServiceImpl_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        List<Object> objs = this.loadDynPluginID(dynPlugin);
        if (!objs.isEmpty()) {
            return this.updateDynPlugin(dynPlugin);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_DYNPLUGIN);
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        this.dynPluginConvertToDynamicObject(obj, dynPlugin, isSave);
        DynamicPluginServiceImpl.saveOrUpdate(apiResult, obj);
        if (apiResult.isStatus()) {
            DynamicPluginDesignMeta.clearCacheById((Object)apiResult.getData());
        }
        return apiResult;
    }

    public ApiResult updateDynPlugin(DynPlugin dynPlugin) {
        ApiResult apiResult;
        boolean isSave = false;
        Tuple validator = dynPlugin.validator(isSave);
        ApiResult apiResult2 = apiResult = (Boolean)validator.item1 != false ? ApiResult.success(null) : ApiResult.error((String)"4", (String)((String)validator.item2), null);
        if (!apiResult.isStatus()) {
            return apiResult;
        }
        List<DynamicObject> objs = this.loadDynamicObject(FORMID_DYNPLUGIN, Collections.singletonList(dynPlugin.getFid()));
        if (objs.isEmpty()) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        DynamicObject obj = objs.get(0);
        String currentIsv = ISVService.getISVInfo().getId();
        String isv = obj.getString(KEY_DYNPLUGIN_ISV);
        dynPlugin.setEventmethod(obj.getString(KEY_DYNPLUGIN_EVENTMETHOD));
        dynPlugin.setInterfacetype(obj.getString(KEY_DYNPLUGIN_INTERFACETYPE));
        if (!currentIsv.equals(isv)) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u8bf7\u52ff\u64cd\u4f5c\u975e\u672c\u5f00\u53d1\u5546\u7684\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        this.dynPluginConvertToDynamicObject(obj, dynPlugin, isSave);
        DynamicPluginServiceImpl.saveOrUpdate(apiResult, obj);
        if (apiResult.isStatus()) {
            DynamicPluginDesignMeta.clearCacheById((Object)apiResult.getData());
        }
        return apiResult;
    }

    private void dynPluginConvertToDynamicObject(DynamicObject obj, DynPlugin dynPlugin, boolean isSave) {
        long id;
        MainEntityType mainType = (MainEntityType)obj.getDataEntityType();
        IDataEntityProperty roleProp = mainType.findProperty(KEY_DYNPLUGIN_ROLE);
        IDataEntityProperty interfacetypeProp = mainType.findProperty(KEY_DYNPLUGIN_INTERFACETYPE);
        IDataEntityProperty clientProp = mainType.findProperty(KEY_DYNPLUGINBIND_CLIENT);
        IDataEntityProperty eventmethodProp = mainType.findProperty(KEY_DYNPLUGIN_EVENTMETHOD);
        IDataEntityProperty nameProp = mainType.findProperty(KEY_DYNPLUGIN_NAME);
        IDataEntityProperty numberProp = mainType.findProperty(KEY_DYNPLUGIN_NUMBERPK);
        IDataEntityProperty classnameProp = mainType.findProperty("number");
        IDataEntityProperty codeTypeProp = mainType.findProperty(KEY_DYNPLUGIN_CODETYPE);
        IDataEntityProperty bizappProp = mainType.findProperty(KEY_DYNPLUGIN_BIZAPP);
        IDataEntityProperty plugindescProp = mainType.findProperty(KEY_DYNPLUGIN_PLUGINDESC);
        IDataEntityProperty isvProp = mainType.findProperty(KEY_DYNPLUGIN_ISV);
        IDataEntityProperty enable = mainType.findProperty("enable");
        String eventmethod = dynPlugin.getEventmethod();
        if (isSave) {
            String interfacetype = dynPlugin.getInterfacetype();
            String client = dynPlugin.getClient();
            String role = LAYOUT_ROLE;
            String currentIsv = ISVService.getISVInfo().getId();
            if ("4".equals(interfacetype)) {
                role = ENTITY_ROLE;
            }
            roleProp.setValueFast((Object)obj, (Object)role);
            interfacetypeProp.setValueFast((Object)obj, (Object)interfacetype);
            eventmethodProp.setValueFast((Object)obj, (Object)eventmethod);
            nameProp.setValueFast((Object)obj, (Object)eventmethod);
            enable.setValueFast((Object)obj, (Object)LAYOUT_ROLE);
            isvProp.setValueFast((Object)obj, (Object)currentIsv);
            clientProp.setValueFast((Object)obj, (Object)client);
        }
        String className = dynPlugin.getClassName();
        String codeType = dynPlugin.getCodeType();
        String bizapp = dynPlugin.getBizapp();
        if (CODETYPE_JAVA.equals(codeType)) {
            bizapp = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPlugin.getPlugindesc())) {
            HashMap<String, String> codeContext = new HashMap<String, String>(1);
            codeContext.put(KEY_TEXT, dynPlugin.getPlugindesc());
            String plugindesc = SerializationUtils.toJsonString(codeContext);
            plugindescProp.setValueFast((Object)obj, (Object)plugindesc);
        }
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            classnameProp.setValueFast((Object)obj, (Object)className);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeType)) {
            codeTypeProp.setValueFast((Object)obj, (Object)codeType);
        }
        bizappProp.setValueFast((Object)obj, (Object)bizapp);
        long l = id = obj.getPkValue() == null ? 0L : (Long)obj.getPkValue();
        if (id == 0L) {
            id = ID.genLongId();
            obj.set(KEY_ID, (Object)id);
        }
        className = DynamicPluginServiceImpl.getNumberByClassName(className.trim());
        numberProp.setValueFast((Object)obj, (Object)(className + "_" + eventmethod + "_" + id));
    }

    private static void saveOrUpdate(ApiResult apiResult, DynamicObject obj) {
        BusinessDataWriter.save((IDataEntityType)obj.getDataEntityType(), (Object[])new DynamicObject[]{obj});
        Object id = obj.get(KEY_ID);
        if (id != null) {
            apiResult.setData(id);
        } else {
            ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e\u5931\u8d25\u3002", (String)"DynamicPluginServiceImpl_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
    }

    public ApiResult saveDynPluginBind(DynPluginBind dynPluginBind) {
        ApiResult apiResult = ApiResult.success(null);
        List<Object> objs = this.loadDynPluginIDByPkId(dynPluginBind.getDynpluginId());
        if (objs.isEmpty()) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u3002", (String)"DynamicPluginServiceImpl_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        objs = this.loadDynPluginBindID(dynPluginBind);
        if (!objs.isEmpty()) {
            return this.updateDynPluginBind(dynPluginBind);
        }
        boolean isSave = true;
        Tuple validator = dynPluginBind.validator(isSave);
        ApiResult apiResult2 = apiResult = (Boolean)validator.item1 != false ? ApiResult.success(null) : ApiResult.error((String)"4", (String)((String)validator.item2), null);
        if (!apiResult.isStatus()) {
            return apiResult;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_DYNPLUGINBIND);
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        this.dynPluginBindConvertToDynamicObject(obj, dynPluginBind, isSave);
        DynamicPluginServiceImpl.saveOrUpdate(apiResult, obj);
        if (apiResult.isStatus()) {
            DynamicPluginBindDesignMeta.clearCacheByBindId((Object)apiResult.getData());
        }
        return apiResult;
    }

    public ApiResult updateDynPluginBind(DynPluginBind dynPluginbind) {
        String isv;
        ApiResult apiResult;
        boolean isSave = false;
        Tuple validator = dynPluginbind.validator(isSave);
        ApiResult apiResult2 = apiResult = (Boolean)validator.item1 != false ? ApiResult.success(null) : ApiResult.error((String)"4", (String)((String)validator.item2), null);
        if (!apiResult.isStatus()) {
            return apiResult;
        }
        List<DynamicObject> dynpluginObj = this.loadDynamicObject(FORMID_DYNPLUGIN, Collections.singletonList(dynPluginbind.getDynpluginId()));
        if (dynpluginObj.isEmpty()) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_7", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        List<DynamicObject> dynpluginBindObjs = this.loadDynamicObject(FORMID_DYNPLUGINBIND, Collections.singletonList(dynPluginbind.getFid()));
        if (dynpluginBindObjs.isEmpty()) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u52a8\u6001\u63d2\u4ef6\u6ce8\u518c\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        DynamicObject dynpluginBind = dynpluginBindObjs.get(0);
        String currentIsv = ISVService.getISVInfo().getId();
        if (!currentIsv.equals(isv = dynpluginBind.getString(KEY_DYNPLUGIN_ISV))) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u8bf7\u52ff\u64cd\u4f5c\u975e\u672c\u5f00\u53d1\u5546\u7684\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        this.dynPluginBindConvertToDynamicObject(dynpluginBind, dynPluginbind, isSave);
        ArrayList<Object> dynPluginBindIds = new ArrayList<Object>(1);
        dynPluginBindIds.add(dynPluginbind.getFid());
        List<Map<String, String>> beforeUpdateClearCacheInfos = this.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
        DynamicPluginServiceImpl.saveOrUpdate(apiResult, dynpluginBind);
        List<Map<String, String>> afterUpdateClearCacheInfos = this.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
        if (apiResult.isStatus()) {
            if (beforeUpdateClearCacheInfos != null) {
                DynamicPluginBindDesignMeta.clearCacheInfos(beforeUpdateClearCacheInfos);
            }
            if (afterUpdateClearCacheInfos != null) {
                DynamicPluginBindDesignMeta.clearCacheInfos(afterUpdateClearCacheInfos);
            }
        }
        return apiResult;
    }

    public ApiResult enableDynPluginBind(long dynPluginbindId, boolean enable) {
        String isv;
        ApiResult apiResult = ApiResult.success(null);
        List<DynamicObject> objs = this.loadDynamicObject(FORMID_DYNPLUGINBIND, Collections.singletonList(dynPluginbindId));
        if (objs.isEmpty()) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u52a8\u6001\u63d2\u4ef6\u6ce8\u518c\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_10", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        DynamicObject obj = objs.get(0);
        String currentIsv = ISVService.getISVInfo().getId();
        if (!currentIsv.equals(isv = obj.getString(KEY_DYNPLUGIN_ISV))) {
            return ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u8bf7\u52ff\u64cd\u4f5c\u975e\u672c\u5f00\u53d1\u5546\u7684\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_11", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
        }
        MainEntityType mainType = (MainEntityType)obj.getDataEntityType();
        IDataEntityProperty enableProp = mainType.findProperty("enable");
        enableProp.setValueFast((Object)obj, (Object)(enable ? LAYOUT_ROLE : ENTITY_ROLE));
        DynamicPluginServiceImpl.saveOrUpdate(apiResult, obj);
        if (apiResult.isStatus()) {
            DynamicPluginBindDesignMeta.clearCacheByBindId((Object)apiResult.getData());
        }
        return apiResult;
    }

    private void dynPluginBindConvertToDynamicObject(DynamicObject obj, DynPluginBind dynPluginBind, boolean isSave) {
        long id;
        long dynpluginId = dynPluginBind.getDynpluginId();
        String objecttype = dynPluginBind.getObjecttype();
        String currentIsv = ISVService.getISVInfo().getId();
        MainEntityType mainType = (MainEntityType)obj.getDataEntityType();
        IDataEntityProperty dynpluginProp = mainType.findProperty(KEY_DYNPLUGINBIND_DYNPLUGIN);
        IDataEntityProperty objecttypeProp = mainType.findProperty(KEY_DYNPLUGINBIND_OBJECTTYPE);
        IDataEntityProperty operationkeyProp = mainType.findProperty(KEY_DYNPLUGINBIND_OPERATIONKEY);
        IDataEntityProperty runconditionProp = mainType.findProperty(KEY_DYNPLUGINBIND_RUNCONDITION);
        IDataEntityProperty isvProp = mainType.findProperty(KEY_DYNPLUGIN_ISV);
        IDataEntityProperty enableProp = mainType.findProperty("enable");
        IDataEntityProperty numberProp = mainType.findProperty("number");
        if (StringUtils.isNotEmpty((CharSequence)objecttype)) {
            objecttypeProp.setValueFast((Object)obj, (Object)objecttype);
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPluginBind.getOperationkey())) {
            operationkeyProp.setValueFast((Object)obj, (Object)dynPluginBind.getOperationkey());
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPluginBind.getRuncondition())) {
            runconditionProp.setValueFast((Object)obj, (Object)dynPluginBind.getRuncondition());
        }
        if (StringUtils.isNotEmpty((CharSequence)dynPluginBind.getEnable())) {
            enableProp.setValueFast((Object)obj, (Object)dynPluginBind.getEnable());
        }
        long l = id = obj.getPkValue() == null ? 0L : (Long)obj.getPkValue();
        if (id == 0L) {
            id = ID.genLongId();
            obj.set(KEY_ID, (Object)id);
        }
        if (dynpluginId != 0L) {
            dynpluginProp.setValueFast((Object)obj, (Object)dynpluginId);
            DynPlugin dynPluginTemp = new DynPlugin();
            dynPluginTemp.setFid(dynpluginId);
            List<DynamicObject> dynamicObjects = this.loadDynPlugin(dynPluginTemp);
            if (!CollectionUtils.isEmpty(dynamicObjects) && StringUtils.isNotEmpty((CharSequence)objecttype)) {
                DynamicObject dynplugin = dynamicObjects.get(0);
                Object eventmethod = dynplugin.get(KEY_DYNPLUGIN_EVENTMETHOD);
                String classname = dynplugin.get("number") == null ? "" : (String)dynplugin.get("number");
                classname = DynamicPluginServiceImpl.getNumberByClassName(classname);
                ArrayList<Object> formIds = new ArrayList<Object>(1);
                formIds.add(objecttype);
                List<DynamicObject> formmetas = this.loadDynamicObject("bos_formmeta", formIds);
                if (!CollectionUtils.isEmpty(formmetas)) {
                    Object formnumber = formmetas.get(0).get("number");
                    numberProp.setValueFast((Object)obj, (Object)(formnumber + "_" + classname + "_" + eventmethod + "_" + id));
                }
            }
        }
        if (isSave) {
            if (StringUtils.isNotEmpty((CharSequence)dynPluginBind.getEnable())) {
                enableProp.setValueFast((Object)obj, (Object)dynPluginBind.getEnable());
            } else {
                enableProp.setValueFast((Object)obj, (Object)LAYOUT_ROLE);
            }
            isvProp.setValueFast((Object)obj, (Object)currentIsv);
        }
    }

    public ApiResult deleteDynPlugin(long dynPluginId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"deleteDynPlugin");){
            ApiResult apiResult = ApiResult.success(null);
            if (dynPluginId == 0L) {
                ApiResult apiResult2 = ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DynamicPluginServiceImpl_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
                return apiResult2;
            }
            String currentIsv = ISVService.getISVInfo().getId();
            List<Object> idList = this.loadDynPluginIDByPkId(dynPluginId);
            if (CollectionUtils.isEmpty(idList)) {
                ApiResult apiResult3 = ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\uff0c\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DynamicPluginServiceImpl_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
                return apiResult3;
            }
            DynPluginBind dynPluginBind = new DynPluginBind();
            dynPluginBind.setDynpluginId(dynPluginId);
            List<DynamicObject> dynamicObjects = this.loadDynPluginBind(null, dynPluginBind);
            if (!CollectionUtils.isEmpty(dynamicObjects)) {
                ApiResult apiResult4 = ApiResult.error((String)"4", (String)String.format(ResManager.loadKDString((String)"\u5df2\u5173\u8054%1$s\u6761\u52a8\u6001\u63d2\u4ef6\u6ce8\u518c\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u52a8\u6001\u63d2\u4ef6\u6ce8\u518c\u6570\u636e\u3002", (String)"DynamicPluginServiceImpl_13", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dynamicObjects.size()), null);
                return apiResult4;
            }
            List<Map<String, String>> clearCacheInfosByDynPluginIds = this.getClearCacheInfosByDynPluginIds(idList);
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORMID_DYNPLUGIN), (Object[])idList.toArray());
            if (apiResult.isStatus()) {
                DynamicPluginBindDesignMeta.clearCacheInfos(clearCacheInfosByDynPluginIds);
            }
            ApiResult apiResult5 = apiResult;
            return apiResult5;
        }
    }

    public ApiResult deleteDynPluginBind(long dynPluginBindId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"deleteDynPluginBind");){
            ApiResult apiResult = ApiResult.success(null);
            if (dynPluginBindId == 0L) {
                ApiResult apiResult2 = ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DynamicPluginServiceImpl_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
                return apiResult2;
            }
            DynPluginBind dynPluginbind = new DynPluginBind();
            dynPluginbind.setFid(dynPluginBindId);
            List<Object> idList = this.loadDynPluginBindID(dynPluginbind);
            if (CollectionUtils.isEmpty(idList)) {
                ApiResult apiResult3 = ApiResult.error((String)"4", (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\uff0c\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DynamicPluginServiceImpl_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), null);
                return apiResult3;
            }
            List<Map<String, String>> clearCacheInfosByDynPluginBindIds = this.getClearCacheInfosByDynPluginBindIds(idList);
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORMID_DYNPLUGINBIND), (Object[])idList.toArray());
            if (apiResult.isStatus()) {
                DynamicPluginBindDesignMeta.clearCacheInfos(clearCacheInfosByDynPluginBindIds);
            }
            ApiResult apiResult4 = apiResult;
            return apiResult4;
        }
    }

    public static String getNumberByClassName(String className) {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            if (className.endsWith(".ts")) {
                className = className.substring(0, className.lastIndexOf(".ts"));
            }
            if (className.lastIndexOf("/") != -1) {
                className = className.substring(className.lastIndexOf("/") + 1);
            }
            if (className.lastIndexOf(".") != -1) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            return className;
        }
        return "";
    }
}

