/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.design;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.PropertyGroup;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiner;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.service.metadata.design.DesignMetadataService;
import kd.bos.service.metadata.design.DomainModelTypeExtHandler;
import kd.bos.service.metadata.design.DomainModelTypeRewriteHandler;
import org.jetbrains.annotations.Nullable;

public class DesignMetadataServiceImpl
implements DesignMetadataService {
    private static final Log log = LogFactory.getLog(DesignMetadataServiceImpl.class);
    private static final String CACHE_REGION_DOMAINMODEL = "domainmodel";
    private static final String CACHE_REGION_DOMAINMODELEXT = "domainmodelext";
    private static final String CACHE_REGION_DOMAINMODELBIZEXT = "domainmodelbizext";
    private static final String DM = "DM_";
    private static final String DM_Category = "DM_Category_";
    private static final String DM_PropertyGroup = "DM_PropertyGroup_";
    private static final String DM_ElementType = "DM_ElementType_";
    private static final String DM_ElementType_Property = "DM_ElementType_Property_";
    private static final String DM_ElementType_Property_Desc = "DM_ElementType_Property_Desc_";
    private static final String DM_ElementType_Property_Group = "DM_ElementType_Property_Group_";
    private static final String DM_ElementType_Property_Editor = "DM_ElementType_Property_Editor_";
    private static final String TYPE = "type";
    private static final String COMBO = "combo";
    private static final String ITEMS = "items";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String MCOMBO = "mcombo";
    private static final String EDITCOMBO = "editcombo";
    private static final String FONTBOLD = "fontbold";
    private static final String BTNEDIT = "btnedit";
    private static final String BTN_NAME = "btnName";
    private static final String DIMENSION = "dimension";
    private static final String UNITS = "units";

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGION_DOMAINMODEL, new DistributeCacheHAPolicy());
    }

    public String getDomainModel(String modelType) {
        String locale = Lang.get().getLocale().toString();
        return this.getDomainModel(modelType, locale);
    }

    private static DistributeSessionlessCache getCacheExt() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGION_DOMAINMODELEXT, new DistributeCacheHAPolicy());
    }

    private static DistributeSessionlessCache getCacheBizExt() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGION_DOMAINMODELBIZEXT, new DistributeCacheHAPolicy());
    }

    private Map<String, Object> getDomainModelType(String modelType, String locale) {
        List dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcJsonSerializer jser = new DcJsonSerializer((Iterable)dts);
        DomainModelType dm = DomainModelType.getDomainModelType((String)modelType, (String)locale);
        DomainModelTypeRewriteHandler.rewriteDomainModelType(dm);
        jser.getBinder().setLCId(locale);
        return jser.serializeToMap((Object)dm, null);
    }

    public String getDomainModelExt(String modelType) {
        String key;
        String locale = Lang.get().getLocale().toString();
        if (Boolean.getBoolean("domainmodeltype.rediscache.disabled")) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            long start = System.currentTimeMillis();
            DomainModelTypeExtHandler.extHandler(map, modelType);
            long end = System.currentTimeMillis();
            System.out.println("\u5c5e\u6027\u88c1\u526a\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (end - start));
            return SerializationUtils.toJsonString(map);
        }
        DistributeSessionlessCache cache = DesignMetadataServiceImpl.getCacheExt();
        String content = (String)cache.get(key = DomainModelTypeFactory.getRedisCacheKey((String)locale) + "_ext", modelType);
        if (StringUtils.isBlank((CharSequence)content)) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            DomainModelTypeExtHandler.extHandler(map, modelType);
            content = SerializationUtils.toJsonString(map);
            cache.put(key, modelType, (Object)content);
        }
        return content;
    }

    public String getDomainModelBizExt(String modelType) {
        String key;
        String locale = Lang.get().getLocale().toString();
        if (Boolean.getBoolean("domainmodeltype.rediscache.disabled")) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            DomainModelTypeExtHandler.lightExtHandler(map, modelType);
            return SerializationUtils.toJsonString(map);
        }
        DistributeSessionlessCache cache = DesignMetadataServiceImpl.getCacheBizExt();
        String content = (String)cache.get(key = DomainModelTypeFactory.getRedisCacheKey((String)locale) + "_bizext", modelType);
        if (StringUtils.isBlank((CharSequence)content)) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            DomainModelTypeExtHandler.lightExtHandler(map, modelType);
            content = SerializationUtils.toJsonString(map);
            cache.put(key, modelType, (Object)content);
        }
        return content;
    }

    public String getDomainModel(String modelType, String locale) {
        String key;
        if (Boolean.getBoolean("domainmodeltype.rediscache.disabled")) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            map = this.customMap(map, modelType);
            return SerializationUtils.toJsonString(map);
        }
        DistributeSessionlessCache cache = DesignMetadataServiceImpl.getCache();
        String content = (String)cache.get(key = DomainModelTypeFactory.getRedisCacheKey((String)locale), modelType);
        if (StringUtils.isBlank((CharSequence)content)) {
            Map<String, Object> map = this.getDomainModelType(modelType, locale);
            map = this.customMap(map, modelType);
            content = SerializationUtils.toJsonString(map);
            cache.put(key, modelType, (Object)content);
        }
        return content;
    }

    private static void genAllDomainTypeLocale() {
        List list = DomainModelTypeFactory.loadDomainModelTypeDefiner_LY();
        for (DomainModelTypeDefiner definer : list) {
            try {
                DomainModelType dm = DomainModelTypeFactory.getDomainModelTypeSys((String)definer.getTypeName(), (boolean)true);
                DesignMetadataServiceImpl.genModelTypeLocaleFileAndInsertDb(dm);
            }
            catch (Exception e) {
                System.out.println("dm=====" + definer.getTypeName());
                log.error((Throwable)e);
            }
        }
    }

    private static void genModelTypeLocaleFileAndInsertDb(DomainModelType dm) {
        if (dm.getName() == null) {
            return;
        }
        LinkedHashMap<String, String> localeEN_USMap = new LinkedHashMap<String, String>(50);
        LinkedHashMap<String, String> localeZH_CNMap = new LinkedHashMap<String, String>(50);
        localeEN_USMap.put(DM + dm.getId(), dm.getId());
        localeZH_CNMap.put(DM + dm.getId(), dm.getName() == null || dm.getName().get((Object)"zh_CN") == null ? " " : (String)dm.getName().get((Object)"zh_CN"));
        for (Category category : dm.getCategories()) {
            localeEN_USMap.put(DM_Category + category.getId(), category.getId());
            localeZH_CNMap.put(DM_Category + category.getId(), category.getName() == null || category.getName().get((Object)"zh_CN") == null ? " " : (String)category.getName().get((Object)"zh_CN"));
            for (ElementType entry : category.getElementTypes()) {
                localeEN_USMap.put(DM_ElementType + entry.getId(), entry.getId());
                localeZH_CNMap.put(DM_ElementType + entry.getId(), entry.getName() == null || entry.getName().get((Object)"zh_CN") == null ? " " : (String)entry.getName().get((Object)"zh_CN"));
                for (Property property : entry.getProperties()) {
                    Object units;
                    if (property.getDescription() != null) {
                        localeEN_USMap.put(DM_ElementType_Property_Desc + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property_Desc + entry.getId() + "_" + property.getPropertyName(), DesignMetadataServiceImpl.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getDescription().get((Object)"zh_CN"))) || ((String)property.getDescription().get((Object)"zh_CN")).equals(" ") ? " " : (String)property.getDescription().get((Object)"zh_CN")));
                    }
                    if (property.getGroup() != null) {
                        localeEN_USMap.put(DM_ElementType_Property_Group + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property_Group + entry.getId() + "_" + property.getPropertyName(), DesignMetadataServiceImpl.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getGroup().get((Object)"zh_CN"))) ? " " : (String)property.getGroup().get((Object)"zh_CN")));
                    }
                    if (property.getName() != null) {
                        localeEN_USMap.put(DM_ElementType_Property + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property + entry.getId() + "_" + property.getPropertyName(), DesignMetadataServiceImpl.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getName().get((Object)"zh_CN"))) || ((String)property.getName().get((Object)"zh_CN")).equals(" ") ? " " : (String)property.getName().get((Object)"zh_CN")));
                    }
                    if (property.getEditor() == null) continue;
                    Map editorMap = property.getEditor();
                    Object Type2 = editorMap.get(TYPE);
                    if (COMBO.equals(Type2) || MCOMBO.equals(Type2) || EDITCOMBO.equals(Type2) || FONTBOLD.equals(Type2)) {
                        Object itemsObj = editorMap.get(ITEMS);
                        if (!(itemsObj instanceof List)) continue;
                        for (Object itemObj : (List)itemsObj) {
                            if (!(itemObj instanceof Map)) continue;
                            Map item = (Map)itemObj;
                            Object itemId = item.get(ID);
                            String key = itemId instanceof String ? DesignMetadataServiceImpl.saveConvert((String)itemId) : String.valueOf(itemId);
                            String itemNameObj = (String)item.get(NAME);
                            String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + key;
                            localeEN_USMap.put(resKey, itemNameObj + "_en");
                            localeZH_CNMap.put(resKey, itemNameObj);
                        }
                        continue;
                    }
                    if (BTNEDIT.equals(Type2)) {
                        String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + BTN_NAME;
                        if (editorMap.get(BTN_NAME) == null) continue;
                        String itemNameObj = (String)editorMap.get(BTN_NAME);
                        localeEN_USMap.put(resKey, itemNameObj + "_en");
                        localeZH_CNMap.put(resKey, itemNameObj);
                        continue;
                    }
                    if (!DIMENSION.equals(Type2) || !((units = editorMap.get(UNITS)) instanceof List)) continue;
                    List uintsList = (List)units;
                    for (int i = 0; i < uintsList.size(); ++i) {
                        String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + DIMENSION + "_" + i;
                        String itemNameObj = String.valueOf(uintsList.get(i));
                        localeEN_USMap.put(resKey, itemNameObj + "_en");
                        localeZH_CNMap.put(resKey, itemNameObj);
                    }
                }
            }
        }
        for (PropertyGroup propertyGroup : dm.getPropertyGroups()) {
            localeEN_USMap.put(DM_PropertyGroup + propertyGroup.getKey(), propertyGroup.getKey());
            localeZH_CNMap.put(DM_PropertyGroup + propertyGroup.getKey(), propertyGroup.getName() == null || propertyGroup.getName().get((Object)"zh_CN") == null ? " " : (String)propertyGroup.getName().get((Object)"zh_CN"));
        }
    }

    private static void buildFile(String filePath, HashMap<String, String> localeMap) {
    }

    public static void writeProperties(String filePath, HashMap<String, String> localeMap) {
    }

    private static void insertLocale(HashMap<String, String> localeMap, String dmId) {
        String insertSql = "insert into t_int_promptwordtran_l(fpkid,fresid,flocaleid,ftranslation,fprojectnumber) values(?,?,?,?,?);";
        for (Map.Entry<String, String> entry : localeMap.entrySet()) {
            DesignMetadataServiceImpl.insertLocale(entry.getKey(), "en_US", dmId, entry.getValue());
        }
    }

    private static void insertLocale(String resid, String localeid, String projectnumber, String translation) {
        String isExistSql = "select count(1) as counter from t_int_promptwordtran_l where fresid=? and flocaleid=? and fprojectnumber=?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fresid", 12, (Object)resid), new SqlParameter(":flocaleid", 12, (Object)localeid), new SqlParameter(":fprojectnumber", 12, (Object)projectnumber)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        String number = (String)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)isExistSql, (Object[])params, (ResultSetHandler)action);
        if (StringUtils.isNotBlank((CharSequence)number) && Integer.parseInt(number) > 0) {
            return;
        }
        String insertSql = "insert into t_int_promptwordtran_l(fpkid,fresid,flocaleid,ftranslation,fprojectnumber) values(?,?,?,?,?);";
        Object[] insertParams = new SqlParameter[]{new SqlParameter(":fpkid", -5, (Object)DB.genGlobalLongId()), new SqlParameter(":fresid", 12, (Object)resid), new SqlParameter(":flocaleid", 12, (Object)localeid), new SqlParameter(":ftranslation", 12, (Object)translation), new SqlParameter(":fprojectnumber", 12, (Object)projectnumber)};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)insertSql, (Object[])insertParams);
    }

    public String getDomainModelOnlyEntityExt(String modelType) {
        return this.innerGetDomainModelOnlyEntity(modelType, DomainModelTypeExtHandler::extHandler);
    }

    public String getDomainModelOnlyEntity(String modelType) {
        return this.innerGetDomainModelOnlyEntity(modelType, null);
    }

    @Nullable
    private String innerGetDomainModelOnlyEntity(String modelType, BiConsumer<Map<String, Object>, String> consumer) {
        String locale = Lang.get().getLocale().toString();
        DistributeSessionlessCache cache = null;
        String key = null;
        String content = null;
        if (Boolean.getBoolean("domainmodeltype.rediscache.disabled")) {
            cache = DesignMetadataServiceImpl.getCache();
            key = DomainModelTypeFactory.getEntityRedisCacheKey((String)locale);
            content = (String)cache.get(key, modelType);
        }
        if (StringUtils.isBlank(content)) {
            String sDomainModel = this.getDomainModel(modelType, locale);
            if (StringUtils.isBlank((CharSequence)sDomainModel)) {
                return null;
            }
            List dts = DomainModelType.getDomainModelTypeEntityTypes();
            DcJsonSerializer jser = new DcJsonSerializer((Iterable)dts);
            DomainModelType dm = (DomainModelType)jser.deserializeFromString(sDomainModel, null);
            ArrayList<Category> toRemoveCategories = new ArrayList<Category>(16);
            ElementType formAp = dm.getElementType("BillFormAp");
            ElementType billEntity = dm.getElementType("BillEntity");
            ElementType baseEntity = dm.getElementType("BaseEntity");
            if (formAp != null) {
                Optional<Property> first;
                ArrayList<Property> extProps = new ArrayList<Property>();
                for (Property prop : formAp.getProperties()) {
                    if (!"EnableInheritProperty".equals(prop.getPropertyName()) && !"EnableExtendProperty".equals(prop.getPropertyName())) continue;
                    extProps.add(prop);
                }
                if (billEntity != null) {
                    billEntity.getProperties().addAll(extProps);
                    first = billEntity.getProperties().stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)"Key", (CharSequence)p.getPropertyName())).findFirst();
                    if (first.isPresent()) {
                        first.get().setReadOnly(true);
                    }
                }
                if (baseEntity != null) {
                    baseEntity.getProperties().addAll(extProps);
                    first = baseEntity.getProperties().stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)"Key", (CharSequence)p.getPropertyName())).findFirst();
                    if (first.isPresent()) {
                        first.get().setReadOnly(true);
                    }
                }
            }
            Category entryCategory = null;
            for (Category category : dm.getCategories()) {
                List elementTypes;
                if ("Field".equalsIgnoreCase(category.getBaseType())) continue;
                if ("Entry".equalsIgnoreCase(category.getBaseType())) {
                    entryCategory = category;
                    elementTypes = category.getElementTypes();
                    for (ElementType elementType : elementTypes) {
                        elementType.getProperties().removeIf(p -> "Rules".equalsIgnoreCase(p.getPropertyName()));
                    }
                    continue;
                }
                if ("HideElements".equalsIgnoreCase(category.getId())) {
                    elementTypes = category.getElementTypes();
                    for (ElementType elementType : elementTypes) {
                        elementType.getProperties().removeIf(p -> "NetworkControl".equalsIgnoreCase(p.getPropertyName()));
                        elementType.getProperties().removeIf(p -> "PermissionItems".equalsIgnoreCase(p.getPropertyName()));
                        elementType.getProperties().removeIf(p -> "Rules".equalsIgnoreCase(p.getPropertyName()));
                        elementType.getProperties().removeIf(p -> "Operations".equalsIgnoreCase(p.getPropertyName()));
                        elementType.getProperties().removeIf(p -> "BusinessControl".equalsIgnoreCase(p.getPropertyName()));
                    }
                    continue;
                }
                toRemoveCategories.add(category);
            }
            while (toRemoveCategories.size() > 0) {
                Category category = (Category)toRemoveCategories.get(0);
                toRemoveCategories.remove(category);
                dm.getCategories().remove(category);
            }
            if (entryCategory != null) {
                entryCategory.getElementTypes().removeIf(et -> !"BaseEntity".equalsIgnoreCase(et.getId()) && !"EntryEntity".equalsIgnoreCase(et.getId()) && !"SubEntryEntity".equalsIgnoreCase(et.getId()) && !"TreeEntryEntity".equalsIgnoreCase(et.getId()) && !"JsonSubEntryEntity".equalsIgnoreCase(et.getId()) && !"TreeSubEntryEntity".equalsIgnoreCase(et.getId()));
                entryCategory.setVisible(false);
            }
            jser.getBinder().setLCId(locale);
            content = jser.serializeToString((Object)dm, null);
            if (Boolean.getBoolean("domainmodeltype.rediscache.disabled")) {
                cache.put(key, modelType, content, 3600);
            }
            if (consumer != null) {
                Map map = jser.serializeToMap((Object)dm, null);
                consumer.accept(map, modelType);
                content = SerializationUtils.toJsonString((Object)map);
            }
        } else if (consumer != null) {
            Map map = (Map)SerializationUtils.fromJsonString(content, Map.class);
            consumer.accept(map, modelType);
            content = SerializationUtils.toJsonString((Object)map);
        }
        return content;
    }

    public String getFormDeployFile(String formId, String lang) {
        List files = MetadataDao.getFormDeployFile((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form));
        if (StringUtils.isBlank((CharSequence)lang)) {
            return ((DeployFile)files.get(0)).getFileContent();
        }
        for (DeployFile file : files) {
            if (!file.getFileName().contains("." + lang)) continue;
            return file.getFileContent();
        }
        return null;
    }

    protected Map<String, Object> customMap(Map<String, Object> map, String modelType) {
        return map;
    }

    private static String saveConvert(String theString) {
        return DesignMetadataServiceImpl.saveConvert(theString, true);
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

