/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

class HotTipsLogin {
    private static Log log = LogFactory.getLog(HotTipsLogin.class);
    private String domainUrl;
    private String appId;
    private String appSecuret;
    private String accountId;
    private String userPhone;
    private static final String URL_GET_APPTOKEN = "/api/getAppToken.do";
    private static final String URL_LOGIN = "/api/login.do";
    private static final String BOS_HOTTIPS_INFO = "bos.hottips.logininfo";

    public HotTipsLogin() {
        String loginInfo = System.getProperty(BOS_HOTTIPS_INFO);
        if (StringUtils.isNotBlank((CharSequence)loginInfo)) {
            Map properties = (Map)SerializationUtils.fromJsonString((String)loginInfo, Map.class);
            this.domainUrl = (String)properties.get("domainUrl");
            this.appId = (String)properties.get("appId");
            this.appSecuret = (String)properties.get("appSecuret");
            this.accountId = (String)properties.get("accountId");
            this.userPhone = (String)properties.get("user");
        }
    }

    public HotTipsLogin(String domainUrl, String accountId, String appId, String appSecuret, String userPhone) {
        this.domainUrl = domainUrl;
        this.accountId = accountId;
        this.appId = appId;
        this.appSecuret = appSecuret;
        this.userPhone = userPhone;
    }

    protected String getAccessToken() {
        String accessToken;
        block6: {
            if (StringUtils.isBlank((CharSequence)this.appId) || StringUtils.isBlank((CharSequence)this.appSecuret)) {
                log.warn("\u672a\u914d\u7f6e\u8fd0\u8425\u5e73\u53f0\u76f8\u5173\u767b\u5f55\u53c2\u6570\uff0c\u83b7\u53d6accesstoken\u5931\u8d25\u3002");
                return null;
            }
            accessToken = "";
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            String appToken = this.getAppToken();
            if (StringUtils.isBlank((CharSequence)appToken)) {
                log.warn("appToken \u4e3a\u7a7a\u3002");
                return null;
            }
            body.put("accountId", this.accountId);
            body.put("tenantid", "");
            body.put("appId", this.appId);
            if (Encrypters.isEncrypted((String)this.appSecuret)) {
                this.appSecuret = Encrypters.decode((String)this.appSecuret);
            }
            body.put("appSecuret", this.appSecuret);
            body.put("user", this.userPhone);
            body.put("apptoken", appToken);
            try {
                boolean status;
                String resp = HttpClientUtils.postAppJson((String)(this.domainUrl + URL_LOGIN), headerParam, body, (int)5000, (int)6000);
                log.warn(String.format("\u83b7\u53d6accessToken\u54cd\u5e94\uff1a%s", resp));
                if (!StringUtils.isNotEmpty((CharSequence)resp)) break block6;
                Map result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
                boolean bl = status = result == null ? false : (Boolean)result.get("status");
                if (result != null && status && result.get("data") != null) {
                    Map tokenData = (Map)result.get("data");
                    accessToken = tokenData.get("access_token").toString();
                    break block6;
                }
                log.warn(String.format("url:%s \u83b7\u53d6accessToken\u5f02\u5e38\uff0c\u54cd\u5e94\uff1a%s", this.domainUrl + URL_LOGIN, resp));
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return accessToken;
    }

    private String getAppToken() {
        String appToken;
        block4: {
            appToken = "";
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("accountId", this.accountId);
            body.put("tenantid", "");
            body.put("appId", this.appId);
            if (Encrypters.isEncrypted((String)this.appSecuret)) {
                this.appSecuret = Encrypters.decode((String)this.appSecuret);
            }
            body.put("appSecuret", this.appSecuret);
            try {
                boolean status;
                String resp = HttpClientUtils.postAppJson((String)(this.domainUrl + URL_GET_APPTOKEN), headerParam, body, (int)5000, (int)6000);
                log.warn(String.format("\u83b7\u53d6appToken\u54cd\u5e94\uff1a%s", resp));
                if (!StringUtils.isNotEmpty((CharSequence)resp)) break block4;
                Map result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
                boolean bl = status = result == null ? false : (Boolean)result.get("status");
                if (result != null && status && result.get("data") != null) {
                    Map tokenData = (Map)result.get("data");
                    appToken = tokenData.get("app_token").toString();
                    break block4;
                }
                log.warn(String.format("url:%s \u83b7\u53d6appToken\u5f02\u5e38\uff0c\u54cd\u5e94\uff1a%s", this.domainUrl + URL_GET_APPTOKEN, resp));
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return appToken;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    public void setDomainUrl(String domainUrl) {
        this.domainUrl = domainUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecuret() {
        return this.appSecuret;
    }

    public void setAppSecuret(String appSecuret) {
        this.appSecuret = appSecuret;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getUserPhone() {
        return this.userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }
}

