/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips;

import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dbversion.IndustryVersionService;
import kd.bos.entity.DBVersion;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.model.ThirdAppApplyInfoDto;
import kd.bos.open.res.service.ThirdAppApplyClientService;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.tips.HotTipsCacheManager;
import kd.bos.service.tips.HottipsAuthUtil;
import kd.bos.service.tips.IHotTipsService;
import kd.bos.service.tips.PageType;
import kd.bos.service.tips.builder.AbsctractTipsBuilder;
import kd.bos.service.tips.builder.FormBuilder;
import kd.bos.service.tips.builder.IHottipsBuilder;
import kd.bos.service.tips.builder.ListBuilder;
import kd.bos.service.tips.builder.MobileFormBuild;
import kd.bos.service.tips.builder.MobileListBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class HotTipsServiceImpl
implements IHotTipsService {
    private static Log log = LogFactory.getLog(HotTipsServiceImpl.class);
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String KEY_ID = "id";
    private static final String KEY_FORMID = "formid";
    private static final String KEY_FORM_ID = "formId";
    private static final String KEY_TIPSDATA = "tipsdata";
    private static final String KEY_CONTROLKEY = "controlkey";
    private static final String KEY_FORM_TYPE = "formType";
    private static final String KEY_FORMTYPE = "formtype";
    private static final String KEY_PRODUCT = "product";
    private static final String KEY_PRODUCT_ID = "productId";
    private static final String KEY_CONTROL_ID = "controlId";
    private static final String KEY_IS_DELETE = "isDeleted";
    private static final String KEY_IS_DELETE_LOW = "isdelete";
    private static final String IS_DELETE_TRUE = "1";
    private static final String IS_DELETE_FALSE = "0";
    private static final String KEY_AUDITTIME = "audittime";
    private static final String KEY_SYNCTIME = "synctime";
    private static final String KEY_VERSION = "version";
    private static final String KEY_BIZAPP = "bizapp";
    private static final String KEY_BIZCLOUD = "bizcloud";
    private static final String KEY_APPID = "appId";
    private static final String KEY_BIZCLOUD_ID = "bizCloudId";
    private static final String TIPS_SYNC_API = "/kapi/v2/poa/SyncTips";
    private static final String TIPS_SYNC_RES_API = "https://resource.kdcloud.com/kapi/v2/kdec/kdec_poa/tips/syncTips";
    private static final String TIPS_SYNC_RES_API_POSTFIX = "kapi/v2/kdec/kdec_poa/tips/syncTips";
    private static final String TIPS_TABLE = "t_bas_hottips";
    private static final String TIPS_ENTITY_ID = "bos_hottips";
    private static final String BOS_HOTTIPS_ON = "bos.hottips.on";
    private static final String BOS_HOTTIPS_SYNC_URL = "bos.hottips.sync.url";
    private static final String ERROR_CODE_SUCCESS = "0";
    private static final String ERROR_CODE_APPLY_SUBMIT = "APPLY01";
    private static final String ERROR_CODE_APPLYING = "APPLY02";

    public boolean enableHotTips() {
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)BOS_HOTTIPS_ON, (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return Boolean.TRUE;
    }

    private String getTipsSyncResApi(ThirdAppApplyDto dto) {
        String url = dto.getTargeturl();
        return url + TIPS_SYNC_RES_API_POSTFIX;
    }

    public void clearHotTipsCache() {
        HotTipsCacheManager.clearCache();
    }

    public void syncTips(Map<String, Object> param) {
        int tipsCount;
        log.info("HotTipsServiceImpl starts to synchronize tips from the operating platform");
        if (!this.enableHotTips()) {
            log.info("The online tips function is not enabled, and the synchronization exits");
            return;
        }
        Map<String, Object> data = this.getTipsData(param);
        if (data == null) {
            log.info("The online tips interface responded successfully, but the data did not contain data. Therefore, the synchronization exited");
            return;
        }
        List tipsDataList = (List)data.get("data");
        String syncTimeStr = (String)data.get("syncTime");
        String auditTimeStr = (String)data.get("auditTime");
        int n = tipsCount = data.get("tipsCount") == null ? 0 : (Integer)data.get("tipsCount");
        if (tipsDataList == null || tipsDataList.isEmpty()) {
            this.saveSyncInfo();
            log.info("No tips data\uff0c the synchronization ends");
            return;
        }
        log.info(String.format("A total of %s tips were obtained from the operation platform and synchronization began...", tipsCount));
        Date syncTime = new Date();
        Date auditTime = null;
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isNotBlank((CharSequence)syncTimeStr)) {
                syncTime = datetimeFormat.parse(syncTimeStr);
            }
            if (StringUtils.isNotBlank((CharSequence)auditTimeStr)) {
                auditTime = datetimeFormat.parse(auditTimeStr);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        ArrayList<DynamicObject> tipsList = new ArrayList<DynamicObject>(10);
        ArrayList<ThreeTuple> paramList = new ArrayList<ThreeTuple>(10);
        ArrayList<Tuple<String, Integer>> clearList = new ArrayList<Tuple<String, Integer>>(10);
        for (Object obj : tipsDataList) {
            Map tipsData = (Map)obj;
            String formId = (String)tipsData.get(KEY_FORM_ID);
            String controlId = (String)tipsData.get(KEY_CONTROL_ID);
            Integer formType = StringUtils.isBlank(tipsData.get(KEY_FORM_TYPE)) ? 1 : Integer.parseInt((String)tipsData.get(KEY_FORM_TYPE));
            paramList.add(new ThreeTuple((Object)formId, (Object)controlId, (Object)String.valueOf(formType)));
            clearList.add((Tuple<String, Integer>)new Tuple((Object)formId, (Object)formType));
            tipsList.add(this.convertToDynamicObject(tipsData, syncTime, auditTime));
        }
        if (!tipsList.isEmpty()) {
            try (TXHandle h = TX.requiresNew((String)"HotTips.Save");){
                try {
                    this.delTipsData(paramList);
                    SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)TIPS_ENTITY_ID), (Object[])tipsList.toArray());
                    this.saveSyncInfo();
                }
                catch (Exception e) {
                    String msg = String.format("HotTips save failed\uff0cerr:%s", e.getMessage());
                    h.markRollback();
                    log.warn(msg, (Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
                }
            }
            HotTipsCacheManager.clearCache(clearList);
            log.info("Cache clearing complete.");
        } else {
            this.saveSyncInfo();
        }
    }

    public List<Object> getHotTips(String pageId) {
        List<Object> tipsList = new ArrayList<Object>(10);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            log.info(String.format("The pageId: %s passed in when getting tips is empty", pageId));
            return tipsList;
        }
        String formId = "";
        PageType pageType = PageType.Form;
        try {
            QFilter QIsDelete;
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(pageId);
            if (formView == null) {
                log.info(String.format("The formView view for pageId: %s is empty", pageId));
                return tipsList;
            }
            formId = this.getFormId(formView);
            pageType = this.getPageType(formView);
            String mobileFormId = formId;
            String id = "";
            if ((PageType.MobileForm == pageType || PageType.MobileList == pageType) && StringUtils.isBlank((CharSequence)(id = MetadataDao.getIdByNumber((String)mobileFormId, (MetaCategory)MetaCategory.Form))) && formId.endsWith("_mob")) {
                formId = formId.substring(0, formId.lastIndexOf("_mob"));
            }
            if ((tipsList = HotTipsCacheManager.getFromCache(formId, pageType.getValue())) != null) {
                return tipsList;
            }
            QFilter QFormId = new QFilter(KEY_FORMID, "=", (Object)formId);
            QFilter QFormType = new QFilter(KEY_FORMTYPE, "=", (Object)String.valueOf(pageType.getValue()));
            QFilter[] qFilters = new QFilter[]{QFormId, QFormType, QIsDelete = new QFilter(KEY_IS_DELETE_LOW, "!=", (Object)IS_DELETE_TRUE)};
            Map tipsMap = BusinessDataServiceHelper.loadFromCache((String)TIPS_ENTITY_ID, (QFilter[])qFilters);
            if (tipsMap == null || tipsMap.isEmpty()) {
                tipsList = new ArrayList(0);
                HotTipsCacheManager.putToCache(formId, pageType.getValue(), tipsList);
                return tipsList;
            }
            IHottipsBuilder hottipsBuilder = this.getTipsBuilder(pageType, tipsMap, formId, mobileFormId);
            tipsList = hottipsBuilder.build();
            HotTipsCacheManager.putToCache(formId, pageType.getValue(), tipsList);
        }
        catch (Exception e) {
            log.error(String.format("Form\uff1a%s\uff0cPage ype\uff1a%s Obtaining online tips fails\uff0cERR\uff1a%s", formId, pageType.name(), e.getMessage()), (Throwable)e);
        }
        return tipsList;
    }

    private IHottipsBuilder getTipsBuilder(PageType pageType, Map<Object, DynamicObject> tipsMap, String formId, String mobileFormId) {
        AbsctractTipsBuilder hottipsBuilder = null;
        switch (pageType) {
            case Form: {
                hottipsBuilder = new FormBuilder(tipsMap, formId);
                break;
            }
            case MobileForm: {
                hottipsBuilder = new MobileFormBuild(tipsMap, formId, mobileFormId);
                break;
            }
            case List: {
                hottipsBuilder = new ListBuilder(tipsMap, formId);
                break;
            }
            case MobileList: {
                hottipsBuilder = new MobileListBuilder(tipsMap, formId);
                break;
            }
            default: {
                hottipsBuilder = new FormBuilder(tipsMap, formId);
            }
        }
        return hottipsBuilder;
    }

    private String getFormId(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        String formId = showParameter.getFormId();
        if (showParameter instanceof ListShowParameter && StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId()))) {
            formId = showParameter.getFormId();
        }
        return formId;
    }

    private PageType getPageType(IFormView formView) {
        PageType pageType = PageType.Form;
        FormShowParameter showParameter = formView.getFormShowParameter();
        if (formView instanceof MobileListView || showParameter instanceof MobileListShowParameter) {
            pageType = PageType.MobileList;
        } else if (showParameter instanceof ListShowParameter) {
            pageType = PageType.List;
        } else if (formView instanceof MobileBillView || showParameter instanceof MobileFormShowParameter) {
            pageType = PageType.MobileForm;
        }
        return pageType;
    }

    private DynamicObject convertToDynamicObject(Map<String, Object> tipsData, Date syncTime, Date auditTime) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TIPS_ENTITY_ID));
        long id = DB.genGlobalLongId();
        String formId = (String)tipsData.get(KEY_FORM_ID);
        String controlId = (String)tipsData.get(KEY_CONTROL_ID);
        String formType = (String)tipsData.get(KEY_FORM_TYPE);
        String version = (String)tipsData.get(KEY_VERSION);
        String appId = (String)tipsData.get(KEY_APPID);
        String bizCloudId = (String)tipsData.get(KEY_BIZCLOUD_ID);
        Boolean isDelete = (Boolean)tipsData.get(KEY_IS_DELETE);
        Map tips = (Map)tipsData.get("tips");
        obj.set(KEY_ID, (Object)id);
        obj.set(KEY_FORMID, (Object)formId);
        obj.set(KEY_TIPSDATA, (Object)SerializationUtils.toJsonString((Object)tips));
        obj.set(KEY_CONTROLKEY, (Object)controlId);
        obj.set(KEY_FORMTYPE, (Object)formType);
        obj.set(KEY_VERSION, (Object)version);
        obj.set(KEY_SYNCTIME, (Object)syncTime);
        obj.set(KEY_BIZCLOUD, (Object)bizCloudId);
        obj.set(KEY_BIZAPP, (Object)appId);
        if (auditTime != null) {
            obj.set(KEY_AUDITTIME, (Object)auditTime);
        }
        if (isDelete != null) {
            obj.set(KEY_IS_DELETE_LOW, (Object)(isDelete != false ? IS_DELETE_TRUE : "0"));
        }
        return obj;
    }

    private void delTipsData(List<ThreeTuple> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"HotTipsServiceImpl", (String)"delTipsData");
             TXHandle h = TX.requiresNew((String)"delTipsData");){
            String sql = String.format("delete from %s where fformid=? and fkey = ? and fformtype = ?", TIPS_TABLE);
            ArrayList<Object[]> list = new ArrayList<Object[]>(10);
            for (ThreeTuple obj : paramList) {
                Object[] param = new Object[]{obj.item1, obj.item2, obj.item3};
                list.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, list);
        }
    }

    private Map<String, Object> getTipsData(Map<String, Object> param) {
        HashMap body = new HashMap(16);
        HashMap<String, String> syncTipsParaIn = new HashMap<String, String>(16);
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateTime = new Date();
        Map<String, String> verMap = this.getCosmicVer();
        String product = this.getProduct();
        syncTipsParaIn.put(KEY_PRODUCT, product);
        syncTipsParaIn.put("dataCenterId", RequestContext.get().getAccountId());
        Date lastSyncTime = this.getTipsSyncTime();
        if (param != null && !param.isEmpty()) {
            if (param.get("dateTime") != null) {
                dateTime = (Date)param.get("dateTime");
            }
            if (param.get("lastSyncTime") != null) {
                lastSyncTime = (Date)param.get("lastSyncTime");
            }
        }
        if (lastSyncTime != null) {
            syncTipsParaIn.put("lastSyncTime", datetimeFormat.format(lastSyncTime));
        }
        syncTipsParaIn.put("dateTime", datetimeFormat.format(dateTime));
        syncTipsParaIn.put("bizVersion", verMap.get("cosmic_biz"));
        syncTipsParaIn.put("cosmicVersion", verMap.get("cosmic_bos"));
        body.put("syncTipsParaIn", syncTipsParaIn);
        String bodyStr = SerializationUtils.toJsonString(body);
        log.info(String.format("This tips synchronization parameter: %s", bodyStr));
        try {
            boolean status;
            ApiCommonResult<ThirdAppApplyDto> apiCommonResult = this.getThirdApp();
            String tipsResApi = this.getTipsSyncResApi((ThirdAppApplyDto)apiCommonResult.getData());
            log.info(String.format("api\u63a5\u53e3\u5730\u5740\uff1a%s", tipsResApi));
            CustomApiResult<Map> customApiResult = HottipsAuthUtil.doDigestApiRequest(tipsResApi, (ThirdAppApplyDto)apiCommonResult.getData(), Map.class, bodyStr);
            String resp = customApiResult == null ? "" : SerializationUtils.toJsonString(customApiResult);
            log.warn(String.format("Get tips response\uff1a%s", resp));
            boolean bl = status = customApiResult == null ? false : customApiResult.isStatus();
            if (customApiResult != null && status) {
                Map data = (Map)customApiResult.getData();
                return data;
            }
            String msg = String.format("url:%s Get tips response fails\uff0cresponse\uff1a%s", tipsResApi, resp);
            log.warn(msg);
            throw new KDException(new ErrorCode("bos-exception", resp), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getProduct() {
        String product = "constellation";
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (modelType == 4) {
            product = "galaxy";
        }
        return product;
    }

    private Map<String, String> getCosmicVer() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        List versionInfos = null;
        versionInfos = modelType == 4 ? IndustryVersionService.getGalaxyVersionInfos() : IndustryVersionService.getVersionInfos();
        IndustryVersionInfo bizVersion = null;
        IndustryVersionInfo bosVersion = null;
        String dbVer = "";
        String bosVer = "";
        String bizVer = "";
        if (versionInfos == null || versionInfos.isEmpty()) {
            dbVer = DBVersion.getVer();
            bosVer = bosVer + dbVer;
            bizVer = bizVer + dbVer;
        } else {
            for (IndustryVersionInfo version : versionInfos) {
                if ("cosmic_bos".equals(version.getProductNumber())) {
                    bosVersion = version;
                    continue;
                }
                bizVersion = version;
            }
            bosVer = bosVer + (bosVersion == null ? (bizVersion == null ? "" : bizVersion.getVersion()) : bosVersion.getVersion());
            bizVer = bizVer + (bizVersion == null ? (bosVersion == null ? "" : bosVersion.getVersion()) : bizVersion.getVersion());
        }
        map.put("cosmic_bos", this.formatVer(bosVer));
        map.put("cosmic_biz", this.formatVer(bizVer));
        return map;
    }

    private String formatVer(String version) {
        String ver = "";
        if (StringUtils.isNotBlank((CharSequence)version)) {
            String[] verStrs = version.split("\\.");
            String iterator = "0";
            if (verStrs.length > 2) {
                iterator = verStrs[2];
            }
            ver = String.format("%s.%s.%s", verStrs[0], verStrs[1], iterator);
        }
        return ver;
    }

    private Date getTipsSyncTime() {
        String sql = "select fsynctime from T_BAS_HOTTIPS_SYNCINFO";
        ResultSetHandler<Date> action = new ResultSetHandler<Date>(){

            public Date handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getTimestamp("fsynctime");
                }
                return null;
            }
        };
        return (Date)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)action);
    }

    private void saveSyncInfo() {
        String insVerSql = "insert into T_BAS_HOTTIPS_SYNCINFO (FID, FSYNCTIME) values(1, getdate());";
        String updVerSql = "update T_BAS_HOTTIPS_SYNCINFO SET FSYNCTIME = getdate() where FID = 1;";
        if (this.getTipsSyncTime() == null) {
            DB.execute((DBRoute)DBRoute.basedata, (String)"delete from T_BAS_HOTTIPS_SYNCINFO;", null);
            DB.execute((DBRoute)DBRoute.basedata, (String)insVerSql, null);
        } else {
            DB.execute((DBRoute)DBRoute.basedata, (String)updVerSql, null);
        }
    }

    private ApiCommonResult<ThirdAppApplyDto> getThirdApp() {
        ThirdAppApplyInfoDto thirdAppApplyInfoDto = new ThirdAppApplyInfoDto();
        for (int i = 0; i < 6; ++i) {
            ApiCommonResult apiCommonResult = (ApiCommonResult)DispatchApiServiceHelper.invokeApiService((String)ThirdAppApplyClientService.class.getSimpleName(), (String)"findThirdAppApplyInfo", (Object[])new Object[]{thirdAppApplyInfoDto});
            if (apiCommonResult == null) {
                log.info(String.format("Failed to obtain the third-party application application parameters. %s attempts will be made", i + 1));
                continue;
            }
            String errorCode = apiCommonResult.getErrorCode();
            if (ERROR_CODE_APPLYING.equals(errorCode) || ERROR_CODE_APPLY_SUBMIT.equals(errorCode)) {
                log.info(String.format("The third-party application application parameters are being applied for. Wait 5 seconds and retry for the %s time", i + 1));
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!"0".equals(errorCode)) continue;
            return apiCommonResult;
        }
        throw new KDException(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570\u7533\u8bf7\u4e2d\uff0c\u83b7\u53d6\u7533\u8bf7\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HotTipsServiceImpl_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
    }
}

