/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.util.HttpClientOpenUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.model.SignInfoDto;

class HottipsAuthUtil {
    private static Log logger = LogFactory.getLog(HottipsAuthUtil.class);
    private static final String FORMAT_SECOND = "yyyy-MM-dd HH:mm:ss";

    HottipsAuthUtil() {
    }

    protected static <T> CustomApiResult<T> doDigestApiRequest(String url, ThirdAppApplyDto params, Class<T> clazz, String jsonContent) throws OpenApiException {
        logger.info(String.format("---------------OpenApiDigestAuthUtil.doDigestApiRequest url:%s, params:%s, jsonContent:%s", url, params, jsonContent));
        String appSecret = params.getPublickey();
        String openApiSign = params.getSecretKey();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(FORMAT_SECOND);
        String timestamp = simpleDateFormat2.format(new Date());
        String uuid = UUID.randomUUID().toString();
        headerMap.put("signatureNonce", uuid);
        headerMap.put("timestamp", timestamp);
        if (StringUtils.isBlank((CharSequence)openApiSign)) {
            headerMap.put("appId", params.getThirdcode());
            headerMap.put("accountId", params.getTargetaccountid());
            headerMap.put("user", params.getThirdcode());
            headerMap.put("usertype", "UserName");
        } else {
            headerMap.put("OpenApiAuth", "2");
            headerMap.put("openApiSign", openApiSign);
        }
        headerMap.put("signature", HottipsAuthUtil.getSignature(jsonContent, timestamp, uuid, appSecret));
        headerMap.put("Content-Type", "application/json");
        String responseString = "";
        try {
            responseString = HttpClientOpenUtils.post((String)url, headerMap, (String)jsonContent);
        }
        catch (Exception e) {
            logger.info(String.format("post error,accId:%s,appId:%s,res:%s, error:%s", params.getTargetaccountid(), params.getThirdcode(), responseString, e.getMessage()), (Object)e);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u4e91\u7aef\u5730\u5740\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e91\u7aef\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_23", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (responseString.contains("login.loginBizException")) {
            JSONObject errorResponse = JSON.parseObject((String)responseString);
            String errMsg = errorResponse.getString("errorMsg") == null ? responseString : errorResponse.getString("errorMsg");
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, errMsg, new Object[0]);
        }
        CustomApiResult result = null;
        try {
            result = (CustomApiResult)JSON.parseObject((String)responseString, (TypeReference)new TypeReference<CustomApiResult<T>>(){}, (Feature[])new Feature[0]);
            String dataString = JSON.toJSONString((Object)result.getData());
            Object data = JSON.toJavaObject((JSON)JSON.parseObject((String)dataString), clazz);
            result.setData(data);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "doDigestApiRequest receive post error, responseString:" + responseString, new Object[]{e});
        }
        logger.info(String.format("---------------OpenApiDigestAuthUtil.doDigestApiRequest result:%s ", url, params, JSON.toJSONString((Object)result)));
        return result;
    }

    private static String getSignature(String content, String timestamp, String uuid, String publicKey) {
        SignInfoDto signInfo = new SignInfoDto();
        signInfo.setContent(content);
        signInfo.setDateTime(timestamp);
        signInfo.setSignatureNonce(uuid);
        signInfo.setAuthType("2");
        ApiSecurityService apiSecurityService = ApiSecurityFactory.getApiSecurityService();
        String encyptString = apiSecurityService.signingBySha256(publicKey, signInfo);
        return encyptString;
    }
}

