/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.tips.builder.AbsctractTipsBuilder;

public class FormBuilder
extends AbsctractTipsBuilder {
    private static Log logger = LogFactory.getLog(FormBuilder.class);

    public FormBuilder() {
    }

    public FormBuilder(Map<Object, DynamicObject> tipsMap, String formId) {
        this.tipsMap = tipsMap;
        this.formId = formId;
    }

    @Override
    public List<Object> build() {
        ArrayList<Object> tipsList = new ArrayList<Object>(10);
        if (this.tipsMap == null || this.tipsMap.isEmpty()) {
            return tipsList;
        }
        HashMap<String, String> entryControlMap = new HashMap<String, String>(16);
        this.buildEntryControl(this.getRootItems(), entryControlMap);
        Map<String, Map<String, Object>> ctrlTipsMap = this.getCtrlTips();
        for (Map.Entry entry : this.tipsMap.entrySet()) {
            DynamicObject tipsData = (DynamicObject)entry.getValue();
            String controlKey = tipsData.getString("controlkey");
            Map<String, Object> ctrlTips = ctrlTipsMap.get(controlKey);
            if (ctrlTips != null && "bill".equals(ctrlTips.get("type"))) {
                logger.info(String.format("\u63a7\u4ef6%s\u7684\u7c7b\u578b\u662f\u8868\u5355\uff0c\u8df3\u8fc7\u3002", controlKey));
                continue;
            }
            Map<String, Object> controlMap = this.createControl(tipsData);
            if (entryControlMap.containsKey(controlKey)) {
                HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>(1);
                String entryKey = (String)entryControlMap.get(controlKey);
                entryMap.put(entryKey, controlMap);
                tipsList.add(entryMap);
                continue;
            }
            tipsList.add(controlMap);
        }
        return tipsList;
    }

    protected List<Control> getRootItems() {
        FormRoot formRoot = FormMetadataCache.getRootControl((String)this.formId);
        if (formRoot == null) {
            return new ArrayList<Control>(0);
        }
        return formRoot.getItems();
    }

    protected Map<String, Map<String, Object>> getCtrlTips() {
        HashMap<String, Map<String, Object>> ctrlTipsMap = new HashMap<String, Map<String, Object>>(16);
        List<Map<String, Object>> itemList = this.getClientItems();
        this.buildCtrlTips(ctrlTipsMap, itemList);
        return ctrlTipsMap;
    }

    private void buildCtrlTips(Map<String, Map<String, Object>> ctrlTipsMap, List<Map<String, Object>> itemList) {
        if (itemList == null) {
            return;
        }
        for (Map<String, Object> item : itemList) {
            String controlKey = (String)item.get("id");
            if (StringUtils.isEmpty((Object)controlKey)) {
                controlKey = (String)item.get("dataIndex");
            }
            String type = (String)item.get("type");
            Map tips = (Map)item.get("tips");
            if (tips != null) {
                ctrlTipsMap.put(controlKey, tips);
            }
            List items = null;
            items = "grid".equals(type) ? (List)item.get("columns") : (List)item.get("items");
            this.buildCtrlTips(ctrlTipsMap, items);
        }
    }

    protected List<Map<String, Object>> getClientItems() {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(10);
        MetadataService MetadataServiceImpl2 = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = MetadataServiceImpl2.loadClientFormMeta(this.formId);
        if (StringUtils.isEmpty((Object)metadata)) {
            return itemList;
        }
        Map formMetaMap = (Map)SerializationUtils.fromJsonString((String)metadata, Map.class);
        List items = (List)formMetaMap.get("items");
        if (items != null) {
            itemList.addAll(items);
        }
        return itemList;
    }
}

