/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.Tips;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.tips.builder.AbsctractTipsBuilder;

public class ListBuilder
extends AbsctractTipsBuilder {
    private static Log log = LogFactory.getLog(ListBuilder.class);

    public ListBuilder() {
    }

    public ListBuilder(Map<Object, DynamicObject> tipsMap, String formId) {
        this.tipsMap = tipsMap;
        this.formId = formId;
    }

    @Override
    public List<Object> build() {
        ArrayList<Object> tipsList = new ArrayList<Object>(10);
        if (this.tipsMap == null || this.tipsMap.isEmpty()) {
            return tipsList;
        }
        HashMap<String, Tips> ctrlTipsMap = new HashMap<String, Tips>(16);
        Map<String, Control> listColumMap = this.buildListColum(ctrlTipsMap);
        for (Map.Entry entry : this.tipsMap.entrySet()) {
            DynamicObject tipsData = (DynamicObject)entry.getValue();
            String controlKey = tipsData.getString("controlkey");
            Tips ctrlTips = (Tips)ctrlTipsMap.get(controlKey);
            if (ctrlTips != null && "bill".equals(ctrlTips.getType())) {
                log.info(String.format("\u63a7\u4ef6%s\u7684\u7c7b\u578b\u662f\u8868\u5355\uff0c\u8df3\u8fc7\u3002", controlKey));
                continue;
            }
            String listFieldKey = controlKey.replace('.', '_');
            Map<String, Object> controlMap = this.createControl(tipsData, listFieldKey);
            if (listColumMap.containsKey(controlKey)) {
                HashMap<String, Map<String, Object>> billListMap = new HashMap<String, Map<String, Object>>(1);
                billListMap.put(this.getListApKey(), controlMap);
                tipsList.add(billListMap);
                continue;
            }
            tipsList.add(controlMap);
        }
        return tipsList;
    }

    protected Map<String, Control> buildListColum(Map<String, Tips> ctrlTipsMap) {
        HashMap<String, Control> listColumMap = new HashMap<String, Control>(16);
        Map<String, Object> listMeta = this.getListMeta();
        if (listMeta == null || listMeta.isEmpty()) {
            log.warn(String.format("\u8868\u5355\u6807\u8bc6\uff1a%s\u7684\u5217\u8868\u5143\u6570\u636e\u4e3a\u7a7a,listMeta:%s", this.formId, listMeta));
            return listColumMap;
        }
        String strBillList = (String)listMeta.get(BillList.class.getSimpleName());
        BillList billList = (BillList)ControlTypes.fromJsonString((String)strBillList);
        List items = billList.getItems();
        this.builListColums(items, listColumMap, ctrlTipsMap);
        return listColumMap;
    }

    protected String getListApKey() {
        return "billlistap";
    }

    protected Map<String, Object> getListMeta() {
        return FormMetadataCache.getListMeta((String)this.formId);
    }

    private void builListColums(List<Control> items, Map<String, Control> listColumMap, Map<String, Tips> ctrlTipsMap) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (Control control : items) {
            if (control instanceof AbstractListColumn) {
                listColumMap.put(((AbstractListColumn)control).getListFieldKey(), control);
            } else if (control instanceof Container) {
                this.builListColums(((Container)control).getItems(), listColumMap, ctrlTipsMap);
            }
            if (control instanceof ListColumn && ((ListColumn)control).getCtlTips() != null) {
                ctrlTipsMap.put(((ListColumn)control).getListFieldKey(), ((ListColumn)control).getCtlTips());
                continue;
            }
            if (!(control instanceof ListColumnGroup) || ((ListColumnGroup)control).getCtlTips() == null) continue;
            ctrlTipsMap.put(((ListColumnGroup)control).getListFieldKey(), ((ListColumnGroup)control).getCtlTips());
        }
    }
}

