/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.tips.builder.FormBuilder;

public class MobileFormBuild
extends FormBuilder {
    private String mobileFormId;

    public MobileFormBuild() {
    }

    public MobileFormBuild(Map<Object, DynamicObject> tipsMap, String formId, String mobileFormId) {
        super(tipsMap, formId);
        this.mobileFormId = mobileFormId;
    }

    @Override
    protected List<Control> getRootItems() {
        FormRoot formRoot = FormMetadataCache.getRootControl((String)this.mobileFormId);
        if (formRoot == null) {
            return new ArrayList<Control>(0);
        }
        return formRoot.getItems();
    }

    @Override
    protected void buildEntryControl(List<Control> items, Map<String, String> entryControlMap) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (Control item : items) {
            if (item instanceof EntryGrid) {
                List entryItems = ((EntryGrid)item).getItems();
                if (entryItems == null) continue;
                for (Control entryItem : entryItems) {
                    entryControlMap.put(entryItem.getKey(), item.getKey());
                }
                continue;
            }
            if (!(item instanceof Container)) continue;
            this.buildEntryControl(((Container)item).getItems(), entryControlMap);
        }
    }

    @Override
    protected List<Map<String, Object>> getClientItems() {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(10);
        MetadataService MetadataServiceImpl2 = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = MetadataServiceImpl2.loadClientFormMeta(this.mobileFormId);
        if (StringUtils.isEmpty((Object)metadata)) {
            return itemList;
        }
        Map formMetaMap = (Map)SerializationUtils.fromJsonString((String)metadata, Map.class);
        List items = (List)formMetaMap.get("items");
        if (items != null) {
            itemList.addAll(items);
        }
        return itemList;
    }
}

