/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.service.upgrade.DeployServiceImpl;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.threads.ThreadPools;

public class DeployServiceWebApiPlugin
implements IBillWebApiPlugin {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String TASKID = "taskid";
    private static final String LOGID = "logid";
    private static Log log = LogFactory.getLog(DeployServiceWebApiPlugin.class);
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"DeployServiceWebApiPlugin-Thread", (int)3, (int)10);

    public ApiResult doCustomService(Map<String, Object> params) {
        boolean execDeprecated = Boolean.parseBoolean(System.getProperty("kd.deployapi.execdeprecatedmethod", "false"));
        if (!execDeprecated) {
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{"deprecated method access."});
        }
        ApiResult ret = new ApiResult();
        ret.setSuccess(true);
        Map<Object, Object> mapRetInfo = new HashMap<String, Number>();
        Object type = params.get("type");
        if (type != null) {
            Map param = (Map)params.get("params");
            if (param == null) {
                ret.setSuccess(false);
                ret.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"DeployServiceWebApiPlugin_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return ret;
            }
            String action = (String)type;
            if (action.equalsIgnoreCase("u")) {
                String dmUrl = (String)param.get("dmurl");
                String ver = (String)param.get("ver");
                long id = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, id);
                mapRetInfo.put("progress", 0);
                log.debug("begin deployRunnable");
                es.execute(new DeployRunnable(RequestContext.get(), id, ver, dmUrl));
                log.debug("end deployRunnable");
            } else if (action.equalsIgnoreCase("l")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    mapRetInfo = this.getLogs(Long.parseLong((String)taskid), Long.parseLong((String)logid));
                }
            } else if (action.equalsIgnoreCase("p")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.excuteStatus(task);
                }
            } else if (action.equalsIgnoreCase("s")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.getLogs(task, l);
                    mapRetInfo.putAll(this.excuteStatus(task));
                }
            } else {
                ret.setSuccess(false);
                ret.setMessage(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a%s", (String)"DeployServiceWebApiPlugin_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), action));
            }
            ret.setData(mapRetInfo);
        } else {
            ret.setSuccess(false);
            ret.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"DeployServiceWebApiPlugin_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        return ret;
    }

    private Map<String, Object> getLogs(long taskid, long logid) {
        DeployServiceImpl deployService = new DeployServiceImpl();
        return deployService.getLogs(taskid, logid);
    }

    private Map<String, Object> excuteStatus(long taskid) {
        DeployServiceImpl deployService = new DeployServiceImpl();
        return deployService.excuteStatus(taskid);
    }

    public class DeployRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(DeployRunnable.class);
        private long id;
        private String ver;
        private String dmUrl;
        private RequestContext ctx;

        public DeployRunnable(RequestContext ctx, long id, String ver, String dmUrl) {
            this.id = id;
            this.ver = ver;
            this.dmUrl = dmUrl;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            log.debug("deployRunnable run");
            try {
                DeployServiceImpl deployService = new DeployServiceImpl();
                deployService.deployDM(this.id, this.ver, this.dmUrl);
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, "Deploy dm").toString();
                DeployLog.error(this.id, this.ver, DeployCategory.Package, result, e);
            }
            log.debug("deployRunnable run end.");
        }
    }
}

