/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.DBVersion;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.StandardVersion;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.util.ExceptionUtils;

public class IndustryVersion
extends AbsractVersion {
    protected static final String VERSION_TABLE = "T_BAS_INDUSTRY_VERSION";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";

    public IndustryVersion(DeployParam deployParam) {
        super(deployParam);
    }

    @Override
    public boolean checkVer() {
        if (this.isIgnoreVer()) {
            return true;
        }
        try {
            String dbVer = this.getVer();
            String fullVer = this.getDeployParam().getFullVer();
            if (!this.compareVer(fullVer, dbVer)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u7248\u672c%1$s\u5c0f\u4e8e\u7cfb\u7edf\u7248\u672cIndustry %2$s\uff0c\u4e0d\u80fd\u5347\u7ea7\uff01", (String)"IndustryVersion_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fullVer, dbVer);
                DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, msg);
                return false;
            }
            DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, ResManager.loadKDString((String)"Industry Version \u6821\u9a8c\u901a\u8fc7...", (String)"IndustryVersion_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return true;
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7248\u672c\u51fa\u9519\uff0c\u5806\u6808\uff1a%s", (String)"IndustryVersion_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), stackMsg);
            DeployLog.error(this.getDeployParam().getTaskId(), this.getDeployParam().getFullVer(), DeployCategory.Package, msg, e);
            return false;
        }
    }

    @Override
    public boolean checkRely() {
        String isv = this.getDeployParam().getIsv();
        Map<String, String> relyOn = this.getDeployParam().getRelyOn();
        if (relyOn == null || relyOn.isEmpty()) {
            return true;
        }
        Map<String, String> products = this.loadAllProduct();
        for (Map.Entry<String, String> entry : relyOn.entrySet()) {
            String productNumber = entry.getKey();
            String key = isv + "-" + productNumber;
            key = key.toLowerCase();
            String dbVer = products.get(key);
            String relyVer = entry.getValue();
            if (!products.containsKey(key)) {
                if (StandardVersion.ISV.equalsIgnoreCase(isv) && (StandardVersion.BOS_NUMBER.equalsIgnoreCase(productNumber) || StandardVersion.BIZ_NUMBER.equalsIgnoreCase(productNumber))) {
                    dbVer = DBVersion.getVer();
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u6ca1\u6709\u68c0\u67e5\u5230\u4f9d\u8d56\u7684\u4ea7\u54c1\uff0cisv\uff1a%1$s productNumber\uff1a%2$s", (String)"IndustryVersion_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), isv, productNumber);
                    DeployLog.warn(this.getDeployParam().getTaskId(), this.getDeployParam().getFullVer(), DeployCategory.Package, msg);
                    return false;
                }
            }
            if (this.compareRely(relyVer, dbVer)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u4ea7\u54c1\u7248\u672c\uff1a%1$s \u5c0f\u4e8e \u4f9d\u8d56\u7248\u672c\uff1a%2$s\uff0cisv\uff1a%3$s productNumber\uff1a%4$s", (String)"IndustryVersion_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dbVer, relyVer, isv, productNumber);
            DeployLog.warn(this.getDeployParam().getTaskId(), this.getDeployParam().getFullVer(), DeployCategory.Package, msg);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUndoVer() {
        String fullVer;
        String dbVer = this.getVer();
        return dbVer.equals(fullVer = this.getDeployParam().getFullVer());
    }

    @Override
    public boolean checkUndoRely() {
        throw new KDException("");
    }

    private Map<String, String> loadAllProduct() {
        String sql = "select FPRODUCTNUMBER, FISV, FVERSION from T_BAS_INDUSTRY_VERSION";
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){
            Map<String, String> res = new HashMap<String, String>();

            public Map<String, String> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String productNumber = rs.getString(1);
                    String isv = rs.getString(2);
                    String version = rs.getString(3);
                    String key = isv + "-" + productNumber;
                    key = key.toLowerCase();
                    this.res.put(key, version);
                }
                return this.res;
            }
        });
    }

    @Override
    protected String getVer() {
        DeployParam param = this.getDeployParam();
        String number = StringUtils.isBlank((CharSequence)param.getProductNumber()) ? "" : param.getProductNumber();
        String sql = String.format("select FVERSION from %s where FPRODUCTNUMBER = ? and FISV = ?", VERSION_TABLE);
        Object[] params = new SqlParameter[]{new SqlParameter("FPRODUCTNUMBER", 12, (Object)number), new SqlParameter("FISV", 12, (Object)param.getIsv())};
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
    }

    @Override
    public void saveVer() {
        if (this.isIgnoreVer()) {
            return;
        }
        this.saveIndustryVer();
    }

    @Override
    public String getPackageType() {
        return AbsractVersion.PackageType.Industry.getValue();
    }
}

