/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.DBVersion;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.util.ExceptionUtils;

public class StandardVersion
extends AbsractVersion {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    protected static String ISV = "kingdee";
    protected static String BOS_NUMBER = "cosmic_bos";
    protected static String BIZ_NUMBER = "cosmic_biz";

    public StandardVersion(DeployParam deployParam) {
        super(deployParam);
    }

    @Override
    public boolean checkVer() {
        if (this.isIgnoreVer()) {
            return true;
        }
        try {
            String dbVer = this.getVer();
            String fullVer = this.getDeployParam().getFullVer();
            if (!this.compareVer(fullVer, dbVer)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u7248\u672c%1$s\u5c0f\u4e8e\u7cfb\u7edf\u7248\u672c%2$s\uff0c\u4e0d\u80fd\u5347\u7ea7\uff01", (String)"StandardVersion_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fullVer, dbVer);
                DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, msg);
                return false;
            }
            DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, ResManager.loadKDString((String)"Standard Version \u6821\u9a8c\u901a\u8fc7...", (String)"StandardVersion_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return true;
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7248\u672c\u51fa\u9519\uff0c\u5806\u6808\uff1a%s", (String)"StandardVersion_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), stackMsg);
            DeployLog.error(this.getDeployParam().getTaskId(), this.getDeployParam().getFullVer(), DeployCategory.Package, msg, e);
            return false;
        }
    }

    @Override
    public boolean checkRely() {
        return true;
    }

    @Override
    public boolean checkUndoVer() {
        try {
            String dbVer = this.getVer();
            String fullVer = this.getDeployParam().getFullVer();
            int result = this.comparePartVer(fullVer, dbVer, 3);
            if (result != 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u56de\u6eda\u7248\u672c%1$s\u4e0e\u7cfb\u7edf\u7248\u672c%2$s\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u56de\u6eda\uff01", (String)"StandardVersion_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fullVer, dbVer);
                DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, msg);
                return false;
            }
            DeployLog.info(this.getDeployParam().getTaskId(), fullVer, DeployCategory.Package, ResManager.loadKDString((String)"Standard Version \u6821\u9a8c\u901a\u8fc7...", (String)"StandardVersion_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return true;
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7248\u672c\u51fa\u9519\uff0c\u5806\u6808\uff1a%s", (String)"StandardVersion_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), stackMsg);
            DeployLog.error(this.getDeployParam().getTaskId(), this.getDeployParam().getFullVer(), DeployCategory.Package, msg, e);
            return false;
        }
    }

    @Override
    public boolean checkUndoRely() {
        return true;
    }

    @Override
    public void saveVer() {
        if (this.isIgnoreVer()) {
            return;
        }
        String insVerSql = "insert into T_BAS_VERSION (FID, FDBVERSION, FUPGRADETIME) values(1, ?, getdate());";
        String updVerSql = "update T_BAS_VERSION SET FDBVERSION = ?, FUPGRADETIME = getdate() where FID = 1;";
        Object[] params = new Object[]{this.getDeployParam().getFullVer()};
        String dbVer = this.getVer();
        if (StringUtils.isBlank((CharSequence)dbVer) || "1.5.0".equals(dbVer)) {
            DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_VERSION;", null);
            DB.execute((DBRoute)DBRoute.meta, (String)insVerSql, (Object[])params);
        } else {
            DB.execute((DBRoute)DBRoute.meta, (String)updVerSql, (Object[])params);
        }
        if (DB.exitsTable((DBRoute)DBRoute.meta, (String)"T_BAS_INDUSTRY_VERSION")) {
            this.saveIndustryVer();
        }
    }

    @Override
    protected String getVer() {
        return DBVersion.getVer();
    }

    @Override
    public String getPackageType() {
        return AbsractVersion.PackageType.Standard.getValue();
    }
}

