/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.service.upgrade.entity.SqlScript;
import kd.bos.service.upgrade.entity.UndoSqlScript;
import kd.bos.service.upgrade.entity.UpgradeSqlScript;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlFileHandler {
    private static final String S_S_S = "%s%s%s";
    String pkgName;
    String ver;
    DeployInfo deployInfo;
    private String isv;
    private boolean isUndo;

    public String getIsv() {
        return this.isv;
    }

    public void setIsv(String isv) {
        this.isv = isv;
    }

    public void setUndo(boolean isUndo) {
        this.isUndo = isUndo;
    }

    public XmlFileHandler() {
        long id = DB.genGlobalLongId();
        this.deployInfo = new DeployInfo();
        this.deployInfo.setId(id);
    }

    public XmlFileHandler(long id, String ver) {
        this.deployInfo = new DeployInfo();
        this.deployInfo.setId(id);
        String[] verStrs = ver.split("\\.");
        if (verStrs.length > 2) {
            this.deployInfo.setIteration(verStrs[2]);
        } else {
            this.deployInfo.setIteration("0");
        }
        this.ver = String.format("%s.%s", verStrs[0], verStrs[1]);
        this.deployInfo.setVer(this.ver);
        if (verStrs.length > 3) {
            this.deployInfo.setPatch(verStrs[3]);
        } else {
            this.deployInfo.setPatch("0");
        }
    }

    public void readXml(String xmlFile) throws Exception {
        File xmlPath = new File(xmlFile);
        String dmXmlFile = "";
        for (String str : xmlPath.list()) {
            if (!str.endsWith(".xml")) continue;
            dmXmlFile = str;
            break;
        }
        if (StringUtils.isBlank((CharSequence)dmXmlFile)) {
            String msg = String.format(ResManager.loadKDString((String)"xml \u6587\u4ef6\u4e0d\u5b58\u5728\u3002\u8def\u5f84\uff1a%s", (String)"XmlFileHandler_0", (String)"bos-mservice-form", (Object[])new Object[0]), xmlFile);
            throw new Exception(msg);
        }
        File file = new File(xmlFile, dmXmlFile);
        SAXReader reader = SAXReaderUtil.getSAXReader();
        reader.setEncoding("utf-8");
        Document document = reader.read(file);
        Element iterationElement = document.getRootElement().element("iteration");
        if (iterationElement != null) {
            String iteration = document.getRootElement().element("iteration").getText();
            this.deployInfo.setIteration(iteration);
        }
        this.pkgName = document.getRootElement().attributeValue("name");
        String appVer = document.getRootElement().element("ver").getText();
        List elements = document.getRootElement().element("app").elements();
        this.deployInfo.setName(this.pkgName);
        this.deployInfo.setFileName(xmlFile);
        this.deployInfo.setExecTime(new Date());
        this.deployInfo.setIsv(this.isv);
        for (Element element : elements) {
            String id = element.attributeValue("id").toLowerCase();
            String name = element.attributeValue("name").toLowerCase();
            String pkname = element.attributeValue("pkname");
            String subPath = element.attributeValue("path");
            String path = String.format("%s%s%s%s%s%s%s.xml", xmlPath.toString(), Character.valueOf(File.separatorChar), appVer, Character.valueOf(File.separatorChar), subPath, Character.valueOf(File.separatorChar), name);
            DeployAppInfo app = new DeployAppInfo(id, path);
            app.setId(DB.genGlobalLongId());
            app.setConfigName(name);
            app.setPkgId(this.deployInfo.getId());
            app.setPkgName(pkname);
            app.setVer(this.deployInfo.getVer());
            app.setDeployInfo(this.deployInfo);
            this.deployInfo.addApp(app);
        }
        for (DeployAppInfo app : this.deployInfo.getApp().values()) {
            Attribute xmlpathAttr;
            File appXmlFile = new File(app.getPath());
            if (!appXmlFile.exists()) continue;
            SAXReader xmlReader = SAXReaderUtil.getSAXReader();
            xmlReader.setEncoding("utf-8");
            Document xmlDoc = xmlReader.read(appXmlFile);
            Attribute dympathAttr = xmlDoc.getRootElement().attribute("dympath");
            String parentPath = appXmlFile.getParent();
            if (dympathAttr != null) {
                String dymPath = dympathAttr.getText();
                app.addMetaFileList(String.format(S_S_S, parentPath, Character.valueOf(File.separatorChar), dymPath));
            }
            if ((xmlpathAttr = xmlDoc.getRootElement().attribute("xmlpath")) != null) {
                String xmlDataPath = xmlpathAttr.getText();
                app.addXmlFileList(String.format(S_S_S, parentPath, Character.valueOf(File.separatorChar), xmlDataPath));
            }
            List sqlElements = xmlDoc.getRootElement().elements();
            List<DeployScriptInfo> scriptInfoList = app.getScriptInfoList();
            for (Element element : sqlElements) {
                String name = element.attributeValue("name");
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    scriptInfoList.addAll(this.extractScriptInfoV2(app, parentPath, element));
                    continue;
                }
                scriptInfoList.addAll(this.extractScriptInfo(app, parentPath, element, null));
            }
        }
    }

    private List<DeployScriptInfo> extractScriptInfo(DeployAppInfo app, String parentPath, Element element, SqlScript parent) throws IOException {
        File elementFile;
        String ftype;
        String pluginElement;
        String dbKey;
        String errorLevel;
        String separator;
        ArrayList<DeployScriptInfo> scriptInfoList = new ArrayList<DeployScriptInfo>();
        String sqlPath = this.getFilePath(parentPath, element, parent);
        String type = element.attributeValue("Type");
        if (StringUtils.isBlank((CharSequence)type) && parent != null) {
            type = parent.getSqlType();
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "KSQL";
        }
        if (StringUtils.isBlank((CharSequence)(separator = element.attributeValue("Separator"))) && parent != null) {
            separator = parent.getSeparator();
        }
        if (StringUtils.isBlank((CharSequence)separator)) {
            separator = ";";
        }
        if (StringUtils.isBlank((CharSequence)(errorLevel = element.attributeValue("ErrorLevel"))) && parent != null) {
            errorLevel = parent.getErrorLevel();
        }
        if (StringUtils.isBlank((CharSequence)errorLevel)) {
            errorLevel = "";
        }
        if (StringUtils.isBlank((CharSequence)(dbKey = element.attributeValue("dbkey"))) && parent != null) {
            dbKey = parent.getDbKey();
        }
        if (StringUtils.isBlank((CharSequence)(pluginElement = element.attributeValue("Plugin"))) && parent != null) {
            pluginElement = parent.getPluginElement();
        }
        if (StringUtils.isBlank((CharSequence)(ftype = element.attributeValue("ftype"))) && parent != null) {
            ftype = parent.getFileType();
        }
        if (StringUtils.isBlank((CharSequence)ftype)) {
            ftype = "sql";
        }
        String bigtab = element.attributeValue("bigtab");
        boolean isBigTable = false;
        if (StringUtils.isNotBlank((CharSequence)bigtab) && "true".equals(bigtab)) {
            isBigTable = true;
        }
        String batchsql = element.attributeValue("batchsql");
        boolean isBatchSql = false;
        if (StringUtils.isNotBlank((CharSequence)batchsql) && "true".equals(batchsql)) {
            isBatchSql = true;
        }
        if ((elementFile = new File(sqlPath)).isFile() && elementFile.exists()) {
            SqlScript sqlScript = null;
            if (element.getName().equalsIgnoreCase("undo")) {
                sqlScript = new UndoSqlScript(elementFile.getName(), type, separator, dbKey, sqlPath);
            } else if (element.getName().equalsIgnoreCase("upgrade")) {
                sqlScript = new UpgradeSqlScript(elementFile.getName(), type, separator, dbKey, sqlPath);
            } else if (!this.isUndo) {
                sqlScript = new SqlScript(elementFile.getName(), type, separator, dbKey, sqlPath);
            }
            if (sqlScript != null) {
                sqlScript.setFileType(ftype);
                sqlScript.setErrorLevel(errorLevel);
                if (StringUtils.isNotBlank((CharSequence)pluginElement)) {
                    sqlScript.createPlugin(app.getName(), pluginElement);
                }
                DeployScriptInfo scriptInfo = new DeployScriptInfo();
                scriptInfo.setId(DB.genGlobalLongId());
                scriptInfo.setAppId(app.getName());
                scriptInfo.setEntryId(app.getId());
                scriptInfo.setVer(app.getVer());
                scriptInfo.setFileName(elementFile.getName());
                scriptInfo.setSqlScript(sqlScript);
                scriptInfo.setBigTable(isBigTable);
                scriptInfo.setBatchSql(isBatchSql);
                scriptInfoList.add(scriptInfo);
            }
        } else if (elementFile.isDirectory()) {
            File[] dirSqlFiles;
            for (File oneFile : dirSqlFiles = elementFile.listFiles()) {
                if (oneFile.isDirectory() && "xml".equalsIgnoreCase(oneFile.getName())) continue;
                SqlScript sqlScript = new SqlScript(oneFile.getName(), type, separator, dbKey, oneFile.getCanonicalPath());
                sqlScript.setErrorLevel(errorLevel);
                sqlScript.setFileType(ftype);
                if (StringUtils.isNotBlank((CharSequence)pluginElement)) {
                    sqlScript.createPlugin(app.getName(), pluginElement);
                }
                DeployScriptInfo scriptInfo = new DeployScriptInfo();
                scriptInfo.setId(DB.genGlobalLongId());
                scriptInfo.setAppId(app.getName());
                scriptInfo.setEntryId(app.getId());
                scriptInfo.setVer(app.getVer());
                scriptInfo.setFileName(oneFile.getName());
                scriptInfo.setSqlScript(sqlScript);
                scriptInfoList.add(scriptInfo);
            }
        }
        return scriptInfoList;
    }

    private List<DeployScriptInfo> extractScriptInfoV2(DeployAppInfo app, String parentPath, Element element) throws IOException {
        String errorLevel;
        String separator;
        ArrayList<DeployScriptInfo> scriptInfoList = new ArrayList<DeployScriptInfo>();
        String name = element.attributeValue("name");
        String type = element.attributeValue("Type");
        if (type == null) {
            type = "KSQL";
        }
        if ((separator = element.attributeValue("Separator")) == null) {
            separator = ";";
        }
        if ((errorLevel = element.attributeValue("ErrorLevel")) == null) {
            errorLevel = "";
        }
        String dbKey = element.attributeValue("dbkey");
        String path = element.attributeValue("path");
        String ftype = element.attributeValue("ftype");
        String sqlPath = String.format("%s%s%s%s%s", parentPath, Character.valueOf(File.separatorChar), path, Character.valueOf(File.separatorChar), name);
        List elements = element.elements();
        if (elements.size() > 0) {
            SqlScript sqlScript = new SqlScript(name, type, separator, dbKey, sqlPath);
            sqlScript.setFileType(ftype);
            sqlScript.setErrorLevel(errorLevel);
            for (Element e1 : elements) {
                List<DeployScriptInfo> scriptInfoes = this.extractScriptInfo(app, parentPath, e1, sqlScript);
                for (DeployScriptInfo deployScriptInfo : scriptInfoes) {
                    if (this.isUndo && deployScriptInfo.getSqlScript() instanceof UndoSqlScript) {
                        scriptInfoList.add(deployScriptInfo);
                        continue;
                    }
                    if (this.isUndo || !(deployScriptInfo.getSqlScript() instanceof UpgradeSqlScript)) continue;
                    scriptInfoList.add(deployScriptInfo);
                }
            }
            return scriptInfoList;
        }
        scriptInfoList.addAll(this.extractScriptInfo(app, parentPath, element, null));
        return scriptInfoList;
    }

    public DeployInfo getDeployInfo() {
        return this.deployInfo;
    }

    private String getFilePath(String parentPath, Element element, SqlScript parent) {
        String sqlPath = element.getText();
        if (StringUtils.isBlank((CharSequence)sqlPath)) {
            String ftype = element.attributeValue("ftype");
            String name = parent != null ? parent.getFilePath() : element.attributeValue("name");
            sqlPath = this.isUndo ? String.format("%s%sundo%s%s%s", parentPath, Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar), name, this.getFileSuffix(ftype)) : String.format("%s%s%s%s", parentPath, Character.valueOf(File.separatorChar), name, this.getFileSuffix(ftype));
        } else {
            sqlPath = String.format(S_S_S, parentPath, Character.valueOf(File.separatorChar), sqlPath);
        }
        return sqlPath;
    }

    private String getFileSuffix(String ftype) {
        String suffix = "xml".equalsIgnoreCase(ftype) ? "xml" : "sql";
        suffix = this.isUndo ? String.format(".undo.%s", suffix) : String.format(".%s", suffix);
        return suffix;
    }
}

