/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.after.BuildTaskGroup;
import kd.bos.service.upgrade.after.DePaUtil;
import kd.bos.service.upgrade.after.RebuildService;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.servicehelper.DispatchServiceHelper;

class FormMetaBuilder
implements Callable<Map<String, Object>> {
    private BuildTaskGroup taskGroup;
    private DeployState deployState;
    private BigDecimal factor;
    private RequestContext requestContext;

    public FormMetaBuilder(BuildTaskGroup taskGroup, DeployState deployState, BigDecimal factor, RequestContext rc) {
        this.requestContext = rc;
        this.taskGroup = taskGroup;
        this.deployState = deployState;
        this.factor = factor;
        DB.__setIgnoreCheckThreadGetMaxConnectionCount((boolean)true);
    }

    @Override
    public Map<String, Object> call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        try {
            if (this.taskGroup != null && this.taskGroup.getMetas() != null) {
                long start = System.currentTimeMillis();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                ArrayList ids = new ArrayList(10);
                this.taskGroup.getMetas().forEach(meta -> ids.add(meta.getId()));
                param.put("ids", ids);
                param.put("taskId", this.taskGroup.getTaskId());
                param.put("dispatchTaskId", this.taskGroup.getDispatchTaskId());
                param.put("ver", this.taskGroup.getVer());
                DeployLog.info(this.taskGroup.getTaskId(), this.taskGroup.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5fae\u670d\u52a1\u5206\u53d1\uff0c\u5f53\u524ddispatch task id\uff1a%s", (String)"RebuildService_1", (String)"bos-mservice-form", (Object[])new Object[0]), this.taskGroup.getDispatchTaskId()));
                Map result = (Map)DispatchServiceHelper.invokeBOSService((String)RebuildService.SERVICE_NODE, (String)RebuildService.METADATA_SERVICE, (String)"rebuildForms", (Object[])new Object[]{param});
                DeployLog.info(this.taskGroup.getTaskId(), this.taskGroup.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5fae\u670d\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u5f53\u524ddispatch task id\uff1a%1$s\uff0c\u8017\u65f6\uff1a%2$s", (String)"RebuildService_2", (String)"bos-mservice-form", (Object[])new Object[0]), this.taskGroup.getDispatchTaskId(), System.currentTimeMillis() - start));
                BigDecimal progress = new BigDecimal(1).divide(new BigDecimal(DePaUtil.SERVICE_MAXNODES), 10, RoundingMode.HALF_EVEN).multiply(this.factor);
                this.deployState.addProgress(progress);
                return result;
            }
            return new HashMap<String, Object>(0);
        }
        catch (Exception e) {
            long taskId = this.taskGroup == null ? 0L : this.taskGroup.getTaskId();
            String ver = this.taskGroup == null ? "" : this.taskGroup.getVer();
            long dispatchTaskId = this.taskGroup == null ? 0L : this.taskGroup.getDispatchTaskId();
            DeployLog.error(taskId, ver, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5fae\u670d\u52a1\u5206\u53d1\u6267\u884c\u5931\u8d25\uff0cdispatch task id\uff1a%1$s, error msg:%2$s", (String)"RebuildService_3", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchTaskId, DePaUtil.getErrorMsg(e)), e);
            ErrorCode ec = new ErrorCode("BOS_META", e.getMessage());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }
}

