/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.after.BuildTaskGroup;
import kd.bos.service.upgrade.after.DePaUtil;

class RebuildStrategy {
    RebuildStrategy() {
    }

    protected static List<BuildTaskGroup> getTaskGroup(List<BuildFormDesignMeta> metas, DeployPackageParam dpParam) {
        ArrayList<BuildTaskGroup> taskGroupList = new ArrayList<BuildTaskGroup>(10);
        if (metas == null || metas.isEmpty()) {
            return taskGroupList;
        }
        LinkedHashMap grpMetas = new LinkedHashMap(16);
        ArrayList rootList = new ArrayList(10);
        metas.forEach(meta -> {
            String parentId = meta.getParentId();
            if (StringUtils.isBlank((CharSequence)parentId)) {
                rootList.add(meta);
            } else {
                ArrayList<BuildFormDesignMeta> children = (ArrayList<BuildFormDesignMeta>)grpMetas.get(parentId);
                if (children == null) {
                    children = new ArrayList<BuildFormDesignMeta>(10);
                }
                children.add((BuildFormDesignMeta)meta);
                grpMetas.put(parentId, children);
            }
        });
        for (Map.Entry entry : grpMetas.entrySet()) {
            if (entry.getValue() == null) continue;
            rootList.addAll((Collection)entry.getValue());
        }
        int total = rootList.size();
        int batchSize = total / DePaUtil.SERVICE_MAXNODES;
        int remainder = total % DePaUtil.SERVICE_MAXNODES;
        batchSize = remainder == 0 ? batchSize : batchSize + DePaUtil.SERVICE_MAXNODES;
        long[] dispatchTaskIds = DB.genGlobalLongIds((int)DePaUtil.SERVICE_MAXNODES);
        int idIdx = 0;
        for (int i = 0; i < total; i += batchSize) {
            int startIndex = i;
            int endIndex = i + batchSize;
            if (endIndex > metas.size()) {
                endIndex = metas.size();
            }
            BuildTaskGroup taskGroup = new BuildTaskGroup(metas.subList(startIndex, endIndex));
            taskGroup.setTaskId(dpParam.getTaskId());
            taskGroup.setVer(dpParam.getVer());
            taskGroup.setDispatchTaskId(dispatchTaskIds[idIdx]);
            taskGroupList.add(taskGroup);
            ++idIdx;
        }
        return taskGroupList;
    }
}

