/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.service.upgrade.deploy.DeployBatchSql;
import kd.bos.service.upgrade.deploy.IBatchExcutor;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.util.ExceptionUtils;

class BatchExcutorOne
implements IBatchExcutor {
    BatchExcutorOne() {
    }

    @Override
    public void batchInsert(long taskId, String fullVer, List<Map<String, Object>> sqlList, DBRoute dbRoute) {
        long start = System.currentTimeMillis();
        int index = 1;
        int totalCount = 0;
        for (Map<String, Object> map : sqlList) {
            try {
                this.checkSql(map, index);
                String columnStr = (String)map.get("columns");
                List<DeployBatchSql.Column> columns = this.parseColumns(columnStr);
                String iSql = (String)map.get("insertSql");
                String dSql = (String)map.get("deleteSql");
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7b2c%1$s\u6279sql\uff0cinsert\u6a21\u677f\uff1a%2$s\uff0c delete\u6a21\u677f\uff1a%3$s", (String)"BatchExcutorOne_0", (String)"bos-mservice-form", (Object[])new Object[0]), index, iSql, dSql));
                ArrayList delParams = (ArrayList)map.get("delParams");
                ArrayList insParams = (ArrayList)map.get("insParams");
                int count = insParams.size();
                totalCount += count;
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8bfb\u53d6\u5230\u6570\u636e\uff1a%1$s\u6761\uff0cdbRoute:%2$s", (String)"DeployBatchSql_3", (String)"bos-mservice-form", (Object[])new Object[0]), count, dbRoute.getRouteKey()));
                long s = System.currentTimeMillis();
                ArrayList delIds = new ArrayList(1000);
                delParams.forEach(param -> delIds.add(param.toArray(new Object[param.size()])));
                ArrayList parseParams = new ArrayList(1000);
                insParams.forEach(param -> {
                    ArrayList insertParams = new ArrayList(param.size());
                    columns.forEach(column -> {
                        int colIdx = column.getIndex();
                        int colType = column.getType();
                        Object value = param.get(colIdx);
                        insertParams.add(this.parseValue(value, colType));
                    });
                    parseParams.add(insertParams.toArray(new Object[insertParams.size()]));
                });
                long parseParam = System.currentTimeMillis();
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_4", (String)"bos-mservice-form", (Object[])new Object[0]), parseParam - s));
                try (TXHandle h = TX.requiresNew();){
                    DB.executeBatch((DBRoute)dbRoute, (String)dSql, delIds);
                    long d = System.currentTimeMillis();
                    DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6279\u91cf\u5220\u9664\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_5", (String)"bos-mservice-form", (Object[])new Object[0]), d - parseParam));
                    DB.executeBatch((DBRoute)dbRoute, (String)iSql, parseParams);
                    long ic = System.currentTimeMillis();
                    DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6279\u91cf\u63d2\u5165\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_6", (String)"bos-mservice-form", (Object[])new Object[0]), ic - d));
                }
                long e = System.currentTimeMillis();
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6279\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s ms", (String)"DeployBatchSql_7", (String)"bos-mservice-form", (Object[])new Object[0]), index, e - s));
                ++index;
            }
            catch (Exception e) {
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6279\u6267\u884c\u5931\u8d25\uff0c\u5806\u6808\uff1a%2$s", (String)"DeployBatchSql_8", (String)"bos-mservice-form", (Object[])new Object[0]), index, msg));
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u811a\u672c\u6267\u884c\u7ed3\u675f\uff0c\u63d2\u5165\u6570\u5171\uff1a%1$s\u6761\uff0c\u8017\u65f6\uff1a%2$s ms", (String)"DeployBatchSql_9", (String)"bos-mservice-form", (Object[])new Object[0]), totalCount, end - start));
    }

    private boolean checkSql(Map<String, Object> map, int index) {
        List firstRow;
        String[] columnArr;
        String columnStr = (String)map.get("columns");
        String iSql = (String)map.get("insertSql");
        String dSql = (String)map.get("deleteSql");
        ArrayList delParams = (ArrayList)map.get("delParams");
        ArrayList insParams = (ArrayList)map.get("insParams");
        String msg = "";
        if (StringUtils.isBlank((CharSequence)columnStr)) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0ccolums\u5b57\u6bb5\u5217\u63cf\u8ff0\u4e3a\u7a7a\u3002", (String)"DeployBatchSql_11", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if (StringUtils.isBlank((CharSequence)iSql)) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0cinsertSql\u8bed\u53e5\u4e3a\u7a7a\u3002", (String)"DeployBatchSql_12", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if (StringUtils.isBlank((CharSequence)dSql)) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0cdeleteSql\u8bed\u53e5\u4e3a\u7a7a\u3002", (String)"DeployBatchSql_13", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if (StringUtils.isBlank((Object)delParams)) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0cdelParams\u6279\u91cf\u5220\u9664\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DeployBatchSql_14", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if (StringUtils.isBlank((Object)insParams)) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0cinsParams\u6279\u91cf\u63d2\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DeployBatchSql_15", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if ((columnArr = columnStr.split(",")).length != (firstRow = (List)insParams.get(0)).size()) {
            msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u7b2c%s\u6279\u4e0d\u7b26\u5408\u89c4\u8303\u683c\u5f0f\uff0ccolums\u5b57\u6bb5\u5217\u4e0einsParams\u53c2\u6570\u5217\u7684\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"DeployBatchSql_16", (String)"bos-mservice-form", (Object[])new Object[0]), index);
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new KDBizException(msg);
        }
        return true;
    }

    private Object parseValue(Object value, int colType) {
        switch (colType) {
            case 12: {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
                try {
                    value = StringUtils.isBlank((Object)value) ? value : sFormat.parse(value.toString());
                    break;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            case 14: {
                value = value == null ? new BigDecimal("0.00") : new BigDecimal(value.toString());
            }
        }
        return value;
    }

    private List<DeployBatchSql.Column> parseColumns(String columnStr) {
        ArrayList<DeployBatchSql.Column> columns = new ArrayList<DeployBatchSql.Column>(10);
        if (StringUtils.isBlank((CharSequence)columnStr)) {
            return columns;
        }
        String[] columnArr = columnStr.split(",");
        int index = 0;
        String[] stringArray = columnArr;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String str;
            String name = str = stringArray[i];
            int type = 1111;
            if (str.indexOf(":") != -1) {
                String[] array = str.split(":");
                name = array[0];
                switch (array[1]) {
                    case "date": {
                        type = 12;
                        break;
                    }
                    case "decimal": {
                        type = 14;
                    }
                }
            }
            columns.add(new DeployBatchSql.Column(name, type, index));
            ++index;
        }
        return columns;
    }
}

