/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.deploy.DeployBatchSql;
import kd.bos.service.upgrade.deploy.IBatchExcutor;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.util.ExceptionUtils;

class BatchExcutorTwo
implements IBatchExcutor {
    BatchExcutorTwo() {
    }

    @Override
    public void batchInsert(long taskId, String fullVer, List<Map<String, Object>> sqlList, DBRoute dbRoute) {
        long start = System.currentTimeMillis();
        int index = 1;
        int totalCount = 0;
        for (Map<String, Object> map : sqlList) {
            try {
                String table = (String)map.get("table");
                String columnStr = (String)map.get("columns");
                List<DeployBatchSql.Column> columns = this.parseColumns(columnStr);
                String iSql = this.getInsertSql(table, columns);
                List primaryKey = (List)map.get("pk");
                if (primaryKey == null || primaryKey.isEmpty()) {
                    throw new KDException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u811a\u672c\u5b9a\u4e49\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7atable:%s ", (String)"DeployBatchSql_1", (String)"bos-mservice-form", (Object[])new Object[0]), table));
                }
                String dSql = this.getDeleteSql(table, columns, primaryKey);
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7b2c%1$s\u6279sql\uff0cinsert\u6a21\u677f\uff1a%2$s\uff0c delete\u6a21\u677f\uff1a%3$s\uff0cprimaryKey:%4$s", (String)"DeployBatchSql_2", (String)"bos-mservice-form", (Object[])new Object[0]), index, iSql, dSql, SerializationUtils.toJsonString((Object)primaryKey)));
                ArrayList params = (ArrayList)map.get("params");
                int count = params.size();
                totalCount += count;
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8bfb\u53d6\u5230\u6570\u636e\uff1a%1$s\u6761\uff0cdbRoute:%2$s", (String)"DeployBatchSql_3", (String)"bos-mservice-form", (Object[])new Object[0]), count, dbRoute.getRouteKey()));
                long s = System.currentTimeMillis();
                ArrayList parseParams = new ArrayList(1000);
                ArrayList ids = new ArrayList(1000);
                params.forEach(param -> {
                    ArrayList idParam = new ArrayList(primaryKey.size());
                    ArrayList insertParams = new ArrayList(param.size());
                    for (Integer idx : primaryKey) {
                        idParam.add(param.get(idx));
                    }
                    ids.add(idParam.toArray(new Object[idParam.size()]));
                    columns.forEach(column -> {
                        int colIdx = column.getIndex();
                        int colType = column.getType();
                        Object value = param.get(colIdx);
                        insertParams.add(this.parseValue(value, colType));
                    });
                    parseParams.add(insertParams.toArray(new Object[insertParams.size()]));
                });
                long parseParam = System.currentTimeMillis();
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_4", (String)"bos-mservice-form", (Object[])new Object[0]), parseParam - s));
                try (TXHandle h = TX.requiresNew();){
                    DB.executeBatch((DBRoute)dbRoute, (String)dSql, ids);
                    long d = System.currentTimeMillis();
                    DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6279\u91cf\u5220\u9664\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_5", (String)"bos-mservice-form", (Object[])new Object[0]), d - parseParam));
                    DB.executeBatch((DBRoute)dbRoute, (String)iSql, parseParams);
                    long ic = System.currentTimeMillis();
                    DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6279\u91cf\u63d2\u5165\u8017\u65f6\uff1a%s", (String)"DeployBatchSql_6", (String)"bos-mservice-form", (Object[])new Object[0]), ic - d));
                }
                long e = System.currentTimeMillis();
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6279\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s ms", (String)"DeployBatchSql_7", (String)"bos-mservice-form", (Object[])new Object[0]), index, e - s));
                ++index;
            }
            catch (Exception e) {
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6279\u6267\u884c\u5931\u8d25\uff0c\u5806\u6808\uff1a%2$s", (String)"DeployBatchSql_8", (String)"bos-mservice-form", (Object[])new Object[0]), index, msg));
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        DeployLog.info(taskId, fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u811a\u672c\u6267\u884c\u7ed3\u675f\uff0c\u63d2\u5165\u6570\u5171\uff1a%1$s\u6761\uff0c\u8017\u65f6\uff1a%2$s ms", (String)"DeployBatchSql_9", (String)"bos-mservice-form", (Object[])new Object[0]), totalCount, end - start));
    }

    private Object parseValue(Object value, int colType) {
        switch (colType) {
            case 12: {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
                try {
                    value = StringUtils.isBlank((Object)value) ? value : sFormat.parse(value.toString());
                    break;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            case 14: {
                value = value == null ? new BigDecimal("0.00") : new BigDecimal(value.toString());
            }
        }
        return value;
    }

    private String getInsertSql(String table, List<DeployBatchSql.Column> columns) {
        String iSql = "";
        if (StringUtils.isBlank((CharSequence)table) || columns == null || columns.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u540d\u6216\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeployBatchSql_10", (String)"bos-mservice-form", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(table).append("(");
        StringBuilder fieldSb = new StringBuilder(" ");
        StringBuilder valuesSb = new StringBuilder(" ");
        for (DeployBatchSql.Column column : columns) {
            fieldSb.append(column.getName()).append(",");
            valuesSb.append("?,");
        }
        String fieldStr = fieldSb.toString();
        fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
        String valuesStr = valuesSb.toString();
        valuesStr = valuesStr.substring(0, valuesStr.length() - 1);
        sb.append(fieldStr).append(")").append("VALUES(").append(valuesStr).append(") ");
        iSql = sb.toString();
        return iSql;
    }

    private String getDeleteSql(String table, List<DeployBatchSql.Column> columns, List<Integer> primaryKey) {
        if (StringUtils.isBlank((CharSequence)table) || columns == null || columns.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u540d\u6216\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeployBatchSql_10", (String)"bos-mservice-form", (Object[])new Object[0]));
        }
        StringBuilder deleteSb = new StringBuilder("DELETE FROM ");
        deleteSb.append(table);
        deleteSb.append(" WHERE ");
        int i = 0;
        for (Integer idx : primaryKey) {
            if (i > 0) {
                deleteSb.append(" and ");
            }
            DeployBatchSql.Column column = columns.get(idx);
            deleteSb.append(column.getName()).append(" = ? ");
            ++i;
        }
        deleteSb.append(';');
        return deleteSb.toString();
    }

    private List<DeployBatchSql.Column> parseColumns(String columnStr) {
        ArrayList<DeployBatchSql.Column> columns = new ArrayList<DeployBatchSql.Column>(10);
        if (StringUtils.isBlank((CharSequence)columnStr)) {
            return columns;
        }
        String[] columnArr = columnStr.split(",");
        int index = 0;
        String[] stringArray = columnArr;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String str;
            String name = str = stringArray[i];
            int type = 1111;
            if (str.indexOf(":") != -1) {
                String[] array = str.split(":");
                name = array[0];
                switch (array[1]) {
                    case "date": {
                        type = 12;
                        break;
                    }
                    case "decimal": {
                        type = 14;
                    }
                }
            }
            columns.add(new DeployBatchSql.Column(name, type, index));
            ++index;
        }
        return columns;
    }
}

