/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.math.BigDecimal;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;

public class DeployState {
    private static final String BOS_DEPLOY_CACHE = "bos_deploy_cache_";
    private static final int CACHE_TIMEOUT = 3600;
    private static final String DEPLOY_PROGRESS = "deploy_progress";
    private static final String METADATA_REBUILD = "metadata_rebuild";
    private static final String METADATA_REBUILD_STATE = "metadata_rebuild_state";
    private static final String DEPLOY_RESEND_STATE = "deploy_resend_state";
    public static final String DEPLOY_INSTANCE_ID = "deploy_instance_id";
    public static final String DEPLOY_STATUS_FAILED = "0";
    public static final String DEPLOY_STATUS_SUCCESS = "1";
    public static final String DEPLOY_STATUS_EXECUTING = "2";
    private static BigDecimal finish = new BigDecimal(1);
    private DistributeSessionlessCache cache;
    private String progressKey;
    private String rebuildStatus;
    private String rebuildRes;
    private String deployResendState;
    private String instanceKey;

    public DeployState(long taskId) {
        this.progressKey = BOS_DEPLOY_CACHE + taskId + "_" + DEPLOY_PROGRESS;
        this.rebuildStatus = BOS_DEPLOY_CACHE + taskId + "_" + METADATA_REBUILD_STATE;
        this.rebuildRes = BOS_DEPLOY_CACHE + taskId + "_" + METADATA_REBUILD;
        this.deployResendState = BOS_DEPLOY_CACHE + taskId + "_" + DEPLOY_RESEND_STATE;
        this.instanceKey = BOS_DEPLOY_CACHE + taskId + "_" + DEPLOY_INSTANCE_ID;
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        this.cache.put(this.progressKey, (Object)DEPLOY_STATUS_FAILED, 3600);
    }

    public void setProgress(BigDecimal progress) {
        if (progress.compareTo(finish) >= 0) {
            progress = BigDecimal.valueOf(0.99);
        }
        this.cache.put(this.progressKey, (Object)String.valueOf(progress.multiply(new BigDecimal(100)).intValue()), 3600);
    }

    public synchronized void addProgress(BigDecimal progress) {
        BigDecimal curProgress = new BigDecimal(this.getPropgress());
        if (curProgress.compareTo(new BigDecimal(0)) > 0) {
            curProgress = curProgress.divide(new BigDecimal(100));
        }
        if ((progress = curProgress.add(progress)).compareTo(finish) >= 0) {
            progress = BigDecimal.valueOf(0.99);
        }
        this.cache.put(this.progressKey, (Object)String.valueOf(progress.multiply(new BigDecimal(100)).intValue()), 3600);
    }

    public String getPropgress() {
        String progress = (String)this.cache.get(this.progressKey);
        if (StringUtils.isBlank((CharSequence)progress)) {
            progress = DEPLOY_STATUS_FAILED;
        }
        return progress;
    }

    public void finish() {
        this.cache.put(this.progressKey, (Object)String.valueOf(new BigDecimal(1).multiply(new BigDecimal(100)).intValue()), 3600);
    }

    public String getDeployRebuildStatus() {
        return (String)this.cache.get(this.rebuildStatus);
    }

    public void setDeployRebuildStatus(String val) {
        this.cache.put(this.rebuildStatus, (Object)val, 3600);
    }

    public String getDeployRebuildResult() {
        return (String)this.cache.get(this.rebuildRes);
    }

    public void setDeployRebuildResult(String val) {
        this.cache.put(this.rebuildRes, (Object)val, 3600);
    }

    public String getDeployResendState() {
        return (String)this.cache.get(this.deployResendState);
    }

    public String getDeployInstanceId() {
        return (String)this.cache.get(this.instanceKey);
    }

    public void setDeployInstanceId(String val) {
        this.cache.put(this.instanceKey, (Object)val, 3600);
    }
}

