/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.upgrade.IUpgradePlugin;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.service.CloudAppMappingDictionary;
import kd.bos.service.upgrade.StandUpgradePlugin;

public class SqlScript {
    private String name;
    private String sqlType;
    private String separator;
    private String dbKey;
    private String errorLevel;
    private String filePath;
    private String pluginElement;
    private IUpgradePlugin plugin;
    private String fileType;

    public SqlScript() {
    }

    public SqlScript(String name, String sqlType, String separator, String dbKey, String filePath) {
        this.name = name;
        this.sqlType = sqlType;
        this.separator = separator;
        this.dbKey = dbKey;
        this.filePath = filePath;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(String errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDbKey() {
        return this.dbKey;
    }

    public void setDbKey(String dbKey) {
        this.dbKey = dbKey;
    }

    public IUpgradePlugin getPlugin() {
        return this.plugin;
    }

    public String getPluginElement() {
        return this.pluginElement;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void createPlugin(String appNumber, String pluginNameElement) {
        Object splugin;
        if (StringUtils.isBlank((CharSequence)pluginNameElement)) {
            return;
        }
        this.pluginElement = pluginNameElement;
        String[] pluginParams = pluginNameElement.split(",");
        if (pluginParams == null || pluginParams.length == 0) {
            return;
        }
        String type = "js";
        String pluginName = "";
        String cloud = "";
        String app = appNumber;
        String scriptPlugin = "";
        for (String param : pluginParams) {
            String[] sp = param.split(":");
            if (sp.length == 2) {
                if ("cloud".equalsIgnoreCase(sp[0])) {
                    cloud = sp[1];
                    continue;
                }
                if ("app".equalsIgnoreCase(sp[0])) {
                    app = sp[1];
                    continue;
                }
                if ("scriptPlugin".equalsIgnoreCase(sp[0])) {
                    scriptPlugin = sp[1];
                    continue;
                }
                type = sp[0];
                pluginName = sp[1];
                continue;
            }
            if (sp.length != 1) continue;
            pluginName = sp[0];
        }
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)app)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u63d2\u4ef6app\u540d\u79f0\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"SqlScript_0", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
        if ("class".equalsIgnoreCase(type)) {
            if (StringUtils.isBlank((CharSequence)cloud)) {
                cloud = CloudAppMappingDictionary.getCloudIdBy((String)app);
            }
            if (StringUtils.isBlank((CharSequence)cloud)) {
                String getCloudSql = "select a.fnumber from t_meta_bizcloud a inner join t_meta_bizapp b on a.fid = b.fbizcloudid where b.fnumber = ?";
                Object[] getCloudParams = new Object[]{app};
                cloud = (String)DB.query((DBRoute)DBRoute.meta, (String)getCloudSql, (Object[])getCloudParams, (ResultSetHandler)new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            String tmp = rs.getString("fnumber");
                            return StringUtils.isNotBlank((CharSequence)tmp) ? tmp.toLowerCase() : tmp;
                        }
                        return "";
                    }
                });
            }
            if (StringUtils.isBlank((CharSequence)cloud)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u63d2\u4ef6\u6240\u5c5ecloud\uff0c\u8bf7\u68c0\u67e5", (String)"SqlScript_1", (String)"bos-mservice-form", (Object[])new Object[0])});
            }
            splugin = new StandUpgradePlugin();
            ((StandUpgradePlugin)((Object)splugin)).setDispatchParams(cloud, app, pluginName);
            if (StringUtils.isNotBlank((CharSequence)scriptPlugin)) {
                ((StandUpgradePlugin)((Object)splugin)).setScriptPluginName(scriptPlugin);
            }
            this.plugin = splugin;
        } else {
            try {
                splugin = this.createDynamicScriptPlugin(pluginName);
                this.plugin = splugin;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IUpgradePlugin createDynamicScriptPlugin(String scriptNumber) throws IOException {
        String scriptContent = this.getScript(scriptNumber);
        if (StringUtils.isBlank((CharSequence)scriptContent)) {
            return null;
        }
        try (InputStream in = FormConfig.class.getResourceAsStream("/FormPlugin.js");){
            String envScript = FormConfig.getContent((InputStream)in);
            ScriptExecutor scriptExecutor = ScriptExecutor.getOrCreate();
            scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            scriptExecutor.begin();
            scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo("/FormPlugin.js", envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
            IUpgradePlugin iUpgradePlugin = (IUpgradePlugin)scriptExecutor.getContext().get("plugin");
            return iUpgradePlugin;
        }
    }

    private String getScript(String scriptNumber) {
        HashMap<String, String> map;
        block15: {
            map = new HashMap<String, String>();
            String sql = "select fscriptnumber,fscriptcontext_tag,fscripttype from t_meta_pluginscript where fclassname = ?";
            Object[] params = new Object[]{scriptNumber};
            try (DataSet ds = DB.queryDataSet((String)"FormConfig.t_meta_pluginscript.getScriptInfo", (DBRoute)DBRoute.meta, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    map.put("scriptnumber", row.getString("fscriptnumber"));
                    map.put("scripttype", row.getString("fscripttype"));
                    map.put("scriptcontext", row.getString("fscriptcontext_tag"));
                    break block15;
                }
                String string = null;
                return string;
            }
        }
        return (String)map.get("scripttype");
    }
}

