/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BillLayoutScheme;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.IBillView;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.IUpdateView;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.mvc.bill.BillController;
import kd.bos.mvc.bill.BillDefValueProvider;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillTypeApHelper;
import kd.bos.mvc.bill.BillTypeDefValueProvider;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.form.FormDefValueProvider;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.UpdateViewService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.PermRes;
import kd.bos.permission.model.perm.req.field.FieldControlRules2RuleReq;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillView
extends FormView
implements IBillView,
IConfirmCallBack {
    private static final String SPAN_TYPE_NAME = "formview";
    private static final String SPAN_TYPE_BILLLAYOUT = "billlayout";
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String CAN_NOT_WRITE_FIELD = "canNotWriteField";
    private static final String FILED_PERMISSION = "FieldPermission";
    private static final String CAN_NOT_READ_FIELDS = "canNotReadFields";
    private static final String DELETE_REFRESH_FLAG = "BillView.afterDelete";
    private static final Log log = LogFactory.getLog(BillView.class);

    @KSMethod
    public void load(Object pkValue) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.load");){
            span.addTag("pkValue", String.valueOf(pkValue));
            IBillModel model = (IBillModel)this.getModel();
            model.beginInit();
            model.setPKValue(pkValue);
            model.load(pkValue);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
            if (pluginProxy instanceof BillViewPluginProxy) {
                ((BillViewPluginProxy)pluginProxy).fireAfterLoadData(new EventObject((Object)this));
            }
            model.endInit();
            this.updateView();
        }
    }

    @Override
    @KSMethod
    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.updateView");){
            this.lockMainOrgField();
            super.updateView();
            this.initFieldsWithPermission();
            this.updateBillLayout();
        }
    }

    private void lockMainOrgField() {
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return;
        }
        MainOrgProp orgProp = (MainOrgProp)this.getModel().getProperty(mainOrg);
        if (orgProp == null) {
            return;
        }
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            this.setEnable(false, new String[]{mainOrg});
        } else {
            this.setEnable(true, new String[]{mainOrg});
            Object orgValue = this.getModel().getValue(mainOrg);
            boolean inDeleteRefresh = this.getModel().getContextVariable(DELETE_REFRESH_FLAG) instanceof Boolean;
            if (orgValue == null && !inDeleteRefresh) {
                FieldTip orgTip = new FieldTip();
                orgTip.setFieldKey(mainOrg);
                orgTip.setLevel(FieldTip.FieldTipsLevel.Info);
                orgTip.setSuccess(false);
                orgTip.setTipsType(FieldTip.FieldTipsTypes.others);
                orgTip.setTip(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s", (String)"BillView_3", (String)BOS_FORM_MVC, (Object[])new Object[0]), orgProp.getDisplayName().toString()));
                DeleteRule deleteRule = new DeleteRule();
                deleteRule.setAction("isChange");
                ArrayList<String> fields = new ArrayList<String>(1);
                fields.add(mainOrg);
                deleteRule.setFields(fields);
                orgTip.setDeleteRule(deleteRule);
                this.showFieldTip(orgTip);
            }
        }
    }

    @Override
    protected FormOperate getOperation(String operationKey) {
        FormOperate operate = super.getOperation(operationKey);
        BillShowParameter billShowParameter = (BillShowParameter)this.getFormShowParameter();
        if (StringUtils.isNotBlank((CharSequence)billShowParameter.getPermissionEntityId())) {
            operate.setPermissionEntityId(billShowParameter.getPermissionEntityId());
        }
        return operate;
    }

    @Override
    public OperationResult invokeOperation(String operationKey, OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"BillView.invokeOperation", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            BillShowParameter billShowParameter;
            span.addTag("operationKey", operationKey);
            if (option == null) {
                option = OperateOption.create();
            }
            if (this.isMutexByThisPage()) {
                option.setVariableValue("isStrict", "false");
            }
            if (!option.containsVariable("bos_checkFormDataVersion")) {
                option.setVariableValue("bos_checkFormDataVersion", "true");
            }
            if (!option.containsVariable("bos_fromFormViewOp")) {
                option.setVariableValue("bos_fromFormViewOp", "true");
            }
            if (StringUtils.isNotEmpty((CharSequence)(billShowParameter = (BillShowParameter)this.getFormShowParameter()).getRouteKey())) {
                option.setVariableValue("routeKey", billShowParameter.getRouteKey());
                option.setVariableValue("ArchiveKey", billShowParameter.getArchiveKey());
            }
            span.addTag("formId", billShowParameter.getFormId());
            FormOperate op = this.getOperation(operationKey);
            OperationResult operationResult = super.invokeOperation(operationKey, option);
            if (operationResult != null && (operationResult.isSuccess() || !operationResult.getSuccessPkIds().isEmpty())) {
                boolean inDeleteOp;
                boolean bl = inDeleteOp = op != null && "delete".equals(op.getType());
                if (inDeleteOp) {
                    this.getModel().putContextVariable(DELETE_REFRESH_FLAG, (Object)true);
                }
                this.updateViewStatus();
                if (inDeleteOp) {
                    this.getModel().removeContextVariable(DELETE_REFRESH_FLAG);
                }
            }
            OperationResult operationResult2 = operationResult;
            return operationResult2;
        }
    }

    private void updateBillLayout() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLLAYOUT, (String)"BillView.updateBillLayout", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            if (LayoutControlInfo.isBillTypeLayout()) {
                boolean disableBillType;
                boolean bl = disableBillType = this.formShowParameter.getCustomParam("disableBillType") == null ? false : (Boolean)this.formShowParameter.getCustomParam("disableBillType");
                if (disableBillType) {
                    return;
                }
                BillEntityType dt = (BillEntityType)this.getModel().getDataEntityType();
                String billTypeKey = dt.getBillType();
                if (StringUtils.isNotBlank((CharSequence)billTypeKey)) {
                    DynamicObject billTypeObj = (DynamicObject)this.getModel().getValue(billTypeKey);
                    BillShowParameter showParameter = (BillShowParameter)this.getFormShowParameter();
                    BillTypeApHelper.updateViewByBillType(billTypeObj, showParameter.getBillStatus(), (IFormView)this);
                }
            }
        }
    }

    private boolean checkDataChanged(BeforeClosedEvent e) {
        BillShowParameter showParameter = (BillShowParameter)this.getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.VIEW || showParameter.getBillStatus() == BillOperationStatus.VIEW) {
            return false;
        }
        if (showParameter.getStatus() == OperationStatus.EDIT || showParameter.getBillStatus() == BillOperationStatus.SUBMIT || showParameter.getBillStatus() == BillOperationStatus.AUDIT) {
            List auditEnabledFields;
            List submitEnabledFields;
            Map enabledControlsMap = EntityMetadataCache.getEnabledControlsMap((String)showParameter.getFormId());
            if (showParameter.getBillStatus() == BillOperationStatus.SUBMIT ? (submitEnabledFields = (List)enabledControlsMap.get("submit")) == null || submitEnabledFields.isEmpty() : showParameter.getBillStatus() == BillOperationStatus.AUDIT && ((auditEnabledFields = (List)enabledControlsMap.get("audit")) == null || auditEnabledFields.isEmpty())) {
                return false;
            }
        }
        if (e.isSkipNoField()) {
            this.getModel().putContextVariable("bos_datachanged_skipnofield", (Object)true);
        } else {
            this.getModel().removeContextVariable("bos_datachanged_skipnofield");
        }
        return this.getModel().getDataChanged() && StringUtils.isNotBlank((CharSequence)this.getModel().getChangeDesc());
    }

    @Override
    @KSMethod
    public void close() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.close");){
            block33: {
                if (!this.getModel().isDataLoaded()) {
                    this.onClose();
                    return;
                }
                if (this.getFormShowParameter().isRuntimeMetaChanged()) {
                    this.onClose();
                    return;
                }
                BeforeClosedEvent e = new BeforeClosedEvent((Object)this);
                this.getPluginProxy().fireBeforeClosed(e);
                if (e.isCancel()) {
                    return;
                }
                IDataModel model = this.getModel();
                try {
                    if (e.isCheckDataChange() && this.checkDataChanged(e)) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IConfirmCallBack)this);
                        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                        MessageBoxOptions options = MessageBoxOptions.OKCancel;
                        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"BillView_2", (String)BOS_FORM_MVC, (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_4", (String)BOS_FORM_MVC, (Object[])new Object[0]);
                        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                        this.showConfirm(msg, model.getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                        return;
                    }
                }
                catch (KDException error) {
                    if ("bos.pageCacheInvalid".equals(error.getErrorCode().getCode())) break block33;
                    throw error;
                }
            }
            try {
                this.onClose();
            }
            catch (KDException error) {
                if (!"bos.pageCacheInvalid".equals(error.getErrorCode().getCode())) {
                    throw error;
                }
            }
        }
    }

    private void removeAttachmentField(IFormView view) {
        String formId = view.getModel().getDataEntityType().getName();
        String pageId = view.getPageId();
        IAttachmentFieldModelProxy attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        if (attachmentFieldModel.checkIfHasAttProp(formId)) {
            attachmentFieldModel.removeTempAttachments(pageId);
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.removeAttachmentField((IFormView)this);
        MutexHelper.release((IFormView)this);
        if (MutexHelper.isOpenIntentLocks()) {
            String intentKey = this.getPageCache().get("INTENTKEY_" + this.getPageCache().get("HMUTEX_OBJ_ID"));
            MutexHelper.releaseIntent((IFormView)this, (String)intentKey, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.confirmCallBack");){
            BillView formView = (BillView)((Object)evt.getSource());
            if (evt.getResult() == MessageBoxResult.Yes) {
                formView.onClose();
            }
        }
    }

    @Override
    protected FormController createFormController() {
        return new BillController((IFormView)this);
    }

    protected FormDataModel createDataModel() {
        String permissionItem = "47150e89000000ac";
        Object mainOrgId = this.getFormShowParameter().getCustomParam("mainOrgId");
        BillModel model = new BillModel(this.getEntityId(), this.getPageId(), this.services, this.getFormShowParameter().getAppId(), permissionItem);
        if (mainOrgId != null) {
            model.putContextVariable(model.getDataEntityType().getMainOrg(), mainOrgId);
        }
        return model;
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new BillViewPluginProxy();
    }

    @KSMethod
    public void setBillStatus(BillOperationStatus value) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.setBillStatus");){
            span.addTag("value", String.valueOf(value));
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
            clientViewProxy.removeAction("setFormStatus");
            clientViewProxy.addAction("setFormStatus", (Object)value.getValue());
        }
    }

    protected HashMap<Object, Object> getNumberById(List<Object> ids) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (ids.isEmpty()) {
            return map;
        }
        MainEntityType et = this.getModel().getDataEntityType();
        String numberPropName = "";
        if (et instanceof BasedataEntityType) {
            numberPropName = ((BasedataEntityType)et).getNumberProperty();
            String number = (String)this.getModel().getValue(numberPropName);
            map.put(ids.get(0), number);
        } else if (et instanceof BillEntityType) {
            numberPropName = ((BillEntityType)et).getBillNo();
            String number = (String)this.getModel().getValue(numberPropName);
            map.put(ids.get(0), number);
        } else {
            map.put(ids.get(0), ids.get(0));
        }
        return map;
    }

    private void initFieldsWithPermission() {
        IPageCache cache = (IPageCache)this.getService(IPageCache.class);
        String pageId = this.getPageId();
        if (cache.get(CAN_NOT_READ_FIELDS + pageId) != null) {
            Set oldCanNotReadFields = (Set)SerializationUtils.fromJsonString((String)cache.get(CAN_NOT_READ_FIELDS + pageId), Set.class);
            for (String oldCanNotReadField : oldCanNotReadFields) {
                this.setVisible(FILED_PERMISSION, Boolean.TRUE, oldCanNotReadField);
            }
            cache.remove(CAN_NOT_READ_FIELDS + pageId);
        }
        if (cache.get(CAN_NOT_WRITE_FIELD + pageId) != null) {
            Set oldCanNotWriteFields = (Set)SerializationUtils.fromJsonString((String)cache.get(CAN_NOT_WRITE_FIELD + pageId), Set.class);
            for (String oldCanNotWriteField : oldCanNotWriteFields) {
                this.setEnable(FILED_PERMISSION, Boolean.TRUE, oldCanNotWriteField);
            }
            cache.remove(CAN_NOT_WRITE_FIELD + pageId);
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, this.getFormShowParameter().getCheckRightAppId(), entityType.getName());
        if (fieldControlRules == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
        String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
        String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
        DynamicObject dyn = this.getModel().getDataEntity();
        DynamicObjectCollection doc = new DynamicObjectCollection();
        doc.add((Object)dyn);
        FieldControlRules2RuleReq req = new FieldControlRules2RuleReq(doc, fieldControlRules, mainOrg, dimension, dataDimensionField);
        PermRes fieldControlRuleMapPermRes = permissionService.fieldControlRules2RuleMap(req);
        Map fieldControlRuleMap = (Map)fieldControlRuleMapPermRes.getData();
        if (null != fieldControlRuleMap && !fieldControlRuleMap.isEmpty() && null != fieldControlRuleMap.get(String.valueOf(dyn.getPkValue()))) {
            FieldControlRule frule = (FieldControlRule)fieldControlRuleMap.get(String.valueOf(dyn.getPkValue()));
            Set lstCanNotReadFields = frule.getCanNotReadFields();
            Set lstCanNotWriteFields = frule.getCanNotWriteFields();
            this.getBasedataPropKeyByFieldKey(lstCanNotReadFields);
            this.getBasedataPropKeyByFieldKey(lstCanNotWriteFields);
            for (String canNotReadField : lstCanNotReadFields) {
                this.setVisible(FILED_PERMISSION, Boolean.FALSE, canNotReadField);
            }
            for (String canNotWriteField : lstCanNotWriteFields) {
                this.setEnable(FILED_PERMISSION, Boolean.FALSE, canNotWriteField);
            }
            cache.put(CAN_NOT_READ_FIELDS + pageId, SerializationUtils.toJsonString((Object)lstCanNotReadFields));
            cache.put(CAN_NOT_WRITE_FIELD + pageId, SerializationUtils.toJsonString((Object)lstCanNotWriteFields));
            this.hideContainerCollapseFields(lstCanNotReadFields);
        }
    }

    private void hideContainerCollapseFields(Set<String> canNotReadFields) {
        if (canNotReadFields == null || canNotReadFields.isEmpty()) {
            return;
        }
        List<Control> allControls = this.getControls();
        ArrayList<String> canNotReadFieldList = new ArrayList<String>(canNotReadFields);
        for (Control ctrl : allControls) {
            Container container;
            List collapseFields;
            if (!(ctrl instanceof Container) || (collapseFields = (container = (Container)ctrl).getCollapseFields()) == null || collapseFields.isEmpty() || Collections.disjoint(canNotReadFields, collapseFields)) continue;
            container.setCollapseFieldsVisible(null, canNotReadFieldList);
        }
    }

    private void getBasedataPropKeyByFieldKey(Set<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        List<Control> allControls = this.getControls();
        HashSet<String> basedataPropSet = new HashSet<String>(16);
        for (Control ctrl : allControls) {
            if (!(ctrl instanceof BasedataPropEdit)) continue;
            BasedataPropEdit basedataPropEdit = (BasedataPropEdit)ctrl;
            String key = basedataPropEdit.getRefBasedataProp() + "." + basedataPropEdit.getRefDisplayProp();
            if (fields.contains(key)) {
                fields.add(basedataPropEdit.getKey());
                basedataPropSet.add(key);
            }
            if (!fields.contains(basedataPropEdit.getRefBasedataProp())) continue;
            fields.add(basedataPropEdit.getKey());
        }
        if (!CollectionUtils.isEmpty(basedataPropSet)) {
            fields.removeAll(basedataPropSet);
        }
    }

    private List<Control> getControls() {
        FormRoot root;
        List rootControls;
        ArrayList<Control> allControls = new ArrayList<Control>();
        if (this.cacheControls != null && !this.cacheControls.isEmpty()) {
            allControls.addAll(this.cacheControls.values());
        }
        if ((rootControls = (root = this.getRootControl()).getItems()) != null) {
            allControls.addAll(rootControls);
        }
        return allControls;
    }

    private void setVisible(String policy, Boolean value, String ... ctlKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ctlKey : ctlKeys) {
            Object ctl = this.getControl(ctlKey);
            if (ctl instanceof FieldEdit) {
                if (((FieldEdit)ctl).getProperty().getParent() instanceof EntryType) {
                    this.setVisible4EntryField(value, ctlKey, (FieldEdit)ctl);
                } else {
                    list.add(ctlKey);
                }
                ctl.getView().getRootControl();
                continue;
            }
            list.add(ctlKey);
        }
        HashMap<String, Object> visableMap = new HashMap<String, Object>();
        visableMap.put("policy", policy);
        visableMap.put("visible", value);
        visableMap.put("keys", list.toArray());
        this.getClientProxy().addAction("setVisible", visableMap);
    }

    private void setVisible4EntryField(Boolean value, String ctlKey, FieldEdit ctl) {
        EntryType entryType = (EntryType)ctl.getProperty().getParent();
        Object control = this.getControl(entryType.getName());
        if (control instanceof CardEntry) {
            ((CardEntry)control).setChildVisible(value.booleanValue(), -1, new String[]{ctlKey});
            return;
        }
        ctl.setVisible("", value.booleanValue());
    }

    private void setEnable(String policy, Boolean value, String ... ctlKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ctlKey : ctlKeys) {
            Object ctl = this.getControl(ctlKey);
            if (ctl instanceof FieldEdit) {
                if (((FieldEdit)ctl).getProperty().getParent() instanceof EntryType) {
                    ((FieldEdit)ctl).setEnable("", value.booleanValue(), -1);
                } else {
                    list.add(ctlKey);
                }
                ctl.getView().getRootControl();
                continue;
            }
            list.add(ctlKey);
        }
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", policy);
        enableMap.put("enable", value);
        enableMap.put("keys", list.toArray());
        this.getClientProxy().addAction("setEnable", enableMap);
    }

    private long getMainOrgId(String mainOrg) {
        DynamicObject obj = this.getModel().getDataEntity();
        long orgId = -1L;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }

    public void updateViewStatus() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.updateViewStatus");){
            String billStatus = ((BillEntityType)this.getModel().getDataEntityType()).getBillStatus();
            if (StringUtils.isBlank((CharSequence)billStatus)) {
                return;
            }
            if (this.getModel().getProperty(billStatus) != null) {
                BillOperationStatus curOptStatus = null;
                if (this.getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                    curOptStatus = BillOperationStatus.VIEW;
                } else {
                    String value = (String)this.getModel().getValue(billStatus);
                    if ("A".equals(value)) {
                        boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                        curOptStatus = bFromDb ? BillOperationStatus.EDIT : BillOperationStatus.ADDNEW;
                    } else if ("B".equals(value)) {
                        curOptStatus = BillOperationStatus.SUBMIT;
                    } else if ("C".equals(value)) {
                        curOptStatus = BillOperationStatus.AUDIT;
                    }
                }
                if (curOptStatus != null) {
                    this.setBillStatus(curOptStatus);
                    BillShowParameter showParameter = (BillShowParameter)this.getFormShowParameter();
                    if (showParameter.getBillStatus() != curOptStatus) {
                        showParameter.setBillStatus(curOptStatus);
                        this.cacheFormShowParameter();
                    }
                }
            }
            this.updateBillLayout();
            this.lockMainOrgField();
        }
    }

    @Override
    protected CloseCallBackWraper getCloseCallBackWraper() {
        CloseCallBackWraper closeCallBackWraper = super.getCloseCallBackWraper();
        if (closeCallBackWraper != null) {
            closeCallBackWraper.setBillView(true);
            if (this.getModel().isDataLoaded() && !this.getFormShowParameter().isRuntimeMetaChanged()) {
                closeCallBackWraper.setPkId(((BillModel)this.getModel()).getPKValue());
            }
        }
        return closeCallBackWraper;
    }

    @Override
    protected void initiService() {
        super.initiService();
        this.addService(IUpdateView.class, new UpdateViewService((IFormView)this));
        if (LayoutControlInfo.isBillTypeLayout()) {
            BillEntityType dt = (BillEntityType)this.getModel().getDataEntityType();
            BillShowParameter billShowParameter = (BillShowParameter)this.getFormShowParameter();
            if (StringUtils.isNotBlank((CharSequence)dt.getBillType())) {
                Long defaultBillTypeId = null;
                if (StringUtils.isNotBlank((CharSequence)billShowParameter.getBillTypeId())) {
                    defaultBillTypeId = Long.parseLong(billShowParameter.getBillTypeId());
                }
                this.addService(IDefValueProvider.class, (Object)new BillTypeDefValueProvider((IFormView)this, defaultBillTypeId));
            }
        }
    }

    public boolean loadPageLayout() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLLAYOUT, (String)"BillView.loadPageLayout", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            if (this.formShowParameter instanceof MobileBillShowParameter) {
                boolean bl = false;
                return bl;
            }
            if (((BillShowParameter)this.formShowParameter).isDisableLayoutScheme()) {
                boolean bl = false;
                return bl;
            }
            Long originaScheme = ((BillShowParameter)this.formShowParameter).getLayoutSchemeId();
            BillLayoutScheme bls = this.getLayoutScheme();
            if (originaScheme != null && originaScheme != 0L) {
                boolean bl = false;
                return bl;
            }
            String billTypeKey = ((BillEntityType)this.getModel().getDataEntityType()).getBillType();
            boolean hidden = false;
            if (StringUtils.isBlank((CharSequence)billTypeKey)) {
                hidden = true;
            } else {
                DynamicObject billTypeObj = (DynamicObject)this.getModel().getValue(billTypeKey);
                if (billTypeObj != null && billTypeObj.getPkValue() != null) {
                    long billTypeId = (Long)billTypeObj.getPkValue();
                    if (billTypeId == 0L) {
                        hidden = true;
                    }
                } else {
                    hidden = true;
                }
            }
            String formId = this.getFormId();
            BillShowParameter billShowParameter = bls.convertLayoutShowParameter((BillShowParameter)this.formShowParameter, hidden);
            if (billShowParameter != null && !StringUtils.equals((CharSequence)formId, (CharSequence)billShowParameter.getFormId())) {
                this.showForm((FormShowParameter)billShowParameter);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
                if (!CollectionUtils.isEmpty((Collection)clientViewProxy.getLazySummaryGrid())) {
                    clientViewProxy.getLazySummaryGrid().clear();
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private BillLayoutScheme getLayoutScheme() {
        BillLayoutParameter blp = new BillLayoutParameter();
        BillShowParameter billShowParameter = (BillShowParameter)this.getFormShowParameter();
        Long newOrgValue = billShowParameter.getLayoutMainOrgId();
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        long billTypeId = 0L;
        String billType = billShowParameter.getBillTypeId();
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            try {
                billTypeId = Long.parseLong(billType);
            }
            catch (Exception e) {
                billTypeId = 0L;
            }
        }
        blp.setBillTypeId(billTypeId);
        return new BillLayoutScheme((IBillModel)this.getModel(), billShowParameter, blp);
    }

    @Override
    protected FormDefValueProvider createFormDefValueProvider() {
        if (LayoutControlInfo.isBillTypeLayout()) {
            return super.createFormDefValueProvider();
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getFormShowParameter();
        Long layoutSchemeId = billShowParameter.getLayoutSchemeId();
        return new BillDefValueProvider((IFormView)this, layoutSchemeId);
    }

    private boolean isMutexByThisPage() {
        IPageCache pageCache = (IPageCache)this.getService(IPageCache.class);
        String operKey = pageCache.get("MUTEX_OPER_KEY");
        String objId = pageCache.get("MUTEX_OBJ_ID");
        return operKey != null && objId != null;
    }

    protected boolean needShowOpResultFieldLoc() {
        return true;
    }
}

