/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.card;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.card.ICardPlugin;
import kd.bos.card.ICardView;
import kd.bos.card.adapter.Button;
import kd.bos.card.adapter.Hyperlink;
import kd.bos.card.adapter.Image;
import kd.bos.card.adapter.Label;
import kd.bos.card.events.TimerElapsedArgs;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;

public class CardView
implements ICardView {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private String formId;
    private String cardId;
    private Map<String, Object> param;
    private List<ICardPlugin> plugins;
    private Integer intervalTime;
    private Map<String, Object> otherActions = new HashMap<String, Object>();
    private Map<String, Map<String, Object>> _dctControlsStates = new HashMap<String, Map<String, Object>>();
    private List<Map<String, Object>> _controlsState = new ArrayList<Map<String, Object>>();

    public CardView(String formId, String cardId, Map<String, Object> param) {
        this.formId = formId;
        this.cardId = cardId;
        this.param = param;
        FormConfig config = FormMetadataCache.getFormConfig((String)formId);
        this.plugins = config.createCardPlugin(formId);
        for (ICardPlugin plugin : this.plugins) {
            plugin.setView((ICardView)this);
        }
    }

    public void loadData() {
        this.fireCreateCardData(new EventObject(this));
    }

    public String getCardId() {
        return this.cardId;
    }

    public String getFormId() {
        return this.formId;
    }

    public Map<String, Object> getParameter() {
        return this.param;
    }

    public void setParameter(Map<String, Object> param) {
        this.param = param;
    }

    public void setControlValue(String key, String property, Object value) {
        this.getControlState(key).put(property, value);
    }

    private Map<String, Object> getControlState(String key) {
        Map<String, Object> controlState = null;
        controlState = this._dctControlsStates.get(key);
        if (controlState == null) {
            controlState = new HashMap<String, Object>();
            controlState.put("k", key);
            this._dctControlsStates.put(key, controlState);
            this._controlsState.add(controlState);
        }
        return controlState;
    }

    private void fireCreateCardData(EventObject e) {
        for (ICardPlugin pl : this.plugins) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(pl.getClass().getName() + ".createCardData"));
            Throwable throwable = null;
            try {
                pl.createCardData(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public List<Object> getActionResult() {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this._controlsState.size() > 0) {
            actions.add(this.createAction("u", this._controlsState));
        }
        this.otherActions.forEach((k, v) -> actions.add(this.createAction((String)k, v)));
        return actions;
    }

    public Label getLabel(String key) {
        return new Label((ICardView)this, key);
    }

    public Button getButton(String key) {
        return new Button((ICardView)this, key);
    }

    public Image getImage(String key) {
        return new Image((ICardView)this, key);
    }

    public Hyperlink getHyperlink(String key) {
        return new Hyperlink((ICardView)this, key);
    }

    private Map<String, Object> createAction(String actionName, Object arg) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>(1);
        paras.add(arg);
        action.put("p", paras);
        return action;
    }

    public void click(String key) {
        this.fireClick(new EventObject(this), key);
    }

    private void fireClick(EventObject e, String key) {
        for (ICardPlugin pl : this.plugins) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(pl.getClass().getName() + ".onClick"));
            Throwable throwable = null;
            try {
                span.addTag("key", key);
                pl.onClick(e, key);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void setTimer(Integer intervalMilliSec) {
        this.intervalTime = intervalMilliSec;
    }

    public void clearTimer() {
        this.intervalTime = 0;
    }

    public void timerElapsed() {
        this.fireTimerElapsed();
    }

    private void fireTimerElapsed() {
        TimerElapsedArgs args = new TimerElapsedArgs((Object)this, this.getParameter());
        for (ICardPlugin pl : this.plugins) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(pl.getClass().getName() + ".onTimerElapsed"));
            Throwable throwable = null;
            try {
                pl.onTimerElapsed(args);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public Integer getIntervalTime() {
        return this.intervalTime;
    }

    public void openUrl(String url) {
        this.otherActions.put("openUrl", url);
    }
}

