/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.ReportColumn;
import kd.bos.lang.Lang;
import kd.bos.mvc.export.ColExcelExporter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

class RptColExcelExporter
extends ColExcelExporter {
    private SXSSFWorkbook wb;
    private Map<String, CellStyle> decimalStyles = new HashMap<String, CellStyle>();
    private Map<String, CellStyle> formulaStyles = new HashMap<String, CellStyle>();
    private CellStyle commonStyle = null;

    public RptColExcelExporter(IColumn column) {
        super(column);
    }

    public ReportColumn getReportColumn() {
        return (ReportColumn)this.getColumn();
    }

    @Override
    public final Object getValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        Object value = this.readValue(rowData, numberFormatProvider);
        value = this.formatValue(rowData, numberFormatProvider, value);
        return this.desensitizeValue(rowData, value);
    }

    protected Object readValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        return super.getValue(rowData, numberFormatProvider);
    }

    protected Object formatValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider, Object value) {
        return value;
    }

    protected Object desensitizeValue(DynamicObject rowData, Object value) {
        if (this.getReportColumn() == null || !this.getReportColumn().isDesensitized()) {
            return value;
        }
        String operateType = "EXPORT";
        boolean isDesensitizeField = false;
        DynamicProperty thisFieldProp = this.getReportColumn().getFieldProperty();
        if (thisFieldProp != null) {
            isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)rowData);
        }
        if (isDesensitizeField) {
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                for (int i = 0; i < val.length; ++i) {
                    val[i] = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)rowData, (Object)val[i]);
                }
            } else {
                value = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)rowData, (Object)value);
            }
        }
        return value;
    }

    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public CellStyle getCommonStyle() {
        if (this.commonStyle == null) {
            this.commonStyle = this.wb.createCellStyle();
            RptColExcelExporter.setCommonStyle(this.commonStyle);
        }
        return this.commonStyle;
    }

    public CellStyle getFormulaStyle(String align) {
        String style = "FORMULA_" + align;
        CellStyle formulaStyle = this.formulaStyles.get(style);
        if (formulaStyle == null) {
            formulaStyle = this.wb.createCellStyle();
            RptColExcelExporter.setCommonStyle(formulaStyle);
            formulaStyle.setDataFormat((short)0);
            formulaStyle.setAlignment(this.getAlignment(align));
            this.formulaStyles.put(style, formulaStyle);
        }
        return formulaStyle;
    }

    public CellStyle getDecimalStyle(int precision, String align) {
        CellStyle decimalStyle = this.decimalStyles.get(precision + " " + align);
        if (decimalStyle == null) {
            String format = "_(#,##0.00_);_(-#,##0.00_)";
            format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
            decimalStyle = this.wb.createCellStyle();
            RptColExcelExporter.setCommonStyle(decimalStyle);
            decimalStyle.setDataFormat(this.wb.createDataFormat().getFormat(format));
            decimalStyle.setAlignment(this.getAlignment(align));
            this.decimalStyles.put(precision + " " + align, decimalStyle);
        }
        return decimalStyle;
    }

    private static void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }
}

