/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.mvc.export.RptColExcelExporter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;

class RptDateColExcelExporter
extends RptColExcelExporter {
    private Map<String, CellStyle> dateStyle = null;

    public RptDateColExcelExporter(IColumn column) {
        super(column);
    }

    @Override
    protected Object formatValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider, Object value) {
        if (value instanceof Object[]) {
            Object[] val = (Object[])value;
            value = val[0].toString();
            this.cellStyle = this.getDateStyle();
        }
        return value;
    }

    private CellStyle getDateStyle() {
        IColumn column = this.getColumn();
        if (column instanceof DateTimeReportColumn) {
            DateTimeReportColumn dateColumn = (DateTimeReportColumn)column;
            String mask = dateColumn.getMask();
            if (StringUtils.isBlank((CharSequence)mask)) {
                this.indexOldStyle = 3;
                return this.getCommonStyle();
            }
            if (!StringUtils.equals((CharSequence)mask, (CharSequence)"yyyy/MM/dd") && !StringUtils.equals((CharSequence)mask, (CharSequence)"yyyy-MM-dd")) {
                return null;
            }
            if (this.dateStyle == null) {
                this.dateStyle = new HashMap<String, CellStyle>(16);
            }
            CellStyle dateCellStyle = this.dateStyle.get(mask);
            if (this.dateStyle.get(mask) == null) {
                dateCellStyle = this.getWb().createCellStyle();
                DataFormat format = this.getWb().createDataFormat();
                dateCellStyle.setDataFormat(format.getFormat(mask));
                this.dateStyle.put(mask, dateCellStyle);
            }
            RptDateColExcelExporter.setCommonStyle(dateCellStyle);
            this.indexOldStyle = 5;
            return dateCellStyle;
        }
        this.indexOldStyle = 3;
        return this.getCommonStyle();
    }

    private static void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }
}

