/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.bill.BillTypeApHelper;

public class BillTypeChangeListener
implements IDataModelChangeListener {
    private IBillView view;

    BillTypeChangeListener(IBillView view) {
        this.view = view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (LayoutControlInfo.isBillTypeLayout()) {
            DynamicObject billTypeObj;
            if (e.getProperty() instanceof BillTypeProp && (billTypeObj = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
                BillTypeApHelper.reloadDataModelByBillType(billTypeObj, this.view);
                this.view.updateView();
            }
        } else {
            DynamicObject billTypeObj;
            boolean isReloadDataModel;
            boolean bl = isReloadDataModel = this.view.getFormShowParameter().getCustomParam("BillTypeChangeReloadDataModel") == null ? false : (Boolean)this.view.getFormShowParameter().getCustomParam("BillTypeChangeReloadDataModel");
            if (e.getProperty() instanceof BillTypeProp && isReloadDataModel && (billTypeObj = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
                BillTypeApHelper.reloadDataModelByBillType(billTypeObj, this.view, false);
                this.view.updateView();
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        BillShowParameter showParameter;
        if (e.getProperty() instanceof BillTypeProp && this.isChanged(e.getChangeSet()) && (showParameter = (BillShowParameter)this.view.getFormShowParameter()).getBillStatus() != BillOperationStatus.ADDNEW && !Boolean.TRUE.equals(this.view.getModel().getContextVariable("IGNORE_RELOADDATAMODEL"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u5355\u636e\u72b6\u6001\u4e3a\u65b0\u589e\u7684\u65f6\u5019\uff0c\u4fee\u6539\u5355\u636e\u7c7b\u578b", (String)"BillTypeChangeListener_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        }
    }

    private boolean isChanged(ChangeData[] changeDatas) {
        if (changeDatas == null || changeDatas.length == 0) {
            return false;
        }
        for (ChangeData changeData : changeDatas) {
            Object newPk;
            Object oldValue = changeData.getOldValue();
            Object newValue = changeData.getNewValue();
            if (oldValue == null && newValue == null) continue;
            if (oldValue == null || newValue == null || oldValue.getClass() != newValue.getClass()) {
                return true;
            }
            if (oldValue.equals(newValue)) continue;
            Object oldPk = oldValue instanceof DynamicObject ? ((DynamicObject)oldValue).getPkValue() : oldValue.toString();
            Object object = newPk = newValue instanceof DynamicObject ? ((DynamicObject)newValue).getPkValue() : newValue.toString();
            if (oldPk.equals(newPk)) continue;
            return true;
        }
        return false;
    }
}

