/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.plugin.support.util.ClassUtils;
import kd.bos.form.CtsyFormShowParameter;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICtsyShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.list.CtsyListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.mvc.form.TileTabUtil;
import kd.bos.servicehelper.ctsy.CtsyApiDispatchServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class CtsyControllerService {
    private static final Log log = LogFactory.getLog((String)"CtsyControllerService");
    private static final String SPAN_TYPE_NAME = "CtsyControllerService";
    private static final String ORIGIN_SHOWTYPE = "originShowType";
    public static final String CTSY_RETURNTOPARENTDATA = "ctsyReturnToParentData";
    public static final String CTSY_RETURNTOPARENTDATA_CLASSNAME = "ctsyReturnToParentDataClassName";
    private static final String SUB_MAIN_TAB = "_submaintab_";
    private static final String MAIN_VIEW_TAB = "tabap";

    public String batchInvokeAction(IFormView view, String dataParams, Map<String, Object> actionParams) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"batchInvokeAction");){
            span.addTag("dataParams", dataParams);
            span.addLocaleTag("actionParams", actionParams);
            if (CtsyListShowParameter.isSelfTenant((ICtsyShowParameter)((ICtsyShowParameter)view.getFormShowParameter()))) {
                String string = null;
                return string;
            }
            String loaddata = "[{\"key\":\"\",\"methodName\":\"loadData\"";
            if (dataParams.startsWith(loaddata)) {
                view.getPageCache().put("bos_open_done", "true");
            }
            String remoteJsonString = this.relayToRemoteTenantRequest(dataParams, actionParams, view.getFormShowParameter());
            span.addTag("remoteJsonString", remoteJsonString);
            if (remoteJsonString.contains("No such accessible method")) {
                String string = "[]";
                return string;
            }
            String closeFirstCtsyJson = this.closeFirstCtsyPageHandle(view, remoteJsonString, dataParams);
            if (!StringUtils.isEmpty((String)closeFirstCtsyJson)) {
                String string = closeFirstCtsyJson;
                return string;
            }
            remoteJsonString = this.interceptShowFormAction(view, remoteJsonString);
            remoteJsonString = this.remotePageIdReplaceWithPageId(view, remoteJsonString);
            span.addTag("lastremoteJsonString", remoteJsonString);
            String string = remoteJsonString;
            return string;
        }
    }

    private String relayToRemoteTenantRequest(String dataParams, Map<String, Object> actionParams, FormShowParameter showParameter) {
        boolean callWebApi;
        dataParams = this.pageIdReplaceWithRemotePageId(dataParams);
        ICtsyShowParameter formShowParameter = (ICtsyShowParameter)showParameter;
        String tenantCode = formShowParameter.getTenantCode();
        String accountId = formShowParameter.getAccountId();
        String remotePageId = showParameter.getCustomParams().get("remotePageId") == null ? "" : (String)showParameter.getCustomParams().get("remotePageId");
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("method", "batchInvokeAction");
        params.put("pageId", remotePageId);
        params.put("appId", showParameter.getServiceAppId());
        params.put("dataParams", dataParams);
        params.put("actionParams", actionParams);
        HashMap<String, HashMap<String, Object>> paramsTemp = new HashMap<String, HashMap<String, Object>>(1);
        paramsTemp.put("params", params);
        String ret = "";
        boolean bl = callWebApi = showParameter.getCustomParams().get("callWebApi") == null ? true : (Boolean)showParameter.getCustomParams().get("callWebApi");
        if (callWebApi) {
            Object resultMap = CtsyApiDispatchServiceHelper.invokeWebApi((String)tenantCode, (String)accountId, (String)"/v2/ctsy/ctform/handle", paramsTemp);
            if (resultMap instanceof Map && ((Map)resultMap).get("data") instanceof String) {
                ret = (String)((Map)resultMap).get("data");
            }
        } else {
            String result = CtsyApiDispatchServiceHelper.post((String)tenantCode, (String)accountId, (String)"v2/ctsy/ctform/handle", (String)SerializationUtils.toJsonString(paramsTemp));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            if (openApiResult.get("data") instanceof String) {
                ret = (String)openApiResult.get("data");
            }
        }
        return ret;
    }

    private String interceptShowFormAction(IFormView formView, String ctsyJsonString) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"interceptShowFormAction");){
            if (!ctsyJsonString.contains("\"a\":\"showForm\"") && !ctsyJsonString.contains("\"a\":\"openWindow\"")) {
                String string = ctsyJsonString;
                return string;
            }
            FormShowParameter showParameter = formView.getFormShowParameter();
            IFormView mainview = formView.getMainView();
            IFormView appView = this.getAppView(formView);
            TileTabUtil tileTabUtil = new TileTabUtil(formView.getMainView(), showParameter.getPageId());
            boolean enableTileMenu = tileTabUtil.enableTileMenu();
            if (!enableTileMenu && appView != null) {
                mainview = appView;
            }
            ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)ctsyJsonString, ArrayList.class);
            for (Map object : arrayList) {
                int originShowType;
                if (object.get("a") != null && "sendDynamicFormAction".equals(object.get("a"))) {
                    ArrayList pList = (ArrayList)object.get("p");
                    for (Map pMap : pList) {
                        ArrayList actionList = (ArrayList)pMap.get("actions");
                        ArrayList<Map<String, Object>> actionListTemp = new ArrayList<Map<String, Object>>(1);
                        for (Map actionMap : actionList) {
                            Map<String, Object> addVirtualTab;
                            int originShowType2 = this.createCtsyShowParameter(span, formView, mainview, actionMap, enableTileMenu);
                            if (originShowType2 == ShowType.MainNewTabPage.getValue() && mainview != null) {
                                pMap.put("pageId", mainview.getPageId());
                            }
                            if ((addVirtualTab = this.getVirtualTabMap(formView, appView, actionMap, enableTileMenu)) == null) continue;
                            actionListTemp.add(addVirtualTab);
                        }
                        if (actionListTemp == null || actionListTemp.size() <= 0) continue;
                        actionList.addAll(actionListTemp);
                    }
                }
                if ((originShowType = this.createCtsyShowParameter(span, formView, mainview, object, enableTileMenu)) != ShowType.MainNewTabPage.getValue() || mainview == null) continue;
                ArrayList<Map> actionList = new ArrayList<Map>(2);
                Map<String, Object> addVirtualTab = this.getVirtualTabMap(formView, appView, object, enableTileMenu);
                if (addVirtualTab != null) {
                    actionList.add(addVirtualTab);
                }
                actionList.add(object);
                HashMap<String, Object> arg = new HashMap<String, Object>(2);
                arg.put("pageId", mainview.getPageId());
                arg.put("actions", actionList);
                HashMap<String, Object> commandMain = new HashMap<String, Object>(2);
                commandMain.put("a", "sendDynamicFormAction");
                commandMain.put("p", Collections.singletonList(arg));
                String string = SerializationUtils.toJsonString(Collections.singletonList(commandMain));
                return string;
            }
            ctsyJsonString = SerializationUtils.toJsonString((Object)arrayList);
        }
        return ctsyJsonString;
    }

    private int createCtsyShowParameter(EntityTraceSpan span, IFormView formView, IFormView mainview, Map<String, Object> object, boolean enableTileMenu) {
        int originShowType;
        if (object.get("a") == null || !"showForm".equals(object.get("a")) && !"openWindow".equals(object.get("a"))) {
            return 0;
        }
        ArrayList pList = (ArrayList)object.get("p");
        Map pMap = (Map)pList.get(0);
        String pageId = pMap.get("pageId") == null ? "" : (String)pMap.get("pageId");
        String formId = pMap.get("formId") == null ? "" : (String)pMap.get("formId");
        String billFormId = pMap.get("billFormId") == null ? "" : (String)pMap.get("billFormId");
        String appId = pMap.get("appId") == null ? "" : (String)pMap.get("appId");
        String caption = "";
        Map captionMap = (Map)pMap.get("caption");
        if (captionMap != null) {
            caption = (String)captionMap.get(RequestContext.get().getLang().name());
        }
        Object formShowParameter = null;
        FormShowParameter showParameter = formView.getFormShowParameter();
        ICtsyShowParameter ctsyShowParameter = (ICtsyShowParameter)showParameter;
        formShowParameter = StringUtils.isNotEmpty((String)billFormId) ? new CtsyListShowParameter(ctsyShowParameter.getTenantCode(), ctsyShowParameter.getAccountId(), billFormId) : new CtsyFormShowParameter(ctsyShowParameter.getTenantCode(), ctsyShowParameter.getAccountId(), formId);
        boolean callWebApi = showParameter.getCustomParams().get("callWebApi") == null ? true : (Boolean)showParameter.getCustomParams().get("callWebApi");
        pMap.put("ctsynonce", CtsyListShowParameter.getCtsynonce((String)ctsyShowParameter.getTenantCode(), (String)ctsyShowParameter.getAccountId(), (boolean)callWebApi));
        if ("openWindow".equals(object.get("a"))) {
            CtsyListShowParameter.saveCacheCtsyPageId((String)formShowParameter.getPageId(), (String)pageId);
        }
        String imageFullUrl = UrlService.getCheckAuthImageUrl((String)"");
        String fileServerUrl = UrlService.getCheckAuthImageUrl((String)"");
        pMap.put("imageurl", imageFullUrl);
        pMap.put("fileserver", fileServerUrl);
        formShowParameter.setParentPageId(showParameter.getPageId());
        formShowParameter.setRootPageId(showParameter.getRootPageId());
        formShowParameter.setSessionId(showParameter.getSessionId());
        formShowParameter.setAppId(showParameter.getAppId());
        if (StringUtils.isNotEmpty((String)appId)) {
            formShowParameter.setCustomParam("ServiceAppId", (Object)appId);
        }
        if (StringUtils.isNotEmpty((String)caption)) {
            formShowParameter.setCaption(caption);
        }
        formShowParameter.setCustomParam("remotePageId", (Object)pageId);
        formShowParameter.setCustomParam("callWebApi", (Object)callWebApi);
        FormConfig configList = new FormConfig();
        configList.setEntityTypeId(formId);
        if (StringUtils.isNotEmpty((String)caption)) {
            configList.setCaption(new LocaleString(caption));
        }
        formShowParameter.setFormConfig(configList);
        IPageCache cache = SessionManager.getCurrent().getPageCache(formShowParameter.getPageId());
        RootPageCache.addPageId(showParameter.getRootPageId(), formShowParameter.getPageId());
        formShowParameter.setCacheExpireTime(System.currentTimeMillis());
        cache.put(FormShowParameter.class.getSimpleName(), formShowParameter.toString());
        cache.saveChanges();
        span.addTag("pageId", formShowParameter.getPageId());
        span.addTag("remotePageId", pageId);
        span.addTag("rootPageId", showParameter.getRootPageId());
        span.addTag("billFormId", billFormId);
        span.addTag("formId", formId);
        pMap.put("pageId", formShowParameter.getPageId());
        int n = originShowType = pMap.get(ORIGIN_SHOWTYPE) == null ? 0 : (Integer)pMap.get(ORIGIN_SHOWTYPE);
        if (originShowType == ShowType.MainNewTabPage.getValue() && mainview != null) {
            String targetKey = SUB_MAIN_TAB;
            if (enableTileMenu) {
                targetKey = MAIN_VIEW_TAB;
            }
            HashMap<String, Object> openStyle = new HashMap<String, Object>(2);
            openStyle.put("showType", ShowType.NewTabPage.getValue());
            openStyle.put("targetKey", targetKey);
            pMap.put("openStyle", openStyle);
            pMap.put("mainPageId", mainview.getPageId());
        }
        return originShowType;
    }

    private String remotePageIdReplaceWithPageId(IFormView formView, String ctsyJsonString) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"service.remotePageIdReplaceWithPageId");){
            String remotePageId = formView.getFormShowParameter().getCustomParams().get("remotePageId") == null ? "" : (String)formView.getFormShowParameter().getCustomParams().get("remotePageId");
            span.addTag("pageId", formView.getFormShowParameter().getPageId());
            span.addTag("remotePageId", remotePageId);
            ctsyJsonString = ctsyJsonString.replaceAll(remotePageId, formView.getFormShowParameter().getPageId());
            IFormView parentView = this.getParentViewNoPlugin(formView);
            if (parentView != null && parentView.getFormShowParameter() instanceof ICtsyShowParameter) {
                ctsyJsonString = this.remotePageIdReplaceWithPageId(parentView, ctsyJsonString);
            }
            String string = ctsyJsonString;
            return string;
        }
    }

    private String pageIdReplaceWithRemotePageId(String dataParams) {
        List params = (List)SerializationUtils.fromJsonString((String)dataParams, List.class);
        for (Map param : params) {
            List postDatas;
            Object postData = param.get("postData");
            if (!(postData instanceof List) || (postDatas = (List)postData).size() <= 2) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"service.pageIdReplaceWithRemotePageId");
            Throwable throwable = null;
            try {
                Map childFormStates = (Map)postDatas.get(2);
                if (childFormStates == null || childFormStates.size() == 0) continue;
                for (Map.Entry childFormState : childFormStates.entrySet()) {
                    String pageId = (String)childFormState.getKey();
                    FormShowParameter showParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
                    if (showParameter == null) continue;
                    span.addTag("showParameter", showParameter.toString());
                    String remotePageId = showParameter.getCustomParams().get("remotePageId") == null ? "" : (String)showParameter.getCustomParams().get("remotePageId");
                    if (!StringUtils.isNotEmpty((String)remotePageId)) continue;
                    span.addTag("pageId", pageId);
                    span.addTag("remotePageId", remotePageId);
                    dataParams = dataParams.replaceAll(pageId, remotePageId);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        return dataParams;
    }

    private void setReturnToParentData(IFormView view, String ctsyJsonString, ArrayList<Map<String, Object>> arrayList) {
        if (!ctsyJsonString.contains("\"a\":\"ctsyReturnToParentData\"")) {
            return;
        }
        for (Map<String, Object> object : arrayList) {
            List pList;
            Map pMap;
            String clPageId;
            if (object.get("a") == null || !CTSY_RETURNTOPARENTDATA.equals(object.get("a")) || !(object.get("p") instanceof List) || !StringUtils.isNotEmpty((String)(clPageId = (pMap = (Map)(pList = (List)object.get("p")).get(0)).get("pageId") == null ? "" : (String)pMap.get("pageId"))) || !clPageId.equals(view.getPageId())) continue;
            String returnToParentDataClassName = pMap.get(CTSY_RETURNTOPARENTDATA_CLASSNAME) == null ? "" : (String)pMap.get(CTSY_RETURNTOPARENTDATA_CLASSNAME);
            String returnToParentData = pMap.get(CTSY_RETURNTOPARENTDATA) == null ? "" : (String)pMap.get(CTSY_RETURNTOPARENTDATA);
            try {
                Object obj = SerializationUtils.fromJsonString((String)returnToParentData, (Class)ClassUtils.forName((String)returnToParentDataClassName, (ClassLoader)ClassLoader.getSystemClassLoader()));
                view.returnDataToParent(obj);
            }
            catch (Exception e) {
                view.returnDataToParent((Object)returnToParentData);
                log.error("Serialization returns a parent information exception: ", (Throwable)e);
            }
            arrayList.remove(object);
            break;
        }
    }

    private IFormView getAppView(IFormView formView) {
        if (formView.getMainView() == null || StringUtils.isEmpty((String)formView.getMainView().getPageId())) {
            return null;
        }
        String mainPageId = formView.getMainView().getPageId();
        IFormView appView = SessionManager.getCurrent().getViewNoPlugin(formView.getFormShowParameter().getAppId() + mainPageId);
        if (appView == null || StringUtils.isEmpty((String)appView.getPageId())) {
            return null;
        }
        return appView;
    }

    private String closeFirstCtsyPageHandle(IFormView view, String remoteJsonString, String dataParams) {
        IFormView parentView = this.getParentViewNoPlugin(view);
        if (parentView != null && !(parentView.getFormShowParameter() instanceof ICtsyShowParameter)) {
            String release = "[{\"key\":\"\",\"methodName\":\"release\"";
            if (remoteJsonString.contains("\"a\":\"closeWindow\"") || remoteJsonString.contains("\"a\":\"closeBrowserPage\"") || dataParams.startsWith(release)) {
                ArrayList arrayList = (ArrayList)SerializationUtils.fromJsonString((String)remoteJsonString, ArrayList.class);
                this.setReturnToParentData(view, remoteJsonString, arrayList);
                String hyperLinkClick = "\"methodName\":\"hyperLinkClick\"";
                if (dataParams.contains(hyperLinkClick)) {
                    for (Map object : arrayList) {
                        if (object.get("a") == null || !"closeWindow".equals(object.get("a")) && !"closeBrowserPage".equals(object.get("a"))) continue;
                        arrayList.remove(object);
                        break;
                    }
                    remoteJsonString = SerializationUtils.toJsonString((Object)arrayList);
                    return this.remotePageIdReplaceWithPageId(view, remoteJsonString);
                }
                view.close();
                List actionResult = view.getActionResult();
                ArrayList results = new ArrayList();
                results.addAll(actionResult);
                return SerializationUtils.toJsonString(results);
            }
        }
        return null;
    }

    private Map<String, Object> getVirtualTabMap(IFormView formView, IFormView appView, Map<String, Object> object, boolean enableTileMenu) {
        if (!enableTileMenu && appView != null) {
            ArrayList pList = (ArrayList)object.get("p");
            Map pMap = (Map)pList.get(0);
            String pageId = pMap.get("pageId") == null ? "" : (String)pMap.get("pageId");
            String caption = "";
            Map captionMap = (Map)pMap.get("caption");
            if (captionMap != null) {
                caption = (String)captionMap.get(RequestContext.get().getLang().name());
            }
            IFormView mainView = formView.getMainView();
            boolean isHomepageForm = false;
            if (mainView != null && mainView.getFormShowParameter() != null) {
                isHomepageForm = "home_page".equals(mainView.getFormShowParameter().getFormId());
            }
            if (isHomepageForm) {
                String method = "addVirtualTab";
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                parentMap.put("methodname", method);
                parentMap.put("key", "homepagetabap");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("pageId", pageId);
                params.put("appId", formView.getFormShowParameter().getAppId());
                params.put("tabName", caption);
                ArrayList<HashMap<String, String>> argList = new ArrayList<HashMap<String, String>>();
                argList.add(params);
                parentMap.put("args", argList);
                HashMap<String, Object> invokeControlMethod = new HashMap<String, Object>();
                invokeControlMethod.put("a", "InvokeControlMethod");
                invokeControlMethod.put("p", Collections.singletonList(parentMap));
                HashMap<String, Object> arg = new HashMap<String, Object>(2);
                arg.put("pageId", mainView.getPageId());
                arg.put("actions", Collections.singletonList(invokeControlMethod));
                HashMap<String, Object> commandMain = new HashMap<String, Object>(2);
                commandMain.put("a", "sendDynamicFormAction");
                commandMain.put("p", Collections.singletonList(arg));
                return commandMain;
            }
        }
        return null;
    }

    private IFormView getParentViewNoPlugin(IFormView formView) {
        if (formView != null) {
            return formView.getViewNoPlugin(formView.getFormShowParameter().getParentPageId());
        }
        return null;
    }
}

