/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.form.BinderMap;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeSubEntryGrid;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.util.CollectionUtils;

class DataModelChangeListener
implements IDataModelListener,
IDataModelChangeListener {
    private static final Log log = LogFactory.getLog(DataModelChangeListener.class);
    private IFormView view;
    private boolean hasBinderMap;
    private BinderMap binderMap;

    public DataModelChangeListener(IFormView view) {
        this.view = view;
        this.setHasBinderMap(view.getFormShowParameter().getFormConfig().isHasBinderMap());
    }

    public boolean isHasBinderMap() {
        return this.hasBinderMap;
    }

    private void setHasBinderMap(boolean hasBinderMap) {
        this.hasBinderMap = hasBinderMap;
    }

    private IClientViewProxy getViewProxy() {
        return (IClientViewProxy)this.view.getService(IClientViewProxy.class);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        this.raiseItemAdded(model);
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        if (!model.getDataEntity().getDataEntityState().getFromDatabase()) {
            this.raiseItemAdded(model);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        List<FieldEdit> edits = this.getEdits(prop.getName());
        if (edits.size() > 0) {
            this.bindEditData(prop, e.getChangeSet(), edits);
            this.updateChildren(prop, e.getChangeSet());
        }
        if (prop instanceof OrgProp) {
            // empty if block
        }
        FormRuleContainer ruleContaiber = (FormRuleContainer)((Object)this.view.getService(RuleContainer.class));
        ruleContaiber.raiseDataChanged(e.getProperty(), Arrays.asList(e.getChangeSet()), new FormRuleExecuteContext(this.view));
        boolean summaryAll = false;
        for (FieldEdit fieldEdit : edits) {
            EntryGrid entryGrid;
            String entryKey;
            if (fieldEdit.getProperty() instanceof DecimalProp) {
                entryKey = fieldEdit.getEntryKey();
                if (StringUtils.isBlank((CharSequence)entryKey)) continue;
                entryGrid = null;
                if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                    fieldEdit.getView().getControl(fieldEdit.getEntryControlKey());
                }
                if (entryGrid == null) {
                    entryGrid = (EntryGrid)fieldEdit.getView().getControl(entryKey);
                }
                if (entryGrid == null) continue;
                entryGrid.setAmountTotalFloatButtomData(fieldEdit.getKey());
                continue;
            }
            if (!(fieldEdit.getProperty() instanceof CurrencyProp) && !(fieldEdit.getProperty() instanceof UnitProp)) continue;
            entryKey = fieldEdit.getEntryKey();
            if (!StringUtils.isBlank((CharSequence)entryKey)) {
                entryGrid = null;
                if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                    fieldEdit.getView().getControl(fieldEdit.getEntryControlKey());
                }
                if (entryGrid == null) {
                    entryGrid = (EntryGrid)fieldEdit.getView().getControl(entryKey);
                }
                if (entryGrid == null) continue;
                entryGrid.summary();
                if (entryGrid.getSubEntryGrids() == null) continue;
                for (String subKey : entryGrid.getSubEntryGrids()) {
                    if (this.view.getControl(subKey) == null) continue;
                    ((EntryGrid)this.view.getControl(subKey)).summary();
                }
                continue;
            }
            summaryAll = true;
            break;
        }
        if (summaryAll) {
            Map entities = this.view.getModel().getDataEntityType().getAllEntities();
            if (entities == null || entities.size() == 0) {
                return;
            }
            entities.keySet().forEach(p -> {
                if (entities.get(p) instanceof EntryType && this.view.getControl(p) instanceof EntryGrid) {
                    ((EntryGrid)this.view.getControl(p)).summary();
                }
            });
        }
    }

    private void updateChildren(IDataEntityProperty prop, ChangeData[] changeDatas) {
        List<FieldEdit> edits = this.getChildEdits(prop.getName());
        if (edits.isEmpty()) {
            return;
        }
        if (prop instanceof CurrencyProp || prop instanceof UnitProp || prop instanceof OrgProp) {
            ChangeData changeData;
            ArrayList<FieldEdit> propEdits = new ArrayList<FieldEdit>();
            ArrayList<FieldEdit> controlEdits = new ArrayList<FieldEdit>();
            for (FieldEdit fieldEdit : edits) {
                if (fieldEdit instanceof BasedataPropEdit) {
                    propEdits.add(fieldEdit);
                    continue;
                }
                if (fieldEdit instanceof DateTimeEdit) {
                    propEdits.add(fieldEdit);
                }
                controlEdits.add(fieldEdit);
            }
            if (prop instanceof UnitProp && ((UnitProp)prop).isFollowUnitToChange() && (changeData = changeDatas[0]).getNewValue() != null && changeData.getOldValue() != null) {
                Long newUnitPkid = (Long)((DynamicObject)changeData.getNewValue()).getPkValue();
                Long oldUnitPkId = (Long)((DynamicObject)changeData.getOldValue()).getPkValue();
                StringBuilder errMsg = new StringBuilder();
                UnitConvertHelper.convertQtyByNewUnit((IDataModel)this.view.getModel(), (UnitProp)((UnitProp)prop), (long)newUnitPkid, (long)oldUnitPkId, (int)changeData.getRowIndex(), (StringBuilder)errMsg);
                if (errMsg.length() > 0) {
                    this.view.showErrorNotification(errMsg.toString());
                }
            }
            this.updateFmt(prop, changeDatas, controlEdits);
            this.bindEditData(prop, changeDatas, propEdits);
        } else if (prop instanceof ItemClassTypeProp) {
            this.updateItemClass((ItemClassTypeProp)prop, changeDatas, edits);
        } else if (prop instanceof MaterielProp && FmtInfoUtils.applyMaterialPrecision((IDataModel)this.view.getModel())) {
            ArrayList<FieldEdit> fmtEdits = new ArrayList<FieldEdit>();
            for (FieldEdit fieldEdit : edits) {
                if (!(fieldEdit instanceof UnitEdit)) continue;
                for (Control control : this.getChildEdits(fieldEdit.getFieldKey())) {
                    if (!(control instanceof QtyEdit)) continue;
                    fmtEdits.add((FieldEdit)control);
                }
            }
            this.setFmtInfo(prop, changeDatas, edits);
            this.sendUpdateFmtAction(prop, changeDatas, fmtEdits);
            this.bindEditData(prop, changeDatas, edits);
        } else if (prop instanceof BasedataProp && CollectionUtils.isNotEmpty(edits)) {
            this.setFmtInfo(prop, changeDatas, edits);
            this.bindEditData(prop, changeDatas, edits);
        } else {
            this.bindEditData(prop, changeDatas, edits);
        }
    }

    private void updateDelegate(IDataEntityProperty prop, ChangeData[] changeDatas) {
        List edits = this.getDelegateOrgs(prop.getName());
        if (edits.isEmpty()) {
            return;
        }
        int currentParentRowIndex = -1;
        if (prop.getParent() instanceof SubEntryType) {
            currentParentRowIndex = this.view.getModel().getEntryCurrentRowIndex(prop.getParent().getParent().getName());
        }
        for (ChangeData o : changeDatas) {
            if (currentParentRowIndex >= 0 && currentParentRowIndex != o.getParentRowIndex()) continue;
            IDefValueProvider defValueProvider = (IDefValueProvider)this.view.getModel().getService(IDefValueProvider.class);
            for (int i = 0; i < edits.size(); ++i) {
                int index;
                int count;
                if (defValueProvider == null) continue;
                OrgProp po = (OrgProp)((FieldEdit)edits.get(i)).getProperty();
                Object defOrgValue = defValueProvider.getOrgDefValue(this.view.getModel(), po, o);
                if (defOrgValue == null) continue;
                if (po.getParent() instanceof SubEntryType && prop.getParent() instanceof SubEntryType) {
                    this.view.getModel().setValue(((FieldEdit)edits.get(i)).getKey(), defOrgValue, o.getRowIndex(), o.getParentRowIndex());
                    continue;
                }
                if (po.getParent() instanceof SubEntryType && prop.getParent() instanceof EntryType) {
                    count = this.view.getModel().getEntryRowCount(po.getParent().getName());
                    for (index = 0; index < count; ++index) {
                        this.view.getModel().setValue(((FieldEdit)edits.get(i)).getKey(), defOrgValue, index, o.getParentRowIndex());
                    }
                    continue;
                }
                if (po.getParent() instanceof EntryType && prop.getParent() instanceof EntryType) {
                    this.view.getModel().setValue(((FieldEdit)edits.get(i)).getKey(), defOrgValue, o.getRowIndex(), o.getParentRowIndex());
                    continue;
                }
                if (po.getParent() instanceof EntryType && prop.getParent() instanceof EntityType) {
                    count = this.view.getModel().getEntryRowCount(po.getParent().getName());
                    for (index = 0; index < count; ++index) {
                        this.view.getModel().setValue(((FieldEdit)edits.get(i)).getKey(), defOrgValue, index, o.getParentRowIndex());
                    }
                    continue;
                }
                if (!(po.getParent() instanceof EntityType) || !(prop.getParent() instanceof EntityType)) continue;
                this.view.getModel().setValue(po.getName(), defOrgValue);
            }
        }
    }

    private void updateItemClass(ItemClassTypeProp prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        block12: {
            block13: {
                block11: {
                    if (!(prop.getParent() instanceof MainEntityType)) break block11;
                    for (FieldEdit edit : edits) {
                        if (StringUtils.isBlank((CharSequence)edit.getEntryKey())) {
                            for (ChangeData o : changeDatas) {
                                BindingContext bctx = new BindingContext((Object)o.getDataEntity());
                                edit.bindData(bctx);
                            }
                            continue;
                        }
                        DynamicObjectCollection rows = this.view.getModel().getEntryEntity(edit.getEntryKey());
                        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
                            BindingContext bctx = new BindingContext(rows.get(rowIndex), rowIndex);
                            edit.bindData(bctx);
                        }
                    }
                    break block12;
                }
                if (!(prop.getParent() instanceof SubEntryType)) break block13;
                int currentParentRowIndex = this.view.getModel().getEntryCurrentRowIndex(prop.getParent().getParent().getName());
                for (ChangeData o : changeDatas) {
                    if (currentParentRowIndex >= 0 && currentParentRowIndex != o.getParentRowIndex()) continue;
                    BindingContext bctx = new BindingContext((Object)o.getDataEntity(), o.getRowIndex());
                    for (int i = 0; i < edits.size(); ++i) {
                        edits.get(i).bindData(bctx);
                    }
                }
                break block12;
            }
            if (!(prop.getParent() instanceof EntryType)) break block12;
            for (FieldEdit edit : edits) {
                if (StringUtils.equals((CharSequence)prop.getParent().getName(), (CharSequence)edit.getEntryKey())) {
                    for (ChangeData o : changeDatas) {
                        BindingContext bctx = new BindingContext((Object)o.getDataEntity(), o.getRowIndex());
                        edit.bindData(bctx);
                    }
                    continue;
                }
                if (!prop.getParent().getProperties().containsKey((Object)edit.getEntryKey())) continue;
                int currentParentRowIndex = this.view.getModel().getEntryCurrentRowIndex(prop.getParent().getName());
                for (ChangeData o : changeDatas) {
                    if (currentParentRowIndex != o.getRowIndex()) continue;
                    DynamicObjectCollection subEntryRows = o.getDataEntity().getDynamicObjectCollection(edit.getEntryKey());
                    for (int rowIndex = 0; rowIndex < subEntryRows.size(); ++rowIndex) {
                        BindingContext bctx = new BindingContext(subEntryRows.get(rowIndex), rowIndex);
                        edit.bindData(bctx);
                    }
                }
            }
        }
    }

    private void updateFmt(IDataEntityProperty prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        this.setFmtInfo(prop, changeDatas, edits);
        this.sendUpdateFmtAction(prop, changeDatas, edits);
    }

    private void sendUpdateFmtAction(IDataEntityProperty prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        for (ChangeData o : changeDatas) {
            List grids;
            HashMap<String, ArrayList<String>> gridFmtMapping = new HashMap<String, ArrayList<String>>();
            for (FieldEdit fieldEdit : edits) {
                if (fieldEdit.getEntryKey() != null) {
                    if (prop.getParent().getName().equals(fieldEdit.getEntryKey())) {
                        ArrayList<String> fields = (ArrayList<String>)gridFmtMapping.get(fieldEdit.getEntryKey());
                        if (fields == null) {
                            fields = new ArrayList<String>();
                            gridFmtMapping.put(fieldEdit.getEntryKey(), fields);
                        }
                        fields.add(fieldEdit.getFieldKey());
                        continue;
                    }
                    grids = this.getEdits(fieldEdit.getEntryKey());
                    for (EntryGrid grid : grids) {
                        grid.updateColFmt(fieldEdit.getFieldKey());
                    }
                    continue;
                }
                this.getViewProxy().addAction("updateFmt", (Object)fieldEdit.getKey());
            }
            for (Map.Entry entry : gridFmtMapping.entrySet()) {
                grids = this.getEdits((String)entry.getKey());
                for (EntryGrid grid : grids) {
                    grid.updateCellFmt((List)entry.getValue(), o.getRowIndex());
                }
            }
        }
    }

    private void bindEditData(IDataEntityProperty prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        int currentParentRowIndex = -1;
        if (prop.getParent() instanceof SubEntryType) {
            currentParentRowIndex = this.view.getModel().getEntryCurrentRowIndex(prop.getParent().getParent().getName());
        }
        for (ChangeData o : changeDatas) {
            if (currentParentRowIndex >= 0 && currentParentRowIndex != o.getParentRowIndex()) continue;
            for (int i = 0; i < edits.size(); ++i) {
                FieldEdit edit = edits.get(i);
                this.bindEditData(prop, edit, o);
            }
        }
    }

    private void bindEditData(IDataEntityProperty prop, FieldEdit edit, ChangeData o) {
        if (StringUtils.isNotBlank((CharSequence)edit.getEntryKey())) {
            if (prop.getParent().getName().equals(edit.getEntryKey())) {
                edit.bindData(new BindingContext((Object)o.getDataEntity(), o.getRowIndex(), o.getParentRowIndex()));
            } else {
                IDataEntityType parent = edit.getProperty().getParent();
                if (parent.getParent() != null) {
                    if (prop.getParent().getName().equals(parent.getParent().getName())) {
                        DynamicObjectCollection rows = this.view.getModel().getEntryEntity(parent.getName());
                        int i = 0;
                        for (DynamicObject row : rows) {
                            edit.bindData(new BindingContext((Object)row, i++));
                        }
                    } else {
                        DynamicObjectCollection subEntryRows = this.view.getModel().getEntryEntity(parent.getName());
                        if (subEntryRows == null) {
                            return;
                        }
                        int j = 0;
                        for (DynamicObject subEntryRow : subEntryRows) {
                            edit.bindData(new BindingContext((Object)subEntryRow, j++));
                        }
                    }
                }
            }
        } else {
            edit.bindData(new BindingContext((Object)o.getDataEntity(), o.getRowIndex()));
        }
    }

    private void setFmtInfo(IDataEntityProperty prop, ChangeData[] changeDatas, List<FieldEdit> edits) {
        HashMap entryFields = new HashMap();
        for (FieldEdit fieldEdit : edits) {
            if (!(fieldEdit instanceof DecimalEdit) && (!(fieldEdit instanceof DateTimeEdit) || fieldEdit instanceof DateEdit) && !(fieldEdit instanceof UnitEdit) && !(fieldEdit instanceof BasedataPropEdit)) continue;
            if (entryFields.get(fieldEdit.getEntryKey()) == null) {
                ArrayList<FieldEdit> list = new ArrayList<FieldEdit>();
                list.add(fieldEdit);
                entryFields.put(fieldEdit.getEntryKey(), list);
                continue;
            }
            ((List)entryFields.get(fieldEdit.getEntryKey())).add(fieldEdit);
        }
        for (Map.Entry entry : entryFields.entrySet()) {
            if (entry.getKey() == null) {
                DynamicObject object = (DynamicObject)changeDatas[changeDatas.length - 1].getNewValue();
                if (prop instanceof MaterielProp) {
                    for (FieldEdit edit : (List)entry.getValue()) {
                        String unitKey = edit.getFieldKey();
                        DynamicObject unitObj = changeDatas[changeDatas.length - 1].getDataEntity().getDynamicObject(unitKey);
                        if (!(edit.getProperty() instanceof UnitProp)) continue;
                        this.getViewProxy().setNumFmtInfo(unitKey, FmtInfoUtils.getUnitFmt((UnitProp)((UnitProp)edit.getProperty()), (DynamicObject)unitObj, (DynamicObject)object));
                    }
                    continue;
                }
                if (prop instanceof CurrencyProp) {
                    this.getViewProxy().setNumFmtInfo(prop.getName(), FmtInfoUtils.getCurrencyFmt((DynamicObject)object));
                    continue;
                }
                if (object != null) {
                    if (prop instanceof UnitProp) {
                        DynamicObject materielObj = null;
                        String materielKey = ((UnitProp)prop).getMaterielField();
                        if (StringUtils.isNotBlank((CharSequence)materielKey)) {
                            materielObj = changeDatas[changeDatas.length - 1].getDataEntity().getDynamicObject(materielKey);
                        }
                        this.getViewProxy().setNumFmtInfo(prop.getName(), FmtInfoUtils.getUnitFmt((UnitProp)((UnitProp)prop), (DynamicObject)object, materielObj));
                        continue;
                    }
                    if (!(prop instanceof OrgProp)) continue;
                    this.getViewProxy().setTimeZone(prop.getName(), FmtInfoUtils.getTimeZone((DynamicObject)object));
                    continue;
                }
                if (prop instanceof OrgProp) {
                    this.getViewProxy().setTimeZone(prop.getName(), new HashMap());
                    continue;
                }
                if (prop instanceof UnitProp) {
                    this.getViewProxy().setNumFmtInfo(prop.getName(), null);
                    continue;
                }
                this.getViewProxy().setNumFmtInfo(prop.getName(), new HashMap());
                continue;
            }
            if (prop instanceof MaterielProp) {
                for (FieldEdit fieldEdit : (List)entry.getValue()) {
                    List grids = this.getEdits(fieldEdit.getEntryKey());
                    grids.stream().distinct().collect(Collectors.toList());
                    ChangeData[] changeDataArray = changeDatas;
                    int n = changeDataArray.length;
                    for (int i = 0; i < n; ++i) {
                        ChangeData o = changeDataArray[i];
                        for (EntryGrid grid : grids) {
                            if (prop.getParent() == null) continue;
                            if (StringUtils.equals((CharSequence)grid.getKey(), (CharSequence)prop.getParent().getName())) {
                                grid.setUnitRowFmtInfo((MaterielProp)prop, o.getRowIndex());
                                continue;
                            }
                            grid.setUnitRowFmtInfo((MaterielProp)prop, -1);
                        }
                    }
                }
                continue;
            }
            List grids = this.getEdits((String)entry.getKey());
            boolean undateRowFmt = false;
            if (prop instanceof UnitProp) {
                if (FmtInfoUtils.applyMaterialPrecision((IDataModel)this.view.getModel())) {
                    undateRowFmt = true;
                }
            } else if (!(prop instanceof CurrencyProp) && prop instanceof BasedataProp) {
                undateRowFmt = true;
            }
            for (ChangeData o : changeDatas) {
                for (EntryGrid grid : grids) {
                    if (undateRowFmt) {
                        grid.setRowFmtInfo(prop, (DynamicObject)o.getNewValue(), o.getRowIndex());
                        if (!(prop instanceof OrgProp)) continue;
                        grid.setFmtInfo(prop, (DynamicObject)o.getNewValue());
                        continue;
                    }
                    grid.setFmtInfo(prop, (DynamicObject)o.getNewValue());
                }
            }
        }
    }

    private boolean isNeedUpdateView(EntryGrid grid, int rowIndex, int[] delRows) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        int rowCount = model.getFilterEntryRowCount(grid.getEntryKey());
        int forceSplitRows = model.getEntryPageInfo(grid.getEntryKey()).getPageSize();
        if (!grid.isNeedPaged()) {
            return false;
        }
        AbstractGrid.GridState entryState = grid.getEntryState();
        if (entryState.getPageRows() == 0 && grid.getPageRow() != 0) {
            entryState.setPageRows(grid.getPageRow());
        } else if (entryState.getPageRows() == 0 && grid.getPageRow() == 0) {
            entryState.setPageRows(forceSplitRows);
        }
        if (rowCount <= entryState.getPageRows()) {
            if (entryState.getCurrentPageIndex() > 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
                return true;
            }
            if (delRows != null) {
                int delRowCount = delRows.length;
                if (delRowCount + rowCount > entryState.getPageRows()) {
                    return true;
                }
                for (FieldEdit fieldEdit : grid.getFieldEdits()) {
                    if (!fieldEdit.isDesensitizeField()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        int pageCount = rowCount / entryState.getPageRows() + (rowCount % entryState.getPageRows() > 0 ? 1 : 0);
        if (entryState.getCurrentPageIndex() > pageCount) {
            entryState.setCurrentPageIndex(Integer.valueOf(pageCount == 0 ? 1 : pageCount));
            return true;
        }
        ArrayList<Integer> objects = new ArrayList<Integer>(1);
        objects.add(rowIndex);
        List filterIndex = model.getFilterIndexByRowKeys(grid.getKey(), objects);
        rowIndex = CollectionUtils.isNotEmpty((Collection)filterIndex) ? (Integer)filterIndex.get(0) : -1;
        if (entryState.getCurrentPageIndex() == pageCount && rowIndex >= (pageCount - 1) * entryState.getPageRows() && rowIndex < pageCount * entryState.getPageRows() && rowCount != pageCount * entryState.getPageRows()) {
            return false;
        }
        if (grid instanceof CardEntry && this.view instanceof IMobileView) {
            return false;
        }
        int currPageIndex = (rowIndex + 1) / entryState.getPageRows() + ((rowIndex + 1) % entryState.getPageRows() > 0 ? 1 : 0);
        if (this.isFirstRowInEntryData(grid.getEntryKey(), rowIndex + 1)) {
            ++currPageIndex;
        }
        entryState.setCurrentPageIndex(Integer.valueOf(currPageIndex == 0 ? 1 : currPageIndex));
        return true;
    }

    private void dataRowChange(EntryGrid grid, boolean isNeedUpdateView, Consumer<EntryGrid> consumer) {
        if (isNeedUpdateView) {
            this.view.updateView(grid.getKey());
        } else {
            consumer.accept(grid);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp prop = e.getEntryProp();
        List grids = this.getEdits(prop.getName());
        HashSet<String> ctlNumber = new HashSet<String>();
        HashSet<String> needUpdateViewGridKeys = new HashSet<String>(4);
        for (RowDataEntity rowObj : e.getRowDataEntities()) {
            BindingContext bindCtx = new BindingContext(rowObj.getDataEntity().getDataEntityType(), rowObj.getDataEntity(), rowObj.getRowIndex());
            Consumer<EntryGrid> consumer = grid -> {
                List rowValues = grid.getRowBindValue(bindCtx);
                if (e.getInsertRow() == -1) {
                    this.getViewProxy().appendRow(grid.getKey(), rowValues);
                } else {
                    this.getViewProxy().insertRow(grid.getKey(), e.getInsertRow(), rowValues, e.isInsertBehind());
                }
            };
            for (EntryGrid grid2 : grids) {
                if (grid2.isStopUpdateCell()) continue;
                for (IDataEntityProperty entryproperty : prop.getItemType().getProperties()) {
                    String key;
                    DynamicObject o;
                    if (!(entryproperty instanceof CurrencyProp) && !(entryproperty instanceof UnitProp) || (o = (DynamicObject)entryproperty.getValueFast((Object)rowObj.getDataEntity())) == null || !ctlNumber.add(key = grid2.getKey() + "." + entryproperty.getClass().getName() + "." + o.get("number"))) continue;
                    grid2.setNumFmtInfo(entryproperty, o);
                }
                boolean needUpdateView = this.isNeedUpdateView(grid2, rowObj.getRowIndex(), null);
                if (needUpdateView) {
                    needUpdateViewGridKeys.add(grid2.getKey());
                } else {
                    this.dataRowChange(grid2, needUpdateView, consumer);
                }
                grid2.summary(true);
            }
        }
        if (CollectionUtils.isNotEmpty(needUpdateViewGridKeys)) {
            for (String gridKey : needUpdateViewGridKeys) {
                this.view.updateView(gridKey);
            }
        }
        FormRuleContainer ruleContainber = (FormRuleContainer)((Object)this.view.getService(RuleContainer.class));
        List<RowDataEntity> rowEntities = Arrays.asList(e.getRowDataEntities());
        FormRuleExecuteContext ctx = new FormRuleExecuteContext(this.view);
        ruleContainber.raiseItemAdded(prop.getItemType(), rowEntities, ctx);
        ruleContainber.raiseInitialized(prop.getItemType(), rowEntities, ctx);
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        List grids = this.getEdits(e.getEntryProp().getName());
        for (EntryGrid grid : grids) {
            this.view.updateView(grid.getKey());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        List grids = this.getEdits(e.getEntryProp().getName());
        Consumer<EntryGrid> consumer = grid -> this.getViewProxy().deleteRows(grid.getKey(), e.getRowIndexs(), grid.getModel().getEntryRowCount(grid.getEntryKey()));
        for (EntryGrid grid2 : grids) {
            if (grid2.isStopUpdateCell() || e.getRowIndexs().length == 0) continue;
            int rowIndex = e.getRowIndexs()[0] - 1;
            if (e.getPreviousRowKey() > -1) {
                rowIndex = e.getPreviousRowKey() - 1;
            }
            boolean isNeededUpdateView = this.isNeedUpdateView(grid2, rowIndex, e.getRowIndexs());
            this.dataRowChange(grid2, isNeededUpdateView, consumer);
            if (!grid2.isStopSelectRow()) {
                if (e.getPreviousRowKey() == -2) {
                    if (this.isFirstRowInEntryData(grid2.getEntryKey(), rowIndex + 1)) {
                        grid2.selectRows(-1);
                    } else {
                        grid2.selectRows(e.getRowIndexs()[0] - 1);
                    }
                } else if (e.getPreviousRowKey() == -1) {
                    grid2.selectRows(-1);
                } else {
                    grid2.selectRows(e.getPreviousRowKey() - 1);
                }
                List strKeys = grid2.getSubEntryGrids();
                if (strKeys != null) {
                    for (String subGridKey : strKeys) {
                        this.view.updateView(subGridKey);
                    }
                }
            }
            grid2.summary(true);
        }
    }

    public void beforeAddRow(BeforeAddRowEventArgs arg0) {
    }

    public void beforeDeleteEntry(BeforeDeleteEntryEventArgs arg0) {
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs arg0) {
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        IClientViewProxy proxy = this.getViewProxy();
        List grids = this.getEdits(entryKey);
        for (EntryGrid grid : grids) {
            if (grid instanceof TreeEntryGrid || grid instanceof TreeSubEntryGrid) {
                grid.bindData(null);
                int[] selectRows = new int[e.getRowIndexs().length];
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    selectRows[i] = e.getRowIndexs()[i] - (Integer)e.getSteps().get(i);
                }
                grid.selectRows(selectRows, selectRows[0]);
                continue;
            }
            boolean isNeedReBindData = false;
            for (int index = 0; index < e.getRowIndexs().length; ++index) {
                if (!grid.isSplitPage() || grid.getEntryState().getPageRows() == 0 || e.getRowIndexs()[index] % grid.getEntryState().getPageRows() != 0) continue;
                isNeedReBindData = true;
                break;
            }
            if (isNeedReBindData) {
                grid.bindData(null);
                continue;
            }
            proxy.moveUp(grid.getKey(), e.getRowIndexs());
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        IClientViewProxy proxy = this.getViewProxy();
        List grids = this.getEdits(entryKey);
        for (EntryGrid grid : grids) {
            if (grid instanceof TreeEntryGrid || grid instanceof TreeSubEntryGrid) {
                grid.bindData(null);
                int[] selectRows = new int[e.getRowIndexs().length];
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    int stepIndex = e.getSteps().size() - i - 1;
                    stepIndex = stepIndex >= 0 && stepIndex < e.getSteps().size() ? stepIndex : i;
                    selectRows[i] = e.getRowIndexs()[i] + (Integer)e.getSteps().get(stepIndex);
                }
                grid.selectRows(selectRows, selectRows[0]);
                continue;
            }
            boolean isNeedReBindData = false;
            for (int index = 0; index < e.getRowIndexs().length; ++index) {
                if (!grid.isSplitPage() || grid.getEntryState().getPageRows() == 0 || (e.getRowIndexs()[index] + 1) % grid.getEntryState().getPageRows() != 0) continue;
                isNeedReBindData = true;
                break;
            }
            if (isNeedReBindData) {
                grid.bindData(null);
                continue;
            }
            proxy.moveDown(grid.getKey(), e.getRowIndexs(), e.getRowCount());
        }
    }

    public void afterSetEntryTop(AfterMoveEntryEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        List grids = this.getEdits(entryKey);
        if (CollectionUtils.isEmpty(grids)) {
            return;
        }
        EntryGrid grid = (EntryGrid)grids.get(0);
        if (grid instanceof TreeEntryGrid || grid instanceof TreeSubEntryGrid) {
            grid.bindData(null);
            int[] selectRows = new int[e.getRowIndexs().length];
            for (int i = 0; i < e.getRowIndexs().length; ++i) {
                selectRows[i] = e.getRowIndexs()[i] - (Integer)e.getSteps().get(i);
            }
            grid.selectRows(selectRows, selectRows[0]);
        } else {
            IClientViewProxy proxy = this.getViewProxy();
            proxy.moveTop(entryKey, e.getRowIndexs(), e.getRowCount());
        }
    }

    public void afterSetEntryBottom(AfterMoveEntryEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        List grids = this.getEdits(entryKey);
        if (CollectionUtils.isEmpty(grids)) {
            return;
        }
        EntryGrid grid = (EntryGrid)grids.get(0);
        if (grid instanceof TreeEntryGrid || grid instanceof TreeSubEntryGrid) {
            grid.bindData(null);
            int[] selectRows = new int[e.getRowIndexs().length];
            for (int i = 0; i < e.getRowIndexs().length; ++i) {
                selectRows[i] = e.getRowIndexs()[i] + (Integer)e.getSteps().get(i);
            }
            grid.selectRows(selectRows, selectRows[0]);
        } else {
            IClientViewProxy proxy = this.getViewProxy();
            proxy.moveBottom(entryKey, e.getRowIndexs(), e.getRowCount());
        }
    }

    private <T extends Control> List<T> getEdits(String propertyName) {
        List sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl((String)this.view.getFormShowParameter().getFormId(), (String)"_bindermap_");
        }
        ArrayList<Control> fes = new ArrayList<Control>();
        Control ctl = this.view.getControl(propertyName);
        if (ctl != null) {
            if (ctl instanceof FieldEdit) {
                if (StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)ctl).getFieldKey(), (CharSequence)propertyName)) {
                    fes.add(ctl);
                }
            } else if (ctl instanceof EntryGrid) {
                if (StringUtils.equalsIgnoreCase((CharSequence)((EntryGrid)ctl).getEntryKey(), (CharSequence)propertyName)) {
                    fes.add(ctl);
                }
            } else {
                fes.add(ctl);
            }
        }
        if (this.binderMap != null && (sf = (List)this.binderMap.getMap().get(propertyName.toLowerCase())) != null) {
            for (String key : sf) {
                Control sfCtl = this.view.getControl(key);
                if (sfCtl == null) continue;
                fes.add(this.view.getControl(key));
            }
        }
        return fes;
    }

    private <T extends Control> List<T> getChildEdits(String propertyName) {
        List sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl((String)this.view.getFormShowParameter().getFormId(), (String)"_bindermap_");
        }
        ArrayList<Control> fes = new ArrayList<Control>();
        if (this.binderMap != null && (sf = (List)this.binderMap.getMap().get(propertyName.toLowerCase() + ".child")) != null) {
            for (String key : sf) {
                if (this.view.getControl(key) == null) continue;
                fes.add(this.view.getControl(key));
            }
        }
        return fes;
    }

    private <T extends Control> List<T> getDelegateOrgs(String propertyName) {
        List sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl((String)this.view.getFormShowParameter().getFormId(), (String)"_bindermap_");
        }
        ArrayList<Control> fes = new ArrayList<Control>();
        if (this.binderMap != null && (sf = (List)this.binderMap.getMap().get(propertyName.toLowerCase() + ".delegate")) != null) {
            for (String key : sf) {
                if (this.view.getControl(key) == null) continue;
                fes.add(this.view.getControl(key));
            }
        }
        return fes;
    }

    private void raiseItemAdded(IDataModel model) {
        ArrayList<RowDataEntity> dataEntities = new ArrayList<RowDataEntity>();
        dataEntities.add(new RowDataEntity(0, model.getDataEntity(true)));
        FormRuleContainer ruleContaiber = (FormRuleContainer)((Object)this.view.getService(RuleContainer.class));
        ruleContaiber.raiseItemAdded((IDataEntityType)model.getDataEntityType(), dataEntities, new FormRuleExecuteContext(this.view));
    }

    private boolean isFirstRowInEntryData(String entryKey, int rowIndex) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        EntryInfo entryInfo = model.getEntryPageInfo(entryKey);
        return entryInfo != null && entryInfo.getRowCount() != null && entryInfo.getStartRowIndex() > 0 && entryInfo.getStartRowIndex() == rowIndex;
    }
}

