/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.ai.AISystemTokenService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.DBVersion;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ClientCallbackListener;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ICtsyShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.aicommand.AICommandFactory;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.TimerElapsedArgs;
import kd.bos.form.field.ExRateConfigUtil;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.TextAreaEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.PageType;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.script.debug.DebugConfig;
import kd.bos.service.ServiceFactory;
import kd.bos.service.tips.IHotTipsService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.ctsy.CtsyApiDispatchServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.utils.DBDateUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.log4j.Logger;

@SdkPublic
public class FormController
implements IFormController {
    private static final String SPAN_TYPE_NAME = "formview";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String MODELTYPE = "modeltype";
    private static Logger log = Logger.getLogger(FormController.class);
    private static final String CSRFTOKEN_ = "_csrftoken_";
    private static final String LASTCSRFTOKEN_ = "_lastcsrftoken_";
    private static final String[] csrfExceptionalFormId = new String[]{"bos_devportal_bizpagelist", "bos_devportal_bizapplist", "bos_devp_kde"};
    protected IFormView view;
    protected boolean bRegListner = false;
    private String questCsrfToken;
    private boolean needUpdateCsrfToken;
    private static final String NUMBER = "number";
    DistributeSessionlessCache redisCache;
    private static boolean needCheckCsrf = false;
    private static int checkCsrfTimeout = 10000;
    private static String need_check_csrf = "is_need_check_csrf_page";
    private static String need_check_csrf_timeout = "is_need_check_csrf_page_timeout";
    private static String need_check_csrf_log = "is_need_check_csrf_page_debuglog";

    public FormController(IFormView view) {
        this.view = view;
        this.redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
    }

    public static boolean isNeedCheckCsrf() {
        return needCheckCsrf;
    }

    public static int getCheckCsrfTimeout() {
        return checkCsrfTimeout;
    }

    private IDataModel getModel() {
        return (IDataModel)this.view.getService(IDataModel.class);
    }

    protected FormViewPluginProxy getPluginProxy() {
        return (FormViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
    }

    public void getAIAccessToken(Boolean regen) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.getAIAccessToken");){
            if (span.isRealtime()) {
                span.addTag("regen", String.valueOf(regen));
            }
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            String aiServer = AISystemTokenService.getPublicParameter((String)"aiserver");
            String authUrl = String.format("%s/oauth/auth", aiServer);
            String appId = AISystemTokenService.getPublicParameter((String)"aiappid");
            String privateKey = AISystemTokenService.getPublicParameter((String)"aiprivatekey");
            if (StringUtils.isBlank((CharSequence)authUrl) || StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)privateKey)) {
                this.getView().showMessage(ResManager.loadKDString((String)"ai \u5e73\u53f0\u5bf9\u5e94\u53c2\u6570\u672a\u914d\u7f6e", (String)"FormController_7", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                return;
            }
            proxy.addAction("setAIToken", (Object)AISystemTokenService.getToken((boolean)regen));
        }
    }

    @Override
    public void postData(List<Map<String, Object>> postDatas) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.postDatas");){
            if (postDatas == null) {
                return;
            }
            if (span.isRealtime()) {
                span.addTag("postDatas", SerializationUtils.toJsonString(postDatas));
            }
            if (postDatas.size() > 0) {
                Map<String, Object> controlStates = postDatas.get(0);
                this.postControlState(controlStates);
                if (postDatas.size() > 1) {
                    List fieldStates = (List)((Object)postDatas.get(1));
                    this.postFieldState(fieldStates);
                    if (postDatas.size() > 2) {
                        Map<String, Object> childFormStates = postDatas.get(2);
                        this.postChildFormSate(childFormStates);
                    }
                }
            }
        }
    }

    public void executeAICommand(Map<String, Object> aicmd) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.executeAICommand");){
            if (span.isRealtime()) {
                span.addTag("aicmd", aicmd == null ? "null" : SerializationUtils.toJsonString(aicmd));
            }
            String actionName = null;
            Map parameter = null;
            if (aicmd != null) {
                actionName = (String)aicmd.get("action");
                parameter = (Map)aicmd.get("parameters");
            }
            if (StringUtils.isNotBlank(actionName) && parameter != null) {
                AICommandParameter aiParameter = new AICommandParameter();
                aiParameter.setPara(parameter);
                AICommandFactory.createCmdInvoker((String)actionName, (AICommandParameter)aiParameter, (IFormView)this.view).invoke();
            } else {
                this.view.showErrorNotification(ResManager.loadKDString((String)"AI\u547d\u4ee4\u53c2\u6570\u6709\u8bef\uff01", (String)"FormController_0", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            }
        }
    }

    private void postChildFormSate(Map<String, Object> childFormStates) {
        if (childFormStates == null || childFormStates.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> childFormState : childFormStates.entrySet()) {
            String pageId = childFormState.getKey();
            SessionManager current = SessionManager.getCurrent();
            FormShowParameter showParameter = current.getFormShowParameter(pageId);
            if (showParameter == null) continue;
            List postDatas = (List)childFormState.getValue();
            if (showParameter instanceof ICtsyShowParameter) {
                this.relayToRemoteTenantRequest(showParameter, postDatas);
            } else {
                DispatchServiceHelper.invokeBOSService((String)showParameter.getServiceAppId(), (String)"FormService", (String)"postChildFormStates", (Object[])new Object[]{pageId, postDatas});
            }
            current.clearLocalPageCache(pageId);
        }
    }

    private void postControlState(Map<String, Object> controlStates) {
        if (controlStates == null) {
            return;
        }
        if (controlStates.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> postData : controlStates.entrySet()) {
            Control control = this.view.getControl(postData.getKey());
            if (postData.getKey().equals(CSRFTOKEN_) || control == null) continue;
            Object value = control.decode(postData.getValue());
            this.view.getControl(postData.getKey()).postBack(value);
        }
    }

    private void postFieldState(List<Map<String, Object>> fieldStates) {
        boolean isTrim = this.isTrim();
        for (int i = 0; i < fieldStates.size(); ++i) {
            Object parentRow;
            FieldEdit edit;
            Map<String, Object> fieldState = fieldStates.get(i);
            String key = (String)fieldState.get("k");
            Object rowKey = fieldState.get("r");
            int rowIndex = 0;
            if (rowKey != null && StringUtils.isNotEmpty((CharSequence)rowKey.toString())) {
                rowIndex = (Integer)rowKey;
            }
            Object value = fieldState.get("v");
            if (key == null || (edit = this.getFieldEdit(key)) == null) continue;
            if (isTrim) {
                value = this.trim(edit, value);
            }
            int pRow = (parentRow = fieldState.get("pr")) == null ? -1 : (Integer)parentRow;
            BeforeFieldPostBackEvent e = new BeforeFieldPostBackEvent((Object)edit, value, rowIndex, pRow);
            e.setKey(key);
            this.getPluginProxy().fireBeforeFieldPostBack(e);
            if (e.isCancel()) continue;
            edit.postBack(value, rowIndex, pRow);
        }
    }

    private boolean isTrim() {
        try {
            Object isTrim;
            Map cache = ParameterReader.loadPublicParameterFromCache();
            if (cache.size() > 0 && (isTrim = cache.get("istrim")) != null) {
                return (Boolean)isTrim;
            }
        }
        catch (Throwable ex) {
            log.error((Object)"\u83b7\u53d6\u516c\u5171\u53c2\u6570\u5931\u8d25.", ex);
        }
        return false;
    }

    private Object trim(FieldEdit edit, Object value) {
        String name;
        boolean isLargeTextEdit = LargeTextEdit.class.isAssignableFrom(edit.getClass());
        boolean isTextAreaEdit = TextAreaEdit.class.isAssignableFrom(edit.getClass());
        boolean isIdeLargeText = false;
        IDataModel model = edit.getModel();
        if (model instanceof FormDataModel && "ide_largertextedit".equals(name = ((FormDataModel)model).getMainEntityType().getName())) {
            isIdeLargeText = true;
        }
        if (edit instanceof TextEdit && !isLargeTextEdit && !isTextAreaEdit && !isIdeLargeText) {
            if (value == null) {
                return null;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    map.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString().trim());
                }
                return map;
            }
            if (value instanceof String) {
                return value.toString().trim();
            }
            return value;
        }
        return value;
    }

    private FieldEdit getFieldEdit(String key) {
        FieldEdit fieldEdit = null;
        Control control = this.view.getControl(key);
        if (control instanceof FieldEdit) {
            fieldEdit = (FieldEdit)control;
        }
        return fieldEdit;
    }

    protected FieldEdit getFieldEdit(String key, int rowIndex) {
        return (FieldEdit)this.view.getControl(key);
    }

    public void clientCallBack(String name) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.clientCallBack");){
            span.addTag("name", name);
            ClientCallBackEvent e = new ClientCallBackEvent((Object)this.getView(), name);
            this.getPluginProxy().fireClientCallBack(e);
        }
    }

    public void clientCallBack(String name, Map param) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.clientCallBack");){
            span.addTag("name", name);
            if (span.isRealtime()) {
                span.addTag("param", param == null ? "null" : SerializationUtils.toJsonString((Object)param));
            }
            ClientCallBackEvent e = new ClientCallBackEvent((Object)this.getView(), name, param);
            this.getPluginProxy().fireClientCallBack(e);
        }
    }

    @Override
    public void loadData() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.loadData", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            IDataModel model = this.getModel();
            model.beginInit();
            this.initModelContextVariable(this.getView().getFormShowParameter(), model);
            this.createModelData(model);
            ((FormDataModel)model).setCacheExpireAfter(true);
            this.view.updateView();
            model.endInit();
            if (this.getView().getPageId().equals(this.getView().getFormShowParameter().getRootPageId()) && RequestContext.get().getDebugInfo() == null) {
                double intervalTime;
                String key = "bos.form.interval.time";
                String value = System.getProperty(key);
                if (value == null || value.isEmpty()) {
                    value = "00";
                }
                try {
                    intervalTime = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    intervalTime = 60.0;
                }
                List versionInfos = IndustryVersionServiceHelper.getVersionInfos();
                IndustryVersionInfo bizVersion = null;
                IndustryVersionInfo bosVersion = null;
                String dbVer = "";
                String bosVer = "BOS_V";
                String bizVer = "BIZ_V";
                if (versionInfos == null || versionInfos.isEmpty()) {
                    dbVer = DBVersion.getVer();
                    bosVer = bosVer + dbVer;
                    bizVer = bizVer + dbVer;
                } else {
                    for (IndustryVersionInfo version : versionInfos) {
                        if ("cosmic_bos".equals(version.getProductNumber())) {
                            bosVersion = version;
                            continue;
                        }
                        bizVersion = version;
                    }
                    bosVer = bosVer + (bosVersion == null ? (bizVersion == null ? "" : bizVersion.getVersion()) : bosVersion.getVersion());
                    bizVer = bizVer + (bizVersion == null ? (bosVersion == null ? "" : bosVersion.getVersion()) : bizVersion.getVersion());
                }
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("pv", String.format("%s,%s", bosVer, bizVer));
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setHomeConfig", config);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setInterval", (Object)intervalTime);
            }
            ExRateConfigUtil.sendExRateConfigAction((IFormView)this.getView());
            this.createCsrfToken();
            this.sendHotTips();
        }
    }

    protected void sendHotTips() {
        List tipsList;
        IHotTipsService hotTipsService = (IHotTipsService)ServiceFactory.getService(IHotTipsService.class);
        if (hotTipsService.enableHotTips() && (tipsList = hotTipsService.getHotTips(this.getView().getPageId())) != null && !tipsList.isEmpty()) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setTips", (Object)tipsList);
        }
    }

    protected void initModelContextVariable(FormShowParameter parameter, IDataModel model) {
        String permissionItemId;
        String appId = parameter.getAppId();
        if (!StringUtils.isBlank((CharSequence)appId)) {
            model.putContextVariable("CUR_APP_ID", (Object)appId);
            model.putContextVariable("CUR_ENTITY_TYPE_ID", (Object)parameter.getFormId());
        }
        if (StringUtils.isNotBlank((CharSequence)(permissionItemId = parameter.getPermissionItemId()))) {
            model.putContextVariable("CUR_PERMISSION_ITEM_ID", (Object)permissionItemId);
        }
        model.putContextVariable("CUSTOM_PARAM", (Object)parameter.getCustomParams());
        model.putContextVariable("IS_INIT_MODEL", (Object)true);
        model.putContextVariable("DefaultValue_VerifyBDRight", (Object)true);
    }

    public void customEvent(String key, String eventName, String eventArgs) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.customEvent");){
            JSONObject resultMap;
            span.addTag("key", key);
            span.addTag("eventName", eventName);
            span.addTag("eventArgs", eventArgs);
            if ("uploadResultOfCommon".equals(eventName) && (resultMap = (JSONObject)JSON.parse((String)eventArgs)) != null && "error".equals(resultMap.get((Object)"status")) && resultMap.get((Object)"description") instanceof String) {
                this.getView().showErrorNotification((String)resultMap.get((Object)"description"));
            }
            if (eventName.startsWith("QING_ANALYSIS")) {
                this.invokeQingCustomEvent(key, eventName, eventArgs);
            } else {
                this.getPluginProxy().fireCustomEvent(new CustomEventArgs((Object)this.getView(), key, eventName, eventArgs));
            }
        }
    }

    public void customEvent(String key, String eventName, Object eventArgs) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.customEvent");){
            span.addTag("key", key);
            span.addTag("eventName", eventName);
            span.addTag("eventArgs", String.valueOf(eventArgs));
            this.getPluginProxy().fireCustomEvent(new CustomEventArgs((Object)this.getView(), key, eventName, SerializationUtils.toJsonString((Object)eventArgs)));
        }
    }

    private void invokeQingCustomEvent(String key, String eventName, String eventArgs) {
        Control qinganalysisap = this.getView().getControl("qinganalysisap");
        Control qingView = this.getView().getControl("qingview");
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        String methodName = jsonObject.getString("methodName");
        String methodParams = jsonObject.getString("methodParams");
        try {
            if (qingView != null) {
                MethodUtils.invokeMethod((Object)qingView, (String)methodName, (Object)methodParams);
            } else if (qinganalysisap != null) {
                MethodUtils.invokeMethod((Object)qinganalysisap, (String)methodName, (Object)methodParams);
            } else {
                this.getPluginProxy().fireCustomEvent(new CustomEventArgs((Object)this.getView(), key, methodName, methodParams));
            }
        }
        catch (Throwable e) {
            EntityTracer.throwException((Throwable)e);
            throw new KDException(e, BosErrorCode.methodInvocation, new Object[]{e.getMessage()});
        }
    }

    public void timerElapsed() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.timerElapsed");){
            this.getPluginProxy().fireTimerElapsed(new TimerElapsedArgs((Object)this.getView()));
            List<String> pages = SessionManager.getCurrent().getTimerElapsedListener(this.getView().getFormShowParameter().getRootPageId());
            for (String pageId : pages) {
                IFormView view = this.getView().getView(pageId);
                if (view == null) continue;
                FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
                proxy.fireTimerElapsed(new TimerElapsedArgs((Object)view));
                this.getView().sendFormAction(view);
            }
        }
    }

    public void afterConfirm(String callBackId, int returnOption, String customVaule) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.afterConfirm");){
            span.addTag("callBackId", callBackId);
            span.addTag("returnOption", String.valueOf(returnOption));
            span.addTag("customVaule", customVaule);
            IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
            if (cache.get("ConfirmCallBackListener." + callBackId) != null) {
                ConfirmCallBackListener confirmCallBackListener = (ConfirmCallBackListener)SerializationUtils.fromJsonString((String)cache.get("ConfirmCallBackListener." + callBackId), ConfirmCallBackListener.class);
                MessageBoxClosedEvent messageBoxClosedEvent = new MessageBoxClosedEvent((Object)this.view, callBackId, returnOption, customVaule);
                confirmCallBackListener.confirmCallBack(messageBoxClosedEvent);
            }
        }
    }

    public void afterCallClientMethod(String callBackId, Map<String, Object> result) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.afterCallClientMethod");){
            span.addTag("callBackId", callBackId);
            if (span.isRealtime()) {
                span.addTag("result", SerializationUtils.toJsonString(result));
            }
            ClientMethodResult ret = new ClientMethodResult(Boolean.valueOf(result.get("success").toString()), (Map)result.get("result"));
            IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
            String josnListener = cache.get(callBackId);
            ClientCallbackListener listener = (ClientCallbackListener)SerializationUtils.fromJsonString((String)josnListener, ClientCallbackListener.class);
            listener.setView(this.getView());
            listener.finish(ret);
        }
    }

    public void close() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.close");){
            this.view.close();
            log.info((Object)("-----------FormController\u5173\u95ed\u7684view= " + this.view.getPageId()));
        }
    }

    public void release(Map<String, Object> setting) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.release");){
            if (span.isRealtime()) {
                span.addTag("setting", setting == null ? "null" : SerializationUtils.toJsonString(setting));
            }
            this.releaseDataMutex();
            this.saveSetting(setting);
            this.destory();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            ((FormView)this.view).release();
            SessionManager.getCurrent().clearPageSession(this.view.getFormShowParameter().getRootPageId(), this.view.getPageId());
            String tampAttCache = pageCache.get("TampAttCache" + this.view.getPageId());
            if (StringUtils.isNotBlank((CharSequence)tampAttCache)) {
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                Map tampAttCacheInfo = (Map)SerializationUtils.fromJsonString((String)tampAttCache, Map.class);
                List attachmentpanel = (List)tampAttCacheInfo.get("attachmentpanel");
                String url = "";
                if (attachmentpanel != null) {
                    for (Object attinfo : attachmentpanel) {
                        url = ((Map)attinfo).get("url");
                        if (!StringUtils.isNotBlank((Object)url) || !(url instanceof String) || !url.contains("tempfile/download.do?configKey")) continue;
                        tempFileCache.remove(url.toString());
                    }
                }
            }
            ((PageCache)pageCache).release();
            this.removeAllCsrfCache(LASTCSRFTOKEN_);
        }
    }

    public void saveSetting(Map<String, Object> setting) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.saveSetting");){
            if (span.isRealtime()) {
                span.addTag("setting", setting == null ? "null" : SerializationUtils.toJsonString(setting));
            }
            if (setting != null && setting.size() > 0) {
                UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getSettingKey(), (String)SerializationUtils.toJsonString(setting));
            }
        }
    }

    public void releaseDataMutex() {
        MutexHelper.release((IFormView)this.getView());
    }

    protected String getSettingKey() {
        return this.getView().getFormShowParameter().getSettingKey();
    }

    protected void createModelData(IDataModel model) {
        model.createNewData();
    }

    private void autoAddNewEntry(String entryKey) {
    }

    public void showQuickRename(String formId) {
        if (StringUtils.isNotBlank((CharSequence)formId) && ("pc_main_console".equals(formId) || formId.contains("_apphome") || formId.contains("bos_card_quicklaunch"))) {
            return;
        }
        if (!FormController.checkTermFuncPermission()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\"\u672f\u8bed\u91cd\u547d\u540d\"\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"FormController_6", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        if (this.getView() instanceof ListView) {
            formId = ((ListView)this.getView()).getBillFormId();
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_word_entry_modify");
        parameter.setCustomParam("formId", (Object)formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void showDesigner(String formId) {
        List formList;
        if (!FormController.checDesignerPermission()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u8ba1\u5668\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"FormController_1", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        if (EnvTypeHelper.isDeploying()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormController_9", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN"), new SqlParameter(":FNumber", 12, (Object)formId)};
        String sql = "select a.FID, b.FNumber,a.FNAME,b.fisv,b.fmasterid, b.FMODELTYPE,b.FEntityId, b.FInheritPath,b.ftype from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID  where a.FLOCALEID = ? and b.FNumber=?";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                try {
                    while (rs.next()) {
                        list.add(this.buildRsMap(rs));
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (formList.size() > 0) {
            ISVInfo info = ISVService.getISVInfo();
            String curIsv = "";
            if (info != null) {
                curIsv = info.getId();
            }
            Map para = (Map)formList.get(0);
            String isv = (String)para.get("isv");
            String masterId = (String)para.get("masterId");
            String id = (String)para.get("id");
            if (para.get("bizappid") == null) {
                String appId = MetadataDao.getAppIdByFormId((String)id);
                para.put("bizappid", appId);
            }
            if (StringUtils.isBlank((CharSequence)masterId)) {
                masterId = id;
            }
            Map<String, Object> extmap = null;
            if (StringUtils.isNotBlank((CharSequence)curIsv)) {
                if ("kingdee".equals(curIsv)) {
                    if (StringUtils.isNotBlank((CharSequence)isv) && !curIsv.equals(isv)) {
                        extmap = this.findCurIsvExtForm(curIsv, masterId);
                    }
                } else if (!curIsv.equals(isv)) {
                    extmap = this.findCurIsvExtForm(curIsv, masterId);
                }
            }
            boolean checkParamCheck = Boolean.parseBoolean(System.getProperty("open.url.param.check", "false"));
            if (extmap != null && !extmap.isEmpty()) {
                this.showDesignerForm(extmap, checkParamCheck);
            } else {
                this.showDesignerForm(para, checkParamCheck);
            }
        }
    }

    private void showDesignerForm(Map<String, Object> para, boolean isNewDesigner) {
        String isv;
        String modelType = (String)para.get("modelType");
        String formId = "ide_formdesigner";
        FormShowParameter parameter = new FormShowParameter();
        if (isNewDesigner) {
            PageType pageType = DomainModelType.getPageTypeByModelType((String)modelType);
            switch (pageType) {
                case EntityObject: 
                case Page: {
                    formId = "bos_devpn_formdesign";
                    break;
                }
                case Report: {
                    break;
                }
                case Parameter: {
                    break;
                }
            }
        } else {
            parameter.setFormId("ide_formdesigner");
        }
        if ("2".equals(para.get("type")) && !"kdxk".equals(isv = (String)para.get("isv"))) {
            parameter.setClientParam("ext", (Object)"true");
            parameter.setCustomParam("ext", (Object)"true");
        }
        parameter.setFormId(formId);
        parameter.setCustomParam("id", para.get("id"));
        parameter.setCustomParam(NUMBER, para.get(NUMBER));
        parameter.setCustomParam("bizappid", para.get("bizappid"));
        parameter.setClientParam(MODELTYPE, para.get("modelType"));
        parameter.setClientParam("modelver", (Object)"");
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.view.showForm(parameter);
    }

    private Map<String, Object> findCurIsvExtForm(String currIsv, String masterId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN"), new SqlParameter(":FMasterId", 12, (Object)masterId), new SqlParameter(":FIsv", 12, (Object)currIsv)};
        String sql = "select a.FID, b.FNumber,a.FNAME,b.fisv,b.fmasterid, b.FMODELTYPE,b.FEntityId, b.FInheritPath,b.ftype from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID  where a.FLOCALEID = ? and b.fmasterid = ? and b.fisv = ? order by finheritpath desc";
        try {
            return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                try {
                    if (rs.next()) {
                        map.putAll(this.buildRsMap(rs));
                        return map;
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return map;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private Map<String, Object> buildRsMap(ResultSet rs) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("id", rs.getString(1));
        map.put(NUMBER, rs.getString(2));
        map.put("name", rs.getString(3));
        map.put("isv", rs.getString(4));
        map.put("masterId", rs.getString(5));
        String modelType = rs.getString(6);
        map.put("modelType", modelType);
        map.put("entityid", rs.getString(7));
        map.put("inheritpath", rs.getString(8));
        map.put("type", rs.getString(9));
        if (modelType.startsWith("Mob")) {
            map.put("isPC", false);
        } else {
            map.put("isPC", true);
        }
        return map;
    }

    public void showKDebugger(String pageId) {
        Map<String, Object> config;
        ListShowParameter parameter;
        String formId;
        boolean debugMode = DebugConfig.isDebugEnabled();
        if (!debugMode) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u9ed8\u8ba4\u7981\u7528\u811a\u672c\u8c03\u8bd5", (String)"FormController_2", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        if (!PermissionServiceHelper.checkUserBizApp((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"devportal").getId()).booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\u6743\u9650\u3002", (String)"FormController_5", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        PageCache pageCache = new PageCache(pageId);
        if (this.view instanceof ListView) {
            formId = ((ListView)this.view).getBillFormId();
            parameter = new ListShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setBillFormId(formId);
            pageCache = new PageCache(parameter.getPageId());
            config = FormConfigFactory.createConfig((FormShowParameter)parameter);
            pageCache.put("formconfig", SerializationUtils.toJsonString(config));
            pageId = parameter.getPageId();
        } else {
            formId = this.view.getFormShowParameter().getFormId();
            parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setFormId(formId);
            pageCache = new PageCache(parameter.getPageId());
            config = FormConfigFactory.createConfig((FormShowParameter)parameter);
            pageCache.put("formconfig", SerializationUtils.toJsonString(config));
            pageId = parameter.getPageId();
        }
        String modelType = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)MODELTYPE, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)formId)}).getString(MODELTYPE);
        if ("ReportFormModel".equals(modelType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u62a5\u8868\u4e0d\u5141\u8bb8\u8fdb\u884c\u811a\u672c\u8c03\u8bd5\uff01", (String)"FormController_4", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        String contxtPath = UrlService.getDomainContextUrl();
        for (Plugin plugin : plugins) {
            if (1 != plugin.getType()) continue;
            String url = contxtPath + "/devtools/debug-page/?pageId=" + pageId;
            this.view.openUrl(url);
            return;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u9875\u9762\u6ca1\u6709\u811a\u672c\u63d2\u4ef6\uff0c\u65e0\u9700\u8fdb\u884c\u811a\u672c\u8c03\u8bd5\uff01", (String)"FormController_3", (String)BOS_FORM_MVC, (Object[])new Object[0]));
    }

    public void showScriptOperateLog(String pageId) {
        String sessionId = RequestContext.get().getGlobalSessionId();
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("bos_devp_scriptoperatelog");
        ListFilterParameter filterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("sessionid", "=", (Object)sessionId);
        filterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(filterParameter);
        StyleCss sc = new StyleCss();
        sc.setHeight("480px");
        sc.setWidth("850px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private static boolean checDesignerPermission() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)"bos_devportal_bizapplist", (String)"4715a0df000000ac");
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    private static boolean checkTermFuncPermission() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"bos", (String)"cts_termword_list", (String)"47150e89000000ac");
    }

    @Override
    public void formClosedCallBack(IFormView source) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.formClosedCallBack");){
            this.formClosedCallBack(((FormView)source).getCloseCallBackWraper());
        }
    }

    @Override
    public void formClosedCallBack(CloseCallBackWraper closeCallBackWraper) {
        Object ret = closeCallBackWraper.getReturnData();
        CloseCallBack closeCallBack = closeCallBackWraper.getCloseCallBack();
        IFormPlugin iCloseCallBack = null;
        if (closeCallBack.getClassName() != null && (iCloseCallBack = this.getPluginProxy().getPlugin(closeCallBack.getClassName())) == null) {
            iCloseCallBack = (ICloseCallBack)TypesContainer.createInstance((String)closeCallBack.getClassName());
        }
        if (StringUtils.isNotBlank((CharSequence)closeCallBack.getControlKey())) {
            Control ctl = this.view.getControl(closeCallBack.getControlKey());
            if (ctl instanceof ICloseCallBack) {
                this.registerListener();
                ClosedCallBackEvent callBackArgs = new ClosedCallBackEvent((Object)this, closeCallBack.getActionId(), ret);
                callBackArgs.setView(this.getView());
                ((ICloseCallBack)ctl).closedCallBack(callBackArgs);
            }
        } else if (iCloseCallBack instanceof IFormPlugin) {
            this.getPluginProxy().fireClosedCallBack(closeCallBack, ret);
        } else {
            ClosedCallBackEvent callBackArgs = new ClosedCallBackEvent((Object)this, closeCallBack.getActionId(), ret);
            callBackArgs.setView(this.getView());
            if (iCloseCallBack != null) {
                iCloseCallBack.closedCallBack(callBackArgs);
            }
        }
    }

    @Override
    public void updateValue() {
    }

    @Override
    public void showSelectPicWindow() {
    }

    @Override
    public void contextMenuClick(String source, String itemKey) {
        if ("menu".equals(source)) {
            String[] items = itemKey.split("\\.");
            if (items.length == 2) {
                this.view.invokeOperation(items[1]);
            } else {
                this.getPluginProxy().fireContextMenuClick(source, itemKey);
            }
        } else {
            this.getPluginProxy().fireContextMenuClick(source, itemKey);
        }
    }

    @Override
    public void destory() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"controller.destory");){
            FormViewPluginProxy pluginProxy = this.getPluginProxy();
            if (pluginProxy != null) {
                pluginProxy.fireDestory();
            }
            this.getView().getFormShowParameter().getFormConfig().destory();
            ((FormView)this.getView()).setDestory(true);
        }
    }

    public IFormView getView() {
        return this.view;
    }

    @Override
    public void registerListener() {
        if (!this.bRegListner) {
            this.getPluginProxy().fireRegisterListener(new EventObject(this.getView()));
            this.bRegListner = true;
        }
    }

    @Override
    public void checkCsrfToken(String csrfToken) {
        if (!this.needCheckCsrf()) {
            return;
        }
        Map<String, String> allCsrfMap = this.getAllCsrfCache(LASTCSRFTOKEN_);
        if (allCsrfMap.isEmpty()) {
            return;
        }
        this.questCsrfToken = csrfToken;
        this.needUpdateCsrfToken = true;
        String cacheLastCsrfTime = allCsrfMap.get(csrfToken);
        if (StringUtils.isNotBlank((CharSequence)cacheLastCsrfTime)) {
            return;
        }
        String cacheCsrfTime = this.getCsrfCache(CSRFTOKEN_, csrfToken);
        Long systime = this.getSysTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)cacheCsrfTime) && systime - Long.parseLong(cacheCsrfTime) < (long)FormController.getCheckCsrfTimeout()) {
            return;
        }
        if (this.needCsrfLog()) {
            try {
                Map<String, String> lastTokens = this.getAllCsrfCache(LASTCSRFTOKEN_);
                Map<String, String> csrfTokens = this.getAllCsrfCache(CSRFTOKEN_);
                String ip = RequestContext.get().getLoginIP();
                String time = RequestContext.get().getLoginTime();
                log.warn((Object)String.format("csrftoken \u68c0\u67e5\u5931\u8d25,ip=%s,logintime=%s,questToken='%s',lastToken='%s', token='%s', systime=%s", ip, time, csrfToken, SerializationUtils.toJsonString(lastTokens), SerializationUtils.toJsonString(csrfTokens), systime));
            }
            catch (Exception lastTokens) {
                // empty catch block
            }
        }
        if (FormController.isNeedCheckCsrf()) {
            String code = "";
            if (StringUtils.isBlank((CharSequence)csrfToken)) {
                code = " token is null";
            }
            throw new KDException(BosErrorCode.oAuthSecurity, new Object[]{String.format(ResManager.loadKDString((String)"csrftoken\u68c0\u67e5\u5931\u8d25\uff01%s", (String)"FormController_8", (String)BOS_FORM_MVC, (Object[])new Object[0]), code)});
        }
    }

    @Override
    public String updateCsrfToken() {
        if (!this.needCheckCsrf()) {
            return "";
        }
        if (!this.needUpdateCsrfToken) {
            return "";
        }
        if (!this.needCheckedCsrfOfFormId()) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)this.questCsrfToken)) {
            Map<String, String> csrfTimeMap = this.getAllCsrfCache(CSRFTOKEN_);
            StringBuilder newCacheCsrfToken = new StringBuilder();
            Long systime = this.getSysTimeMillis();
            for (Map.Entry<String, String> entry : csrfTimeMap.entrySet()) {
                if (systime - Long.parseLong(entry.getValue()) <= (long)FormController.getCheckCsrfTimeout()) continue;
                this.removeCsrfCache(CSRFTOKEN_, entry.getKey());
            }
            this.putCsrfCache(CSRFTOKEN_, this.questCsrfToken, Long.toString(this.getSysTimeMillis()));
        }
        String newCsrfToken = UUID.randomUUID().toString();
        this.removeCsrfCache(LASTCSRFTOKEN_, this.questCsrfToken);
        this.putCsrfCache(LASTCSRFTOKEN_, newCsrfToken, Long.toString(this.getSysTimeMillis()));
        return newCsrfToken;
    }

    protected void createCsrfToken() {
        if (!this.needCheckedCsrfOfFormId()) {
            return;
        }
        this.needUpdateCsrfToken = true;
    }

    private boolean needCheckCsrf() {
        if (!this.needCheckedCsrfOfFormId()) {
            return false;
        }
        return FormController.isNeedCheckCsrf();
    }

    private boolean needCsrfLog() {
        String tenantId = RequestContext.get().getTenantId();
        String checkCsrfLog = SystemPropertyUtils.getProptyByTenant((String)need_check_csrf_log, (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)checkCsrfLog)) {
            return Boolean.parseBoolean(checkCsrfLog);
        }
        return false;
    }

    private boolean needCheckedCsrfOfFormId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        for (String exFormId : csrfExceptionalFormId) {
            if (!formId.equals(exFormId)) continue;
            return false;
        }
        return true;
    }

    private long getSysTimeMillis() {
        return DBDateUtil.getTimeMillis();
    }

    private String getCsrfCache(String type, String key) {
        if (key == null) {
            return null;
        }
        return (String)this.getRedisCache().get(this.getCacheType(type), key);
    }

    private Map<String, String> getAllCsrfCache(String type) {
        return this.getRedisCache().getAll(this.getCacheType(type));
    }

    private void putCsrfCache(String type, String key, String val) {
        if (val == null) {
            return;
        }
        if (CSRFTOKEN_.equals(type)) {
            this.getRedisCache().put(this.getCacheType(type), key, val, 4, TimeUnit.SECONDS);
        } else {
            this.getRedisCache().put(this.getCacheType(type), key, (Object)val);
        }
    }

    private void removeCsrfCache(String type, String key) {
        if (key == null) {
            return;
        }
        this.getRedisCache().remove(this.getCacheType(type), key);
    }

    private DistributeSessionlessCache getRedisCache() {
        if (this.redisCache == null) {
            this.redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        }
        return this.redisCache;
    }

    private void removeAllCsrfCache(String type) {
        this.getRedisCache().remove(this.getCacheType(type));
    }

    private String getCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        return String.format("%s.%s.%s", accountId, this.view.getPageId(), type);
    }

    private void relayToRemoteTenantRequest(FormShowParameter showParameter, List<Map<String, Object>> postDatas) {
        boolean callWebApi;
        String tenantCode = ((ICtsyShowParameter)showParameter).getTenantCode();
        String accountId = ((ICtsyShowParameter)showParameter).getAccountId();
        String remotePageId = showParameter.getCustomParams().get("remotePageId") == null ? "" : (String)showParameter.getCustomParams().get("remotePageId");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("pageId", remotePageId);
        params.put("serviceAppId", showParameter.getServiceAppId());
        params.put("method", "postChildFormStates");
        params.put("postDatas", postDatas);
        HashMap<String, HashMap<String, Object>> paramsTemp = new HashMap<String, HashMap<String, Object>>(1);
        paramsTemp.put("params", params);
        boolean bl = callWebApi = showParameter.getCustomParams().get("callWebApi") == null ? true : (Boolean)showParameter.getCustomParams().get("callWebApi");
        if (callWebApi) {
            CtsyApiDispatchServiceHelper.invokeWebApi((String)tenantCode, (String)accountId, (String)"/v2/ctsy/ctform/handle", paramsTemp);
        } else {
            CtsyApiDispatchServiceHelper.post((String)tenantCode, (String)accountId, (String)"v2/ctsy/ctform/handle", (String)SerializationUtils.toJsonString(paramsTemp));
        }
    }

    static {
        needCheckCsrf = Boolean.parseBoolean(System.getProperty(need_check_csrf, "false"));
        ConfigurationUtil.observeChange((String)need_check_csrf, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                needCheckCsrf = Boolean.parseBoolean(System.getProperty(need_check_csrf));
            }
        });
        checkCsrfTimeout = Integer.parseInt(System.getProperty(need_check_csrf_timeout, "10000"));
        ConfigurationUtil.observeChange((String)need_check_csrf_timeout, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                checkCsrfTimeout = Integer.parseInt(System.getProperty(need_check_csrf_timeout));
            }
        });
    }
}

