/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormDataBinder;
import kd.bos.form.IFormView;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGridTotalListener;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.PriceEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.list.IListView;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.bos.mvc.form.BillTypeChangeListener;
import kd.bos.mvc.form.DataModelChangeListener;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TimeService;

public class FormDataBinder
implements IFormDataBinder {
    private static final String SPAN_TYPE_NAME = "formview";
    IFormView view;
    private IDataModel model;
    private String _firstFocusControl;

    public FormDataBinder(IFormView view) {
        this.view = view;
        this.model = (IDataModel)this.view.getService(IDataModel.class);
        DataModelChangeListener dataModelChangeListener = new DataModelChangeListener(view);
        this.model.addDataModelListener((IDataModelListener)dataModelChangeListener);
        this.model.addDataModelChangeListener((IDataModelChangeListener)dataModelChangeListener);
        if (!(view instanceof BillViewForWebApi) && !(view instanceof IListView)) {
            EntryGridTotalListener entryGridTotalListener = new EntryGridTotalListener(view);
            this.model.addDataModelChangeListener((IDataModelChangeListener)entryGridTotalListener);
        }
        if (view instanceof IBillView) {
            this.model.addDataModelChangeListener((IDataModelChangeListener)new BillTypeChangeListener((IBillView)view));
        }
    }

    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormDataBinder.updateView");){
            this._firstFocusControl = null;
            DynamicObject dataEntity = this.model.getDataEntity();
            if (dataEntity == null) {
                throw new RuntimeException();
            }
            ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>(1);
            objs.add(new RowDataEntity(0, dataEntity));
            FormRoot rootControl = (FormRoot)this.view.getRootControl();
            this.putFmtInfo();
            FormRuleContainer ruleContaiber = (FormRuleContainer)((Object)this.view.getService(RuleContainer.class));
            ruleContaiber.raiseInitialized((IDataEntityType)this.model.getDataEntityType(), objs, new FormRuleExecuteContext(this.view));
            BindingContext bindingContext = new BindingContext((Object)dataEntity, 0, -1);
            rootControl.bindData(bindingContext);
            if (this._firstFocusControl != null) {
                HashMap<String, String> para = new HashMap<String, String>();
                para.put("key", this._firstFocusControl.toUpperCase());
                this.getViewProxy().setFocus(para);
            }
        }
    }

    private IClientViewProxy getViewProxy() {
        return (IClientViewProxy)this.view.getService(IClientViewProxy.class);
    }

    private void putFmtInfo() {
        if (this.view.getFormShowParameter().getFormConfig().getHDFieldCount() == 0) {
            return;
        }
        List decimalFields = FormMetadataCache.getHeadDecimalFields((String)this.view.getFormShowParameter().getFormId());
        HashMap<String, Map> fmtInfo = new HashMap<String, Map>();
        for (String key : decimalFields) {
            String unitPropKey;
            Control c = this.view.getControl(key);
            boolean isQty = c instanceof QtyEdit;
            if (c instanceof AmountEdit || c instanceof PriceEdit) {
                String propName = ((DecimalEdit)c).getControlPropName();
                if (StringUtils.isNotBlank((CharSequence)propName)) {
                    DynamicObject ctrlObj = (DynamicObject)this.model.getValue(propName);
                    fmtInfo.put(propName, FmtInfoUtils.getCurrencyFmt((DynamicObject)ctrlObj));
                    continue;
                }
                fmtInfo.put("_MainCurrency_", FmtInfoUtils.getMainCurrencyFmt());
                continue;
            }
            if (!isQty || !StringUtils.isNotBlank((CharSequence)(unitPropKey = ((DecimalEdit)c).getControlPropName()))) continue;
            IDataEntityProperty unitProp = this.model.getProperty(unitPropKey);
            DynamicObject unitObj = (DynamicObject)this.model.getValue(unitPropKey);
            String materialKey = unitProp instanceof UnitProp ? ((UnitProp)unitProp).getMaterielField() : null;
            DynamicObject materialObj = null;
            if (StringUtils.isNotBlank((CharSequence)materialKey)) {
                materialObj = (DynamicObject)this.model.getValue(materialKey);
            }
            fmtInfo.put(unitPropKey, FmtInfoUtils.getUnitFmt((UnitProp)((UnitProp)unitProp), (DynamicObject)unitObj, (DynamicObject)materialObj));
        }
        if (fmtInfo.size() > 0) {
            this.getViewProxy().setNumFmtInfos(fmtInfo);
        }
        List datetimeFields = FormMetadataCache.getHeadDateTimeFields((String)this.view.getFormShowParameter().getFormId());
        HashMap timezoneInfo = new HashMap();
        for (String key : datetimeFields) {
            String relateOrg;
            Control c = this.view.getControl(key);
            if (!(c instanceof DateTimeEdit) || c instanceof DateEdit || InteTimeZone.TransType.OrgTimeZone.ordinal() != ((DateTimeEdit)c).getTimeZoneTransType() || !StringUtils.isNotBlank((CharSequence)(relateOrg = ((DateTimeProp)((DateTimeEdit)c).getProperty()).getRelateOrg()))) continue;
            DynamicObject ctrlObj = (DynamicObject)this.model.getValue(relateOrg);
            InteTimeZone timeZone = ctrlObj != null ? InteTimeZone.getOrgTimeZone((Long)((Long)ctrlObj.getPkValue())) : null;
            HashMap<String, String> info = new HashMap<String, String>();
            if (timeZone != null) {
                info.put("timezone", timeZone.getTimeZoneDesc());
                info.put("today", timeZone.format(new TimeService().now()));
            }
            timezoneInfo.put(relateOrg, info);
        }
        if (timezoneInfo.size() > 0) {
            this.getViewProxy().setTimeZones(timezoneInfo);
        }
    }

    public void updateViewState() {
    }

    public void updateView(String key) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormDataBinder.updateView");){
            span.addTag("key", key);
            Control c = this.view.getControl(key);
            DynamicObject dataEntity = this.model.getDataEntity();
            if (dataEntity == null) {
                throw new RuntimeException();
            }
            if (c != null) {
                c.bindData(new BindingContext((Object)dataEntity));
                if (c instanceof AbstractGrid) {
                    ((AbstractGrid)c).clearEntryState();
                }
            }
        }
    }

    public void updateView(String key, int row) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormDataBinder.updateView");){
            span.addTag("key", key);
            span.addTag("row", String.valueOf(row));
            Control c = this.view.getControl(key);
            DynamicObject dataEntity = this.model.getDataEntity();
            if (dataEntity == null) {
                throw new RuntimeException();
            }
            if (c != null) {
                if (c instanceof FieldEdit) {
                    IDataEntityType parent = ((FieldEdit)c).getProperty().getParent();
                    if (parent instanceof EntryType) {
                        BindingContext bindingContext = new BindingContext((Object)this.model.getEntryRowEntity(parent.getName(), row), row);
                        bindingContext.setCallByUpdateView(true);
                        c.bindData(bindingContext);
                    }
                } else {
                    c.bindData(new BindingContext((Object)dataEntity, row));
                }
            }
        }
    }

    public void updateView(String key, int row, int parentRow) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormDataBinder.updateView");){
            span.addTag(key, key);
            span.addTag("row", String.valueOf(row));
            span.addTag("parentRow", String.valueOf(parentRow));
            Control c = this.view.getControl(key);
            DynamicObject dataEntity = this.model.getDataEntity();
            if (dataEntity == null) {
                throw new RuntimeException();
            }
            if (c != null) {
                if (c instanceof FieldEdit) {
                    IDataEntityType parent = ((FieldEdit)c).getProperty().getParent();
                    if (parent instanceof EntryType) {
                        int parentCurrRow;
                        if (parentRow != -1 && parent.getParent() instanceof EntryType && parentRow != (parentCurrRow = this.model.getEntryCurrentRowIndex(parent.getParent().getName()))) {
                            return;
                        }
                        c.bindData(new BindingContext((Object)this.model.getEntryRowEntity(parent.getName(), row, parentRow), row));
                    }
                } else {
                    c.bindData(new BindingContext((Object)dataEntity, row));
                }
            }
        }
    }

    public void changedPage(String entryKey, String cmdKey) {
    }

    public void bindInitiData() {
    }

    public IFormView getView() {
        return this.view;
    }
}

