/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormConfig;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormUpdateViewService;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.mvc.form.TitleField;
import kd.bos.mvc.form.TitleSplit;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class FormUpdateViewService
implements IFormUpdateViewService {
    private IFormView view;
    private static final String BOS_FORM_SVC = "bos-form-mvc";

    public FormUpdateViewService(IFormView view) {
        this.view = view;
    }

    public void afterUpdateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)"FormUpdateViewService", (String)"afterUpdateView");){
            this.setTriggerMode();
            if (!(this.view instanceof IListView)) {
                this.showCustomCaption();
            }
        }
    }

    private void setTriggerMode() {
        Map<String, Object> sysParam = this.loadDevpotalParam();
        Object triggerMode = sysParam.get("triggermode");
        if (triggerMode != null && triggerMode.equals("2")) {
            HashMap<String, Object> triggerMap = new HashMap<String, Object>(3);
            Object triggerRange = sysParam.get("triggerrange");
            if (triggerRange == null) {
                return;
            }
            triggerMap.put("range", triggerRange);
            List triggerValue = (List)sysParam.get("triggervalue");
            if (triggerRange.equals("part") && triggerValue != null) {
                HashSet<String> baseNumbers = new HashSet<String>(triggerValue.size());
                for (Map map : triggerValue) {
                    Map baseData = (Map)map.get("fbasedataid");
                    baseNumbers.add((String)baseData.get("number"));
                }
                triggerMap.put("bdList", baseNumbers);
            }
            HashMap<String, HashMap<String, Object>> enterToQuery = new HashMap<String, HashMap<String, Object>>(2);
            enterToQuery.put("bdEnterToQuery", triggerMap);
            HashMap<String, Object> paraMap = new HashMap<String, Object>(3);
            paraMap.put("config", enterToQuery);
            paraMap.put("pageId", this.view.getPageId());
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            proxy.addAction("setPageConfig", paraMap);
        }
    }

    private Map<String, Object> loadDevpotalParam() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        param.setViewType("15");
        param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
    }

    private void showCustomCaption() {
        String formCaption = this.view.getFormShowParameter().getCaption();
        if (StringUtils.isNotBlank((CharSequence)formCaption)) {
            this.view.setFormTitle(new LocaleString(formCaption));
            return;
        }
        Map<String, Object> devParam = this.loadDevpotalParam();
        boolean isAddSuffix = (Boolean)devParam.getOrDefault("titlesuffix", false);
        FormConfig formConfig = this.view.getFormShowParameter().getFormConfig();
        OperationStatus status = this.view.getFormShowParameter().getStatus();
        String titleSuffix = "";
        if (OperationStatus.EDIT.equals((Object)status)) {
            titleSuffix = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"FormUpdateViewService_0", (String)BOS_FORM_SVC, (Object[])new Object[0]);
        } else if (OperationStatus.VIEW.equals((Object)status)) {
            titleSuffix = ResManager.loadKDString((String)"\u67e5\u770b", (String)"FormUpdateViewService_1", (String)BOS_FORM_SVC, (Object[])new Object[0]);
        } else if (OperationStatus.ADDNEW.equals((Object)status)) {
            titleSuffix = ResManager.loadKDString((String)"\u65b0\u589e", (String)"FormUpdateViewService_2", (String)BOS_FORM_SVC, (Object[])new Object[0]);
            if (isAddSuffix && ("bill".equals(formConfig.getModelType()) || "base".equals(formConfig.getModelType()))) {
                LocaleString caption = new LocaleString();
                caption = formCaption == null ? formConfig.getCaption() : new LocaleString(formCaption);
                String captionStr = caption.toString();
                if (StringUtils.isNotBlank((CharSequence)captionStr)) {
                    String suffix = String.format("%1$s_%2$s", captionStr, titleSuffix);
                    this.view.setFormTitle(new LocaleString(suffix));
                }
                return;
            }
        }
        Object title = "0";
        Object titleSplit = null;
        if ("bill".equals(formConfig.getModelType())) {
            title = devParam.get("billtitle");
            titleSplit = devParam.get("billtitlesplite");
        } else if ("base".equals(formConfig.getModelType())) {
            title = devParam.get("basedatatitle");
            titleSplit = devParam.get("basedatasplite");
        } else if ("mobilebase".equalsIgnoreCase(formConfig.getModelType()) || "mobilebill".equals(formConfig.getModelType()) || "mobileform".equals(formConfig.getModelType()) || "mobilelist".equalsIgnoreCase(formConfig.getModelType())) {
            return;
        }
        LocaleString caption = this.view.getFormShowParameter().getFormConfig().getCaption();
        if (caption != null) {
            String captionStr = caption.toString();
            if (isAddSuffix && ("bill".equals(formConfig.getModelType()) || "base".equals(formConfig.getModelType())) && StringUtils.isNotBlank((CharSequence)captionStr)) {
                String suffix = String.format("%1$s_%2$s", captionStr, titleSuffix);
                caption = new LocaleString(suffix);
            }
        }
        if ("0".equals(title)) {
            this.view.setFormTitle(caption);
            return;
        }
        if (title instanceof String) {
            TitleField titleField = TitleField.getTitleField(Integer.parseInt((String)title));
            try {
                if (titleField.isNeedSplite() && titleSplit instanceof String) {
                    String split = TitleSplit.getTitleFieldSplit(Integer.parseInt((String)titleSplit));
                    String fields = titleField.getFieldNames();
                    if (StringUtils.isNotBlank((CharSequence)fields)) {
                        String[] fieldArray = fields.split(",");
                        DynamicObject dataEntity = this.view.getModel().getDataEntity();
                        StringBuilder newCaption = new StringBuilder();
                        for (int i = 0; i < fieldArray.length; ++i) {
                            Object fieldValue;
                            String field = fieldArray[i];
                            if ("caption".equals(field)) {
                                newCaption.append(this.view.getFormShowParameter().getFormConfig().getCaption());
                            } else {
                                Object fieldValue2;
                                if ("number".equals(field)) {
                                    fieldValue2 = "bill".equals(formConfig.getModelType()) ? dataEntity.get("billno") : dataEntity.get("number");
                                    if (StringUtils.isBlank((CharSequence)fieldValue2.toString()) && StringUtils.isNotBlank((CharSequence)newCaption.toString())) {
                                        newCaption.delete(newCaption.length() - split.length(), newCaption.length());
                                    }
                                } else {
                                    fieldValue2 = dataEntity.get(field);
                                    if (fieldValue2 instanceof OrmLocaleValue && (fieldValue2 = ((OrmLocaleValue)fieldValue2).getDefaultItem()) == null) {
                                        fieldValue2 = "";
                                        if (StringUtils.isNotBlank((CharSequence)newCaption.toString())) {
                                            newCaption.delete(newCaption.length() - split.length(), newCaption.length());
                                        }
                                    }
                                }
                                newCaption.append(fieldValue2);
                            }
                            if (i >= fieldArray.length - 1) continue;
                            if (StringUtils.isNotBlank((CharSequence)newCaption.toString())) {
                                newCaption.append(split);
                            }
                            if (!"4".equals(titleSplit)) continue;
                            String fieldNext = fieldArray[i + 1];
                            if ("number".equals(fieldNext)) {
                                fieldValue = "bill".equals(formConfig.getModelType()) ? dataEntity.get("billno") : dataEntity.get("number");
                                if (StringUtils.isBlank((CharSequence)fieldValue.toString()) && StringUtils.isNotBlank((CharSequence)newCaption.toString())) {
                                    newCaption.delete(newCaption.length() - split.length(), newCaption.length());
                                }
                            } else {
                                fieldValue = dataEntity.get(fieldNext);
                                if (fieldValue instanceof OrmLocaleValue && (fieldValue = ((OrmLocaleValue)fieldValue).getDefaultItem()) == null) {
                                    fieldValue = "";
                                    if (StringUtils.isNotBlank((CharSequence)newCaption.toString())) {
                                        newCaption.delete(newCaption.length() - split.length(), newCaption.length());
                                    }
                                }
                            }
                            String temCaption = StringUtils.isBlank((CharSequence)newCaption.toString()) ? fieldValue.toString() : String.format(newCaption.toString(), fieldValue);
                            String string = temCaption = StringUtils.isNotBlank((CharSequence)temCaption) ? temCaption : formConfig.getCaption().toString();
                            if (isAddSuffix) {
                                temCaption = String.format("%1$s_%2$s", temCaption, titleSuffix);
                            }
                            this.view.setFormTitle(new LocaleString(temCaption));
                            return;
                        }
                        String temCaption = newCaption.toString();
                        if (StringUtils.isBlank((CharSequence)temCaption)) {
                            return;
                        }
                        if (isAddSuffix) {
                            temCaption = String.format("%1$s_%2$s", newCaption, titleSuffix);
                        }
                        this.view.setFormTitle(new LocaleString(temCaption));
                    }
                } else {
                    Object fieldValue;
                    DynamicObject dataEntity = this.view.getModel().getDataEntity();
                    if ("number".equals(titleField.getFieldNames())) {
                        fieldValue = "bill".equals(formConfig.getModelType()) ? dataEntity.get("billno") : dataEntity.get("number");
                    } else {
                        String field = titleField.getFieldNames();
                        fieldValue = dataEntity.get(field);
                        if (fieldValue instanceof OrmLocaleValue) {
                            fieldValue = ((OrmLocaleValue)fieldValue).getDefaultItem();
                        }
                    }
                    Object object = fieldValue = StringUtils.isNotBlank((Object)fieldValue) ? fieldValue : formConfig.getCaption().toString();
                    if (isAddSuffix) {
                        fieldValue = String.format("%1$s_%2$s", fieldValue, titleSuffix);
                    }
                    this.view.setFormTitle(new LocaleString(fieldValue.toString()));
                }
            }
            catch (ORMDesignException ormDesignException) {
                this.view.setFormTitle(caption);
                return;
            }
        }
    }
}

