/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.userconfig.UserConfigQuery;
import kd.bos.userconfig.UserConfigWriter;

public class FormUserConfig
implements IFormUserConfig {
    private IFormView view;
    private Map<String, UserConfig> userConfigs;

    public FormUserConfig(IFormView view) {
        this.view = view;
    }

    protected IFormView getView() {
        return this.view;
    }

    protected Map<String, UserConfig> getUserConfigs() {
        if (this.userConfigs == null) {
            this.initFormUserConfigs();
        }
        return this.userConfigs;
    }

    protected void initFormUserConfigs() {
        this.userConfigs = new HashMap<String, UserConfig>();
        HashSet<String> keys = new HashSet<String>();
        this.addGridConfigKeys(keys);
        this.onAddKeys(keys);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        UserConfigQuery query = new UserConfigQuery();
        Map fromDB = query.getUserConfig(keys.toArray(new String[0]), userId);
        if (fromDB != null) {
            this.userConfigs.putAll(fromDB);
        }
    }

    protected void onAddKeys(Set<String> keys) {
    }

    private void addGridConfigKeys(Set<String> keys) {
        FormRoot formRoot = (FormRoot)this.getView().getRootControl();
        ArrayList<EntryGrid> grids = new ArrayList<EntryGrid>();
        this.searchEntryGrid((Container)formRoot, grids);
        String formId = this.getView().getFormShowParameter().getFormId();
        for (EntryGrid grid : grids) {
            String key = GridConfigDAO.buildUserConfigKey((String)formId, (String)grid.getEntryKey());
            keys.add(key);
        }
    }

    private void searchEntryGrid(Container container, List<EntryGrid> grids) {
        if (container instanceof EntryGrid) {
            grids.add((EntryGrid)container);
        } else {
            for (Control ctl : container.getItems()) {
                if (ctl instanceof EntryGrid) {
                    grids.add((EntryGrid)ctl);
                    continue;
                }
                if (!(ctl instanceof Container)) continue;
                this.searchEntryGrid((Container)ctl, grids);
            }
        }
    }

    public UserConfig loadUserConfig(String key) {
        if (this.getUserConfigs().containsKey(key)) {
            return this.getUserConfigs().get(key);
        }
        UserConfigQuery query = new UserConfigQuery();
        UserConfig userConfig = query.getUserConfig(key, Long.parseLong(RequestContext.get().getUserId()));
        this.getUserConfigs().put(key, userConfig);
        return userConfig;
    }

    public boolean saveUserConfig(String key, String value, StringBuilder errorMessage) {
        UserConfig userConfig = new UserConfig();
        userConfig.setKey(key);
        userConfig.setSetting(value);
        userConfig.setUserId(Long.parseLong(RequestContext.get().getUserId()));
        UserConfigWriter writer = new UserConfigWriter();
        if (!writer.saveUserConfig(userConfig, errorMessage)) {
            return false;
        }
        this.getUserConfigs().put(key, userConfig);
        return true;
    }
}

